/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.jewelry;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.items.jewelry.GemSlot;
import org.oxytocina.geomancy.items.jewelry.IJewelryItem;
import org.oxytocina.geomancy.items.jewelry.JewelryItemSettings;

public class JewelryItem
extends TrinketItem
implements IJewelryItem {
    public final int gemSlotCount;
    private final JewelryItemSettings jewelrySettings;

    public JewelryItem(class_1792.class_1793 settings, JewelryItemSettings jewelryItemSettings) {
        super(settings);
        this.gemSlotCount = jewelryItemSettings.gemSlotCount;
        List.add(this);
        switch (jewelryItemSettings.slot) {
            case ANY: {
                ModItems.JewelryAnySlotItems.add(this);
                break;
            }
            case RING: {
                ModItems.JewelryRingItems.add(this);
                break;
            }
            case NECKLACE: {
                ModItems.JewelryNecklaceItems.add(this);
                break;
            }
        }
        this.jewelrySettings = jewelryItemSettings;
    }

    @Override
    public int getGemSlotCount() {
        return this.gemSlotCount;
    }

    @Override
    public JewelryItemSettings getSettings() {
        return this.jewelrySettings;
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            GemSlot.tick(stack, gem, slot, entity);
        }
    }

    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            GemSlot.equip(stack, gem, slot, entity);
        }
    }

    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            GemSlot.unequip(stack, gem, slot, entity);
        }
    }

    public Multimap<class_1320, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
        Multimap<class_1320, class_1322> modifiers = super.getModifiers(stack, slot, entity, uuid);
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            modifiers = GemSlot.modifyModifiers(stack, gem, slot, entity, uuid, modifiers);
        }
        return modifiers;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 context) {
        ArrayList<GemSlot> gems;
        if (this.isPendant()) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.geomancy.jewelry.pendant1").method_27692(class_124.field_1063));
            list.add((class_2561)class_2561.method_43471((String)"tooltip.geomancy.jewelry.pendant2").method_27692(class_124.field_1063));
        }
        boolean hasGems = !(gems = IJewelryItem.getSlots(stack)).isEmpty();
        class_746 wearer = class_310.method_1551().field_1724;
        ArrayList<ArrayList<class_2561>> tooltips = new ArrayList<ArrayList<class_2561>>();
        for (GemSlot gem : gems) {
            ArrayList<class_2561> arrayList = new ArrayList<class_2561>();
            GemSlot.appendTooltip(stack, gem, (class_1309)wearer, world, arrayList, context);
            if (arrayList.isEmpty()) continue;
            tooltips.add(arrayList);
        }
        ArrayList<class_3545> textsCounted = new ArrayList<class_3545>();
        for (List list2 : tooltips) {
            boolean sortedIn = false;
            for (int i = 0; i < textsCounted.size(); ++i) {
                if (!((List)((class_3545)textsCounted.get(i)).method_15442()).stream().findFirst().equals(list2.stream().findFirst())) continue;
                ((class_3545)textsCounted.get(i)).method_34965((Object)((Integer)((class_3545)textsCounted.get(i)).method_15441() + 1));
                sortedIn = true;
                break;
            }
            if (sortedIn) continue;
            textsCounted.add(new class_3545((Object)list2, (Object)1));
        }
        for (class_3545 class_35452 : textsCounted) {
            int amount = (Integer)class_35452.method_15441();
            List texts = (List)class_35452.method_15442();
            for (class_2561 t : texts) {
                list.add((class_2561)class_2561.method_43470((String)(amount > 1 ? "x" + amount + " " : "")).method_27692(class_124.field_1054).method_10852(t));
            }
        }
        if (!hasGems) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.geomancy.jewelry.nogems").method_27692(class_124.field_1063));
        }
        if (stack.method_7985() && stack.method_7969().method_10573("preview", 1) && stack.method_7969().method_10577("preview")) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.geomancy.jewelry.unsmith").method_27692(class_124.field_1077));
        }
        super.method_7851(stack, world, list, context);
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int method_7837() {
        return this.jewelrySettings.enchantability;
    }
}

