/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.tools;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.items.tools.IVariableStoringItem;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.spells.SpellSignal;

public class VariableStoringItem
extends class_1792
implements IVariableStoringItem {
    public final int capacity;

    public VariableStoringItem(class_1792.class_1793 settings, int capacity) {
        super(settings);
        this.capacity = capacity;
    }

    public static SpellSignal getSignalStatic(class_1799 storage, String name) {
        HashMap<String, SpellSignal> sigs = VariableStoringItem.getSignalsStatic(storage);
        if (sigs != null && sigs.containsKey(name)) {
            return sigs.get(name);
        }
        return null;
    }

    public static HashMap<String, SpellSignal> getSignalsStatic(class_1799 storage) {
        class_2487 nbt = storage.method_7969();
        if (nbt == null || !nbt.method_10573("signals", 10)) {
            return null;
        }
        class_2487 list = nbt.method_10562("signals");
        LinkedHashMap<String, SpellSignal> res = new LinkedHashMap<String, SpellSignal>();
        Set keys = list.method_10541();
        for (String key : keys) {
            SpellSignal sig = SpellSignal.fromNBT(list.method_10562(key), 1);
            res.put(key, sig);
        }
        return res;
    }

    public static boolean setSignalStatic(class_1799 storage, SpellSignal signal) {
        class_2487 list = storage.method_7911("signals");
        if (signal.type == SpellSignal.Type.None) {
            if (list.method_10545(signal.name)) {
                list.method_10551(signal.name);
                return true;
            }
            return false;
        }
        if (list.method_10546() + (list.method_10545(signal.name) ? 0 : 1) > ((VariableStoringItem)storage.method_7909()).capacity) {
            return false;
        }
        class_2487 sigNbt = signal.toNBT(true);
        list.method_10566(signal.name, (class_2520)sigNbt);
        VariableStoringItem.markDirty(storage);
        return true;
    }

    protected static void markDirty(class_1799 stack) {
    }

    @Override
    public SpellSignal getSignal(class_1799 stack, String name) {
        return VariableStoringItem.getSignalStatic(stack, name);
    }

    @Override
    public boolean setSignal(class_1799 stack, SpellSignal signal) {
        return VariableStoringItem.setSignalStatic(stack, signal);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        HashMap<String, SpellSignal> sigs = VariableStoringItem.getSignalsStatic(stack);
        tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.varstorage.prefix").method_27692(class_124.field_1080).method_27693(this.getAccessorPrefix(stack)));
        tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.varstorage.storage").method_27692(class_124.field_1080).method_27693((sigs != null ? sigs.size() : 0) + "/" + this.capacity));
        if (sigs != null) {
            for (String signame : sigs.keySet()) {
                SpellSignal sig = sigs.get(signame).named(signame);
                class_5250 text = class_2561.method_43473().method_27692(class_124.field_1063).method_10852(sig.toText()).method_27693(" : ").method_27693(sig.toString(SpellContext.ofWorld(world, (class_1657)class_310.method_1551().field_1724)));
                tooltip.add((class_2561)text);
            }
        }
    }
}

