/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.helpers.NbtHelper;
import org.oxytocina.geomancy.recipe.CountIngredient;

public class NbtIngredient
extends CountIngredient {
    public class_2487 nbt;

    public NbtIngredient(class_1856 ingredient, int count, int slot, class_2487 nbt) {
        super(ingredient, count, slot);
        this.nbt = nbt;
    }

    public NbtIngredient(class_1856 ingredient, int count, int slot) {
        this(ingredient, count, slot, new class_2487());
    }

    public NbtIngredient(CountIngredient base, class_2487 nbt) {
        this(base.ingredient, base.count, base.slot, nbt);
    }

    public static NbtIngredient fromJson(@Nullable JsonElement json) {
        return NbtIngredient.fromJson(json, true);
    }

    public static NbtIngredient fromJson(@Nullable JsonElement json, boolean allowAir) {
        if (json != null && !json.isJsonNull()) {
            CountIngredient base = CountIngredient.fromJson(json, allowAir);
            class_2487 nbt = (class_2487)NbtHelper.fromJson(json.getAsJsonObject().get("nbt"));
            return new NbtIngredient(base, nbt);
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static NbtIngredient fromPacket(class_2540 buf) {
        CountIngredient ing = CountIngredient.fromPacket(buf);
        class_2487 nbt = buf.method_10798();
        return new NbtIngredient(ing, nbt);
    }

    @Override
    public void write(class_2540 buf) {
        super.write(buf);
        buf.method_10794(this.nbt);
    }

    @Override
    public JsonElement toJson() {
        JsonObject res = super.toJson().getAsJsonObject();
        res.add("nbt", NbtHelper.toJson((class_2520)this.nbt));
        return res;
    }

    public static NbtIngredient ofItems(class_1935 ... items) {
        return NbtIngredient.ofItems(1, items);
    }

    public static NbtIngredient ofItems(int count, class_1935 ... items) {
        return NbtIngredient.ofItems(count, new class_2487(), items);
    }

    public static NbtIngredient ofItems(int count, class_2487 nbt, class_1935 ... items) {
        return NbtIngredient.ofItems(count, nbt, -1, items);
    }

    public static NbtIngredient ofItems(int count, class_2487 nbt, int slot, class_1935 ... items) {
        CountIngredient ingredient1 = CountIngredient.ofItems(count, slot, items);
        return new NbtIngredient(ingredient1, nbt);
    }

    public class_1799 getStack() {
        class_1799 res = class_1799.field_8037;
        if (this.ingredient.method_8105().length > 0) {
            res = this.ingredient.method_8105()[0];
        }
        res.method_7980(this.nbt);
        res.method_7939(this.count);
        return res;
    }

    @Override
    public boolean test(class_1799 stack) {
        return this.ingredient.method_8093(stack) && this.nbtsMatch(stack.method_7969(), this.nbt);
    }

    public boolean nbtsMatch(class_2487 testedNbt, class_2487 conditionNbt) {
        if (conditionNbt == null || conditionNbt.method_33133()) {
            return true;
        }
        if (testedNbt == null || testedNbt.method_33133()) {
            return false;
        }
        for (String key : conditionNbt.method_10541()) {
            if (!testedNbt.method_10545(key)) {
                return false;
            }
            if (this.nbtElementsMatch(testedNbt.method_10580(key), conditionNbt.method_10580(key))) continue;
            return false;
        }
        return true;
    }

    public boolean nbtElementsMatch(class_2520 testedElement, class_2520 conditionElement) {
        if (testedElement.method_10711() != conditionElement.method_10711()) {
            return false;
        }
        switch (testedElement.method_10711()) {
            case 10: {
                return this.nbtsMatch((class_2487)testedElement, (class_2487)conditionElement);
            }
            case 8: {
                return Objects.equals(testedElement.method_10714(), conditionElement.method_10714());
            }
        }
        if (testedElement instanceof class_2514) {
            class_2514 testedNumber = (class_2514)testedElement;
            if (conditionElement instanceof class_2514) {
                class_2514 conditionNumber = (class_2514)conditionElement;
                return testedNumber.method_10697() == conditionNumber.method_10697();
            }
        }
        return true;
    }
}

