/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe.smithery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.items.jewelry.GemSlot;
import org.oxytocina.geomancy.items.jewelry.IJewelryItem;
import org.oxytocina.geomancy.items.jewelry.JewelryItem;
import org.oxytocina.geomancy.recipe.GatedModRecipe;
import org.oxytocina.geomancy.recipe.smithery.SmitheryRecipeI;
import org.oxytocina.geomancy.recipe.smithery.SmithingIngredient;
import org.oxytocina.geomancy.registries.ModRecipeTypes;

public class JewelryRecipe
extends GatedModRecipe<class_1263>
implements SmitheryRecipeI {
    public static final class_2960 UNLOCK_IDENTIFIER = null;
    protected final SmithingIngredient base;
    protected final int progressRequiredBase;
    protected final int difficulty;
    protected final float gemProgressCostMultiplier;
    protected final float gemDifficultyMultiplier;

    public JewelryRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, @NotNull SmithingIngredient base, int progressRequiredBase, float gemProgressCostMultiplier, int difficulty, float gemDifficultyMultiplier) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.base = base;
        this.progressRequiredBase = progressRequiredBase;
        this.difficulty = difficulty;
        this.gemProgressCostMultiplier = gemProgressCostMultiplier;
        this.gemDifficultyMultiplier = gemDifficultyMultiplier;
    }

    public boolean method_8115(@NotNull class_1263 inv, class_1937 world) {
        return !this.getOutput(inv, false, false).isEmpty();
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        List<class_1799> res = this.newCraft(inventory);
        return res.isEmpty() ? class_1799.field_8037 : res.get(0);
    }

    public List<class_1799> newCraft(class_1263 inv) {
        return this.getOutput(inv, true, false);
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return null;
    }

    public List<class_1799> getOutput(class_1263 inv, boolean removeIngredients, boolean preview) {
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        class_1799 baseStack = this.getRecipeBase(inv);
        if (baseStack.method_7960()) {
            return res;
        }
        class_1792 class_17922 = baseStack.method_7909();
        if (!(class_17922 instanceof IJewelryItem)) {
            return res;
        }
        IJewelryItem jewelryItem = (IJewelryItem)class_17922;
        ArrayList<GemSlot> presentGems = IJewelryItem.getSlots(baseStack);
        int freeSlots = jewelryItem.getGemSlotCount() - presentGems.size();
        HashMap<Integer, class_1799> gemSlotsToAdd = this.getAddedGems(inv, freeSlots);
        if (freeSlots <= 0 || gemSlotsToAdd.isEmpty() && !presentGems.isEmpty()) {
            if (presentGems.isEmpty()) {
                return res;
            }
            res.addAll(jewelryItem.UnSmith(baseStack, preview));
            if (removeIngredients) {
                baseStack.method_7934(1);
            }
            return res;
        }
        if (gemSlotsToAdd.isEmpty()) {
            return res;
        }
        class_1799 output = baseStack.method_7972();
        for (Integer i : gemSlotsToAdd.keySet()) {
            GemSlot newSlot = new GemSlot(gemSlotsToAdd.get(i).method_7909(), 1.0f);
            jewelryItem.addSlot(output, newSlot);
            if (!removeIngredients) continue;
            gemSlotsToAdd.get(i).method_7934(1);
        }
        if (removeIngredients) {
            baseStack.method_7934(1);
        }
        res.add(output);
        return res;
    }

    public HashMap<Integer, class_1799> getAddedGems(class_1263 inv, int freeSlots) {
        HashMap<Integer, class_1799> res = new HashMap<Integer, class_1799>();
        HashMap<Integer, class_1799> slotsWithGems = new HashMap<Integer, class_1799>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 slot = inv.method_5438(i);
            if (slot.method_7960() || !GemSlot.itemIsGem(slot)) continue;
            slotsWithGems.put(i, slot);
        }
        if (slotsWithGems.isEmpty()) {
            return res;
        }
        for (Integer i : slotsWithGems.keySet()) {
            if (res.size() >= freeSlots) break;
            res.put(i, (class_1799)slotsWithGems.get(i));
        }
        return res;
    }

    public class_1799 getRecipeBase(class_1263 inv) {
        for (int baseSlot = 0; baseSlot < inv.method_5439(); ++baseSlot) {
            if (!this.base.test(inv.method_5438(baseSlot))) continue;
            return inv.method_5438(baseSlot);
        }
        return class_1799.field_8037;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 res = class_2371.method_10211();
        res.add((Object)this.base.ingredient);
        return res;
    }

    @Override
    public int getDifficulty(class_1263 inv, class_1799 hammer, class_1309 hammerer) {
        class_1792 class_17922;
        int res = this.difficulty;
        class_1799 baseStack = this.getRecipeBase(inv);
        if (baseStack.method_7960() || !((class_17922 = baseStack.method_7909()) instanceof JewelryItem)) {
            return this.difficulty;
        }
        JewelryItem jewelryItem = (JewelryItem)class_17922;
        ArrayList<GemSlot> presentGems = IJewelryItem.getSlots(baseStack);
        int freeSlots = jewelryItem.gemSlotCount - presentGems.size();
        HashMap<Integer, class_1799> gemsToAdd = this.getAddedGems(inv, freeSlots);
        for (class_1799 s : gemsToAdd.values()) {
            res += Math.round(GemSlot.getGemDifficulty(s) * this.gemDifficultyMultiplier);
        }
        return res;
    }

    @Override
    public int getProgressRequired(class_1263 inv) {
        int res = this.progressRequiredBase;
        class_1799 baseStack = this.getRecipeBase(inv);
        class_1792 class_17922 = baseStack.method_7909();
        if (!(class_17922 instanceof IJewelryItem)) {
            return 1000000;
        }
        IJewelryItem jewelryItem = (IJewelryItem)class_17922;
        ArrayList<GemSlot> presentGems = IJewelryItem.getSlots(baseStack);
        int freeSlots = jewelryItem.getGemSlotCount() - presentGems.size();
        HashMap<Integer, class_1799> gemsToAdd = this.getAddedGems(inv, freeSlots);
        for (class_1799 s : gemsToAdd.values()) {
            res += Math.round(GemSlot.getGemProgressCost(s) * this.gemProgressCostMultiplier);
        }
        return res;
    }

    @Override
    public class_1799 getPreviewOutput(class_1263 inv) {
        List<class_1799> outputs = this.getOutput(inv, false, true);
        return outputs.isEmpty() ? class_1799.field_8037 : outputs.get(0);
    }

    @Override
    public boolean hasBaseStack() {
        return false;
    }

    @Override
    public List<SmithingIngredient> getSmithingIngredients(class_1263 inv) {
        ArrayList<SmithingIngredient> res = new ArrayList<SmithingIngredient>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            SmithingIngredient ing;
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            if (this.base.test(stack)) {
                ing = SmithingIngredient.ofItems(stack.method_7947(), this.base.mishapWeight, new class_1935[]{stack.method_7909()});
                res.add(ing);
                continue;
            }
            if (!GemSlot.itemIsGem(stack)) continue;
            ing = SmithingIngredient.ofItems(stack.method_7947(), 1, new class_1935[]{stack.method_7909()});
            res.add(ing);
        }
        return res;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.SMITHERY.method_8389());
    }

    public class_1865<?> method_8119() {
        return ModRecipeTypes.JEWELRY_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.JEWELRY;
    }

    @Override
    public boolean isShapeless() {
        return true;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "jewelry";
    }

    @Override
    public List<class_1799> getSmithingResult(class_1263 inv, boolean removeItems, boolean preview, class_1799 hammer, class_1309 hammerer, class_1937 world) {
        return this.getOutput(inv, removeItems, preview);
    }
}

