/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe.smithery;

import com.google.gson.JsonObject;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.oxytocina.geomancy.recipe.GatedRecipeSerializer;
import org.oxytocina.geomancy.recipe.smithery.JewelryRecipe;
import org.oxytocina.geomancy.recipe.smithery.SmithingIngredient;

public class JewelryRecipeSerializer<R extends JewelryRecipe>
implements GatedRecipeSerializer<R> {
    public final RecipeFactory<R> recipeFactory;

    public JewelryRecipeSerializer(RecipeFactory<R> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public R read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        SmithingIngredient base = SmithingIngredient.fromJson(jsonObject.get("base"));
        int progressRequiredBase = jsonObject.get("progressRequiredBase").getAsInt();
        int difficulty = jsonObject.get("difficulty").getAsInt();
        float gemProgressCostMultiplier = jsonObject.get("gemProgressCostMultiplier").getAsFloat();
        float gemDifficultyMultiplier = jsonObject.get("gemDifficultyMultiplier").getAsFloat();
        return (R)((JewelryRecipe)this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, base, progressRequiredBase, gemProgressCostMultiplier, difficulty, gemDifficultyMultiplier));
    }

    public void write(class_2540 packetByteBuf, R recipe) {
        packetByteBuf.method_10814(((JewelryRecipe)recipe).group);
        packetByteBuf.writeBoolean(((JewelryRecipe)recipe).secret);
        this.writeNullableIdentifier(packetByteBuf, ((JewelryRecipe)recipe).requiredAdvancementIdentifier);
        ((JewelryRecipe)recipe).base.write(packetByteBuf);
        packetByteBuf.writeInt(((JewelryRecipe)recipe).progressRequiredBase);
        packetByteBuf.writeInt(((JewelryRecipe)recipe).difficulty);
        packetByteBuf.writeFloat(((JewelryRecipe)recipe).gemProgressCostMultiplier);
        packetByteBuf.writeFloat(((JewelryRecipe)recipe).gemDifficultyMultiplier);
    }

    public R read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        SmithingIngredient base = SmithingIngredient.fromPacket(packetByteBuf);
        int progressRequiredBase = packetByteBuf.readInt();
        int difficulty = packetByteBuf.readInt();
        float gemProgressCostMultiplier = packetByteBuf.readFloat();
        float gemDifficultyMultiplier = packetByteBuf.readFloat();
        return (R)((JewelryRecipe)this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, base, progressRequiredBase, gemProgressCostMultiplier, difficulty, gemDifficultyMultiplier));
    }

    public static interface RecipeFactory<R> {
        public R create(class_2960 var1, String var2, boolean var3, class_2960 var4, SmithingIngredient var5, int var6, float var7, int var8, float var9);
    }
}

