/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe.soulforge;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.recipe.GatedModRecipe;
import org.oxytocina.geomancy.recipe.NbtIngredient;
import org.oxytocina.geomancy.recipe.soulforge.ISoulForgeRecipe;
import org.oxytocina.geomancy.registries.ModRecipeTypes;

public class SoulForgeRecipe
extends GatedModRecipe<class_1263>
implements ISoulForgeRecipe {
    public static final class_2960 UNLOCK_IDENTIFIER = Geomancy.locate("milestones/milestone_soulforge");
    protected final List<NbtIngredient> inputs;
    protected final class_1799 output;
    protected final float cost;
    protected final float instability;
    protected final float speed;

    public SoulForgeRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, List<NbtIngredient> inputs, class_1799 output, float cost, float instability, float speed) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.inputs = inputs;
        this.output = output;
        this.cost = cost;
        this.instability = instability;
        this.speed = speed;
    }

    public boolean method_8115(@NotNull class_1263 inv, class_1937 world) {
        return this.inputsPresent(inv);
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        return this.output;
    }

    public boolean inputsPresent(class_1263 inv) {
        ArrayList<Integer> usedUp = new ArrayList<Integer>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            boolean present = false;
            NbtIngredient input = this.inputs.get(i);
            if (i == 0) {
                if (input.test(inv.method_5438(0))) continue;
                return false;
            }
            for (int j = 1; j < inv.method_5439(); ++j) {
                if (usedUp.contains(j) || !input.test(inv.method_5438(j))) continue;
                present = true;
                usedUp.add(j);
                break;
            }
            if (present) continue;
            return false;
        }
        return true;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return this.output;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 res = class_2371.method_10211();
        for (NbtIngredient ing : this.inputs) {
            res.add((Object)ing.ingredient);
        }
        return res;
    }

    public class_1799 method_17447() {
        return ModBlocks.SOUL_FORGE.method_8389().method_7854();
    }

    public class_1865<?> method_8119() {
        return ModRecipeTypes.SOULFORGE_SIMPLE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.SOULFORGE_SIMPLE;
    }

    @Override
    public boolean isShapeless() {
        return true;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "soulforge_simple";
    }

    public float getCost() {
        return this.cost;
    }

    public float getInstability() {
        return this.instability;
    }

    public float getSpeed() {
        return this.speed;
    }

    @Override
    public List<class_1799> getResult(class_1263 inv, boolean removeItems, boolean preview, class_1309 owner) {
        return List.of(this.output);
    }

    @Override
    public float getSoulCost(class_1263 inv) {
        return this.getCost();
    }

    @Override
    public float getInstability(class_1263 inv) {
        return this.getInstability();
    }

    @Override
    public float getSpeed(class_1263 inv) {
        return this.getSpeed();
    }

    @Override
    public class_1799 getPreviewOutput(class_1263 inv) {
        return this.output;
    }

    @Override
    public boolean hasBaseStack() {
        return false;
    }

    @Override
    public List<NbtIngredient> getNbtIngredients(@Nullable class_1263 inv) {
        return this.inputs;
    }

    @Override
    public class_2960 getIdentifier() {
        return this.id;
    }
}

