/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.spells;

import com.mojang.datafixers.util.Function3;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5704;
import net.minecraft.class_5712;
import net.minecraft.class_7133;
import org.oxytocina.geomancy.client.util.CamShakeUtil;
import org.oxytocina.geomancy.items.ISpellSelectorItem;
import org.oxytocina.geomancy.spells.SpellBlock;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellBlockResult;
import org.oxytocina.geomancy.spells.SpellBlocks;
import org.oxytocina.geomancy.spells.SpellComponent;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.spells.SpellSignal;
import org.oxytocina.geomancy.util.EnlightenmentUtil;
import org.oxytocina.geomancy.util.MadnessUtil;
import org.oxytocina.geomancy.util.ParticleUtil;
import org.oxytocina.geomancy.util.SoulUtil;
import org.oxytocina.geomancy.util.Toolbox;

public class SpellBlocks2 {
    public static final SpellBlock EXODIA_1;
    public static final SpellBlock EXODIA_2;
    public static final SpellBlock EXODIA_3;
    public static final SpellBlock EXODIA_4;
    public static final SpellBlock EXODIA_5;
    private static final List<Exodia2Data> EXODIA_2_DATA;
    private static SpellBlock.Category cat;

    private static List<SpellSignal> createNumberList(float[] vals) {
        ArrayList<SpellSignal> res = new ArrayList<SpellSignal>();
        for (int i = 0; i < vals.length; ++i) {
            res.add(SpellSignal.createNumber(vals[i]).named(Integer.toString(i)));
        }
        return res;
    }

    private static List<SpellSignal> createTextList(String[] vals) {
        ArrayList<SpellSignal> res = new ArrayList<SpellSignal>();
        for (int i = 0; i < vals.length; ++i) {
            res.add(SpellSignal.createText(vals[i]).named(Integer.toString(i)));
        }
        return res;
    }

    private static boolean isListSorted(List<SpellSignal> list) {
        Float current = null;
        for (int i = 0; i < list.size(); ++i) {
            SpellSignal sig = list.get(i);
            if (sig.type != SpellSignal.Type.Number) {
                return false;
            }
            Float val = Float.valueOf(sig.getNumberValue());
            if (current == null) {
                current = val;
                continue;
            }
            if (!(val.floatValue() < current.floatValue())) continue;
            return false;
        }
        return true;
    }

    static {
        EXODIA_2_DATA = List.of(new Exodia2Data("reverse", (Function3<SpellContext, SpellBlockArgs, SpellBlockResult, Boolean>)((Function3)(c, in, out) -> out.vars.containsKey("res") && Objects.equals(in.getText("arg"), Toolbox.reverseString(out.vars.get("res").getTextValue()))), SpellBlocks2.createTextList(new String[]{"test", "helloworld", "geomancy", "octopus", "loremipsum", "foobar", "onlyfoolsdoreadthis", "cowlevel", "transrightsarehumanrights", "congratulations", "you", "won!"})), new Exodia2Data("factorial", (Function3<SpellContext, SpellBlockArgs, SpellBlockResult, Boolean>)((Function3)(c, in, out) -> out.vars.containsKey("res") && Toolbox.roughlyEqual(out.vars.get("arg").getNumberValue(), Toolbox.factorial(in.getInt("res")), 0.1f)), SpellBlocks2.createNumberList(new float[]{1.0f, 6.0f, 4.0f, 9.0f, 11.0f, 17.0f, 20.0f, 18.0f, 2.0f})), new Exodia2Data("mix", (Function3<SpellContext, SpellBlockArgs, SpellBlockResult, Boolean>)((Function3)(c, in, out) -> {
            if (c.caster == null) {
                return false;
            }
            if (out.vars.isEmpty() || !out.vars.containsKey("res")) {
                return false;
            }
            SpellSignal sig = out.vars.get("res");
            if (sig.type != SpellSignal.Type.List) {
                return false;
            }
            List<SpellSignal> list = sig.getListValue();
            if (list.size() != 3) {
                return false;
            }
            if (!SpellSignal.createUUID((class_1297)c.caster).softEquals(list.get(0))) {
                return false;
            }
            if (!SpellSignal.createText(c.caster.method_5477().getString()).softEquals(list.get(1))) {
                return false;
            }
            if (!Toolbox.roughlyEqual(list.get(2).getNumberValue(), 0.0f, 0.1f)) {
                return false;
            }
            return true;
        }), List.of(SpellSignal.createNone())), new Exodia2Data("pythagoras", (Function3<SpellContext, SpellBlockArgs, SpellBlockResult, Boolean>)((Function3)(c, in, out) -> {
            if (!out.vars.containsKey("res")) {
                return false;
            }
            List<SpellSignal> listIn = in.getList("arg");
            float a = listIn.get(0).getNumberValue();
            float b = listIn.get(1).getNumberValue();
            double cDesired = Math.sqrt(a * a + b * b);
            float cProvided = out.vars.get("res").getNumberValue();
            return Toolbox.roughlyEqual((float)cDesired, cProvided, 0.1f);
        }), List.of(SpellSignal.createList(List.of(SpellSignal.createNumber(1.0f), SpellSignal.createNumber(1.0f))), SpellSignal.createList(List.of(SpellSignal.createNumber(3.0f), SpellSignal.createNumber(1.0f))), SpellSignal.createList(List.of(SpellSignal.createNumber(10.0f), SpellSignal.createNumber(6.0f))), SpellSignal.createList(List.of(SpellSignal.createNumber(21.0f), SpellSignal.createNumber(75.0f))), SpellSignal.createList(List.of(SpellSignal.createNumber(3.0f), SpellSignal.createNumber(665.0f))))));
        cat = SpellBlock.Category.Ancient;
        EXODIA_1 = SpellBlocks.register(SpellBlock.Builder.create("exodia_1").inputs(SpellSignal.createAny()).func((comp, args) -> {
            class_1309 patt0$temp = comp.context.caster;
            if (!(patt0$temp instanceof class_3222)) {
                return SpellBlockResult.empty();
            }
            class_3222 spe = (class_3222)patt0$temp;
            float ambientSouls = SoulUtil.getAmbientSoulsPerBlock(comp.world(), comp.context.getOriginBlockPos());
            if (ambientSouls >= 1000.0f) {
                float manaCost = 500.0f;
                if (SpellBlocks.trySpendSoul(comp, manaCost)) {
                    SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastSuccess(comp, comp.context.getOriginPos()));
                    SpellBlocks.tryUnlockSpellAdvancement((class_1309)spe, "enlightenment_1");
                    MadnessUtil.addMadness(spe, 500.0f);
                    MadnessUtil.syncMadness((class_1657)spe);
                } else {
                    SpellBlocks.tryLogDebugBroke(comp, manaCost);
                    SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastBroke(comp, comp.context.getOriginPos()));
                }
            }
            return SpellBlockResult.empty();
        }).category(cat).defaultLootWeight(0).build());
        EXODIA_2 = SpellBlocks.register(SpellBlock.Builder.create("exodia_2").inputs(SpellSignal.createAny()).parameters(SpellBlock.Parameter.createText("spell", "helloworld")).func((comp, args) -> {
            class_1792 patt1$temp;
            class_1309 patt0$temp = comp.context.caster;
            if (!(patt0$temp instanceof class_3222)) {
                return SpellBlockResult.empty();
            }
            class_3222 spe = (class_3222)patt0$temp;
            if (EnlightenmentUtil.getEnlightenmentServer(spe) < 1) {
                return SpellBlockResult.empty();
            }
            if (!comp.context.hasCasterItem() || !((patt1$temp = comp.context.casterItem.method_7909()) instanceof ISpellSelectorItem)) {
                return SpellBlockResult.empty();
            }
            ISpellSelectorItem sps = (ISpellSelectorItem)patt1$temp;
            class_1937 patt2$temp = comp.world();
            if (!(patt2$temp instanceof class_3218)) {
                return SpellBlockResult.empty();
            }
            class_3218 sw = (class_3218)patt2$temp;
            Exodia2Data task = EXODIA_2_DATA.get((int)(sw.method_8412() % (long)EXODIA_2_DATA.size()));
            SpellGrid providedSpell = sps.getSpell(comp.context.casterItem, args.getText("spell"));
            if (providedSpell == null) {
                SpellBlocks.tryLogDebug(comp, (class_2561)class_2561.method_43471((String)"geomancy.spells.debug.exodia2").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43471((String)("geomancy.spells.debug.exodia2." + task.name)).method_27692(class_124.field_1080)));
                return SpellBlockResult.empty();
            }
            boolean passedTests = true;
            for (SpellSignal testCase : task.testcases) {
                SpellBlockArgs testArgs = SpellBlockArgs.empty();
                testArgs.vars.put("arg", testCase);
                SpellBlockResult testRes = providedSpell.runReferenced(comp.context, (SpellComponent)comp, testArgs);
                if (((Boolean)task.check.apply((Object)comp.context, (Object)testArgs, (Object)testRes)).booleanValue()) continue;
                passedTests = false;
                break;
            }
            if (passedTests) {
                float manaCost = 250.0f;
                if (SpellBlocks.trySpendSoul(comp, manaCost)) {
                    SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastSuccess(comp, comp.context.getOriginPos()));
                    SpellBlocks.tryUnlockSpellAdvancement((class_1309)spe, "enlightenment_2");
                    CamShakeUtil.cause(comp.world(), comp.context.getOriginPos(), 100.0f, 0.5f, 10.0f);
                    MadnessUtil.addMadness(spe, 750.0f);
                    MadnessUtil.syncMadness((class_1657)spe);
                } else {
                    SpellBlocks.tryLogDebugBroke(comp, manaCost);
                    SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastBroke(comp, comp.context.getOriginPos()));
                }
                return SpellBlockResult.empty();
            }
            SpellBlocks.tryLogDebug(comp, (class_2561)class_2561.method_43471((String)"geomancy.spells.debug.exodia2_fail").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43471((String)("geomancy.spells.debug.exodia2." + task.name)).method_27692(class_124.field_1080)));
            return SpellBlockResult.empty();
        }).category(cat).defaultLootWeight(0).build());
        EXODIA_3 = SpellBlocks.register(SpellBlock.Builder.create("exodia_3").post(comp -> {
            class_1309 patt0$temp = comp.context.caster;
            if (!(patt0$temp instanceof class_3222)) {
                return;
            }
            class_3222 spe = (class_3222)patt0$temp;
            if (EnlightenmentUtil.getEnlightenmentServer(spe) < 2) {
                return;
            }
            if (!comp.context.hasFlag("exodia_3")) {
                return;
            }
            float manaCost = 250.0f;
            if (SpellBlocks.trySpendSoul(comp, manaCost)) {
                SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastSuccess(comp, comp.context.getOriginPos()));
                SpellBlocks.tryUnlockSpellAdvancement((class_1309)spe, "enlightenment_3");
                CamShakeUtil.cause(comp.world(), comp.context.getOriginPos(), 100.0f, 0.5f, 10.0f);
                MadnessUtil.addMadness(spe, 1000.0f);
                MadnessUtil.syncMadness((class_1657)spe);
                spe.method_42272().ifPresent(manager -> manager.method_42248(10));
                class_3218 sw = spe.method_51469();
                class_1923 centerChunkPos = sw.method_22350(comp.context.getOriginBlockPos()).method_12004();
                int range = 4;
                for (int ix = -4; ix <= 4; ++ix) {
                    for (int iz = -4; iz <= 4; ++iz) {
                        class_2818 chunk = sw.method_8497(centerChunkPos.field_9181 + ix, centerChunkPos.field_9180 + iz);
                        for (class_2586 be : chunk.method_12214().values()) {
                            if (be instanceof class_5704) {
                                class_5704 sculkSensor = (class_5704)be;
                                sculkSensor.method_32911().method_32947(sw, class_5712.field_28155, new class_5712.class_7397((class_1297)spe, null), comp.context.getOriginPos());
                                continue;
                            }
                            if (!(be instanceof class_7133)) continue;
                            class_7133 shrieker = (class_7133)be;
                            shrieker.method_42325().method_32947(sw, class_5712.field_28155, new class_5712.class_7397((class_1297)spe, null), comp.context.getOriginPos());
                        }
                    }
                }
            } else {
                SpellBlocks.tryLogDebugBroke(comp, manaCost);
                SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastBroke(comp, comp.context.getOriginPos()));
            }
        }).category(cat).defaultLootWeight(0).build());
        EXODIA_4 = SpellBlocks.register(SpellBlock.Builder.create("exodia_4").func((comp, args) -> {
            class_1309 patt0$temp = comp.caster();
            if (!(patt0$temp instanceof class_3222)) {
                return SpellBlockResult.empty();
            }
            class_3222 spe = (class_3222)patt0$temp;
            if (EnlightenmentUtil.getEnlightenmentServer(spe) < 3) {
                return SpellBlockResult.empty();
            }
            if (spe.method_51469().method_27983().method_29177().equals((Object)new class_2960("the_end")) && spe.method_19538().field_1351 <= -60.0) {
                float manaCost = 250.0f;
                if (SpellBlocks.trySpendSoul(comp, manaCost)) {
                    SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastSuccess(comp, comp.context.getOriginPos()));
                    SpellBlocks.tryUnlockSpellAdvancement((class_1309)spe, "enlightenment_4");
                    CamShakeUtil.cause(comp.world(), comp.context.getOriginPos(), 100.0f, 0.5f, 10.0f);
                    MadnessUtil.addMadness(spe, 1500.0f);
                    MadnessUtil.syncMadness((class_1657)spe);
                } else {
                    SpellBlocks.tryLogDebugBroke(comp, manaCost);
                    SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastBroke(comp, comp.context.getOriginPos()));
                }
            }
            return SpellBlockResult.empty();
        }).category(cat).defaultLootWeight(0).build());
        EXODIA_5 = SpellBlocks.register(SpellBlock.Builder.create("exodia_5").post(comp -> {
            class_1309 patt0$temp = comp.context.caster;
            if (!(patt0$temp instanceof class_3222)) {
                return;
            }
            class_3222 spe = (class_3222)patt0$temp;
            if (EnlightenmentUtil.getEnlightenmentServer(spe) < 4) {
                return;
            }
            if (!comp.context.hasFlag("exodia_5")) {
                return;
            }
            float manaCost = 1000.0f;
            if (SpellBlocks.trySpendSoul(comp, manaCost)) {
                SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastSuccess(comp, comp.context.getOriginPos()));
                SpellBlocks.tryUnlockSpellAdvancement((class_1309)spe, "enlightenment_5");
                CamShakeUtil.cause(comp.world(), comp.context.getOriginPos(), 100.0f, 0.5f, 10.0f);
                MadnessUtil.addMadness(spe, 5000.0f);
                MadnessUtil.syncMadness((class_1657)spe);
            } else {
                SpellBlocks.tryLogDebugBroke(comp, manaCost);
                SpellBlocks.spawnCastParticles(comp, ParticleUtil.ParticleData.createGenericCastBroke(comp, comp.context.getOriginPos()));
            }
        }).category(cat).defaultLootWeight(0).build());
    }

    public static class Exodia2Data {
        public String name;
        public Function3<SpellContext, SpellBlockArgs, SpellBlockResult, Boolean> check;
        public List<SpellSignal> testcases;

        public Exodia2Data(String name, Function3<SpellContext, SpellBlockArgs, SpellBlockResult, Boolean> check, List<SpellSignal> testcases) {
            this.name = name;
            this.check = check;
            this.testcases = testcases;
        }
    }
}

