/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.spells;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.spells.SpellBlock;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellBlockResult;
import org.oxytocina.geomancy.spells.SpellBlocks;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.spells.SpellSignal;
import org.oxytocina.geomancy.util.ByteUtil;
import org.oxytocina.geomancy.util.EnlightenmentUtil;

public class SpellComponent {
    public static final int CURRENT_DATA_FORMAT_VERSION = 1;
    public SideConfig[] sideConfigs;
    public HashMap<String, SpellSignal> receivedSignals = new HashMap();
    public HashMap<String, ConfiguredParameter> configuredParameters = new HashMap();
    public HashMap<Byte, SpellComponent> neighbors = new HashMap();
    public SpellBlock function;
    public SpellGrid parent;
    public Vector2i position;
    public SpellContext context;
    public byte rotation = 0;
    public HashMap<String, String> castClearedData = new HashMap();
    public static final String[] directions = new String[]{"ne", "e", "se", "sw", "w", "nw"};

    public SpellComponent(SpellGrid parent, Vector2i position, SpellBlock function, SideConfig[] sideConfigs, HashMap<String, ConfiguredParameter> configuredParameters) {
        this.parent = parent;
        this.position = position;
        this.function = function;
        this.sideConfigs = sideConfigs;
        this.configuredParameters = configuredParameters;
    }

    @NotNull
    public class_1937 world() {
        return this.context.getWorld();
    }

    public class_1309 caster() {
        return this.context.caster;
    }

    public SpellComponent(SpellGrid parent, Vector2i position, SpellBlock function) {
        this.function = function;
        this.parent = parent;
        this.position = position;
        this.sideConfigs = function.getDefaultSideConfigs(this);
        for (String p : function.parameters.keySet()) {
            this.configuredParameters.put(p, new ConfiguredParameter(function.parameters.get(p)));
        }
    }

    private SpellComponent(SpellGrid parent, class_2540 buf) {
        this.parent = parent;
        this.deserialize(buf);
    }

    public SpellComponent(SpellGrid parent, class_2487 nbt) {
        this.parent = parent;
        this.readNbt(nbt);
    }

    public void preRunSetup(SpellContext context) {
        this.context = context;
        this.castClearedData.clear();
        this.function.initRun(this);
    }

    public void run() {
        this.tryExecute();
    }

    public void postRun() {
        this.function.postRun(this);
    }

    public boolean tryAcceptSignalFrom(byte dir, SpellSignal signal) {
        byte sideConfDir = SpellComponent.mirrorDirection(dir);
        SideConfig conf = this.getSideConfig(sideConfDir);
        if (!conf.isInput()) {
            return false;
        }
        if (!conf.canReceiveSignalOfType(this.function, signal.type)) {
            SpellBlocks.tryLogDebugWrongSignal(this, signal.type, conf.getSignalType(this.function));
            return false;
        }
        this.receiveSignal(signal.clone().named(conf.varName));
        return true;
    }

    public void receiveSignal(SpellSignal signal) {
        if (this.hasSignal(signal.name)) {
            return;
        }
        this.receivedSignals.put(signal.name, signal);
        this.tryExecute();
    }

    public void pushSignals(HashMap<String, SpellSignal> signals) {
        if (signals.isEmpty()) {
            return;
        }
        for (SideConfig sideConfig : this.sideConfigs) {
            if (!sideConfig.isOutput() || !signals.containsKey(sideConfig.varName)) continue;
            this.pushSignal(sideConfig.dir, signals.get(sideConfig.varName));
        }
    }

    public void pushSignals(SpellBlockResult res) {
        if (res.depth > this.context.depthLimit) {
            this.context.depthLimitReached = true;
            return;
        }
        res.refreshSignalDepths();
        this.pushSignals(res.vars);
    }

    public void pushSignal(byte dir, SpellSignal signal) {
        if (!this.hasNeighbor(dir)) {
            return;
        }
        this.getNeighbor(dir).tryAcceptSignalFrom(dir, signal);
    }

    public void tryExecute() {
        if (!this.canExecute()) {
            return;
        }
        if (this.context.timedOut()) {
            return;
        }
        HashMap<String, SpellSignal> args = new HashMap<String, SpellSignal>();
        args.putAll(this.receivedSignals);
        int highestSignalDepth = this.context.baseDepth;
        for (SpellSignal sig : this.receivedSignals.values()) {
            if (sig.getDepth() <= highestSignalDepth) continue;
            highestSignalDepth = sig.getDepth();
        }
        this.context.highestRecordedDepth = Math.max(this.context.highestRecordedDepth, highestSignalDepth);
        if (highestSignalDepth > this.context.depthLimit) {
            return;
        }
        for (ConfiguredParameter param : this.configuredParameters.values()) {
            SpellSignal paramSig = param.getSignal();
            args.put(paramSig.name, paramSig);
        }
        SpellBlockArgs blockArgs = new SpellBlockArgs(args);
        SpellBlockResult result = this.function.run(this, blockArgs);
        result.depth = highestSignalDepth + 1;
        for (int i = 0; i < result.iterations; ++i) {
            SpellBlockResult iterationResult = result.clone();
            iterationResult.depth += i;
            if (iterationResult.depth > this.context.depthLimit) {
                this.context.depthLimitReached = true;
                break;
            }
            iterationResult.add(result.iterationVarName, i);
            iterationResult.refreshSignalDepths();
            this.pushSignals(iterationResult.vars);
            if (iterationResult.subResults == null) continue;
            for (SpellBlockResult subRes : iterationResult.subResults) {
                this.pushSignals(subRes.vars);
            }
        }
        this.receivedSignals.clear();
    }

    public boolean canExecute() {
        if (this.context == null) {
            return false;
        }
        for (String varName : this.function.inputs.keySet()) {
            if (!this.receivedSignals.containsKey(varName)) {
                return false;
            }
            SpellSignal varObj = this.function.inputs.get(varName);
            SpellSignal received = this.receivedSignals.get(varName);
            if (SpellSignal.typesCompatible(received.type, varObj.type)) continue;
            return false;
        }
        return true;
    }

    public SideConfig getSideConfig(byte dir) {
        return this.sideConfigs[ByteUtil.byteToInt(dir)];
    }

    public void setNeighbor(byte dir, SpellComponent comp) {
        this.neighbors.put(dir, comp);
    }

    public SpellComponent getNeighbor(byte dir) {
        return this.hasNeighbor(dir) ? this.neighbors.get(dir) : null;
    }

    public boolean hasNeighbor(byte dir) {
        return this.neighbors.containsKey(dir) && this.neighbors.get(dir) != null;
    }

    public class_2540 serialize() {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(1);
        buf.writeByte((int)this.rotation);
        buf.method_10812(this.function.identifier);
        buf.writeBoolean(this.position != null);
        if (this.position != null) {
            buf.writeInt(this.position.x);
            buf.writeInt(this.position.y);
        }
        buf.writeInt(this.sideConfigs.length);
        for (SideConfig s : this.sideConfigs) {
            s.serialize(buf);
        }
        buf.writeInt(this.configuredParameters.size());
        for (ConfiguredParameter s : this.configuredParameters.values()) {
            s.serialize(buf);
        }
        return buf;
    }

    public static SpellComponent deserialize(SpellGrid parent, class_2540 buf) {
        return new SpellComponent(parent, buf);
    }

    public void deserialize(class_2540 buf) {
        int formatVersion = buf.readInt();
        this.rotation = buf.readByte();
        this.function = SpellBlocks.get(buf.method_10810());
        this.sideConfigs = this.function.getDefaultSideConfigs(this);
        boolean hasPos = buf.readBoolean();
        if (hasPos) {
            this.position = new Vector2i(buf.readInt(), buf.readInt());
        }
        int confLength = buf.readInt();
        for (int i = 0; i < confLength; ++i) {
            this.sideConfigs[i].deserialize(buf);
        }
        int paramsLength = buf.readInt();
        for (int i = 0; i < paramsLength; ++i) {
            ConfiguredParameter param = ConfiguredParameter.deserialize(this.function, buf);
            this.configuredParameters.put(param.parameter.name, param);
        }
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("v", 1);
        String rotKey = "r";
        String funcKey = "f";
        String sidesKey = "s";
        String paramsKey = "p";
        if (this.rotation != 0) {
            nbt.method_10569(rotKey, (int)this.rotation);
        }
        nbt.method_10582(funcKey, this.function.identifier.toString());
        if (this.position != null) {
            nbt.method_10569("x", this.position.x);
            nbt.method_10569("y", this.position.y);
        }
        class_2499 sidesNbt = new class_2499();
        SideConfig[] defaultSides = this.function.getDefaultSideConfigs(this);
        for (int i = 0; i < 6; ++i) {
            SideConfig s = this.sideConfigs[i];
            if (s.equals(defaultSides[i])) continue;
            class_2487 cComp = new class_2487();
            s.writeNbt(cComp, 1);
            sidesNbt.add((Object)cComp);
        }
        if (!sidesNbt.isEmpty()) {
            nbt.method_10566(sidesKey, (class_2520)sidesNbt);
        }
        class_2499 paramsNbt = new class_2499();
        for (ConfiguredParameter s : this.configuredParameters.values()) {
            class_2487 cComp = new class_2487();
            s.writeNbt(cComp, 1);
            paramsNbt.add((Object)cComp);
        }
        if (!paramsNbt.isEmpty()) {
            nbt.method_10566(paramsKey, (class_2520)paramsNbt);
        }
    }

    public void readNbt(class_2487 nbt) {
        int version;
        if (nbt.method_10545("data")) {
            // empty if block
        }
        String rotKey = (version = nbt.method_10550("v")) >= 1 ? "r" : "rotation";
        String funcKey = version >= 1 ? "f" : "func";
        String sidesKey = version >= 1 ? "s" : "sides";
        String paramsKey = version >= 1 ? "p" : "params";
        this.rotation = nbt.method_10545(rotKey) ? ByteUtil.intToByte(nbt.method_10550(rotKey)) : (byte)0;
        this.function = SpellBlocks.get(nbt.method_10558(funcKey));
        this.position = nbt.method_10573("x", 3) && nbt.method_10573("y", 3) ? new Vector2i(nbt.method_10550("x"), nbt.method_10550("y")) : null;
        class_2499 sidesNbt = nbt.method_10545(sidesKey) ? nbt.method_10554(sidesKey, 10) : new class_2499();
        this.sideConfigs = this.function.getDefaultSideConfigs(this);
        for (int i = 0; i < sidesNbt.size(); ++i) {
            SideConfig conf;
            class_2520 class_25202 = sidesNbt.method_10534(i);
            if (!(class_25202 instanceof class_2487)) continue;
            class_2487 comp = (class_2487)class_25202;
            this.sideConfigs[ByteUtil.byteToInt((byte)conf.dir)] = conf = SideConfig.createFromNbt(this, comp, version);
        }
        class_2499 paramsNbt = nbt.method_10545(paramsKey) ? nbt.method_10554(paramsKey, 10) : new class_2499();
        this.configuredParameters.clear();
        HashMap<String, SpellBlock.Parameter> params = this.function.parameters;
        for (int i = 0; i < paramsNbt.size(); ++i) {
            class_2520 class_25203 = paramsNbt.method_10534(i);
            if (!(class_25203 instanceof class_2487)) continue;
            class_2487 comp = (class_2487)class_25203;
            ConfiguredParameter param = ConfiguredParameter.fromNbt(this.function, comp, version);
            if (param.parameter == null || !params.containsKey(param.parameter.name)) continue;
            this.configuredParameters.put(param.parameter.name, param);
        }
        for (String param : params.keySet()) {
            if (this.configuredParameters.containsKey(param)) continue;
            this.configuredParameters.put(param, new ConfiguredParameter(params.get(param)));
        }
    }

    public void setParam(String param, float val) {
        ConfiguredParameter p = this.getParam(param);
        if (p == null) {
            return;
        }
        p.setValue(val);
    }

    public void setParam(String param, String val) {
        ConfiguredParameter p = this.getParam(param);
        if (p == null) {
            return;
        }
        p.setValue(val);
    }

    public void setParam(String param, boolean val) {
        this.setParam(param, val ? 1.0f : 0.0f);
    }

    public ConfiguredParameter getParam(String key) {
        if (this.configuredParameters.containsKey(key)) {
            return this.configuredParameters.get(key);
        }
        return null;
    }

    public static byte mirrorDirection(byte dir) {
        return SpellComponent.rotateDirection(dir, 3);
    }

    public static byte rotateDirection(byte dir, int clockwiseTicks) {
        return ByteUtil.intToByte((ByteUtil.byteToInt(dir) + clockwiseTicks) % directions.length);
    }

    public static int getDirIndex(String dir) {
        for (int i = 0; i < directions.length; ++i) {
            if (!Objects.equals(dir, directions[i])) continue;
            return i;
        }
        return 0;
    }

    public static String getDirString(int index) {
        return directions[(index % 6 + 6) % 6];
    }

    public boolean hasSignal(String name) {
        return this.receivedSignals.containsKey(name);
    }

    public class_2960 getHexFrontTexture() {
        return this.function.getHexFrontTexture();
    }

    public class_2960 getHexBackTexture() {
        return this.function.getHexBackTexture();
    }

    public void rotate(int amount) {
        this.rotation = ByteUtil.intToByte((ByteUtil.byteToInt(this.rotation) - amount % 6 + 6) % 6);
        SideConfig[] newConfigs = new SideConfig[6];
        for (int i = 0; i < 6; ++i) {
            newConfigs[i] = this.sideConfigs[(i - amount % 6 + 6) % 6];
            newConfigs[i].dir = ByteUtil.intToByte(i);
        }
        this.sideConfigs = newConfigs;
    }

    public boolean canAcceptParam(String paramName, String val) {
        return this.getParam(paramName).canAccept(val);
    }

    public void setAndParseParam(String paramName, String val) {
        this.getParam(paramName).setParsed(val);
    }

    public class_1799 getItemStack() {
        return this.function.getItemStack();
    }

    public boolean isAncient() {
        return this.function.isAncient();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isObfuscated() {
        return switch (this.function.identifier.toString()) {
            case "geomancy:exodia_1" -> {
                if (EnlightenmentUtil.getEnlightenmentClient() < 1) {
                    yield true;
                }
                yield false;
            }
            case "geomancy:exodia_2" -> {
                if (EnlightenmentUtil.getEnlightenmentClient() < 2) {
                    yield true;
                }
                yield false;
            }
            case "geomancy:exodia_3" -> {
                if (EnlightenmentUtil.getEnlightenmentClient() < 3) {
                    yield true;
                }
                yield false;
            }
            case "geomancy:exodia_4" -> {
                if (EnlightenmentUtil.getEnlightenmentClient() < 4) {
                    yield true;
                }
                yield false;
            }
            case "geomancy:exodia_5" -> {
                if (EnlightenmentUtil.getEnlightenmentClient() < 5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public SpellComponent clone() {
        return new SpellComponent(this.parent, this.position, this.function, this.sideConfigs, this.configuredParameters);
    }

    public class_5250 getRuntimeName() {
        return class_2561.method_43471((String)("geomancy.spellcomponent." + this.function.identifier.method_12832())).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)(" [" + this.context.grid.getRuntimeName(this.context).getString() + ":" + this.position.x + "," + this.position.y + "]")).method_27692(class_124.field_1063));
    }

    public static Builder builder(SpellBlock func) {
        return new Builder(func);
    }

    public static Builder.ConfBuilder confBuilder(String dir, String name) {
        return new Builder.ConfBuilder(dir, name);
    }

    public static Builder.ConfBuilder confBuilder(String dir) {
        return new Builder.ConfBuilder(dir, "");
    }

    public static class SideConfig {
        public byte dir;
        public String varName;
        public byte selectedMode = 0;
        public ArrayList<Mode> modes;
        public SpellComponent parent;

        private SideConfig(SpellComponent parent, class_2487 nbt, int version) {
            this.parent = parent;
            this.readNbt(nbt, version);
            this.modes = parent.function.getDefaultSideConfigs((SpellComponent)parent)[(ByteUtil.byteToInt((byte)this.dir) + parent.rotation + 6) % 6].modes;
            this.sanityCheckVarName(false);
        }

        public SideConfig(SpellComponent parent, String dir, String varName, Mode[] modes) {
            this.parent = parent;
            this.dir = ByteUtil.intToByte(SpellComponent.getDirIndex(dir));
            this.varName = varName;
            this.modes = new ArrayList();
            this.modes.addAll(Arrays.asList(modes));
        }

        public static SideConfig create(SpellComponent parent, Mode[] modes, String dir) {
            return new SideConfig(parent, dir, "", modes);
        }

        public static SideConfig createBlocked(SpellComponent parent, String dir) {
            return new SideConfig(parent, dir, "", new Mode[]{Mode.Blocked});
        }

        public static SideConfig createOutput(SpellComponent parent, String dir) {
            return new SideConfig(parent, dir, "", new Mode[]{Mode.Output});
        }

        public static SideConfig createToggleableOutput(SpellComponent parent, String dir) {
            return new SideConfig(parent, dir, "", new Mode[]{Mode.Output, Mode.Blocked});
        }

        public static SideConfig createInput(SpellComponent parent, String dir) {
            return new SideConfig(parent, dir, "", new Mode[]{Mode.Input});
        }

        public static SideConfig createToggleableInput(SpellComponent parent, String dir) {
            return new SideConfig(parent, dir, "", new Mode[]{Mode.Input, Mode.Blocked});
        }

        public static SideConfig createFreeform(SpellComponent parent, String dir) {
            return new SideConfig(parent, dir, "", new Mode[]{Mode.Input, Mode.Output, Mode.Blocked});
        }

        public static SideConfig createSingle(SpellComponent parent, Mode mode, String dir) {
            return new SideConfig(parent, dir, "", new Mode[]{mode});
        }

        public static SideConfig createFromNbt(SpellComponent parent, class_2487 nbt, int version) {
            return new SideConfig(parent, nbt, version);
        }

        public boolean isOutput() {
            return this.activeMode() == Mode.Output;
        }

        public boolean isInput() {
            return this.activeMode() == Mode.Input;
        }

        public void setMode(Mode mode) {
            this.setMode(this.modes.indexOf((Object)mode));
        }

        public void setMode(int index) {
            this.setMode(ByteUtil.intToByte(index));
        }

        public void setMode(byte index) {
            if (this.selectedMode == index) {
                return;
            }
            this.selectedMode = index;
            this.sanityCheckVarName(false);
        }

        public Mode activeMode() {
            return this.modes.get(this.selectedMode);
        }

        public SpellSignal.Type getSignalType(SpellBlock func) {
            if (func == null || func.inputs == null || !func.inputs.containsKey(this.varName)) {
                return SpellSignal.Type.None;
            }
            return func.inputs.get((Object)this.varName).type;
        }

        public boolean canReceiveSignalOfType(SpellBlock block, SpellSignal.Type type) {
            if (!block.inputs.containsKey(this.varName)) {
                return false;
            }
            SpellSignal.Type ownType = block.inputs.get((Object)this.varName).type;
            return SpellSignal.typesCompatible(type, ownType);
        }

        public void serialize(class_2540 buf) {
            buf.writeByte((int)this.dir);
            buf.writeByte((int)this.selectedMode);
            buf.method_10814(this.varName);
        }

        public void deserialize(class_2540 buf) {
            this.dir = buf.readByte();
            this.selectedMode = buf.readByte();
            this.varName = buf.method_19772();
        }

        public void writeNbt(class_2487 nbt, int version) {
            String mKey;
            String dKey = version >= 1 ? "d" : "dir";
            String vKey = version >= 1 ? "v" : "var";
            String string = mKey = version >= 1 ? "m" : "mode";
            if (this.dir != 0) {
                nbt.method_10567(dKey, this.dir);
            }
            if (this.varName != null && !this.varName.isEmpty()) {
                nbt.method_10582(vKey, this.varName);
            }
            if (this.selectedMode != 0) {
                nbt.method_10567(mKey, this.selectedMode);
            }
        }

        public String dirString() {
            return directions[ByteUtil.byteToInt(this.dir)];
        }

        public void readNbt(class_2487 nbt, int version) {
            String mKey;
            String dKey = version >= 1 ? "d" : "dir";
            String vKey = version >= 1 ? "v" : "var";
            String string = mKey = version >= 1 ? "m" : "mode";
            if (version < 1) {
                this.setDirFromString(nbt.method_10558(dKey));
                this.varName = nbt.method_10558(vKey);
                this.selectedMode = ByteUtil.intToByte(nbt.method_10550(mKey));
            } else {
                this.dir = nbt.method_10545(dKey) ? nbt.method_10571(dKey) : (byte)0;
                this.varName = nbt.method_10545(vKey) ? nbt.method_10558(vKey) : "";
                this.selectedMode = nbt.method_10545(mKey) ? ByteUtil.intToByte(nbt.method_10571(mKey)) : (byte)0;
            }
        }

        public void setDirFromString(String dirString) {
            this.dir = ByteUtil.intToByte(SpellComponent.getDirIndex(dirString));
        }

        public SideConfig named(String varName) {
            this.varName = varName;
            return this;
        }

        public SideConfig disabled() {
            this.setMode(Mode.Blocked);
            return this;
        }

        public class_2960 getTexture() {
            if (this.activeMode() == Mode.Blocked) {
                return null;
            }
            return Geomancy.locate("textures/gui/spells/" + (this.activeMode() == Mode.Input ? "in" : "out") + "_" + SpellComponent.getDirString(this.dir) + ".png");
        }

        public SpellSignal getSignal(SpellComponent component) {
            SpellSignal res;
            switch (this.activeMode().ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    SpellSignal spellSignal = SpellSignal.createNone();
                    break;
                }
                case 1: {
                    SpellSignal spellSignal = component.function.inputs.get(this.varName);
                    break;
                }
                case 2: {
                    SpellSignal spellSignal = res = component.function.outputs.get(this.varName);
                }
            }
            if (res == null) {
                this.sanityCheckVarName(true);
                return SpellSignal.createNone();
            }
            return res;
        }

        private void sanityCheckVarName(boolean reportErrors) {
            switch (this.activeMode().ordinal()) {
                case 1: {
                    if (this.parent.function.inputs.containsKey(this.varName)) {
                        return;
                    }
                    if (reportErrors) {
                        Geomancy.logError("variable name sanity check failed! in: " + this.varName + ", parent: " + this.parent.function.identifier.toString() + ", side: " + this.dir);
                    }
                    this.setVar(this.parent.function.inputs.keySet().stream().findFirst().orElse(""));
                    return;
                }
                case 2: {
                    if (this.parent.function.outputs.containsKey(this.varName)) {
                        return;
                    }
                    if (reportErrors) {
                        Geomancy.logError("variable name sanity check failed! out: " + this.varName + ", parent: " + this.parent.function.identifier.toString() + ", side: " + this.dir);
                    }
                    this.setVar(this.parent.function.outputs.keySet().stream().findFirst().orElse(""));
                    return;
                }
                case 0: {
                    this.varName = "";
                    return;
                }
            }
        }

        public void setVar(String newVar) {
            this.varName = newVar;
        }

        public void setShaderColor() {
            switch (this.activeMode().ordinal()) {
                case 1: {
                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                case 2: {
                    RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
        }

        public boolean equals(SideConfig o) {
            return Objects.equals(o.varName, this.varName) && this.dir == o.dir && this.selectedMode == o.selectedMode && SideConfig.modesEqual(this.modes, o.modes);
        }

        public static boolean modesEqual(List<Mode> a, List<Mode> b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (int i = 0; i < a.size(); ++i) {
                if (a.get(i).equals((Object)b.get(i))) continue;
                return false;
            }
            return true;
        }

        public static enum Mode {
            Blocked,
            Input,
            Output;

        }
    }

    public static class ConfiguredParameter {
        public SpellSignal signal;
        public SpellBlock.Parameter parameter;

        public ConfiguredParameter(SpellBlock.Parameter base) {
            this.parameter = base;
            this.setSignal(base.getDefaultSignal());
        }

        public SpellSignal getSignal() {
            return this.signal;
        }

        public void setSignal(SpellSignal signal) {
            this.signal = signal;
        }

        public void setValue(float val) {
            this.signal.numberValue = val;
        }

        public void setValue(String val) {
            this.signal.textValue = val;
        }

        public void serialize(class_2540 buf) {
            buf.method_10814(this.parameter.name);
            this.signal.serialize(buf);
        }

        public static ConfiguredParameter deserialize(SpellBlock parent, class_2540 buf) {
            String name = buf.method_19772();
            ConfiguredParameter res = new ConfiguredParameter(parent.getParameter(name));
            res.setSignal(SpellSignal.deserialize(buf));
            return res;
        }

        public void writeNbt(class_2487 nbt, int v) {
            String pKey = v >= 1 ? "p" : "param";
            String sKey = v >= 1 ? "s" : "signal";
            nbt.method_10582(pKey, this.parameter.name);
            class_2487 sigComp = new class_2487();
            this.signal.writeNbt(sigComp, v, false);
            nbt.method_10566(sKey, (class_2520)sigComp);
        }

        private ConfiguredParameter() {
        }

        public static ConfiguredParameter fromNbt(SpellBlock parent, class_2487 nbt, int v) {
            ConfiguredParameter res = new ConfiguredParameter();
            res.readNbt(parent, nbt, v);
            return res;
        }

        public void readNbt(SpellBlock parent, class_2487 nbt, int v) {
            String pKey = v >= 1 ? "p" : "param";
            String sKey = v >= 1 ? "s" : "signal";
            this.parameter = parent.getParameter(nbt.method_10558(pKey));
            this.setSignal(SpellSignal.fromNBT(nbt.method_10562(sKey), v).named(nbt.method_10558(pKey)));
        }

        public boolean canAccept(String val) {
            switch (this.parameter.type) {
                case ConstantText: {
                    return true;
                }
                case ConstantNumber: 
                case ConstantBoolean: {
                    try {
                        Float.parseFloat(val);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            return false;
        }

        public void setParsed(String val) {
            switch (this.parameter.type) {
                case ConstantText: {
                    this.setValue(val);
                    break;
                }
                case ConstantNumber: 
                case ConstantBoolean: {
                    try {
                        this.setValue(Float.parseFloat(val));
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class Builder {
        public SpellBlock func;
        public Vector2i pos;
        public ConfBuilder[] confs;
        public HashMap<String, ConfiguredParameter> params;

        public Builder(SpellBlock func) {
            this.func = func;
            this.confs = new ConfBuilder[6];
            this.params = new HashMap();
        }

        public SpellComponent build(SpellGrid parent) {
            SpellComponent res = new SpellComponent(parent, this.pos, this.func, null, this.params);
            SideConfig[] confs2 = this.func.getDefaultSideConfigs(res);
            for (int i = 0; i < 6; ++i) {
                if (this.confs[i] == null) continue;
                this.confs[i].dir = i;
                confs2[i] = this.confs[i].build(res, confs2[i].modes.toArray(new SideConfig.Mode[0]));
            }
            res.sideConfigs = confs2;
            return res;
        }

        public Builder pos(Vector2i p) {
            this.pos = p;
            return this;
        }

        public Builder pos(int x, int y) {
            return this.pos(new Vector2i(x, y));
        }

        public Builder pos(int width, int height, String sequence) {
            String[] args = sequence.split(",");
            Vector2i center = new Vector2i(width / 2, height / 2);
            Vector2i pos = new Vector2i((Vector2ic)center);
            for (String arg : args) {
                ArrayList<Vector2i> neighbors = SpellGrid.getNeighboringPositions(pos);
                if (!Arrays.stream(directions).toList().contains(arg)) continue;
                pos = neighbors.get(SpellComponent.getDirIndex(arg));
            }
            return this.pos(pos.x, pos.y);
        }

        public Builder conf(ConfBuilder conf) {
            this.confs[conf.dir] = conf;
            return this;
        }

        public Builder param(String name, SpellSignal sig) {
            ConfiguredParameter p = new ConfiguredParameter(this.func.getParameter(name));
            p.setSignal(sig);
            this.params.put(name, p);
            return this;
        }

        public Builder param(String name, float num) {
            return this.param(name, SpellSignal.createNumber(num).named(name));
        }

        public Builder param(String name, String text) {
            return this.param(name, SpellSignal.createText(text).named(name));
        }

        public Builder param(String name, boolean bool) {
            return this.param(name, SpellSignal.createBoolean(bool).named(name));
        }

        public static class ConfBuilder {
            public String name;
            public int dir;
            public SideConfig.Mode mode;

            public ConfBuilder(String dir, String name) {
                this.dir = SpellComponent.getDirIndex(dir);
                this.name = name;
            }

            public ConfBuilder mode(SideConfig.Mode mode) {
                this.mode = mode;
                return this;
            }

            protected SideConfig build(SpellComponent comp, SideConfig.Mode[] modes) {
                SideConfig res = new SideConfig(comp, SpellComponent.getDirString(this.dir), this.name, modes);
                if (this.mode != null) {
                    res.setMode(this.mode);
                }
                res.sanityCheckVarName(false);
                return res;
            }
        }
    }
}

