/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.spells;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.blocks.blockEntities.AutocasterBlockEntity;
import org.oxytocina.geomancy.enchantments.ModEnchantments;
import org.oxytocina.geomancy.entity.CasterDelegateEntity;
import org.oxytocina.geomancy.items.ISpellSelectorItem;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.items.armor.CastingArmorItem;
import org.oxytocina.geomancy.items.trinkets.CastingTrinketItem;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellBlockResult;
import org.oxytocina.geomancy.spells.SpellComponent;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.spells.SpellSignal;
import org.oxytocina.geomancy.util.EntityUtil;
import org.oxytocina.geomancy.util.SoulUtil;
import org.oxytocina.geomancy.util.Toolbox;

public class SpellContext {
    public class_1309 caster;
    public AutocasterBlockEntity casterBlock;
    public CasterDelegateEntity delegate;
    public class_1799 casterItem;
    public class_1799 spellStorage;
    protected float availableSoul;
    protected float soulConsumed = 0.0f;
    public float soulCostMultiplier = 1.0f;
    public Stage stage;
    public boolean debugging = false;
    public boolean silent = false;
    public boolean invisible = false;
    private Restrictions restrictions = Restrictions.NONE;
    public int depthLimit;
    public int baseDepth;
    public int highestRecordedDepth;
    public boolean depthLimitReached;
    public long startTime;
    public boolean couldntAffordSomething;
    public boolean activatedByHotkey;
    public SpellGrid grid;
    public SoundBehavior soundBehavior;
    protected List<String> flags;
    public SourceType sourceType;
    public SpellContext parentCall;
    public SpellComponent referenceCallingFrom;
    public SpellBlockResult referenceResult;
    public SpellBlockArgs internalVars;
    private class_1937 worldOverride;
    public final int TIMEOUT_MS = 1000;

    public SpellContext(SpellGrid grid, class_1309 caster, AutocasterBlockEntity casterBlock, CasterDelegateEntity delegate, class_1799 casterItem, class_1799 spellStorage, float availableSoul, float soulCostMultiplier, float soulConsumed, SoundBehavior soundBehavior, int depth) {
        this.depthLimit = (Integer)Geomancy.CONFIG.maxSpellDepth.value();
        this.baseDepth = 0;
        this.highestRecordedDepth = 0;
        this.depthLimitReached = false;
        this.couldntAffordSomething = false;
        this.activatedByHotkey = false;
        this.referenceResult = SpellBlockResult.empty();
        this.worldOverride = null;
        this.TIMEOUT_MS = 1000;
        this.grid = grid;
        this.caster = caster;
        this.casterBlock = casterBlock;
        this.delegate = delegate;
        this.casterItem = casterItem;
        this.spellStorage = spellStorage;
        this.availableSoul = availableSoul;
        this.stage = Stage.PreInit;
        this.soulCostMultiplier = soulCostMultiplier;
        this.soulConsumed = soulConsumed;
        this.soundBehavior = soundBehavior;
        this.startTime = System.nanoTime();
        this.flags = null;
        this.baseDepth = depth;
        this.highestRecordedDepth = depth;
        this.sourceType = delegate != null ? SourceType.Delegate : (caster != null ? SourceType.Caster : (casterBlock != null ? SourceType.Block : SourceType.Caster));
    }

    public static SpellContext ofCaster(class_1309 caster) {
        SpellContext res = new SpellContext(null, caster, null, null, null, null, 0.0f, 1.0f, 0.0f, SoundBehavior.Silent, 0);
        return res;
    }

    public class_2487 toNbt() {
        class_2487 res = new class_2487();
        this.writeNbt(res);
        return res;
    }

    public void writeNbt(class_2487 nbt) {
        class_2487 temp;
        if (this.caster != null) {
            nbt.method_25927("caster", this.caster.method_5667());
        }
        if (this.casterBlock != null) {
            nbt.method_10566("casterBlock", (class_2520)class_2512.method_10692((class_2338)this.casterBlock.method_11016()));
        }
        if (this.delegate != null) {
            nbt.method_25927("delegate", this.delegate.method_5667());
        }
        if (this.casterItem != null) {
            temp = new class_2487();
            this.casterItem.method_7953(temp);
            nbt.method_10566("casterItem", (class_2520)temp);
        }
        if (this.spellStorage != null) {
            temp = new class_2487();
            this.spellStorage.method_7953(temp);
            nbt.method_10566("spellStorage", (class_2520)temp);
        }
        nbt.method_10548("availableSoul", this.availableSoul);
        nbt.method_10548("soulConsumed", this.soulConsumed);
        nbt.method_10548("soulCostMultiplier", this.soulCostMultiplier);
        nbt.method_10582("stage", this.stage.name());
        nbt.method_10556("debugging", this.debugging);
        nbt.method_10569("depthLimit", this.depthLimit);
        nbt.method_10569("baseDepth", this.baseDepth);
        nbt.method_10569("highestRecordedDepth", this.highestRecordedDepth);
        nbt.method_10556("depthLimitReached", this.depthLimitReached);
        nbt.method_10556("couldntAffordSomething", this.couldntAffordSomething);
        if (this.grid != null) {
            temp = new class_2487();
            this.grid.writeNbt(temp);
            nbt.method_10566("grid", (class_2520)temp);
        }
        nbt.method_10582("soundBehavior", this.soundBehavior.name());
        nbt.method_10582("sourceType", this.sourceType.name());
        if (this.isChild()) {
            class_2487 parentNbt = this.parentCall.toNbt();
            nbt.method_10566("parent", (class_2520)parentNbt);
        }
        if (this.referenceCallingFrom != null) {
            temp = new class_2487();
            this.referenceCallingFrom.writeNbt(temp);
            nbt.method_10566("referenceCallingFrom", (class_2520)temp);
        }
        if (this.referenceResult != null) {
            temp = new class_2487();
            this.referenceResult.writeNbt(temp);
            nbt.method_10566("referenceResult", (class_2520)temp);
        }
        if (this.internalVars != null) {
            temp = new class_2487();
            this.internalVars.writeNbt(temp);
            nbt.method_10566("internalVars", (class_2520)temp);
        }
    }

    public static SpellContext fromNbt(class_3218 world, class_2487 nbt) {
        class_1799 casterItem = nbt.method_10545("casterItem") ? class_1799.method_7915((class_2487)nbt.method_10562("casterItem")) : null;
        class_1799 spellStorage = nbt.method_10545("spellStorage") ? class_1799.method_7915((class_2487)nbt.method_10562("spellStorage")) : null;
        class_1297 caster = nbt.method_10545("caster") ? world.method_14190(nbt.method_25926("caster")) : null;
        class_2586 casterBlock = nbt.method_10545("casterBlock") ? world.method_8321(class_2512.method_10691((class_2487)nbt.method_10562("casterBlock"))) : null;
        class_1297 delegate = nbt.method_10545("delegate") ? world.method_14190(nbt.method_25926("delegate")) : null;
        SpellContext res = new SpellContext(nbt.method_10545("grid") ? new SpellGrid(casterItem, nbt.method_10562("grid")) : null, (class_1309)caster, (AutocasterBlockEntity)casterBlock, (CasterDelegateEntity)delegate, casterItem, spellStorage, nbt.method_10583("availableSoul"), nbt.method_10583("soulCostMultiplier"), nbt.method_10583("soulConsumed"), Enum.valueOf(SoundBehavior.class, nbt.method_10558("soundBehavior")), nbt.method_10550("baseDepth"));
        res.debugging = nbt.method_10577("debugging");
        res.stage = Enum.valueOf(Stage.class, nbt.method_10558("stage"));
        return res;
    }

    public static SpellContext ofWorld(@Nullable class_1937 world, @Nullable class_1657 caster) {
        SpellContext res = new SpellContext(null, (class_1309)caster, null, null, null, null, 0.0f, 0.0f, 0.0f, null, 0);
        res.worldOverride = world;
        return res;
    }

    public float getSoulConsumed() {
        return this.root().soulConsumed;
    }

    public boolean tryConsumeSoul(float amount) {
        if (this.isChild()) {
            return this.parentCall.tryConsumeSoul(amount);
        }
        if (!this.canAfford(amount)) {
            this.couldntAffordSomething = true;
            return false;
        }
        this.soulConsumed += (amount *= this.soulCostMultiplier);
        switch (this.sourceType.ordinal()) {
            case 0: {
                class_1657 player;
                class_1309 class_13092 = this.caster;
                if (class_13092 instanceof class_1657 && (player = (class_1657)class_13092).method_7337()) {
                    return true;
                }
                this.availableSoul -= amount;
                return SoulUtil.tryConsumeSoul(this.caster, amount, this);
            }
            case 1: {
                this.availableSoul -= amount;
                return SoulUtil.tryConsumeSoul(this.casterBlock, amount, this);
            }
        }
        if (this.caster != null) {
            class_1657 player;
            class_1309 class_13093 = this.caster;
            if (class_13093 instanceof class_1657 && (player = (class_1657)class_13093).method_7337()) {
                return true;
            }
            this.availableSoul -= amount;
            return SoulUtil.tryConsumeSoul(this.caster, amount, this);
        }
        if (this.casterBlock != null) {
            this.availableSoul -= amount;
            return SoulUtil.tryConsumeSoul(this.casterBlock, amount, this);
        }
        return true;
    }

    public boolean canAfford(float amount) {
        if (this.isChild()) {
            return this.parentCall.canAfford(amount);
        }
        amount *= this.soulCostMultiplier;
        switch (this.sourceType.ordinal()) {
            case 0: {
                class_1309 class_13092 = this.caster;
                if (class_13092 instanceof class_1657) {
                    class_1657 player = (class_1657)class_13092;
                    this.availableSoul = SoulUtil.getSoul(player);
                    if (player.method_7337()) {
                        return true;
                    }
                    return this.availableSoul >= amount;
                }
                return true;
            }
            case 1: {
                this.availableSoul = SoulUtil.getSoul(this.casterBlock.method_10997(), (class_1263)this.casterBlock);
                return this.availableSoul >= amount;
            }
        }
        if (this.caster != null) {
            class_1309 class_13093 = this.caster;
            if (class_13093 instanceof class_1657) {
                class_1657 player = (class_1657)class_13093;
                this.availableSoul = SoulUtil.getSoul(player);
                if (player.method_7337()) {
                    return true;
                }
                return this.availableSoul >= amount;
            }
            return true;
        }
        if (this.casterBlock != null) {
            this.availableSoul = SoulUtil.getSoul(this.casterBlock.method_10997(), (class_1263)this.casterBlock);
            return this.availableSoul >= amount;
        }
        return true;
    }

    public void refreshAvailableSoul() {
        if (this.isChild()) {
            this.parentCall.getCasterMaxSoul();
            return;
        }
        switch (this.sourceType.ordinal()) {
            case 0: {
                class_1309 class_13092 = this.caster;
                if (class_13092 instanceof class_1657) {
                    class_1657 player = (class_1657)class_13092;
                    this.availableSoul = SoulUtil.getSoul(player);
                    return;
                }
                return;
            }
            case 1: {
                this.availableSoul = SoulUtil.getSoul(this.casterBlock.method_10997(), (class_1263)this.casterBlock);
            }
        }
        class_1309 class_13093 = this.caster;
        if (class_13093 instanceof class_1657) {
            class_1657 player = (class_1657)class_13093;
            this.availableSoul = SoulUtil.getSoul(player);
            return;
        }
        this.availableSoul = SoulUtil.getSoul(this.casterBlock.method_10997(), (class_1263)this.casterBlock);
    }

    public float getCasterMaxSoul() {
        if (this.isChild()) {
            return this.parentCall.getCasterMaxSoul();
        }
        switch (this.sourceType.ordinal()) {
            case 0: {
                class_1309 class_13092 = this.caster;
                if (class_13092 instanceof class_1657) {
                    class_1657 pe = (class_1657)class_13092;
                    return SoulUtil.getMaxSoul(pe);
                }
                return 100.0f;
            }
            case 1: {
                return SoulUtil.getMaxSoul(this.casterBlock.method_10997(), this.casterBlock);
            }
        }
        return 100.0f;
    }

    public SpellContext createReferenced(SpellComponent comp) {
        SpellContext res = new SpellContext(this.grid, this.caster, this.casterBlock, this.delegate, this.casterItem, this.spellStorage, this.availableSoul, this.soulCostMultiplier, this.soulConsumed, this.soundBehavior, this.highestRecordedDepth);
        res.parentCall = this;
        res.referenceCallingFrom = comp;
        res.internalVars = new SpellBlockArgs();
        return res;
    }

    public boolean isChild() {
        return this.parentCall != null;
    }

    public SpellSignal getParentVar(String varName) {
        if (this.internalVars == null || !this.internalVars.has(varName)) {
            return null;
        }
        return this.internalVars.get(varName);
    }

    public class_1937 getWorld() {
        return switch (this.sourceType.ordinal()) {
            case 0 -> {
                if (this.caster != null) {
                    yield this.caster.method_37908();
                }
                yield this.worldOverride;
            }
            case 1 -> {
                if (this.casterBlock != null) {
                    yield this.casterBlock.method_10997();
                }
                yield this.worldOverride;
            }
            case 2 -> {
                if (this.casterBlock != null) {
                    yield this.casterBlock.method_10997();
                }
                if (this.caster != null) {
                    yield this.caster.method_37908();
                }
                yield this.worldOverride;
            }
            default -> this.worldOverride;
        };
    }

    public class_243 getOriginPos() {
        return switch (this.sourceType.ordinal()) {
            case 0 -> this.caster.method_19538();
            case 1 -> this.casterBlock.method_11016().method_46558();
            case 2 -> this.delegate.method_19538();
            default -> null;
        };
    }

    public class_2338 getOriginBlockPos() {
        return Toolbox.posToBlockPos(this.getOriginPos());
    }

    public ISpellSelectorItem getSpellSelector() {
        return this.hasCasterItem() ? (ISpellSelectorItem)this.casterItem.method_7909() : null;
    }

    public class_1263 getInventory() {
        return switch (this.sourceType.ordinal()) {
            case 0 -> {
                class_1309 var2_1 = this.caster;
                if (var2_1 instanceof class_1657) {
                    class_1657 pe = (class_1657)var2_1;
                    yield pe.method_31548();
                }
                yield null;
            }
            case 1 -> this.casterBlock;
            case 2 -> {
                class_1309 var2_2 = this.caster;
                if (var2_2 instanceof class_1657) {
                    class_1657 pe = (class_1657)var2_2;
                    yield pe.method_31548();
                }
                yield this.casterBlock;
            }
            default -> null;
        };
    }

    public class_3419 getSoundCategory() {
        if (this.caster != null) {
            return class_3419.field_15248;
        }
        return class_3419.field_15245;
    }

    public int getExecutionTimeMS() {
        return (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTime);
    }

    public boolean timedOut() {
        return this.getExecutionTimeMS() > 1000;
    }

    public boolean isSilent() {
        return this.silent || this.soundBehavior == SoundBehavior.Silent;
    }

    public boolean showsParticles() {
        return !this.invisible;
    }

    public class_243 getDirection() {
        return switch (this.sourceType.ordinal()) {
            case 0 -> this.caster.method_5720();
            case 2 -> this.delegate.getRotationVec3d();
            case 1 -> new class_243(this.casterBlock.getDirection().method_23955());
            default -> null;
        };
    }

    public boolean isActivatedByHotkey() {
        return this.root().activatedByHotkey;
    }

    public class_243 getMuzzlePos() {
        return switch (this.sourceType.ordinal()) {
            case 0 -> this.getMuzzleOffsetForCaster();
            case 1 -> this.casterBlock.getMuzzlePos();
            default -> this.getOriginPos();
        };
    }

    private class_243 getMuzzleOffsetForCaster() {
        if (!this.hasCasterItem()) {
            return new class_243(0.0, 0.0, 0.0);
        }
        class_1792 item = this.casterItem.method_7909();
        if (item instanceof CastingArmorItem) {
            CastingArmorItem armor = (CastingArmorItem)item;
            switch (armor.method_48398()) {
                case field_41937: {
                    return this.caster.method_33571().method_1031(0.0, (double)-0.2f, 0.0);
                }
                case field_41936: {
                    return this.caster.method_19538().method_1031(0.0, 0.5, 0.0);
                }
                case field_41935: {
                    return this.caster.method_19538().method_1031(0.0, (double)1.2f, 0.0);
                }
            }
        } else if (item instanceof CastingTrinketItem) {
            return this.caster.method_19538().method_1031(0.0, (double)1.2f, 0.0);
        }
        return this.caster.method_33571().method_1019(this.getMuzzleOffsetForItem());
    }

    private class_243 getMuzzleOffsetForItem() {
        if (!this.hasCasterItem()) {
            return new class_243(0.0, 0.0, 0.0);
        }
        class_1792 item = this.casterItem.method_7909();
        boolean bl = this.caster.method_6079().method_31574(item) && !this.caster.method_6047().method_31574(item);
        class_1306 arm = bl ? this.caster.method_6068().method_5928() : this.caster.method_6068();
        return EntityUtil.getRotationVector(45.0f, this.caster.method_36454() + (float)(arm == class_1306.field_6183 ? 80 : -80)).method_1021(0.5);
    }

    public SpellContext root() {
        if (this.isChild()) {
            return this.parentCall.root();
        }
        return this;
    }

    public Restrictions restrictions() {
        return this.root().restrictions;
    }

    public void setRestrictions(Restrictions restrictions) {
        this.root().restrictions = restrictions;
    }

    public boolean hasFlag(String flag) {
        if (this.isChild()) {
            return this.parentCall.hasFlag(flag);
        }
        return this.flags != null && this.flags.contains(flag);
    }

    public void setRootFlag(String flag) {
        this.root().setFlag(flag);
    }

    public void setFlag(String flag) {
        if (this.flags == null) {
            this.flags = new ArrayList<String>();
        }
        if (!this.flags.contains(flag)) {
            this.flags.add(flag);
        }
    }

    public boolean isFromPrecomiled() {
        return this.hasCasterItem() && this.casterItem.method_7909() == ModItems.PRECOMP_CASTER;
    }

    public float getDistanceCostMultiplier() {
        return this.hasCasterItem() ? 1.0f - 0.17999999f * (float)class_1890.method_8225((class_1887)ModEnchantments.FOCUSED, (class_1799)this.casterItem) : 1.0f;
    }

    public boolean hasCasterItem() {
        return this.casterItem != null && !this.casterItem.method_7960();
    }

    public static enum Restrictions {
        NONE("NONE", true, true, true, true),
        UNLOADED("UNLOADED", true, false, false, true),
        DUNGEON("DUNGEON", false, false, true, true),
        DUNGEON_STRICT("DUNGEON_STRICT", false, false, true, false);

        private final String name;
        private final boolean allowTeleports;
        private final boolean allowBlockManipulation;
        private final boolean allowActivate;
        private final boolean allowNonPrecompiled;

        private Restrictions(String name, boolean allowTeleports, boolean allowBlockManipulation, boolean allowActivate, boolean allowNonPrecompiled) {
            this.name = name;
            this.allowTeleports = allowTeleports;
            this.allowBlockManipulation = allowBlockManipulation;
            this.allowActivate = allowActivate;
            this.allowNonPrecompiled = allowNonPrecompiled;
        }

        public String getName() {
            return this.name;
        }

        public boolean allowsTeleports() {
            return this.allowTeleports;
        }

        public boolean allowsBlockManipulation() {
            return this.allowBlockManipulation;
        }

        public boolean allowsActivate() {
            return this.allowActivate;
        }

        public boolean allowsNonPrecompiled() {
            return this.allowNonPrecompiled;
        }
    }

    public static enum Stage {
        PreInit,
        Run;

    }

    public static enum SoundBehavior {
        Full,
        Reduced,
        Silent;

    }

    public static enum SourceType {
        Caster,
        Block,
        Delegate;

    }
}

