/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.spells;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3f;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.helpers.NbtHelper;
import org.oxytocina.geomancy.spells.SpellContext;

public class SpellSignal {
    public Type type;
    public String name;
    public float numberValue;
    public String textValue;
    public UUID uuidValue;
    public class_243 vectorValue;
    public List<SpellSignal> listValue;
    public int depth = 0;

    protected SpellSignal(Type type, String name, float numberValue, String textValue, UUID uuidValue, class_243 vector, List<SpellSignal> list) {
        this.type = type;
        this.name = name;
        this.numberValue = numberValue;
        this.textValue = textValue;
        this.uuidValue = uuidValue;
        this.vectorValue = vector;
        this.listValue = list;
    }

    public static SpellSignal createBoolean(boolean defaultValue) {
        return new SpellSignal(Type.Boolean, "bool", defaultValue ? 1.0f : 0.0f, "", null, null, null);
    }

    public static SpellSignal createBoolean(float defaultValue) {
        return SpellSignal.createBoolean(defaultValue > 0.0f);
    }

    public static SpellSignal createBoolean() {
        return SpellSignal.createBoolean(false);
    }

    public static SpellSignal createNumber(float defaultValue) {
        return new SpellSignal(Type.Number, "num", defaultValue, "", null, null, null);
    }

    public static SpellSignal createNumber(double defaultValue) {
        return SpellSignal.createNumber((float)defaultValue);
    }

    public static SpellSignal createNumber() {
        return SpellSignal.createNumber(0.0f);
    }

    public static SpellSignal createAny() {
        return new SpellSignal(Type.Any, "any", 0.0f, "", null, null, null);
    }

    public static SpellSignal createNone() {
        return new SpellSignal(Type.None, "none", 0.0f, "", null, null, null);
    }

    public static SpellSignal createText() {
        return SpellSignal.createText("");
    }

    public static SpellSignal createText(String defaultValue) {
        return new SpellSignal(Type.Text, "text", 0.0f, defaultValue, null, null, null);
    }

    public static SpellSignal createUUID() {
        return SpellSignal.createUUID((UUID)null);
    }

    public static SpellSignal createUUID(class_1297 entity) {
        return SpellSignal.createUUID(entity.method_5667());
    }

    public static SpellSignal createUUID(UUID defaultValue) {
        return new SpellSignal(Type.UUID, "uuid", 0.0f, "", defaultValue, null, null);
    }

    public static SpellSignal createVector() {
        return SpellSignal.createVector((class_243)null);
    }

    public static SpellSignal createVector(class_2382 vec) {
        return SpellSignal.createVector(new class_243((double)vec.method_10263(), (double)vec.method_10264(), (double)vec.method_10260()));
    }

    public static SpellSignal createVector(Vector3f vec) {
        return SpellSignal.createVector(new class_243((double)vec.x(), (double)vec.y(), (double)vec.z()));
    }

    public static SpellSignal createVector(class_243 defaultValue) {
        return new SpellSignal(Type.Vector, "vec", 0.0f, "", null, defaultValue, null);
    }

    public static SpellSignal createList() {
        return SpellSignal.createList(null);
    }

    public static SpellSignal createList(List<SpellSignal> defaultValue) {
        return new SpellSignal(Type.List, "list", 0.0f, "", null, null, defaultValue);
    }

    public SpellSignal named(String name) {
        this.name = name;
        return this;
    }

    public float getNumberValue() {
        switch (this.type.ordinal()) {
            case 2: 
            case 3: {
                return this.numberValue;
            }
            case 6: {
                return (float)this.vectorValue.method_1033();
            }
            case 7: {
                return this.getListValueOrEmpty().size();
            }
        }
        return 0.0f;
    }

    public int getIntValue() {
        return Math.round(this.getNumberValue());
    }

    public class_243 getVectorValue() {
        return this.vectorValue;
    }

    public boolean getBooleanValue() {
        return this.getNumberValue() > 0.0f;
    }

    public String getTextValue() {
        return this.getTextValue(null);
    }

    public String getTextValue(SpellContext ctx) {
        switch (this.type.ordinal()) {
            case 4: {
                return this.textValue;
            }
            case 5: {
                Object object;
                class_1657 ent = null;
                if (ctx != null && (object = ctx.getWorld()) instanceof class_3218) {
                    class_3218 sw = (class_3218)object;
                    ent = sw.method_14190(this.uuidValue);
                }
                if (ctx != null && !(ctx.getWorld() instanceof class_3218) && (ent = ctx.getWorld().method_18470(this.uuidValue)) == null) {
                    List ents = ctx.getWorld().method_8390(class_1297.class, class_238.method_29968((class_243)ctx.caster.method_19538()).method_1014(1000.0), entity -> true);
                    for (class_1297 contender : ents) {
                        if (!contender.method_5667().equals(this.uuidValue)) continue;
                        ent = contender;
                        break;
                    }
                }
                if (ent != null) {
                    String entName = ent.method_5477().getString();
                    return entName;
                }
                return this.uuidValue.toString();
            }
            case 3: {
                return Float.toString(this.getNumberValue());
            }
            case 2: {
                return this.getBooleanValue() ? "true" : "false";
            }
            case 6: {
                return this.getVectorValue().toString();
            }
            case 7: {
                Object res = "[";
                List<SpellSignal> lv = this.getListValue();
                for (int i = 0; i < lv.size(); ++i) {
                    res = (String)res + lv.get(i).getTextValue(ctx);
                    if (i >= lv.size() - 1) continue;
                    res = (String)res + ",";
                }
                res = (String)res + "]";
                return res;
            }
        }
        return "N/A";
    }

    public UUID getUUIDValue() {
        return this.uuidValue;
    }

    public List<SpellSignal> getListValue() {
        return this.listValue;
    }

    public List<SpellSignal> getListValueOrEmpty() {
        return this.listValue != null ? this.listValue : new ArrayList<SpellSignal>();
    }

    public class_1297 getEntity(class_1937 world) {
        if (this.type != Type.UUID) {
            return null;
        }
        if (!(world instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)world;
        return serverWorld.method_14190(this.getUUIDValue());
    }

    public String toString() {
        return this.getTextValue();
    }

    public String toString(SpellContext ctx) {
        return this.getTextValue(ctx);
    }

    public class_2561 toText() {
        return this.getTypeText().method_10852((class_2561)class_2561.method_43470((String)(" " + this.name)).method_27692(class_124.field_1080));
    }

    public class_5250 getTypeText() {
        return class_2561.method_43471((String)("geomancy.spellmaker.types." + this.type.toString().toLowerCase())).method_27692(class_124.field_1062);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public class_2487 toNBT(boolean writeName) {
        class_2487 res = new class_2487();
        this.writeNbt(res, 1, writeName);
        return res;
    }

    public boolean isLoadingAllowed(MinecraftServer server) {
        return (Boolean)Geomancy.CONFIG.playerVariableLoading.value() != false || !this.containsPlayer(server);
    }

    public boolean containsPlayer(MinecraftServer server) {
        if (this.type != Type.UUID) {
            return false;
        }
        return server.method_3760().method_14602(this.getUUIDValue()) != null;
    }

    public void serialize(class_2540 buf) {
        buf.method_10814(this.type.toString());
        buf.method_10814(this.name);
        switch (this.type.ordinal()) {
            case 3: {
                buf.writeFloat(this.getNumberValue());
                break;
            }
            case 2: {
                buf.writeBoolean(this.getBooleanValue());
                break;
            }
            case 4: {
                buf.method_10814(this.getTextValue());
                break;
            }
            case 5: {
                buf.method_10797(this.getUUIDValue());
                break;
            }
            case 6: {
                buf.method_49068(this.getVectorValue().method_46409());
                break;
            }
            case 7: {
                SpellSignal.serializeList(this.getListValue(), buf);
            }
        }
    }

    private static void serializeList(List<SpellSignal> list, class_2540 buf) {
        buf.writeInt(list.size());
        for (SpellSignal s : list) {
            s.serialize(buf);
        }
    }

    public static SpellSignal deserialize(class_2540 buf) {
        String typeS = buf.method_19772();
        Type type = Enum.valueOf(Type.class, typeS);
        String name = buf.method_19772();
        switch (type.ordinal()) {
            case 3: {
                return SpellSignal.createNumber(buf.readFloat()).named(name);
            }
            case 2: {
                return SpellSignal.createBoolean(buf.readBoolean()).named(name);
            }
            case 4: {
                return SpellSignal.createText(buf.method_19772()).named(name);
            }
            case 5: {
                return SpellSignal.createUUID(buf.method_10790()).named(name);
            }
            case 6: {
                return SpellSignal.createVector(buf.method_49069()).named(name);
            }
            case 7: {
                return SpellSignal.createList(SpellSignal.deserializeList(buf)).named(name);
            }
        }
        return SpellSignal.createNone();
    }

    private static List<SpellSignal> deserializeList(class_2540 buf) {
        int size = buf.readInt();
        ArrayList<SpellSignal> res = new ArrayList<SpellSignal>();
        for (int i = 0; i < size; ++i) {
            res.add(SpellSignal.deserialize(buf));
        }
        return res;
    }

    public void writeNbt(class_2487 nbt, int version, boolean writeName) {
        String tKey = version >= 1 ? "t" : "type";
        String nKey = version >= 1 ? "n" : "name";
        String vKey = version >= 1 ? "v" : "val";
        nbt.method_10582(tKey, this.type.toString());
        if (writeName) {
            nbt.method_10582(nKey, this.name);
        }
        switch (this.type.ordinal()) {
            case 3: {
                nbt.method_10548(vKey, this.getNumberValue());
                break;
            }
            case 2: {
                nbt.method_10556(vKey, this.getBooleanValue());
                break;
            }
            case 4: {
                nbt.method_10582(vKey, this.getTextValue());
                break;
            }
            case 5: {
                nbt.method_25927(vKey, this.getUUIDValue());
                break;
            }
            case 6: {
                nbt.method_10566(vKey, (class_2520)NbtHelper.vectorToNbt(this.getVectorValue()));
                break;
            }
            case 7: {
                nbt.method_10566(vKey, (class_2520)SpellSignal.listToNbt(this.getListValue(), version));
            }
        }
    }

    private static class_2499 listToNbt(List<SpellSignal> list, int v) {
        class_2499 res = new class_2499();
        for (SpellSignal s : list) {
            class_2487 nbt = new class_2487();
            s.writeNbt(nbt, v, true);
            res.add((Object)nbt);
        }
        return res;
    }

    private static List<SpellSignal> listFromNbt(class_2499 nbtl, int v) {
        ArrayList<SpellSignal> res = new ArrayList<SpellSignal>();
        for (int i = 0; i < nbtl.size(); ++i) {
            class_2487 nbt = nbtl.method_10602(i);
            SpellSignal sig = SpellSignal.fromNBT(nbt, v);
            res.add(sig);
        }
        return res;
    }

    public static SpellSignal fromNBT(class_2487 nbt, int version) {
        Type type;
        String tKey = version >= 1 ? "t" : "type";
        String nKey = version >= 1 ? "n" : "name";
        String vKey = version >= 1 ? "v" : "val";
        String typeString = nbt.method_10558(tKey);
        try {
            type = Type.valueOf(typeString);
        }
        catch (Exception ignored) {
            type = Type.None;
        }
        String name = nbt.method_10558("name");
        float numberValue = 0.0f;
        String textValue = "";
        UUID uuidValue = null;
        class_243 vectorValue = null;
        List<SpellSignal> listValue = null;
        switch (type.ordinal()) {
            case 3: {
                numberValue = nbt.method_10583(vKey);
                break;
            }
            case 2: {
                numberValue = nbt.method_10577(vKey) ? 1.0f : 0.0f;
                break;
            }
            case 4: {
                textValue = nbt.method_10558(vKey);
                break;
            }
            case 5: {
                uuidValue = nbt.method_25926(vKey);
                break;
            }
            case 6: {
                vectorValue = NbtHelper.vectorFromNbt(nbt.method_10562(vKey));
                break;
            }
            case 7: {
                listValue = SpellSignal.listFromNbt(nbt.method_10554(vKey, 10), version);
            }
        }
        return new SpellSignal(type, name, numberValue, textValue, uuidValue, vectorValue, listValue);
    }

    public SpellSignal clone() {
        ArrayList<SpellSignal> newList = null;
        if (this.listValue != null) {
            newList = new ArrayList<SpellSignal>();
            for (SpellSignal s : this.listValue) {
                newList.add(s.clone());
            }
        }
        return new SpellSignal(this.type, this.name, this.numberValue, this.textValue, this.uuidValue, this.vectorValue, newList);
    }

    public static boolean typesCompatible(Type from, Type onto) {
        switch (onto.ordinal()) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
            case 2: 
            case 3: {
                return from == Type.Number || from == Type.Boolean || from == Type.Vector;
            }
        }
        return from == onto;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpellSignal that = (SpellSignal)o;
        return Float.compare(this.numberValue, that.numberValue) == 0 && this.depth == that.depth && this.type == that.type && Objects.equals(this.name, that.name) && Objects.equals(this.textValue, that.textValue) && Objects.equals(this.uuidValue, that.uuidValue) && Objects.equals(this.vectorValue, that.vectorValue) && SpellSignal.listValuesAreEqual(this, that);
    }

    public boolean softEquals(SpellSignal o) {
        if (o == null) {
            return false;
        }
        return this.type == o.type && Float.compare(this.numberValue, o.numberValue) == 0 && Objects.equals(this.textValue, o.textValue) && Objects.equals(this.uuidValue, o.uuidValue) && Objects.equals(this.vectorValue, o.vectorValue) && SpellSignal.listValuesAreEqual(this, o);
    }

    private static boolean listValuesAreEqual(SpellSignal a, SpellSignal b) {
        List<SpellSignal> lva = a.getListValue();
        List<SpellSignal> lvb = b.getListValue();
        if (lva == null && lvb != null) {
            return false;
        }
        if (lva == null) {
            return true;
        }
        if (lva.size() != lvb.size()) {
            return false;
        }
        for (int i = 0; i < lva.size(); ++i) {
            if (lva.get(i).equals(lvb.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, Float.valueOf(this.numberValue), this.textValue, this.uuidValue, this.vectorValue, this.listValue, this.depth});
    }

    public static enum Type {
        None,
        Any,
        Boolean,
        Number,
        Text,
        UUID,
        Vector,
        List;

    }
}

