/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.util;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class DrawHelper {
    public static void drawLine(class_332 context, float x1, float y1, float x2, float y2, float thickness, int color) {
        Vector2f pos1 = new Vector2f(x1, y1);
        Vector2f pos2 = new Vector2f(x2, y2);
        Vector2f direction = new Vector2f(pos2.x - pos1.x, pos2.y - pos1.y).normalize();
        Vector2f negDir = new Vector2f((Vector2fc)direction).negate();
        Vector2f dirPep = new Vector2f((Vector2fc)direction).perpendicular();
        Vector2f v1 = new Vector2f((Vector2fc)pos1).add((Vector2fc)new Vector2f((Vector2fc)negDir).mul(thickness)).add((Vector2fc)new Vector2f((Vector2fc)dirPep).mul(thickness));
        Vector2f v2 = new Vector2f((Vector2fc)pos1).add((Vector2fc)new Vector2f((Vector2fc)negDir).mul(thickness)).add((Vector2fc)new Vector2f((Vector2fc)dirPep).mul(-thickness));
        Vector2f v3 = new Vector2f((Vector2fc)pos2).add((Vector2fc)new Vector2f((Vector2fc)direction).mul(thickness)).add((Vector2fc)new Vector2f((Vector2fc)dirPep).mul(thickness));
        Vector2f v4 = new Vector2f((Vector2fc)pos2).add((Vector2fc)new Vector2f((Vector2fc)direction).mul(thickness)).add((Vector2fc)new Vector2f((Vector2fc)dirPep).mul(-thickness));
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        float f = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float h = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float j = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        class_4588 vertexConsumer = context.method_51450().getBuffer(class_1921.method_51784());
        vertexConsumer.method_22918(matrix4f, v1.x, v1.y, 0.0f).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4f, v2.x, v2.y, 0.0f).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4f, v4.x, v4.y, 0.0f).method_22915(g, h, j, f).method_1344();
        vertexConsumer.method_22918(matrix4f, v3.x, v3.y, 0.0f).method_22915(g, h, j, f).method_1344();
        context.method_51452();
    }

    public static void drawTexture(class_4587 matrices, class_2960 texture, float x, float y, float width, float height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        DrawHelper.drawTexture(matrices, texture, x, x + width, y, y + height, 0.0f, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void drawTexture(class_4587 matrices, class_2960 texture, float x1, float x2, float y1, float y2, float z, float regionWidth, float regionHeight, float u, float v, int textureWidth, int textureHeight) {
        DrawHelper.drawTexturedQuad(matrices, texture, x1, x2, y1, y2, z, (u + 0.0f) / (float)textureWidth, (u + regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + regionHeight) / (float)textureHeight);
    }

    public static void drawTexture(class_4587 matrices, class_2960 texture, float x, float y, float width, float height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, float r, float g, float b, float a) {
        DrawHelper.drawTexture(matrices, texture, x, x + width, y, y + height, 0.0f, regionWidth, regionHeight, u, v, textureWidth, textureHeight, r, g, b, a);
    }

    public static void drawTexture(class_4587 matrices, class_2960 texture, float x1, float x2, float y1, float y2, float z, float regionWidth, float regionHeight, float u, float v, int textureWidth, int textureHeight, float r, float g, float b, float a) {
        DrawHelper.drawTexturedQuad(matrices, texture, x1, x2, y1, y2, z, (u + 0.0f) / (float)textureWidth, (u + regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + regionHeight) / (float)textureHeight, r, g, b, a);
    }

    public static void drawTexturedQuad(class_4587 matrices, class_2960 texture, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, x1, y1, z).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix4f, x1, y2, z).method_22913(u1, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, x2, y2, z).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, x2, y1, z).method_22913(u2, v1).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void drawTexturedQuad(class_4587 matrices, class_2960 texture, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2, float r, float g, float b, float a) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader(class_757::method_34543);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(matrix4f, x1, y1, z).method_22913(u1, v1).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix4f, x1, y2, z).method_22913(u1, v2).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix4f, x2, y2, z).method_22913(u2, v2).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix4f, x2, y1, z).method_22913(u2, v1).method_22915(r, g, b, a).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void drawItem(class_332 ctx, @Nullable class_1309 entity, @Nullable class_1937 world, class_1799 stack, float x, float y, int seed, float z, float r, float g, float b) {
        DrawHelper.drawItem(ctx, entity, world, stack, x, y, seed, z, r, g, b, 1.0f);
    }

    public static void drawItem(class_332 ctx, @Nullable class_1309 entity, @Nullable class_1937 world, class_1799 stack, float x, float y, int seed, float z, float r, float g, float b, float a) {
        if (!stack.method_7960()) {
            class_1087 bakedModel = class_310.method_1551().method_1480().method_4019(stack, world, entity, seed);
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416(x + 8.0f, y + 8.0f, 150.0f + (bakedModel.method_4712() ? z : 0.0f));
            try {
                boolean bl;
                ctx.method_51448().method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                ctx.method_51448().method_22905(16.0f, 16.0f, 16.0f);
                boolean bl2 = bl = !bakedModel.method_24304();
                if (bl) {
                    class_308.method_24210();
                }
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                class_310.method_1551().method_1480().method_23179(stack, class_811.field_4317, false, ctx.method_51448(), (class_4597)ctx.method_51450(), 0xF000F0, class_4608.field_21444, bakedModel);
                ctx.method_51452();
                if (bl) {
                    class_308.method_24211();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            catch (Throwable throwable) {
                class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Rendering item");
                class_129 crashReportSection = crashReport.method_562("Item being rendered");
                crashReportSection.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
                crashReportSection.method_577("Item Damage", () -> String.valueOf(stack.method_7919()));
                crashReportSection.method_577("Item NBT", () -> String.valueOf(stack.method_7969()));
                crashReportSection.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
                throw new class_148(crashReport);
            }
            ctx.method_51448().method_22909();
        }
    }

    public static void drawNineSlicedTexture(class_332 ctx, class_2960 texture, int x, int y, int width, int height, int leftSliceWidth, int topSliceHeight, int rightSliceWidth, int bottomSliceHeight, int centerSliceWidth, int centerSliceHeight, int u, int v) {
        if (width == centerSliceWidth && height == centerSliceHeight) {
            ctx.method_25302(texture, x, y, u, v, width, height);
        } else if (height == centerSliceHeight) {
            ctx.method_25302(texture, x, y, u, v, leftSliceWidth, height);
            ctx.method_48585(texture, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, height, u + leftSliceWidth, v, centerSliceWidth - rightSliceWidth - leftSliceWidth, centerSliceHeight);
            ctx.method_25302(texture, x + width - rightSliceWidth, y, u + centerSliceWidth - rightSliceWidth, v, rightSliceWidth, height);
        } else if (width == centerSliceWidth) {
            ctx.method_25302(texture, x, y, u, v, width, topSliceHeight);
            ctx.method_48585(texture, x, y + topSliceHeight, width, height - bottomSliceHeight - topSliceHeight, u, v + topSliceHeight, centerSliceWidth, centerSliceHeight - bottomSliceHeight - topSliceHeight);
            ctx.method_25302(texture, x, y + height - bottomSliceHeight, u, v + centerSliceHeight - bottomSliceHeight, width, bottomSliceHeight);
        } else {
            ctx.method_25302(texture, x, y, u, v, leftSliceWidth, topSliceHeight);
            ctx.method_48585(texture, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, topSliceHeight, u + leftSliceWidth, v, centerSliceWidth - rightSliceWidth - leftSliceWidth, topSliceHeight);
            ctx.method_25302(texture, x + width - rightSliceWidth, y, u + centerSliceWidth - rightSliceWidth, v, rightSliceWidth, topSliceHeight);
            ctx.method_25302(texture, x, y + height - bottomSliceHeight, u, v + centerSliceHeight - bottomSliceHeight, leftSliceWidth, bottomSliceHeight);
            ctx.method_48585(texture, x + leftSliceWidth, y + height - bottomSliceHeight, width - rightSliceWidth - leftSliceWidth, bottomSliceHeight, u + leftSliceWidth, v + centerSliceHeight - bottomSliceHeight, centerSliceWidth - rightSliceWidth - leftSliceWidth, bottomSliceHeight);
            ctx.method_25302(texture, x + width - rightSliceWidth, y + height - bottomSliceHeight, u + centerSliceWidth - rightSliceWidth, v + centerSliceHeight - bottomSliceHeight, rightSliceWidth, bottomSliceHeight);
            ctx.method_48585(texture, x, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, u, v + topSliceHeight, leftSliceWidth, centerSliceHeight - bottomSliceHeight - topSliceHeight);
            ctx.method_48585(texture, x + leftSliceWidth, y + topSliceHeight, width - rightSliceWidth - leftSliceWidth, height - bottomSliceHeight - topSliceHeight, u + leftSliceWidth, v + topSliceHeight, centerSliceWidth - rightSliceWidth - leftSliceWidth, centerSliceHeight - bottomSliceHeight - topSliceHeight);
            ctx.method_48585(texture, x + width - rightSliceWidth, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, u + centerSliceWidth - rightSliceWidth, v + topSliceHeight, rightSliceWidth, centerSliceHeight - bottomSliceHeight - topSliceHeight);
        }
    }

    public static boolean mouseInRect(int mouseX, int mouseY, int drawPosX, int drawPosY, int width, int height) {
        return mouseX >= drawPosX && mouseY >= drawPosY && mouseX <= drawPosX + width && mouseY <= drawPosY + height;
    }

    public static int drawText(class_332 context, class_327 textRenderer, @Nullable String text, float x, float y, int color, boolean shadow) {
        if (text == null) {
            return 0;
        }
        int i = textRenderer.method_27522(text, x, y, color, shadow, context.method_51448().method_23760().method_23761(), (class_4597)context.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0, textRenderer.method_1726());
        context.method_51452();
        return i;
    }

    public static void drawTextOutlined(class_332 context, class_327 textRenderer, @Nullable String text, float x, float y, int color, int outlineColor) {
        DrawHelper.drawText(context, textRenderer, text, x + 1.0f, y, outlineColor, false);
        DrawHelper.drawText(context, textRenderer, text, x - 1.0f, y, outlineColor, false);
        DrawHelper.drawText(context, textRenderer, text, x, y + 1.0f, outlineColor, false);
        DrawHelper.drawText(context, textRenderer, text, x, y - 1.0f, outlineColor, false);
        DrawHelper.drawText(context, textRenderer, text, x, y, color, false);
    }
}

