/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.items.armor.IListenerArmor;

public class EntityUtil {
    public static final HashMap<UUID, Integer> playerjumpCooldowns = new HashMap();

    public static void tick(MinecraftServer server) {
        ArrayList<UUID> toBeRemoved = new ArrayList<UUID>();
        for (UUID uuid : playerjumpCooldowns.keySet()) {
            class_3222 spe = server.method_3760().method_14602(uuid);
            if (spe != null) {
                int c = EntityUtil.getCooldown(spe);
                if (--c > 0) {
                    EntityUtil.setCooldown(spe, c);
                    continue;
                }
                toBeRemoved.add(uuid);
                continue;
            }
            toBeRemoved.add(uuid);
        }
        for (UUID uuid : toBeRemoved) {
            playerjumpCooldowns.remove(uuid);
        }
    }

    public static int getCooldown(class_3222 spe) {
        UUID uuid = spe.method_5667();
        if (playerjumpCooldowns.containsKey(uuid)) {
            return playerjumpCooldowns.get(uuid);
        }
        return 0;
    }

    public static void setCooldown(class_3222 spe, int c) {
        UUID uuid = spe.method_5667();
        playerjumpCooldowns.put(uuid, c);
    }

    public static void onJump(class_1309 entity) {
        class_3222 spe;
        if (entity instanceof class_1308) {
            class_1308 thisMobEntity = (class_1308)entity;
            for (class_1799 armorItemStack : thisMobEntity.method_5661()) {
                class_1792 class_17922 = armorItemStack.method_7909();
                if (!(class_17922 instanceof IListenerArmor)) continue;
                IListenerArmor armorWithHitEffect = (IListenerArmor)class_17922;
                armorWithHitEffect.onJump(armorItemStack, (class_1309)thisMobEntity);
            }
        } else if (entity instanceof class_3222 && EntityUtil.getCooldown(spe = (class_3222)entity) <= 0) {
            for (class_1799 armorItemStack : spe.method_5661()) {
                class_1792 class_17923 = armorItemStack.method_7909();
                if (!(class_17923 instanceof IListenerArmor)) continue;
                IListenerArmor armorWithHitEffect = (IListenerArmor)class_17923;
                armorWithHitEffect.onJump(armorItemStack, (class_1309)spe);
            }
            EntityUtil.setCooldown(spe, 10);
        }
    }

    public static void onAttacking(class_1309 thisEntity, class_1297 target) {
        block3: {
            class_1309 targetEnt;
            block4: {
                if (!(target instanceof class_1309)) {
                    return;
                }
                targetEnt = (class_1309)target;
                class_1937 world = thisEntity.method_37908();
                if (world.field_9236) break block3;
                if (!(thisEntity instanceof class_1308)) break block4;
                class_1308 thisMobEntity = (class_1308)thisEntity;
                for (class_1799 armorItemStack : thisMobEntity.method_5661()) {
                    class_1792 class_17922 = armorItemStack.method_7909();
                    if (!(class_17922 instanceof IListenerArmor)) continue;
                    IListenerArmor armorWithHitEffect = (IListenerArmor)class_17922;
                    armorWithHitEffect.onHit(armorItemStack, (class_1309)thisMobEntity, targetEnt);
                }
                break block3;
            }
            if (!(thisEntity instanceof class_3222)) break block3;
            class_3222 thisPlayerEntity = (class_3222)thisEntity;
            for (class_1799 armorItemStack : thisPlayerEntity.method_5661()) {
                class_1792 class_17923 = armorItemStack.method_7909();
                if (!(class_17923 instanceof IListenerArmor)) continue;
                IListenerArmor armorWithHitEffect = (IListenerArmor)class_17923;
                armorWithHitEffect.onHit(armorItemStack, (class_1309)thisPlayerEntity, targetEnt);
            }
        }
    }

    public static void onMessageSent(class_3222 spe, String message) {
        for (class_1799 armorItemStack : spe.method_5661()) {
            class_1792 class_17922 = armorItemStack.method_7909();
            if (!(class_17922 instanceof IListenerArmor)) continue;
            IListenerArmor armorWithHitEffect = (IListenerArmor)class_17922;
            armorWithHitEffect.onMessageSent(armorItemStack, spe, message);
        }
    }

    public static void slipItem(class_1309 entity, class_1799 heldStack) {
        if (entity == null || heldStack == null || heldStack.method_7960()) {
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 spe = (class_3222)entity;
            int slot = spe.method_31548().method_7395(heldStack);
            if (slot == -1) {
                return;
            }
            spe.method_7329(heldStack.method_51164(), true, true);
        }
    }

    @Nullable
    public static class_3966 raycast(class_1937 world, class_243 min, class_243 max, class_238 box, Predicate<class_1297> predicate, double squaredReach) {
        double e = squaredReach;
        class_1297 resultEntity = null;
        class_243 hitPos = null;
        for (class_1297 contenderEntity : world.method_8390(class_1309.class, box, predicate)) {
            class_243 vec3d2;
            double f;
            class_238 hitBox = contenderEntity.method_5829().method_1014((double)contenderEntity.method_5871());
            Optional hitBoxHit = hitBox.method_992(min, max);
            if (hitBox.method_1006(min)) {
                if (!(e >= 0.0)) continue;
                resultEntity = contenderEntity;
                hitPos = hitBoxHit.orElse(min);
                e = 0.0;
                continue;
            }
            if (!hitBoxHit.isPresent() || !((f = min.method_1025(vec3d2 = (class_243)hitBoxHit.get())) < e) && e != 0.0) continue;
            resultEntity = contenderEntity;
            hitPos = vec3d2;
            e = f;
        }
        if (resultEntity == null) {
            return null;
        }
        return new class_3966(resultEntity, hitPos);
    }

    public static Boolean isInRange(class_1309 le, class_3218 sw, class_243 pos, float range) {
        if (le.method_37908() != sw) {
            return false;
        }
        return EntityUtil.distanceTo((class_1297)le, pos) <= (double)range;
    }

    public static double distanceTo(class_1297 e, class_243 pos) {
        return pos.method_1020(e.method_19538()).method_1033();
    }

    public static class_243 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }
}

