/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.util;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.oxytocina.geomancy.blocks.ILeadPoisoningBlock;
import org.oxytocina.geomancy.entity.PlayerData;
import org.oxytocina.geomancy.items.ILeadPoisoningItem;
import org.oxytocina.geomancy.networking.ModMessages;
import org.oxytocina.geomancy.util.AdvancementHelper;
import org.oxytocina.geomancy.util.Toolbox;
import oshi.util.tuples.Triplet;

public class LeadUtil {
    private static final ArrayList<class_1657> queuedRecalcs = new ArrayList();
    private static final HashMap<class_2338, Float> cachedAmbientPoison = new HashMap();
    private static long clearCacheCounter = 0L;
    private static long leadEffectsCounter = 0L;
    private static long tickCounter = 0L;

    public static boolean addPoisoning(class_1657 player, float amount) {
        if (player == null) {
            return false;
        }
        float newP = Math.max(0.0f, LeadUtil.getPoisoning(player) + amount);
        return LeadUtil.setPoisoning(player, newP);
    }

    public static boolean setPoisoning(class_1657 player, float amount) {
        if (player == null) {
            return false;
        }
        PlayerData data = PlayerData.from(player);
        float old = data.leadPoisoning;
        if (old == amount) {
            return false;
        }
        data.leadPoisoning = amount;
        return true;
    }

    public static boolean setPoisoningSpeed(class_1657 player, float newVal) {
        if (player == null) {
            return false;
        }
        PlayerData data = PlayerData.from(player);
        float old = data.leadPoisoningSpeed;
        if (old == newVal) {
            return false;
        }
        data.leadPoisoningSpeed = newVal;
        return true;
    }

    public static float getPoisoning(class_1657 player) {
        return PlayerData.from((class_1657)player).leadPoisoning;
    }

    public static float getPoisoningSpeed(class_1657 player) {
        return PlayerData.from((class_1657)player).leadPoisoningSpeed;
    }

    private static void recalculatePoisoningSpeed(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        float speed = 0.0f;
        List<HeldInfluenceItem> items = LeadUtil.getAllPoisoningItems(player);
        for (HeldInfluenceItem item : items) {
            class_1792 class_17922 = item.stack.method_7909();
            if (!(class_17922 instanceof ILeadPoisoningItem)) continue;
            ILeadPoisoningItem poisoner = (ILeadPoisoningItem)class_17922;
            if (item.inHand) {
                speed += poisoner.getInHandPoisoningSpeed() * (float)item.stack.method_7947();
                continue;
            }
            if (item.worn) {
                speed += poisoner.getWornPoisoningSpeed() * (float)item.stack.method_7947();
                continue;
            }
            speed += poisoner.getInInventoryPoisoningSpeed() * (float)item.stack.method_7947();
        }
        LeadUtil.setPoisoningSpeed(player, speed);
        LeadUtil.syncPoisoning(player);
    }

    public static void tick(MinecraftServer server) {
        if (++tickCounter > 10L) {
            tickCounter = 0L;
            for (class_3222 player : server.method_3760().method_14571()) {
                LeadUtil.tickLeadPoisoning(player);
            }
        }
        for (class_1657 entity : queuedRecalcs) {
            LeadUtil.recalculatePoisoningSpeed(entity);
        }
        queuedRecalcs.clear();
        if (++clearCacheCounter > 60L) {
            cachedAmbientPoison.clear();
            clearCacheCounter = 0L;
        }
        if (++leadEffectsCounter > 1200L) {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (player.method_7337() || player.method_7325() || player.method_29504()) continue;
                LeadUtil.tryLeadEffects(player);
            }
            leadEffectsCounter = 0L;
        }
    }

    public static void tryLeadEffects(class_3222 player) {
        float poison = LeadUtil.getPoisoning((class_1657)player);
        float chance = poison / (poison + 400.0f);
        if (Toolbox.random.nextFloat() > chance) {
            return;
        }
        ArrayList<Triplet> effects = new ArrayList<Triplet>();
        effects.add(new Triplet((Object)Float.valueOf(10.0f), (Object)1, p -> p.method_7353((class_2561)class_2561.method_43471((String)"geomancy.message.lead.tingling"), true)));
        effects.add(new Triplet((Object)Float.valueOf(20.0f), (Object)1, p -> {
            p.method_7353((class_2561)class_2561.method_43471((String)"geomancy.message.lead.nausea"), true);
            p.method_6092(new class_1293(class_1294.field_5916, 300));
        }));
        effects.add(new Triplet((Object)Float.valueOf(30.0f), (Object)1, p -> {
            p.method_7353((class_2561)class_2561.method_43471((String)"geomancy.message.lead.poison"), true);
            p.method_6092(new class_1293(class_1294.field_5899, 100));
        }));
        effects.add(new Triplet((Object)Float.valueOf(30.0f), (Object)1, p -> {
            p.method_7353((class_2561)class_2561.method_43471((String)"geomancy.message.lead.joints"), true);
            p.method_6092(new class_1293(class_1294.field_5901, 4800));
            p.method_6092(new class_1293(class_1294.field_5909, 3600));
        }));
        HashMap<Triplet, Integer> pickedEffects = new HashMap<Triplet, Integer>();
        for (Triplet t : effects) {
            if (!(((Float)t.getA()).floatValue() < poison)) continue;
            pickedEffects.put(t, (Integer)t.getB());
        }
        Triplet picked = Toolbox.selectWeightedRandomIndex(pickedEffects, null);
        if (picked != null) {
            ((Consumer)picked.getC()).accept(player);
            AdvancementHelper.grantAdvancementCriterion(player, "main/simple_lead_poisoned", "simple_lead_poisoned");
        }
    }

    public static void queueRecalculatePoisoningSpeed(class_1657 player) {
        if (!queuedRecalcs.contains(player)) {
            queuedRecalcs.add(player);
        }
    }

    public static void syncPoisoning(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 spe = (class_3222)player;
        class_2540 buf = PacketByteBufs.create();
        buf.writeFloat(LeadUtil.getPoisoningSpeed(player));
        buf.writeFloat(LeadUtil.getPoisoning(player));
        ServerPlayNetworking.send((class_3222)spe, (class_2960)ModMessages.LEAD_POISONING_SYNC, (class_2540)buf);
    }

    public static float getAmbientPoisoning(class_1297 entity) {
        return LeadUtil.getAmbientPoisoning(entity.method_37908(), entity.method_24515());
    }

    public static float getAmbientPoisoning(class_1937 world, class_2338 pos) {
        if (cachedAmbientPoison.containsKey(pos)) {
            return cachedAmbientPoison.get(pos).floatValue();
        }
        float checkRadius = 2.0f;
        float res = 0.0f;
        ArrayList checkedBlockPos = new ArrayList();
        class_2338.method_29715((class_238)class_238.method_19316((class_3341)new class_3341(pos)).method_1014(2.0)).filter(pos3 -> LeadUtil.isPoisonous(world.method_8320(pos3))).forEach(blockPos -> checkedBlockPos.add(blockPos.method_25503()));
        for (class_2338 pos2 : checkedBlockPos) {
            class_2680 state = world.method_8320(pos2);
            class_2248 class_22482 = state.method_26204();
            if (!(class_22482 instanceof ILeadPoisoningBlock)) continue;
            ILeadPoisoningBlock poisoningBlock = (ILeadPoisoningBlock)class_22482;
            float poisonousness = poisoningBlock.getAmbientPoisoningSpeed();
            double dist = pos.method_10262((class_2382)pos2);
            res += poisonousness / Math.max(1.0f, (float)Math.sqrt(dist));
        }
        cachedAmbientPoison.put(pos, Float.valueOf(res));
        return res;
    }

    private static boolean tickLeadPoisoning(class_3222 player) {
        double lerpPerTick;
        float newPoisoning;
        if (player.method_7337() || player.method_29504()) {
            return false;
        }
        boolean changed = false;
        float prevPoisoning = LeadUtil.getPoisoning((class_1657)player);
        float playerPoisoningSpeed = LeadUtil.getPoisoningSpeed((class_1657)player);
        float ambientPoisoningSpeed = LeadUtil.getAmbientPoisoning((class_1297)player);
        double effectivePoisoningSpeed = playerPoisoningSpeed + ambientPoisoningSpeed;
        double g = 0.03;
        if (effectivePoisoningSpeed > 1.0) {
            effectivePoisoningSpeed = Toolbox.log(1.03, effectivePoisoningSpeed * 0.03 + 1.0);
        }
        if ((newPoisoning = (float)(Toolbox.LerpD(prevPoisoning, 0.0, lerpPerTick = 1.0E-4 / (1.0 + Math.max(effectivePoisoningSpeed *= 0.001, 0.0))) + effectivePoisoningSpeed)) != prevPoisoning) {
            changed = true;
            LeadUtil.setPoisoning((class_1657)player, newPoisoning);
        }
        if (changed) {
            LeadUtil.syncPoisoning((class_1657)player);
        }
        return changed;
    }

    public static boolean isPoisonous(class_1799 stack) {
        return stack.method_7909() instanceof ILeadPoisoningItem;
    }

    public static boolean isPoisonous(class_2680 block) {
        return block.method_26204() instanceof ILeadPoisoningBlock;
    }

    public static List<HeldInfluenceItem> getAllPoisoningItems(class_1657 player) {
        ArrayList<HeldInfluenceItem> res = new ArrayList<HeldInfluenceItem>();
        class_1661 inv = player.method_31548();
        Optional trinketComp = TrinketsApi.getTrinketComponent((class_1309)player);
        List trinketInv = trinketComp.map(TrinketComponent::getAllEquipped).orElse(null);
        if (inv != null) {
            for (class_1799 s : inv.field_7547) {
                if (!LeadUtil.isPoisonous(s)) continue;
                res.add(new HeldInfluenceItem(s, player.method_6047() == s, false));
            }
            for (class_1799 s : inv.field_7548) {
                if (!LeadUtil.isPoisonous(s)) continue;
                res.add(new HeldInfluenceItem(s, false, true));
            }
            for (class_1799 s : inv.field_7544) {
                if (!LeadUtil.isPoisonous(s)) continue;
                res.add(new HeldInfluenceItem(s, true, false));
            }
        }
        if (trinketInv != null) {
            for (class_3545 pair : trinketInv) {
                if (!LeadUtil.isPoisonous((class_1799)pair.method_15441())) continue;
                res.add(new HeldInfluenceItem((class_1799)pair.method_15441(), false, true));
            }
        }
        return res;
    }

    public static class HeldInfluenceItem {
        public final class_1799 stack;
        public final boolean inHand;
        public final boolean worn;

        public HeldInfluenceItem(class_1799 stack, boolean inHand, boolean worn) {
            this.stack = stack;
            this.inHand = inHand;
            this.worn = worn;
        }
    }
}

