/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.util;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.blocks.IMaddeningBlock;
import org.oxytocina.geomancy.effects.ModStatusEffects;
import org.oxytocina.geomancy.entity.PlayerData;
import org.oxytocina.geomancy.items.IMaddeningItem;
import org.oxytocina.geomancy.networking.ModMessages;
import org.oxytocina.geomancy.util.AdvancementHelper;
import org.oxytocina.geomancy.util.EntityUtil;
import org.oxytocina.geomancy.util.LeadUtil;
import org.oxytocina.geomancy.util.Toolbox;
import oshi.util.tuples.Triplet;

public class MadnessUtil {
    private static final ArrayList<class_1657> queuedRecalcs = new ArrayList();
    private static final HashMap<class_2338, Float> cachedAmbientMadness = new HashMap();
    private static long clearCacheCounter = 0L;
    private static long madnessEffectsCounter = 0L;
    private static long whisperCounter = 0L;
    private static long tickCounter = 0L;

    public static boolean setMadness(class_1657 player, float amount) {
        if (player == null) {
            return false;
        }
        PlayerData data = PlayerData.from(player);
        float old = data.madness;
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        if (Float.isNaN(amount)) {
            Geomancy.logError("tried to set " + player.method_5476().getString() + "s madness to not a number!");
            throw new RuntimeException();
        }
        if (old == amount) {
            return false;
        }
        data.madness = amount;
        return true;
    }

    public static void addMadness(class_3222 spe, float amount) {
        MadnessUtil.setMadness((class_1657)spe, MadnessUtil.getMadness((class_1657)spe) + amount);
    }

    public static boolean setMaddeningSpeed(class_1657 player, float newVal) {
        if (player == null) {
            return false;
        }
        PlayerData data = PlayerData.from(player);
        float old = data.madnessSpeed;
        if (old == newVal) {
            return false;
        }
        data.madnessSpeed = newVal;
        return true;
    }

    public static float getMadness(class_1657 player) {
        float res = PlayerData.from((class_1657)player).madness;
        if (Float.isNaN(res)) {
            Geomancy.logError("got NaN as madness of player " + player.method_5476().getString() + "! setting to 0");
            res = 0.0f;
            MadnessUtil.setMadness(player, 0.0f);
        }
        return res;
    }

    public static float getMadnessSpeed(class_1657 player) {
        return PlayerData.from((class_1657)player).madnessSpeed;
    }

    private static void recalculateMadnessSpeed(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        float speed = 0.0f;
        List<LeadUtil.HeldInfluenceItem> items = MadnessUtil.getAllMaddeningItems(player);
        for (LeadUtil.HeldInfluenceItem item : items) {
            class_1792 class_17922 = item.stack.method_7909();
            if (!(class_17922 instanceof IMaddeningItem)) continue;
            IMaddeningItem maddener = (IMaddeningItem)class_17922;
            if (item.inHand) {
                speed += maddener.getInHandMaddeningSpeed() * (float)item.stack.method_7947();
                continue;
            }
            if (item.worn) {
                speed += maddener.getWornMaddeningSpeed() * (float)item.stack.method_7947();
                continue;
            }
            speed += maddener.getInInventoryMaddeningSpeed() * (float)item.stack.method_7947();
        }
        MadnessUtil.setMaddeningSpeed(player, speed);
        MadnessUtil.syncMadness(player);
    }

    public static void tick(MinecraftServer server) {
        if (++tickCounter > 10L) {
            tickCounter = 0L;
            for (class_3222 player : server.method_3760().method_14571()) {
                MadnessUtil.tickMadness(player);
            }
        }
        for (class_1657 entity : queuedRecalcs) {
            MadnessUtil.recalculateMadnessSpeed(entity);
        }
        queuedRecalcs.clear();
        if (++clearCacheCounter > 60L) {
            cachedAmbientMadness.clear();
            clearCacheCounter = 0L;
        }
        if (++madnessEffectsCounter > 1200L) {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (player.method_7337() || player.method_29504()) continue;
                MadnessUtil.tryMadnessEffects(player);
            }
            madnessEffectsCounter = 0L;
        }
        if (++whisperCounter > 40L) {
            for (class_3222 player : server.method_3760().method_14571()) {
                MadnessUtil.tryWhisper(player);
            }
            whisperCounter = 0L;
        }
    }

    private static void tryWhisper(class_3222 player) {
        if (player.method_7337() || player.method_29504()) {
            return;
        }
        float madness = MadnessUtil.getMadness((class_1657)player);
        float ambientMadness = MadnessUtil.getAmbientMadness((class_1297)player);
        float combined = Math.max(0.0f, madness + ambientMadness);
        float chance = Toolbox.clampF(combined / (combined + 800.0f), 0.0f, 1.0f);
        if (Toolbox.random.nextFloat() > chance) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(player.method_24515());
        buf.writeFloat(0.2f + chance * 0.6f);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.WHISPER, (class_2540)buf);
    }

    public static void tryMadnessEffects(class_3222 player) {
        float madness = MadnessUtil.getMadness((class_1657)player);
        float chance = madness / (madness + 800.0f);
        if (Toolbox.random.nextFloat() > chance) {
            return;
        }
        ArrayList<Triplet> effects = new ArrayList<Triplet>();
        effects.add(new Triplet((Object)Float.valueOf(10.0f), (Object)1, p -> {
            p.method_6092(new class_1293(ModStatusEffects.REGRETFUL, 6000, 0));
            p.method_7353((class_2561)class_2561.method_43471((String)"geomancy.message.madness.regret"), true);
        }));
        effects.add(new Triplet((Object)Float.valueOf(20.0f), (Object)1, p -> {
            p.method_6092(new class_1293(ModStatusEffects.MOURNING, 6000, 0));
            p.method_7353((class_2561)class_2561.method_43471((String)"geomancy.message.madness.mourning"), true);
        }));
        effects.add(new Triplet((Object)Float.valueOf(30.0f), (Object)1, p -> {
            p.method_6092(new class_1293(ModStatusEffects.ECSTATIC, 2400, 0));
            p.method_7353((class_2561)class_2561.method_43471((String)"geomancy.message.madness.ecstasy"), true);
        }));
        effects.add(new Triplet((Object)Float.valueOf(40.0f), (Object)1, p -> {
            p.method_6092(new class_1293(class_1294.field_5916, 400, 0));
            p.method_7353((class_2561)class_2561.method_43471((String)"geomancy.message.madness.nausea"), true);
        }));
        effects.add(new Triplet((Object)Float.valueOf(40.0f), (Object)1, p -> {
            p.method_6092(new class_1293(ModStatusEffects.PARANOIA, 3600, 0));
            p.method_7353((class_2561)class_2561.method_43471((String)"geomancy.message.madness.paranoia"), true);
        }));
        HashMap<Triplet, Integer> pickedEffects = new HashMap<Triplet, Integer>();
        for (Triplet t : effects) {
            if (!(((Float)t.getA()).floatValue() < madness)) continue;
            pickedEffects.put(t, (Integer)t.getB());
        }
        Triplet picked = Toolbox.selectWeightedRandomIndex(pickedEffects, null);
        if (picked != null) {
            ((Consumer)picked.getC()).accept(player);
            AdvancementHelper.grantAdvancementCriterion(player, "main/simple_maddened", "simple_maddened");
        }
    }

    public static void queueRecalculateMadnessSpeed(class_1657 player) {
        if (!queuedRecalcs.contains(player)) {
            queuedRecalcs.add(player);
        }
    }

    public static void syncMadness(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 spe = (class_3222)player;
        class_2540 buf = PacketByteBufs.create();
        buf.writeFloat(MadnessUtil.getMadnessSpeed(player));
        buf.writeFloat(MadnessUtil.getMadness(player));
        ServerPlayNetworking.send((class_3222)spe, (class_2960)ModMessages.MADNESS_SYNC, (class_2540)buf);
    }

    public static float getAmbientMadness(class_1297 entity) {
        return MadnessUtil.getAmbientMadness(entity.method_37908(), entity.method_24515());
    }

    public static float getAmbientMadness(class_1937 world, class_2338 pos) {
        if (cachedAmbientMadness.containsKey(pos)) {
            return cachedAmbientMadness.get(pos).floatValue();
        }
        float checkRadius = 4.0f;
        float res = 0.0f;
        ArrayList checkedBlockPos = new ArrayList();
        class_2338.method_29715((class_238)class_238.method_19316((class_3341)new class_3341(pos)).method_1014(4.0)).filter(pos3 -> MadnessUtil.isMaddening(world.method_8320(pos3))).forEach(blockPos -> checkedBlockPos.add(blockPos.method_25503()));
        for (class_2338 pos2 : checkedBlockPos) {
            class_2680 state = world.method_8320(pos2);
            class_2248 class_22482 = state.method_26204();
            if (!(class_22482 instanceof IMaddeningBlock)) continue;
            IMaddeningBlock maddeningBlock = (IMaddeningBlock)class_22482;
            float maddeningness = maddeningBlock.getAmbientMaddeningSpeed();
            double dist = pos.method_10262((class_2382)pos2);
            res += maddeningness / Math.max(1.0f, (float)Math.sqrt(dist));
        }
        cachedAmbientMadness.put(pos, Float.valueOf(res));
        return res;
    }

    private static boolean tickMadness(class_3222 player) {
        double lerpPerTick;
        float newMadness;
        if (player.method_7337() || player.method_29504()) {
            return false;
        }
        boolean changed = false;
        float prevMadness = MadnessUtil.getMadness((class_1657)player);
        float playerMaddeningSpeed = MadnessUtil.getMadnessSpeed((class_1657)player);
        float ambientMaddeningSpeed = MadnessUtil.getAmbientMadness((class_1297)player);
        double effectiveMaddeningSpeed = playerMaddeningSpeed + ambientMaddeningSpeed;
        double g = 0.03;
        if (effectiveMaddeningSpeed > 1.0) {
            effectiveMaddeningSpeed = (float)Toolbox.log(1.03, effectiveMaddeningSpeed * 0.03 + 1.0);
        }
        if ((newMadness = (float)(Toolbox.LerpD(prevMadness, 0.0, lerpPerTick = 1.0E-4 / (1.0 + Math.max(effectiveMaddeningSpeed *= 0.001, 0.0))) + effectiveMaddeningSpeed)) != prevMadness) {
            changed = true;
            MadnessUtil.setMadness((class_1657)player, newMadness);
        }
        if (changed) {
            MadnessUtil.syncMadness((class_1657)player);
        }
        return changed;
    }

    public static boolean isMaddening(class_1799 stack) {
        return stack.method_7909() instanceof IMaddeningItem;
    }

    public static boolean isMaddening(class_2680 block) {
        return block.method_26204() instanceof IMaddeningBlock;
    }

    public static List<LeadUtil.HeldInfluenceItem> getAllMaddeningItems(class_1657 player) {
        ArrayList<LeadUtil.HeldInfluenceItem> res = new ArrayList<LeadUtil.HeldInfluenceItem>();
        class_1661 inv = player.method_31548();
        Optional trinketComp = TrinketsApi.getTrinketComponent((class_1309)player);
        List trinketInv = trinketComp.map(TrinketComponent::getAllEquipped).orElse(null);
        if (inv != null) {
            for (class_1799 s : inv.field_7547) {
                if (!MadnessUtil.isMaddening(s)) continue;
                res.add(new LeadUtil.HeldInfluenceItem(s, player.method_6047() == s, false));
            }
            for (class_1799 s : inv.field_7548) {
                if (!MadnessUtil.isMaddening(s)) continue;
                res.add(new LeadUtil.HeldInfluenceItem(s, false, true));
            }
            for (class_1799 s : inv.field_7544) {
                if (!MadnessUtil.isMaddening(s)) continue;
                res.add(new LeadUtil.HeldInfluenceItem(s, true, false));
            }
        }
        if (trinketInv != null) {
            for (class_3545 pair : trinketInv) {
                if (!MadnessUtil.isMaddening((class_1799)pair.method_15441())) continue;
                res.add(new LeadUtil.HeldInfluenceItem((class_1799)pair.method_15441(), false, true));
            }
        }
        return res;
    }

    public static void whisperAt(class_3218 world, class_2338 pos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.writeFloat(0.5f);
        ModMessages.sendToAllClients(world.method_8503(), ModMessages.WHISPER, buf, s -> EntityUtil.isInRange((class_1309)s, world, pos.method_46558(), 50.0f));
    }
}

