/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.util;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.blocks.blockEntities.AutocasterBlockEntity;
import org.oxytocina.geomancy.effects.ModStatusEffects;
import org.oxytocina.geomancy.entity.PlayerData;
import org.oxytocina.geomancy.entity.SoulStoringItemData;
import org.oxytocina.geomancy.items.ISoulStoringItem;
import org.oxytocina.geomancy.items.jewelry.IJewelryItem;
import org.oxytocina.geomancy.networking.ModMessages;
import org.oxytocina.geomancy.registries.ModBiomeTags;
import org.oxytocina.geomancy.registries.ModBlockTags;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.util.Toolbox;

public class SoulUtil {
    private static final ArrayList<class_1657> queuedRecalcs = new ArrayList();
    private static final HashMap<class_2338, Float> cachedAmbientSouls = new HashMap();
    private static int cacheClearTimer = 0;

    public static boolean setSoul(class_1657 player, float amount) {
        if (player == null) {
            return false;
        }
        PlayerData data = PlayerData.from(player);
        float old = data.mana;
        float mana = Toolbox.clampF(amount, 0.0f, data.maxMana);
        if (old == mana) {
            return false;
        }
        data.mana = mana;
        return true;
    }

    public static boolean setSoulCap(class_1657 player, float newMaxMana) {
        if (player == null) {
            return false;
        }
        PlayerData data = PlayerData.from(player);
        float old = data.maxMana;
        if (old == newMaxMana) {
            return false;
        }
        data.maxMana = newMaxMana;
        return true;
    }

    public static float getSoul(class_1657 player) {
        return PlayerData.from((class_1657)player).mana;
    }

    public static float getSoul(class_1937 world, class_1263 inv) {
        List<class_1799> items = SoulUtil.getAllSoulStoringItems(inv);
        float res = 0.0f;
        for (class_1799 s : items) {
            res += ((ISoulStoringItem)s.method_7909()).getMana(world, s);
        }
        return res;
    }

    public static float getMaxSoul(class_1657 player) {
        return PlayerData.from((class_1657)player).maxMana;
    }

    private static void recalculateSoul(class_1657 player) {
        SoulUtil.recalculateSoul(player, true);
    }

    private static void recalculateSoul(class_1657 player, boolean sync) {
        if (!(player instanceof class_3222)) {
            return;
        }
        float cap = 0.0f;
        float mana = 0.0f;
        List<class_1799> items = SoulUtil.getAllSoulStoringItems(player);
        for (class_1799 item : items) {
            class_1792 class_17922 = item.method_7909();
            if (!(class_17922 instanceof ISoulStoringItem)) continue;
            ISoulStoringItem storer = (ISoulStoringItem)class_17922;
            cap += storer.getCapacity(player.method_37908(), item);
            mana += storer.getMana(player.method_37908(), item);
        }
        SoulUtil.setSoulCap(player, cap);
        SoulUtil.setSoul(player, mana);
        if (sync) {
            SoulUtil.syncSoul(player);
        }
    }

    public static void tick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            SoulUtil.tickPlayerSoul(player);
        }
        for (class_1657 entity : queuedRecalcs) {
            SoulUtil.recalculateSoul(entity);
        }
        queuedRecalcs.clear();
        if (++cacheClearTimer > 40) {
            cachedAmbientSouls.clear();
            cacheClearTimer = 0;
        }
    }

    public static void queueRecalculateSoul(class_1657 player) {
        if (!queuedRecalcs.contains(player)) {
            queuedRecalcs.add(player);
        }
    }

    public static void syncSoul(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 spe = (class_3222)player;
        class_2540 buf = PacketByteBufs.create();
        buf.writeFloat(SoulUtil.getMaxSoul(player));
        buf.writeFloat(SoulUtil.getSoul(player));
        ServerPlayNetworking.send((class_3222)spe, (class_2960)ModMessages.MANA_SYNC, (class_2540)buf);
    }

    public static void syncItemSoul(class_1937 world, class_1799 stack) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 svw = (class_3218)world;
        if (!(stack.method_7909() instanceof ISoulStoringItem)) {
            return;
        }
        for (class_3222 p : svw.method_18456()) {
            SoulUtil.syncItemSoul(world, stack, p);
        }
    }

    public static void syncItemSoul(class_1937 world, class_1799 stack, class_3222 with) {
        if (with == null) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 svw = (class_3218)world;
        if (!(stack.method_7909() instanceof ISoulStoringItem)) {
            return;
        }
        ISoulStoringItem.init(world, stack);
        SoulStoringItemData data = SoulStoringItemData.from(world, stack, ISoulStoringItem.getUUID(stack));
        class_2540 buf = PacketByteBufs.create();
        data.writeBuf(buf);
        ServerPlayNetworking.send((class_3222)with, (class_2960)ModMessages.ITEM_MANA_SYNC, (class_2540)buf);
    }

    public static float getAmbientSoulsPerBlock(class_1297 entity) {
        return SoulUtil.getAmbientSoulsPerBlock(entity.method_37908(), entity.method_24515());
    }

    public static float getAmbientSoulsPerBlock(class_1937 world, class_2338 pos) {
        if (cachedAmbientSouls.containsKey(pos)) {
            return Toolbox.ifNotNullThenElse(cachedAmbientSouls.get(pos), Float.valueOf(0.0f)).floatValue();
        }
        float res = 100.0f;
        class_6880 biome = world.method_23753(pos);
        if (biome.method_40220(ModBiomeTags.VPB_INSANE)) {
            res *= 10.0f;
        } else if (biome.method_40220(ModBiomeTags.VPB_HIGHEST)) {
            res *= 5.0f;
        } else if (biome.method_40220(ModBiomeTags.VPB_HIGHER)) {
            res *= 3.5f;
        } else if (biome.method_40220(ModBiomeTags.VPB_HIGH)) {
            res *= 2.0f;
        } else if (biome.method_40220(ModBiomeTags.VPB_NONE)) {
            res *= 0.0f;
        } else if (biome.method_40220(ModBiomeTags.VPB_LOWEST)) {
            res /= 5.0f;
        } else if (biome.method_40220(ModBiomeTags.VPB_LOWER)) {
            res /= 3.5f;
        } else if (biome.method_40220(ModBiomeTags.VPB_LOW)) {
            res /= 2.0f;
        }
        cachedAmbientSouls.put(pos, Float.valueOf(res += SoulUtil.getAmbientSPBFromBlocks(world, pos)));
        return res;
    }

    public static float getAmbientSPBFromBlocks(class_1937 world, class_2338 pos) {
        float checkRadius = 4.0f;
        float res = 0.0f;
        ArrayList checkedBlockPos = new ArrayList();
        class_2338.method_29715((class_238)class_238.method_19316((class_3341)new class_3341(pos)).method_1014(4.0)).filter(pos3 -> SoulUtil.addsAmbientSouls(world.method_8320(pos3))).forEach(blockPos -> checkedBlockPos.add(blockPos.method_25503()));
        for (class_2338 pos2 : checkedBlockPos) {
            class_2680 state = world.method_8320(pos2);
            double dist = pos.method_10262((class_2382)pos2);
            float div = Math.max(1.0f, (float)Math.sqrt(dist));
            if (state.method_26164(ModBlockTags.ADDS_SOULS_NORMAL)) {
                res += 3.0f / div;
                continue;
            }
            if (state.method_26164(ModBlockTags.ADDS_SOULS_FEW)) {
                res += 1.0f / div;
                continue;
            }
            if (state.method_26164(ModBlockTags.ADDS_SOULS_MANY)) {
                res += 10.0f / div;
                continue;
            }
            if (!state.method_26164(ModBlockTags.REMOVES_SOULS_MANY)) continue;
            res -= 10.0f / div;
        }
        return res;
    }

    public static boolean addsAmbientSouls(class_2680 state) {
        return state.method_26164(ModBlockTags.ADDS_SOULS);
    }

    public static float getRegenSpeedMultiplier(class_3222 player) {
        int amp;
        float res = IJewelryItem.getManaRegenMultiplier((class_1309)player);
        if (player.method_6059(ModStatusEffects.MOURNING)) {
            amp = player.method_6112(ModStatusEffects.MOURNING).method_5578();
            res *= Toolbox.clampF(1.0f - (float)(amp + 1) * 0.2f, 0.0f, 1.0f);
        }
        if (player.method_6059(ModStatusEffects.RIGHTEOUS)) {
            amp = player.method_6112(ModStatusEffects.RIGHTEOUS).method_5578();
            res *= 1.0f + (float)(amp + 1) * 0.5f;
        }
        return res;
    }

    private static boolean tickPlayerSoul(class_3222 player) {
        List<class_1799> storers = SoulUtil.getAllSoulStoringItems((class_1657)player);
        boolean changed = false;
        for (class_1799 stack : storers) {
            changed = SoulUtil.tickStack(player.method_37908(), stack, player.method_24515(), player) || changed;
        }
        if (!changed) {
            return changed;
        }
        SoulUtil.queueRecalculateSoul((class_1657)player);
        return changed;
    }

    public static boolean canStoreSoul(class_1799 stack) {
        return stack.method_7909() instanceof ISoulStoringItem;
    }

    public static class_1799 setItemSoulCapacity(class_1937 world, class_1799 stack, float capacity) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ISoulStoringItem) {
            ISoulStoringItem storingItem = (ISoulStoringItem)class_17922;
            storingItem.setCapacity(world, stack, capacity);
        }
        return stack;
    }

    public static List<class_1799> getAllSoulStoringItems(class_1657 player) {
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        class_1661 inv = player.method_31548();
        Optional trinketComp = TrinketsApi.getTrinketComponent((class_1309)player);
        List trinketInv = trinketComp.map(TrinketComponent::getAllEquipped).orElse(null);
        if (inv != null) {
            for (class_1799 s : inv.field_7547) {
                if (!SoulUtil.canStoreSoul(s)) continue;
                res.add(s);
            }
            for (class_1799 s : inv.field_7548) {
                if (!SoulUtil.canStoreSoul(s)) continue;
                res.add(s);
            }
            for (class_1799 s : inv.field_7544) {
                if (!SoulUtil.canStoreSoul(s)) continue;
                res.add(s);
            }
        }
        if (trinketInv != null) {
            for (class_3545 pair : trinketInv) {
                if (!SoulUtil.canStoreSoul((class_1799)pair.method_15441())) continue;
                res.add((class_1799)pair.method_15441());
            }
        }
        return res;
    }

    public static List<class_1799> getAllSoulStoringItems(class_1263 inv) {
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        if (inv != null) {
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 s = inv.method_5438(i);
                if (!SoulUtil.canStoreSoul(s)) continue;
                res.add(s);
            }
        }
        return res;
    }

    private static boolean tickSoulRegen(class_1799 stack, class_1937 world, float ambientMana, float regenSpeed, class_3222 player) {
        boolean changed = false;
        ISoulStoringItem item = (ISoulStoringItem)stack.method_7909();
        SoulStoringItemData data = ISoulStoringItem.getData(world, stack);
        float max = item.getCapacity(world, stack);
        float actualRegenSpeed = 5.0E-4f * regenSpeed * (player != null ? SoulUtil.getRegenSpeedMultiplier(player) : 1.0f) * item.getRechargeSpeedMultiplier(world, stack, (class_1309)player) * ambientMana;
        if ((actualRegenSpeed *= 1.0f - 0.5f * (data.mana / Math.max(max, 1.0f))) <= 0.0f) {
            return false;
        }
        float newMana = Toolbox.clampF(data.mana + actualRegenSpeed, 0.0f, max);
        if (newMana != data.mana) {
            if (Float.isNaN(newMana)) {
                Geomancy.logError("setting new mana as NaN!");
                newMana = 0.0f;
            }
            data.mana = newMana;
            changed = true;
        }
        if (changed) {
            SoulUtil.syncItemSoul(world, stack, player);
        }
        return changed;
    }

    public static boolean tryConsumeSoul(class_1309 entity, float amount, @Nullable SpellContext ctx) {
        if (!(entity instanceof class_3222)) {
            return true;
        }
        class_3222 player = (class_3222)entity;
        if (SoulUtil.getSoul((class_1657)player) < amount) {
            return false;
        }
        List<class_1799> storers = SoulUtil.getAllSoulStoringItems((class_1657)player);
        SoulUtil.removeSoul(storers, amount, player.method_37908(), ctx);
        SoulUtil.recalculateSoul((class_1657)player, false);
        return true;
    }

    public static boolean tryConsumeSoul(AutocasterBlockEntity casterBlock, float amount, @Nullable SpellContext ctx) {
        if (SoulUtil.getSoul(casterBlock.method_10997(), (class_1263)casterBlock) < amount) {
            return false;
        }
        List<class_1799> storers = SoulUtil.getAllSoulStoringItems((class_1263)casterBlock);
        SoulUtil.removeSoul(storers, amount, casterBlock.method_10997(), ctx);
        class_1309 class_13092 = ctx.caster;
        if (class_13092 instanceof class_3222) {
            class_3222 spe = (class_3222)class_13092;
            for (class_1799 storer : storers) {
                SoulUtil.syncItemSoul(casterBlock.method_10997(), storer, spe);
            }
        }
        return true;
    }

    private static float removeSoul(List<class_1799> storers, float amount, class_1937 world, @Nullable SpellContext ctx) {
        HashMap storerPriorityMap = new HashMap();
        for (class_1799 storer : storers) {
            class_3545 pair = new class_3545((Object)storer, (Object)((ISoulStoringItem)storer.method_7909()));
            if (!((ISoulStoringItem)pair.method_15441()).canRemoveSoulFrom(world, storer, ctx)) continue;
            int priority = ((ISoulStoringItem)pair.method_15441()).depletionPriority(storer);
            if (!storerPriorityMap.containsKey(priority)) {
                storerPriorityMap.put(priority, new ArrayList());
            }
            ((List)storerPriorityMap.get(priority)).add(pair);
        }
        ArrayList keys = new ArrayList(storerPriorityMap.keySet());
        keys.sort(Comparator.comparingInt(o -> o));
        ArrayList<class_1799> stacksToSync = new ArrayList<class_1799>();
        float left = amount;
        for (int i = 0; i < keys.size() && !(left <= 0.0f); ++i) {
            List prioStorers = (List)storerPriorityMap.get(keys.get(i));
            boolean changed = true;
            while (left > 0.0f && changed) {
                changed = false;
                int stacksWithMana = 0;
                for (class_3545 pair : prioStorers) {
                    if (!(((ISoulStoringItem)pair.method_15441()).getMana(world, (class_1799)pair.method_15442()) > 0.0f)) continue;
                    ++stacksWithMana;
                }
                float amountPerStack = left / (float)stacksWithMana;
                for (class_3545 pair : prioStorers) {
                    float mana = ((ISoulStoringItem)pair.method_15441()).getMana(world, (class_1799)pair.method_15442());
                    if (mana <= 0.0f) continue;
                    float taken = Math.min(mana, amountPerStack);
                    left -= taken;
                    ((ISoulStoringItem)pair.method_15441()).removeSoul(world, (class_1799)pair.method_15442(), taken, ctx);
                    if (mana - taken <= 0.0f) {
                        ((ISoulStoringItem)pair.method_15441()).onDepleted((class_1799)pair.method_15442());
                    }
                    changed = true;
                    if (stacksToSync.contains(pair.method_15442())) continue;
                    stacksToSync.add((class_1799)pair.method_15442());
                }
            }
        }
        for (class_1799 s : stacksToSync) {
            SoulUtil.syncItemSoul(world, s);
        }
        return left;
    }

    private static float addSoul(List<class_1799> storers, float amount, class_1937 world, @Nullable SpellContext ctx) {
        HashMap storerPriorityMap = new HashMap();
        for (class_1799 storer : storers) {
            class_3545 pair = new class_3545((Object)storer, (Object)((ISoulStoringItem)storer.method_7909()));
            if (!((ISoulStoringItem)pair.method_15441()).canAddSoulTo(world, storer, ctx)) continue;
            int priority = ((ISoulStoringItem)pair.method_15441()).depletionPriority(storer);
            if (!storerPriorityMap.containsKey(priority)) {
                storerPriorityMap.put(priority, new ArrayList());
            }
            ((List)storerPriorityMap.get(priority)).add(pair);
        }
        ArrayList keys = new ArrayList(storerPriorityMap.keySet());
        keys.sort(Comparator.comparingInt(o -> o));
        ArrayList<class_1799> stacksToSync = new ArrayList<class_1799>();
        float left = amount;
        for (int i = 0; i < keys.size() && !(left <= 0.0f); ++i) {
            List prioStorers = (List)storerPriorityMap.get(keys.get(i));
            boolean changed = true;
            while (left > 0.0f && changed) {
                changed = false;
                int stacksWithMana = 0;
                for (class_3545 pair : prioStorers) {
                    if (!(((ISoulStoringItem)pair.method_15441()).getMana(world, (class_1799)pair.method_15442()) > 0.0f)) continue;
                    ++stacksWithMana;
                }
                float amountPerStack = left / (float)stacksWithMana;
                for (class_3545 pair : prioStorers) {
                    float maxMana;
                    float mana = ((ISoulStoringItem)pair.method_15441()).getMana(world, (class_1799)pair.method_15442());
                    if (mana >= (maxMana = ((ISoulStoringItem)pair.method_15441()).getCapacity(world, (class_1799)pair.method_15442()))) continue;
                    float taken = Math.min(maxMana - mana, amountPerStack);
                    left -= taken;
                    ((ISoulStoringItem)pair.method_15441()).addSoul(world, (class_1799)pair.method_15442(), taken, ctx);
                    if (mana + taken >= maxMana) {
                        ((ISoulStoringItem)pair.method_15441()).onToppedUp((class_1799)pair.method_15442());
                    }
                    changed = true;
                    if (stacksToSync.contains(pair.method_15442())) continue;
                    stacksToSync.add((class_1799)pair.method_15442());
                }
            }
        }
        for (class_1799 s : stacksToSync) {
            SoulUtil.syncItemSoul(world, s);
        }
        return left;
    }

    public static float getMaxSoul(class_1937 world, AutocasterBlockEntity casterBlock) {
        float res = 0.0f;
        List<class_1799> storers = SoulUtil.getAllSoulStoringItems((class_1263)casterBlock);
        for (class_1799 storer : storers) {
            res += ((ISoulStoringItem)storer.method_7909()).getCapacity(world, storer);
        }
        return res;
    }

    public static boolean tickStorage(class_1937 world, class_1263 inv, class_2338 pos) {
        boolean res = false;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            res = SoulUtil.tickStack(world, stack, pos, null) || res;
        }
        return res;
    }

    private static boolean tickStack(class_1937 world, class_1799 stack, class_2338 pos, @Nullable class_3222 player) {
        if (!SoulUtil.canStoreSoul(stack)) {
            return false;
        }
        return SoulUtil.tickSoulRegen(stack, world, SoulUtil.getAmbientSoulsPerBlock(world, pos), 1.0f, player);
    }

    public static void syncItemSoul(class_3222 player) {
        List<class_1799> items = SoulUtil.getAllSoulStoringItems((class_1657)player);
        for (class_1799 stack : items) {
            SoulUtil.syncItemSoul(player.method_37908(), stack, player);
        }
    }

    public static void addSoulToPlayer(class_3222 player, float amount) {
        List<class_1799> items = SoulUtil.getAllSoulStoringItems((class_1657)player);
        if (SoulUtil.addSoul(items, amount, player.method_37908(), null) != amount) {
            SoulUtil.queueRecalculateSoul((class_1657)player);
        }
    }
}

