/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.oxytocina.geomancy.Geomancy;

public class Toolbox {
    public static Random random = new Random();

    public static class_243 RandomItemDropVelocity(float speed) {
        float angle = random.nextFloat() * 2.0f * (float)Math.PI;
        return new class_243(1.0, 0.5, 0.0).method_1024(angle).method_1021((double)speed);
    }

    public static class_1542 spawnItemStackAsEntity(class_1937 world, class_243 pos, class_1799 itemStack) {
        return Toolbox.spawnItemStackAsEntity(world, pos, itemStack, new class_243(0.0, 0.0, 0.0));
    }

    public static class_1542 spawnItemStackAsEntity(class_1937 world, class_243 pos, class_1799 itemStack, class_243 velocity) {
        return Toolbox.spawnItemStackAsEntity(world, pos, itemStack, velocity, true, null);
    }

    public static class_1542 spawnItemStackAsEntity(class_1937 world, class_243 pos, class_1799 itemStack, class_243 velocity, boolean neverDespawn, @Nullable class_1297 owner) {
        class_1799 resultStack = itemStack.method_7972();
        class_1542 itemEntity = new class_1542(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), resultStack);
        itemEntity.method_18799(velocity);
        itemEntity.method_6982(20);
        if (neverDespawn) {
            itemEntity.method_35190();
        }
        if (owner != null) {
            itemEntity.method_48349(owner.method_5667());
        }
        world.method_8649((class_1297)itemEntity);
        return itemEntity;
    }

    public static int selectWeightedRandomIndex(int[] weights) {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (int i = 0; i < weights.length; ++i) {
            m.put(i, weights[i]);
        }
        return Toolbox.selectWeightedRandomIndex(m, -1);
    }

    public static <T> T selectWeightedRandomIndex(Map<T, Integer> weights, T def) {
        if (weights.isEmpty()) {
            return def;
        }
        int weightsum = weights.values().stream().mapToInt(a -> a).sum();
        int weightpick = random.nextInt(weightsum);
        for (T key : weights.keySet()) {
            if ((weightpick -= weights.get(key).intValue()) > 0) continue;
            return key;
        }
        return def;
    }

    public static class_2960 locate(String string) {
        return Geomancy.locate(string);
    }

    public static int colorFromRGB(Vector3f colVec) {
        return Toolbox.colorFromRGB(colVec.x, colVec.y, colVec.z);
    }

    public static int colorFromRGB(float r, float g, float b) {
        return Toolbox.colorFromRGBA(r, g, b, 1.0f);
    }

    public static int colorFromRGBA(float r, float g, float b, float a) {
        int red = (int)(r * 255.0f) & 0xFF;
        int green = (int)(g * 255.0f) & 0xFF;
        int blue = (int)(b * 255.0f) & 0xFF;
        int alpha = (int)(a * 255.0f) & 0xFF;
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int colorFromHSV(float hue, float saturation, float value) {
        hue = Toolbox.clampF(hue, 0.0f, 1.0f);
        saturation = Toolbox.clampF(saturation, 0.0f, 1.0f);
        value = Toolbox.clampF(value, 0.0f, 1.0f);
        int h = (int)(hue * 6.0f);
        float f = hue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        switch (h) {
            case 0: {
                return Toolbox.colorFromRGB(value, t, p);
            }
            case 1: {
                return Toolbox.colorFromRGB(q, value, p);
            }
            case 2: {
                return Toolbox.colorFromRGB(p, value, t);
            }
            case 3: {
                return Toolbox.colorFromRGB(p, q, value);
            }
            case 4: {
                return Toolbox.colorFromRGB(t, p, value);
            }
            case 5: {
                return Toolbox.colorFromRGB(value, p, q);
            }
        }
        throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
    }

    public static boolean itemStacksAreEqual(class_1799 a, class_1799 b) {
        if (a.method_7909() != b.method_7909()) {
            return false;
        }
        if (a.method_7985() != b.method_7985()) {
            return false;
        }
        return !a.method_7985() || a.method_7969().equals((Object)b.method_7969());
    }

    @NotNull
    public static Vector3f colorIntToVec(int color) {
        Color colorObj = new Color(color);
        float[] argb = new float[4];
        colorObj.getColorComponents(argb);
        return new Vector3f(argb[0], argb[1], argb[2]);
    }

    public static int clampI(int v, int m, int m2) {
        return Math.min(Math.max(v, m), m2);
    }

    public static float clampF(float v, float m, float m2) {
        return Math.min(Math.max(v, m), m2);
    }

    public static float Lerp(float value, float target, float t) {
        return value * (1.0f - t) + target * t;
    }

    public static double LerpD(double value, double target, double t) {
        return value * (1.0 - t) + target * t;
    }

    public static int LerpColor(int col1, int col2, float t) {
        Vector3f vec1 = Toolbox.colorIntToVec(col1);
        Vector3f vec2 = Toolbox.colorIntToVec(col2);
        return Toolbox.colorFromRGB(Toolbox.lerpVector(vec1, vec2, t));
    }

    public static Vector3f lerpVector(Vector3f vec1, Vector3f vec2, float t) {
        return new Vector3f(Toolbox.Lerp(vec1.x, vec2.x, t), Toolbox.Lerp(vec1.y, vec2.y, t), Toolbox.Lerp(vec1.z, vec2.z, t));
    }

    public static double log(double base, double val) {
        return Math.log(val) / Math.log(base);
    }

    public static <T> T ifNotNullThenElse(T val, T def) {
        if (val == null) {
            return def;
        }
        return val;
    }

    public static int sign(float f) {
        return f > 0.0f ? 1 : (f < 0.0f ? -1 : 0);
    }

    public static int signD(double f) {
        return f > 0.0 ? 1 : (f < 0.0 ? -1 : 0);
    }

    public static GradientBuilder gradient() {
        return new GradientBuilder();
    }

    @Environment(value=EnvType.CLIENT)
    public static void playUISound(class_3414 event) {
        if (class_310.method_1551() == null) {
            return;
        }
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)event, (float)1.0f));
    }

    public static <T> List<T> reverseList(List<T> list) {
        ArrayList<T> res = new ArrayList<T>();
        for (int i = list.size() - 1; i >= 0; --i) {
            res.add(list.get(i));
        }
        return res;
    }

    public static float randomPitch() {
        return 0.8f + random.nextFloat() * 0.4f;
    }

    public static String formatNumber(float f) {
        int decimals = 0;
        if (f < 10.0f) {
            decimals = 2;
        } else if (f < 100.0f) {
            decimals = 1;
        }
        String suffix = "";
        if (f >= 1.0E7f) {
            f /= 1000000.0f;
            suffix = "M";
        } else if (f >= 10000.0f) {
            f /= 1000.0f;
            suffix = "K";
        }
        int factor = Math.round((float)Math.pow(10.0, decimals));
        f = (float)((int)(f * (float)factor)) / (float)factor;
        String s = decimals == 0 ? Integer.toString(Math.round(f)) : Float.toString(f);
        return s + suffix;
    }

    public static float randomBetween(float min, float max) {
        return min + random.nextFloat() * (max - min);
    }

    public static float factorial(float in) {
        float res = 1.0f;
        while (in >= 1.0f) {
            float f = in;
            in = f - 1.0f;
            res *= f;
        }
        return res;
    }

    public static boolean roughlyEqual(float a, float b, float maxDifference) {
        return Math.abs(b - a) < maxDifference;
    }

    public static <T> T tryElse(Supplier<T> supplier, T ifFailed) {
        try {
            return supplier.get();
        }
        catch (Exception ignored) {
            return ifFailed;
        }
    }

    public static void playSound(class_3414 event, class_1937 world, class_2338 pos, class_3419 cat, float volume) {
        Toolbox.playSound(event, world, pos, cat, volume, Toolbox.randomPitch());
    }

    public static void playSound(class_3414 event, class_1937 world, class_2338 pos, class_3419 cat, float volume, float pitch) {
        if (event == null) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        world.method_8396(null, pos, event, cat, volume, pitch);
    }

    @Environment(value=EnvType.CLIENT)
    public static void playSoundClient(class_3414 event, class_1937 world, class_2338 pos, class_3419 cat, float volume, float pitch) {
        if (event == null || volume <= 0.0f) {
            return;
        }
        if (world instanceof class_638) {
            class_638 cw = (class_638)world;
            cw.method_8396((class_1657)class_310.method_1551().field_1724, pos, event, cat, volume, pitch);
        }
    }

    public static Vector2f rotateVector(Vector2f v1, double a) {
        return new Vector2f((float)(Math.cos(a) * (double)v1.x - Math.sin(a) * (double)v1.y), (float)(Math.sin(a) * (double)v1.x - Math.cos(a) * (double)v1.y));
    }

    public static int floor(double d) {
        return Math.round((float)Math.floor(d));
    }

    public static class_2338 posToBlockPos(class_243 v) {
        return new class_2338(Toolbox.floor(v.field_1352), Toolbox.floor(v.field_1351), Toolbox.floor(v.field_1350));
    }

    public static Random seededRandom(int seed) {
        return new Random(seed);
    }

    public static int roundWithChance(float v) {
        return Math.round(v - v % 1.0f + (float)(random.nextFloat() < v % 1.0f ? 1 : 0));
    }

    public static String reverseString(String s) {
        return new StringBuilder(s).reverse().toString();
    }

    public static <T> T safeCast(Object obj, T def) {
        try {
            return (T)obj;
        }
        catch (Exception exception) {
            return def;
        }
    }

    public static class_52 getLootTable(class_3218 sw, class_2960 identifier) {
        return sw.method_8503().method_3857().getLootTable(identifier);
    }

    public static class GradientBuilder {
        public ArrayList<KeyFrame> keyFrames = new ArrayList();

        public GradientBuilder add(float p, int col) {
            this.keyFrames.add(new KeyFrame(p, col));
            this.keyFrames.sort((o1, o2) -> Toolbox.sign(o1.position - o2.position));
            return this;
        }

        public int get(float position) {
            if (this.keyFrames.isEmpty()) {
                return 0;
            }
            for (int i = 0; i < this.keyFrames.size() - 1; ++i) {
                if (!(this.keyFrames.get((int)i).position > position)) continue;
                KeyFrame frame1 = this.keyFrames.get(i - 1);
                KeyFrame frame2 = this.keyFrames.get(i);
                return Toolbox.LerpColor(frame1.color, frame2.color, (position - frame1.position) / (frame2.position - frame1.position));
            }
            return this.keyFrames.get((int)(this.keyFrames.size() - 1)).color;
        }

        public static class KeyFrame {
            public float position;
            public int color;

            public KeyFrame(float p, int col) {
                this.position = p;
                this.color = col;
            }
        }
    }
}

