/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.blocks.blockEntities.ModBlockEntities;
import org.oxytocina.geomancy.blocks.fluids.ModFluids;
import org.oxytocina.geomancy.client.screen.ModScreenHandlers;
import org.oxytocina.geomancy.commands.ModCommands;
import org.oxytocina.geomancy.compat.GeomancyIntegrationPacks;
import org.oxytocina.geomancy.compat.trinkets.ModTrinketsCompat;
import org.oxytocina.geomancy.effects.ModStatusEffects;
import org.oxytocina.geomancy.enchantments.ModEnchantments;
import org.oxytocina.geomancy.entity.ModEntityAttributes;
import org.oxytocina.geomancy.entity.ModEntityTypes;
import org.oxytocina.geomancy.event.ServerStopHandler;
import org.oxytocina.geomancy.event.ServerTickHandler;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.items.SpellComponentStoringItem;
import org.oxytocina.geomancy.items.jewelry.IJewelryItem;
import org.oxytocina.geomancy.items.tools.SoulBoreItem;
import org.oxytocina.geomancy.loottables.ModLootFunctionTypes;
import org.oxytocina.geomancy.loottables.ModLootTables;
import org.oxytocina.geomancy.networking.ModMessages;
import org.oxytocina.geomancy.particles.ModParticleTypes;
import org.oxytocina.geomancy.progression.advancement.ModCriteria;
import org.oxytocina.geomancy.registries.ModCauldronBehaviors;
import org.oxytocina.geomancy.registries.ModDispenserBehaviors;
import org.oxytocina.geomancy.registries.ModRecipeTypes;
import org.oxytocina.geomancy.registries.ModWoodTypes;
import org.oxytocina.geomancy.sound.ModSoundEvents;
import org.oxytocina.geomancy.spells.SpellBlocks;
import org.oxytocina.geomancy.util.GeomancyConfig;
import org.oxytocina.geomancy.world.dimension.ModDimensions;
import org.oxytocina.geomancy.world.gen.ModWorldGeneration;
import org.oxytocina.geomancy.world.tree.ModFoliagePlacerTypes;
import org.oxytocina.geomancy.world.tree.ModTrunkPlacerTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Geomancy
implements ModInitializer {
    public static final String MOD_ID = "geomancy";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"geomancy");
    public static boolean startedInitialization = false;
    public static boolean initializing = false;
    public static boolean finishedInitialization = false;
    public static GeomancyConfig CONFIG = null;
    public static long tick = 0L;

    public static void initializeForeign(String from) {
        if (finishedInitialization) {
            return;
        }
        if (initializing) {
            Geomancy.logWarning("waiting for finished initialization from foreign entrypoint " + from + "!");
            int waited = 0;
            while (initializing) {
                try {
                    Thread.sleep(1L);
                    if (++waited % 10000 != 0) continue;
                    Geomancy.logWarning("waited for finished initialization from foreign entrypoint " + from + " for " + waited + "ms!");
                }
                catch (Exception ignored) {
                    Geomancy.logError("error while waiting from foreign entrypoint " + from + "!");
                    return;
                }
            }
            return;
        }
        Geomancy.logWarning("initializing from foreign entrypoint " + from + "!");
        Geomancy.initialize();
    }

    public void onInitialize() {
        Geomancy.initialize();
    }

    public static synchronized void initialize() {
        if (startedInitialization) {
            return;
        }
        startedInitialization = true;
        initializing = true;
        LOGGER.info("Loading Geomancy");
        long startTime = System.nanoTime();
        try {
            CONFIG = GeomancyConfig.create();
            ModItems.register();
            IJewelryItem.populateItemGroup();
            SpellComponentStoringItem.populateItemGroup();
            ModBlocks.register();
            ModWoodTypes.registerStrippables();
            ModFluids.register();
            ModBlockEntities.register();
            ModScreenHandlers.register();
            SoulBoreItem.register();
            SpellBlocks.register();
            ModRecipeTypes.registerSerializer();
            ModSoundEvents.register();
            ModLootFunctionTypes.register();
            ModLootTables.register();
            ModCriteria.register();
            ModEnchantments.register();
            ModParticleTypes.register();
            ModMessages.registerC2SPackets();
            ModCommands.register();
            ModEntityTypes.register();
            ModEntityAttributes.register();
            GeomancyIntegrationPacks.register();
            ModStatusEffects.register();
            ModWorldGeneration.generateModWorldGen();
            ModTrunkPlacerTypes.register();
            ModFoliagePlacerTypes.register();
            ModDimensions.register();
            ModTrinketsCompat.register();
            ModDispenserBehaviors.register();
            ModCauldronBehaviors.register();
            ServerTickEvents.START_SERVER_TICK.register((Object)new ServerTickHandler());
            ServerLifecycleEvents.SERVER_STOPPED.register((Object)new ServerStopHandler());
        }
        catch (Throwable t) {
            RuntimeException exception = new RuntimeException(String.format("Geomancy Initialization failed!", t.fillInStackTrace(), Arrays.toString(t.getStackTrace())));
            Log.debug((LogCategory)LogCategory.ENTRYPOINT, (String)"Geomancy");
            throw t;
        }
        long msTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        LOGGER.info("Finished Loading Geomancy. ms:" + msTaken);
        finishedInitialization = true;
        initializing = false;
    }

    public static void logInfo(String message, class_1937 world) {
        LOGGER.info("[Geomancy " + (world != null && world.field_9236 ? "Client" : "Server") + "] " + message);
    }

    public static void logWarning(String message, class_1937 world) {
        LOGGER.warn("[Geomancy " + (world != null && world.field_9236 ? "Client" : "Server") + "] " + message);
    }

    public static void logError(String message, class_1937 world) {
        LOGGER.error("[Geomancy " + (world != null && world.field_9236 ? "Client" : "Server") + "] " + message);
    }

    public static void logInfo(String message) {
        LOGGER.info("[Geomancy] " + message);
    }

    public static void logWarning(String message) {
        LOGGER.warn("[Geomancy] " + message);
    }

    public static void logError(String message) {
        LOGGER.error("[Geomancy] " + message);
    }

    public static class_2960 locate(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static boolean Client() {
        return FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER;
    }

    public static boolean Server() {
        return !Geomancy.Client();
    }
}

