/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.blocks.blockEntities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1716;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_5561;
import org.oxytocina.geomancy.blocks.ISpellSelectorBlock;
import org.oxytocina.geomancy.blocks.blockEntities.AutocasterBlock;
import org.oxytocina.geomancy.blocks.blockEntities.ModBlockEntities;
import org.oxytocina.geomancy.items.SpellStoringItem;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.util.SoulUtil;

public class AutocasterBlockEntity
extends class_2621
implements ISpellSelectorBlock {
    public static final int INVENTORY_SIZE = 9;
    private class_2371<class_1799> inventory;
    private final class_5561 stateManager;
    private List<class_1657> inspectingPlayers = new ArrayList<class_1657>();

    protected AutocasterBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.inventory = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        this.stateManager = new class_5561(){

            protected void method_31681(class_1937 world, class_2338 pos, class_2680 state) {
                AutocasterBlockEntity.this.syncManaContainers();
            }

            protected void method_31683(class_1937 world, class_2338 pos, class_2680 state) {
            }

            protected void method_31682(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
                AutocasterBlockEntity.this.onViewerCountUpdate(world, pos, state, oldViewerCount, newViewerCount);
            }

            protected boolean method_31679(class_1657 player) {
                if (!(player.field_7512 instanceof class_1707)) {
                    return false;
                }
                class_1263 inventory = ((class_1707)player.field_7512).method_7629();
                return inventory == AutocasterBlockEntity.this;
            }
        };
    }

    public AutocasterBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntities.AUTOCASTER_BLOCK_ENTITY, pos, state);
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865) {
            this.stateManager.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
            this.inspectingPlayers.add(player);
        }
        if (!this.field_11865 && !player.method_7325()) {
            this.stateManager.method_31684(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 player) {
        this.inspectingPlayers.remove(player);
        if (!this.field_11865 && !player.method_7325()) {
            this.stateManager.method_31685(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public static int getPlayersLookingInChestCount(class_1922 world, class_2338 pos) {
        class_2586 blockEntity;
        class_2680 blockState = world.method_8320(pos);
        if (blockState.method_31709() && (blockEntity = world.method_8321(pos)) instanceof AutocasterBlockEntity) {
            return ((AutocasterBlockEntity)blockEntity).stateManager.method_31678();
        }
        return 0;
    }

    public void onScheduledTick() {
        if (!this.field_11865) {
            this.stateManager.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    protected void onViewerCountUpdate(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
        class_2248 block = state.method_26204();
        world.method_8427(pos, block, 1, newViewerCount);
    }

    boolean observed() {
        return AutocasterBlockEntity.getPlayersLookingInChestCount((class_1922)this.method_10997(), this.method_11016()) > 0;
    }

    public int method_5439() {
        return 9;
    }

    public void cast() {
        class_1799 caster = this.getFirstCasterItem((class_2586)this);
        if (caster == null) {
            return;
        }
        ArrayList spells = this.getCastableSpellItems((class_2586)this, caster);
        if (spells.isEmpty()) {
            return;
        }
        class_1799 spell = (class_1799)spells.get(this.getSelectedSpellIndex((class_2586)this, caster));
        SpellGrid grid = SpellStoringItem.readGrid(spell);
        if (grid == null) {
            return;
        }
        grid.run(caster, spell, null, this, null, SpellBlockArgs.empty(), SpellContext.SoundBehavior.Reduced, false);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (SoulUtil.tickStorage(world, (class_1263)this, pos) && this.observed()) {
            this.syncManaContainers();
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"geomancy.autocaster");
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(nbt)) {
            class_1262.method_5429((class_2487)nbt, this.inventory);
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (!this.method_11286(nbt)) {
            class_1262.method_5426((class_2487)nbt, this.inventory);
        }
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.inventory = list;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new class_1716(syncId, playerInventory, (class_1263)this);
    }

    public int getSlotWithStack(class_1799 casterItem) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 contender = this.method_5438(i);
            if (!contender.equals(casterItem)) continue;
            return i;
        }
        return -1;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)AutocasterBlock.FACING);
    }

    @Override
    public class_1799 getStack(class_2586 entity, int index) {
        return this.method_5438(index);
    }

    @Override
    public int getStorageSize(class_2586 entity) {
        return this.method_5439();
    }

    @Override
    public void markDirty(class_2586 entity) {
        this.method_5431();
    }

    public void syncManaContainers() {
        for (class_1657 player : this.inspectingPlayers) {
            for (int i = 0; i < this.method_5439(); ++i) {
                SoulUtil.syncItemSoul(this.method_10997(), this.method_5438(i), (class_3222)player);
            }
        }
    }

    public class_1799 tryCollect(class_1799 s) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 onto = this.method_5438(i);
            if (onto.method_7960()) {
                this.method_5447(i, s.method_51164());
                return s;
            }
            if (!onto.method_7946() || !class_1799.method_31577((class_1799)s, (class_1799)onto)) continue;
            int max = onto.method_7914();
            int taken = Math.min(s.method_7947(), max - onto.method_7947());
            onto.method_7933(taken);
            s.method_7934(taken);
            if (!s.method_7960()) continue;
            return s;
        }
        return s;
    }

    public class_243 getMuzzlePos() {
        return this.field_11867.method_46558().method_1019(new class_243(this.getDirection().method_23955().mul(0.7f)));
    }
}

