/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.blocks.blockEntities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.blocks.blockEntities.ModBlockEntities;
import org.oxytocina.geomancy.spells.SpellBlocks;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.util.EntityUtil;
import org.oxytocina.geomancy.util.Toolbox;

public class RestrictorBlockEntity
extends class_2586 {
    public static final HashMap<UUID, class_3545<RestrictorBlockEntity, Integer>> PLAYER_INFLUENCES = new HashMap();
    public static final List<RestrictorBlockEntity> RESTRICTORS = new ArrayList<RestrictorBlockEntity>();
    private static List<PotentiallyForbiddenAction> PFAS = new ArrayList<PotentiallyForbiddenAction>();
    public static float RANGE = 100.0f;
    public static int DURATION = 20;
    private boolean initized = false;

    public static void registerPFA(PotentiallyForbiddenAction pfa) {
        PFAS.add(pfa);
    }

    public static SpellContext.Restrictions getRestrictionsAt(class_243 pos, class_1937 world) {
        double minDist = 1000000.0;
        RestrictorBlockEntity be = null;
        for (RestrictorBlockEntity r : RESTRICTORS) {
            double dist = r.method_11016().method_46558().method_1020(pos).method_1033();
            if (!(dist < minDist) || !((minDist = dist) < (double)RANGE)) continue;
            be = r;
        }
        if (be != null) {
            return be.getRestrictions();
        }
        return RestrictorBlockEntity.getDefaultRestrictionsAt(pos, world);
    }

    public static SpellContext.Restrictions getDefaultRestrictionsAt(class_243 pos, class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            class_2338 blockPos = Toolbox.posToBlockPos(pos);
            return sw.method_22340(blockPos) ? SpellContext.Restrictions.NONE : SpellContext.Restrictions.UNLOADED;
        }
        return SpellContext.Restrictions.UNLOADED;
    }

    public static void clear() {
        PLAYER_INFLUENCES.clear();
        RESTRICTORS.clear();
    }

    public static void tick() {
        ArrayList<Object> toRemove = new ArrayList<Object>();
        for (UUID uUID : PLAYER_INFLUENCES.keySet()) {
            class_3545<RestrictorBlockEntity, Integer> class_35452 = PLAYER_INFLUENCES.get(uUID);
            if (class_35452 == null) {
                toRemove.add(uUID);
                continue;
            }
            RestrictorBlockEntity be = (RestrictorBlockEntity)((Object)class_35452.method_15442());
            if (be == null) {
                toRemove.add(uUID);
                continue;
            }
            int ticksLeft = (Integer)class_35452.method_15441();
            if (--ticksLeft <= 0) {
                toRemove.add(uUID);
                continue;
            }
            PLAYER_INFLUENCES.put(uUID, (class_3545<RestrictorBlockEntity, Integer>)new class_3545((Object)be, (Object)ticksLeft));
        }
        for (UUID uUID : toRemove) {
            PLAYER_INFLUENCES.remove(uUID);
        }
        ArrayList<PotentiallyForbiddenAction> newPFAs = new ArrayList<PotentiallyForbiddenAction>();
        for (PotentiallyForbiddenAction potentiallyForbiddenAction : PFAS) {
            class_1309 caster = potentiallyForbiddenAction.ctx.caster;
            if (caster == null || !(caster instanceof class_3222)) continue;
            class_3222 spe = (class_3222)caster;
            if (potentiallyForbiddenAction.offends(RestrictorBlockEntity.getRestrictionsFor(spe))) {
                potentiallyForbiddenAction.undo();
                continue;
            }
            if (Geomancy.tick - potentiallyForbiddenAction.tick > 20L) continue;
            newPFAs.add(potentiallyForbiddenAction);
        }
        PFAS = newPFAs;
        if (Geomancy.tick % 20L == 0L) {
            toRemove.clear();
            for (RestrictorBlockEntity restrictorBlockEntity : RESTRICTORS) {
                if (!restrictorBlockEntity.method_11015()) continue;
                toRemove.add((Object)restrictorBlockEntity);
            }
            for (Object e : toRemove) {
                RESTRICTORS.remove(e);
            }
        }
    }

    public static SpellContext.Restrictions getRestrictionsFor(class_3222 spe) {
        if (!PLAYER_INFLUENCES.containsKey(spe.method_5667())) {
            return SpellContext.Restrictions.NONE;
        }
        return ((RestrictorBlockEntity)((Object)PLAYER_INFLUENCES.get(spe.method_5667()).method_15442())).getRestrictions();
    }

    public RestrictorBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.RESTRICTOR_BLOCK_ENTITY, pos, state);
    }

    public SpellContext.Restrictions getRestrictions() {
        return SpellContext.Restrictions.DUNGEON;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void method_5431() {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        this.initialize();
        if (world == null) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)world;
        for (class_3222 spe : sw.method_18456()) {
            RestrictorBlockEntity prevBE;
            if (!EntityUtil.isInRange((class_1309)spe, sw, this.method_11016().method_46558(), RANGE).booleanValue()) continue;
            UUID uuid = spe.method_5667();
            RestrictorBlockEntity restrictorBlockEntity = prevBE = PLAYER_INFLUENCES.containsKey(uuid) ? (RestrictorBlockEntity)((Object)PLAYER_INFLUENCES.get(uuid).method_15442()) : null;
            if (prevBE != null && EntityUtil.distanceTo((class_1297)spe, prevBE.method_11016().method_46558()) < EntityUtil.distanceTo((class_1297)spe, this.method_11016().method_46558())) continue;
            PLAYER_INFLUENCES.put(uuid, (class_3545<RestrictorBlockEntity, Integer>)new class_3545((Object)this, (Object)DURATION));
        }
    }

    public void initialize() {
        if (this.initized) {
            return;
        }
        this.initized = true;
        RESTRICTORS.add(this);
    }

    public static class PotentiallyForbiddenAction {
        public Type type = Type.Teleport;
        public class_243 from;
        public class_243 to;
        public class_2960 fromID;
        public class_2960 toID;
        public long tick = Geomancy.tick;
        public SpellContext ctx;

        private PotentiallyForbiddenAction(SpellContext ctx) {
            this.ctx = ctx;
        }

        public static PotentiallyForbiddenAction createTeleport(SpellContext ctx, class_243 from, class_243 to) {
            PotentiallyForbiddenAction res = new PotentiallyForbiddenAction(ctx);
            res.type = Type.Teleport;
            res.from = from;
            res.to = to;
            return res;
        }

        public static PotentiallyForbiddenAction createDimhop(SpellContext ctx, class_2960 from, class_2960 to) {
            PotentiallyForbiddenAction res = new PotentiallyForbiddenAction(ctx);
            res.type = Type.Dimhop;
            res.fromID = from;
            res.toID = to;
            return res;
        }

        public void undo() {
            switch (this.type.ordinal()) {
                case 0: {
                    if (this.ctx.caster == null || this.ctx.caster.method_31481()) break;
                    this.ctx.caster.method_20620(this.from.field_1352, this.from.field_1351, this.from.field_1350);
                    SpellBlocks.punishDisallowedAction(this.ctx);
                    break;
                }
                case 1: {
                    class_3218 destination;
                    if (this.ctx.caster == null || this.ctx.caster.method_31481() || (destination = (class_3218)this.ctx.getWorld()) == null) break;
                    this.from = this.ctx.getOriginPos();
                    class_1309 ent = this.ctx.caster;
                    ent.method_48105(destination, this.from.field_1352, this.from.field_1351, this.from.field_1350, null, ent.method_36454(), ent.method_36455());
                    SpellBlocks.punishDisallowedAction(this.ctx);
                    break;
                }
            }
        }

        public boolean offends(SpellContext.Restrictions restrictions) {
            switch (this.type.ordinal()) {
                case 0: 
                case 1: {
                    if (restrictions.allowsTeleports()) break;
                    return true;
                }
            }
            return false;
        }

        public static enum Type {
            Teleport,
            Dimhop;

        }
    }
}

