/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.blocks.blockEntities;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.blocks.MultiblockCrafter;
import org.oxytocina.geomancy.blocks.blockEntities.IHammerable;
import org.oxytocina.geomancy.blocks.blockEntities.IOwnable;
import org.oxytocina.geomancy.blocks.blockEntities.IPedestalListener;
import org.oxytocina.geomancy.blocks.blockEntities.ModBlockEntities;
import org.oxytocina.geomancy.blocks.blockEntities.PedestalBlockEntity;
import org.oxytocina.geomancy.client.screen.SoulForgeScreenHandler;
import org.oxytocina.geomancy.client.util.CamShakeUtil;
import org.oxytocina.geomancy.inventories.AutoCraftingInventory;
import org.oxytocina.geomancy.inventories.ImplementedInventory;
import org.oxytocina.geomancy.items.ISoulStoringItem;
import org.oxytocina.geomancy.items.tools.HammerItem;
import org.oxytocina.geomancy.networking.ModMessages;
import org.oxytocina.geomancy.recipe.NbtIngredient;
import org.oxytocina.geomancy.recipe.soulforge.ISoulForgeRecipe;
import org.oxytocina.geomancy.registries.ModRecipeTypes;
import org.oxytocina.geomancy.sound.ModSoundEvents;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.util.AdvancementHelper;
import org.oxytocina.geomancy.util.BlockHelper;
import org.oxytocina.geomancy.util.EntityUtil;
import org.oxytocina.geomancy.util.ParticleUtil;
import org.oxytocina.geomancy.util.Toolbox;

public class SoulForgeBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
IOwnable,
IPedestalListener,
IHammerable {
    private final class_2371<class_1799> ownInventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    public final List<PedestalBlockEntity> surroundingInventories = new ArrayList<PedestalBlockEntity>();
    public final List<PedestalBlockEntity> surroundingSoulInventories = new ArrayList<PedestalBlockEntity>();
    public final List<class_1799> surroundingIngredients = new ArrayList<class_1799>();
    private final List<class_1799> totalIngredients = new ArrayList<class_1799>();
    public final List<class_1799> consumedIngredients = new ArrayList<class_1799>();
    private class_1799 baseIngredient = class_1799.field_8037;
    private class_3913 propertyDelegate;
    public static final int BASE_SLOT = 0;
    public static final int PREVIEW_SLOT = 1;
    public static final int SLOT_COUNT = 2;
    public static final int INPUT_SLOT_COUNT = 1;
    public static final int PEDESTAL_RANGE = 5;
    public ISoulForgeRecipe previewingRecipe = null;
    public ISoulForgeRecipe activeRecipe = null;
    public class_1799 currentResult = class_1799.field_8037;
    public float progress;
    public float instability;
    public float availableSoul;
    private boolean initialized = false;
    private class_1657 owner = null;
    private class_2960 activeRecipeIdToLoad = null;
    private class_2960 previewRecipeIdToLoad = null;
    private static final AutoCraftingInventory AUTO_INVENTORY = new AutoCraftingInventory(2, 1);
    private class_1799 lastHammerStack = class_1799.field_8037;
    private class_1657 lastHammerer = null;

    public SoulForgeBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.SOULFORGE_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3919(3);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.ownInventory);
        if (this.isActive()) {
            nbt.method_10582("activeRecipe", this.activeRecipe.getIdentifier().toString());
        }
        if (this.previewingRecipe != null) {
            nbt.method_10582("previewRecipe", this.previewingRecipe.getIdentifier().toString());
        }
        nbt.method_10548("progress", this.progress);
        nbt.method_10548("instability", this.instability);
        nbt.method_10548("availableSoul", this.availableSoul);
        class_2499 consumedList = new class_2499();
        for (int i = 0; i < this.consumedIngredients.size(); ++i) {
            class_2487 stackNbt = new class_2487();
            this.consumedIngredients.get(i).method_7953(stackNbt);
            consumedList.add((Object)stackNbt);
        }
        nbt.method_10566("consumed", (class_2520)consumedList);
        class_2499 surroundingList = new class_2499();
        for (int i = 0; i < this.surroundingIngredients.size(); ++i) {
            class_2487 stackNbt = new class_2487();
            this.surroundingIngredients.get(i).method_7953(stackNbt);
            surroundingList.add((Object)stackNbt);
        }
        nbt.method_10566("surrounding", (class_2520)surroundingList);
    }

    public void method_11014(class_2487 nbt) {
        int i;
        super.method_11014(nbt);
        this.method_5448();
        class_1262.method_5429((class_2487)nbt, this.ownInventory);
        this.activeRecipeIdToLoad = null;
        this.previewRecipeIdToLoad = null;
        if (nbt.method_10545("activeRecipe")) {
            this.activeRecipeIdToLoad = class_2960.method_12829((String)nbt.method_10558("activeRecipe"));
        }
        if (nbt.method_10545("previewRecipe")) {
            this.previewRecipeIdToLoad = class_2960.method_12829((String)nbt.method_10558("previewRecipe"));
        }
        if (this.field_11863 != null) {
            if (this.activeRecipeIdToLoad != null) {
                this.activeRecipe = this.field_11863.method_8433().method_8130(this.activeRecipeIdToLoad).orElse(null);
            }
            if (this.previewRecipeIdToLoad != null) {
                this.previewingRecipe = this.field_11863.method_8433().method_8130(this.previewRecipeIdToLoad).orElse(null);
            }
        }
        this.progress = nbt.method_10583("progress");
        this.instability = nbt.method_10583("instability");
        this.availableSoul = nbt.method_10583("availableSoul");
        this.consumedIngredients.clear();
        if (nbt.method_10545("consumed")) {
            class_2499 consumedList = nbt.method_10554("consumed", 10);
            for (i = 0; i < consumedList.size(); ++i) {
                this.consumedIngredients.add(class_1799.method_7915((class_2487)consumedList.method_10602(i)));
            }
        }
        this.surroundingIngredients.clear();
        if (nbt.method_10545("surrounding")) {
            class_2499 surroundingList = nbt.method_10554("surrounding", 10);
            for (i = 0; i < surroundingList.size(); ++i) {
                this.surroundingIngredients.add(class_1799.method_7915((class_2487)surroundingList.method_10602(i)));
            }
        }
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return ModBlocks.SOUL_FORGE.method_9518();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SoulForgeScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public boolean isActive() {
        return this.activeRecipe != null;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.ownInventory;
    }

    public void refreshAvailableIngredients() {
        this.surroundingIngredients.clear();
        this.totalIngredients.clear();
        this.surroundingSoulInventories.clear();
        this.baseIngredient = this.method_5438(0);
        for (int i = 0; i < 1; ++i) {
            class_1799 ing = this.method_5438(i);
            this.totalIngredients.add(ing);
        }
        for (PedestalBlockEntity inv : this.surroundingInventories) {
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 ing = inv.method_5438(i);
                if (ing.method_7960()) continue;
                this.surroundingIngredients.add(ing);
                this.totalIngredients.add(ing);
            }
        }
        for (PedestalBlockEntity inv : this.surroundingInventories) {
            if (!(inv.method_5438(0).method_7909() instanceof ISoulStoringItem)) continue;
            this.surroundingSoulInventories.add(inv);
        }
        this.refreshPreviewRecipe();
    }

    public void refreshPreviewRecipe() {
        if (this.field_11863.field_9236) {
            return;
        }
        this.previewingRecipe = this.getRecipeFor(this.field_11863, this.totalIngredients);
        this.sendUpdatesToNearbyClients();
    }

    public void activate(SpellContext ctx) {
        if (!this.isActive() && this.previewingRecipe != null) {
            this.startCrafting();
        }
    }

    public float getAvailableSoul() {
        float res = 0.0f;
        for (PedestalBlockEntity inv : this.surroundingSoulInventories) {
            class_1792 class_17922;
            class_1799 stack = inv.method_5438(0);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof ISoulStoringItem)) continue;
            ISoulStoringItem storer = (ISoulStoringItem)class_17922;
            res += storer.getMana(this.field_11863, stack);
        }
        return res;
    }

    public void startCrafting() {
        this.activeRecipe = this.previewingRecipe;
        this.resetProgress();
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (!this.initialized) {
            this.initialize(world, pos, state);
        }
        if (world.field_9236) {
            return;
        }
        if (this.isActive()) {
            this.currentResult = this.activeRecipe.getPreviewOutput(this.inputInventory());
            this.instability += 0.0025000002f * this.activeRecipe.getInstability(this.inputInventory());
            float instabilityPowed = (float)Math.pow(this.instability, 5.0);
            if (Geomancy.tick % 4L == 0L && Toolbox.random.nextFloat() < instabilityPowed) {
                Toolbox.playSound(class_3417.field_15026, world, this.method_11016(), class_3419.field_15245, 0.4f + 0.6f * instabilityPowed, 1.0f + instabilityPowed);
                ParticleUtil.ParticleData.createInstability(world, this.method_11016().method_46558()).send();
                CamShakeUtil.cause(world, this.method_11016().method_46558(), 10.0f, 0.5f + 0.5f * instabilityPowed);
            }
            if (this.instability >= 1.0f) {
                CamShakeUtil.cause(world, this.method_11016().method_46558(), 20.0f, 2.0f, 2.0f, 0.5f);
                for (int i = 0; i < this.surroundingInventories.size(); ++i) {
                    PedestalBlockEntity pedestal = this.surroundingInventories.get(i);
                    class_1799 stack = pedestal.getItem();
                    if (stack.method_7960()) continue;
                    stack = stack.method_51164();
                    pedestal.method_5431();
                    float speed = 0.2f;
                    MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, pedestal.method_11016().method_46558().method_1031(0.0, (double)0.6f, 0.0), stack, stack.method_7947(), new class_243((double)Toolbox.randomBetween(-0.2f, 0.2f), (double)Toolbox.randomBetween(0.0f, 0.4f), (double)Toolbox.randomBetween(-0.2f, 0.2f)), false, (class_1297)this.getOwner());
                }
                this.activeRecipe = null;
                this.refreshAvailableIngredients();
                this.resetProgress();
                this.method_5431();
            }
            if (Geomancy.tick % 4L == 0L) {
                this.sendUpdatesToNearbyClients();
            }
            this.method_5431();
        } else {
            this.currentResult = this.previewingRecipe != null ? this.previewingRecipe.getPreviewOutput(this.inputInventory()) : class_1799.field_8037;
        }
        if (!class_1799.method_7973((class_1799)this.currentResult, (class_1799)this.method_5438(1))) {
            this.method_5447(1, this.currentResult);
        }
        if (Geomancy.tick % (long)(this.isActive() ? 4 : 20) == 0L) {
            this.updateAvailableSoul();
        }
    }

    private void finishCrafting() {
        this.spawnResult();
        this.activeRecipe = null;
        Toolbox.playSound(class_3417.field_15136, this.field_11863, this.method_11016(), class_3419.field_15254, 0.5f, Toolbox.randomPitch());
        CamShakeUtil.cause(this.field_11863, this.method_11016().method_46558(), 20.0f, 2.0f, 2.0f, 0.5f);
        this.refreshAvailableIngredients();
        this.resetProgress();
        this.method_5431();
    }

    private boolean hasCraftingFinished() {
        return this.progress >= 1.0f;
    }

    private void initialize(class_1937 world, class_2338 pos, class_2680 state) {
        this.initialized = true;
        if (this.activeRecipeIdToLoad != null) {
            this.activeRecipe = world.method_8433().method_8130(this.activeRecipeIdToLoad).orElse(null);
        }
        if (this.previewRecipeIdToLoad != null) {
            this.previewingRecipe = world.method_8433().method_8130(this.previewRecipeIdToLoad).orElse(null);
        }
        if (!world.field_9236) {
            this.register();
            this.registerInArea(world, pos, 5);
            this.refreshAvailableIngredients();
        }
    }

    private void resetProgress() {
        this.progress = 0.0f;
        this.instability = 0.0f;
        this.consumedIngredients.clear();
        this.sendUpdatesToNearbyClients();
    }

    private void spawnResult() {
        if (this.activeRecipe != null) {
            List<class_1799> results = this.getCraftingResult(this.activeRecipe, this.ownInventory, this.field_11863);
            for (class_1799 result : results) {
                int count = result.method_7947();
                if (this.field_11863.field_9236) continue;
                MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(this.field_11863, class_243.method_24953((class_2382)this.field_11867).method_1019(new class_243(0.0, 1.0, 0.0)), result, count, new class_243(0.0, 0.25, 0.0), false, null);
            }
            this.field_11863.method_8396(null, this.field_11867, ModSoundEvents.SMITHERY_FINISHED, class_3419.field_15254, 1.0f, 0.6f + this.field_11863.method_8409().method_43057() * 0.2f);
        }
    }

    private ISoulForgeRecipe getRecipe() {
        return this.getRecipeFor(this.field_11863, (List<class_1799>)this.getItems());
    }

    public ISoulForgeRecipe getRecipeFor(@NotNull class_1937 world, List<class_1799> inventory) {
        AUTO_INVENTORY.setInputInventory(inventory);
        ISoulForgeRecipe res = world.method_8433().method_8132(ModRecipeTypes.SOULFORGE_SIMPLE, (class_1263)AUTO_INVENTORY, world).orElse(null);
        return res;
    }

    public class_1263 inputInventory() {
        ImplementedInventory inputInventory = ImplementedInventory.ofSize(this.totalIngredients.size());
        for (int i = 0; i < this.totalIngredients.size(); ++i) {
            inputInventory.method_5447(i, this.totalIngredients.get(i));
        }
        return inputInventory;
    }

    public List<class_1799> getCraftingResult(ISoulForgeRecipe recipe, class_2371<class_1799> inventory, class_1937 world) {
        AUTO_INVENTORY.setInputInventory((List<class_1799>)inventory);
        return recipe.getResult((class_1263)AUTO_INVENTORY, true, false, (class_1309)this.getOwner());
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void inventoryChanged() {
        if (this.field_11863.field_9236) {
            return;
        }
        this.refreshAvailableIngredients();
        this.method_5431();
    }

    @Override
    public void method_5431() {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        if (slot >= 1) {
            return false;
        }
        return ImplementedInventory.super.method_5493(slot, stack, side);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        if (slot >= 1) {
            return false;
        }
        return ImplementedInventory.super.method_5492(slot, stack, side);
    }

    public boolean method_49104(class_1263 hopperInventory, int slot, class_1799 stack) {
        if (slot >= 1) {
            return false;
        }
        return ImplementedInventory.super.method_49104(hopperInventory, slot, stack);
    }

    @Override
    public class_1799 method_5441(int slot) {
        class_1799 res = ImplementedInventory.super.method_5441(slot);
        if (slot < 1) {
            this.inventoryChanged();
        }
        return res;
    }

    @Override
    public class_1799 method_5434(int slot, int count) {
        class_1799 res = ImplementedInventory.super.method_5434(slot, count);
        if (slot < 1) {
            this.inventoryChanged();
        }
        return res;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        ImplementedInventory.super.method_5447(slot, stack);
        if (slot < 1) {
            this.inventoryChanged();
        }
    }

    @Override
    public class_1657 getOwner() {
        return this.owner;
    }

    @Override
    public void registerPedestal(PedestalBlockEntity pedestal) {
        if (this.field_11865) {
            return;
        }
        if (!BlockHelper.withinCube((class_2382)pedestal.method_11016().method_10059((class_2382)this.method_11016()), 5)) {
            return;
        }
        if (this.surroundingInventories.contains(pedestal)) {
            return;
        }
        this.surroundingInventories.add(pedestal);
        this.refreshAvailableIngredients();
        this.sendUpdatesToNearbyClients();
        this.method_5431();
    }

    @Override
    public void pedestalRemoved(PedestalBlockEntity pedestal) {
        if (this.field_11865) {
            return;
        }
        if (!this.surroundingInventories.contains(pedestal)) {
            return;
        }
        this.surroundingInventories.remove(pedestal);
        this.refreshAvailableIngredients();
        this.sendUpdatesToNearbyClients();
        this.method_5431();
    }

    @Override
    public void pedestalChanged(PedestalBlockEntity pedestal) {
        if (this.field_11865) {
            return;
        }
        if (!this.surroundingInventories.contains(pedestal)) {
            return;
        }
        this.refreshAvailableIngredients();
        this.sendUpdatesToNearbyClients();
        this.method_5431();
    }

    @Override
    public class_1799 getLastHammerStack() {
        return this.lastHammerStack;
    }

    @Override
    public class_1657 getLastHammerer() {
        return this.lastHammerer;
    }

    @Override
    public void onHitWithHammer(@Nullable class_1657 player, class_1799 hammer, float skill) {
        float soulToConsume;
        this.lastHammerStack = hammer;
        if (player != null) {
            this.lastHammerer = player;
        }
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (!this.isActive()) {
            AdvancementHelper.grantAdvancementCriterion((class_3222)player, "main/simple_tried_to_smith_cold_forge", "simple_tried_to_smith_cold_forge");
            return;
        }
        HammerItem hammerItem = (HammerItem)hammer.method_7909();
        float availableSoul = this.getAvailableSoul();
        float left = soulToConsume = this.activeRecipe.getSpeed(this.inputInventory()) * 0.3f * Math.min(availableSoul, (float)(hammerItem.getHitProgress(player) * 10) + skill);
        int soulContainers = this.surroundingSoulInventories.size();
        ArrayList<PedestalBlockEntity> takenFrom = new ArrayList<PedestalBlockEntity>();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (PedestalBlockEntity pedestal : this.surroundingSoulInventories) {
                ISoulStoringItem storer;
                float thisMana;
                class_1792 class_17922;
                class_1799 stack = pedestal.method_5438(0);
                if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof ISoulStoringItem) || (thisMana = (storer = (ISoulStoringItem)class_17922).getMana(this.field_11863, stack)) <= 0.0f) continue;
                float taken = Math.min(thisMana, soulToConsume / (float)soulContainers);
                storer.takeSoul(this.field_11863, stack, taken, null);
                takenFrom.add(pedestal);
                left -= taken;
                changed = true;
            }
            if (!(left <= 0.0f)) continue;
        }
        float taken = soulToConsume - left;
        this.progress += taken / this.activeRecipe.getSoulCost(this.inputInventory());
        if (this.progress > 0.0f) {
            boolean consumedAllIngredients = true;
            List<NbtIngredient> ingredients = this.activeRecipe.getNbtIngredients(null);
            int shouldHaveConsumedCount = Math.round((float)Math.ceil(this.progress * (float)ingredients.size()));
            boolean changed2 = true;
            while (this.consumedIngredients.size() < shouldHaveConsumedCount && changed2) {
                changed2 = false;
                ArrayList<Integer> accountedForConsumedIngredients = new ArrayList<Integer>();
                for (int i = 1; i < ingredients.size(); ++i) {
                    NbtIngredient ingredient = ingredients.get(i);
                    boolean consumedAlready = false;
                    for (int j = 0; j < this.consumedIngredients.size(); ++j) {
                        if (accountedForConsumedIngredients.contains(j) || !ingredient.test(this.consumedIngredients.get(j))) continue;
                        consumedAlready = true;
                        accountedForConsumedIngredients.add(j);
                        break;
                    }
                    if (consumedAlready) continue;
                    boolean consumed = false;
                    for (int j = 0; j < this.surroundingInventories.size(); ++j) {
                        class_1799 pedestalStack;
                        PedestalBlockEntity pedestal = this.surroundingInventories.get(j);
                        if (pedestal == null || !ingredient.test(pedestalStack = pedestal.method_5438(0))) continue;
                        this.consumedIngredients.add(pedestalStack.method_46651(ingredient.count));
                        pedestalStack.method_7934(ingredient.count);
                        pedestal.method_5431();
                        ParticleUtil.ParticleData.createForgeConsume(this.field_11863, this.method_11016().method_46558().method_1031(0.0, (double)0.6f, 0.0), pedestal.method_11016().method_46558().method_1031(0.0, (double)0.6f, 0.0)).send();
                        Toolbox.playSound(class_3417.field_15119, this.field_11863, pedestal.method_11016(), class_3419.field_15245, 0.5f, Toolbox.randomPitch());
                        consumed = true;
                        changed2 = true;
                        break;
                    }
                    if (consumed) break;
                    consumedAllIngredients = false;
                }
                if (!consumedAllIngredients || !(this.progress >= 1.0f) || shouldHaveConsumedCount < ingredients.size() || this.consumedIngredients.size() < ingredients.size() - 1) continue;
                NbtIngredient baseIng = ingredients.get(0);
                boolean consumedAlready = false;
                for (int j = 0; j < this.consumedIngredients.size(); ++j) {
                    if (accountedForConsumedIngredients.contains(j) || !baseIng.test(this.consumedIngredients.get(j))) continue;
                    consumedAlready = true;
                    accountedForConsumedIngredients.add(j);
                    break;
                }
                if (consumedAlready) continue;
                boolean consumed = false;
                class_1799 baseStack = this.method_5438(0);
                if (!baseIng.test(baseStack)) {
                    consumedAllIngredients = false;
                    continue;
                }
                this.consumedIngredients.add(baseStack.method_46651(baseIng.count));
                baseStack.method_7934(baseIng.count);
                this.method_5431();
                changed2 = true;
            }
            if (this.hasCraftingFinished() && consumedAllIngredients) {
                this.finishCrafting();
            }
        }
        if (taken <= 0.0f) {
            Toolbox.playSound(ModSoundEvents.USE_HAMMER_FAIL, this.field_11863, this.method_11016(), class_3419.field_15254, 0.7f, Toolbox.randomPitch());
            for (PedestalBlockEntity pedestal : this.surroundingSoulInventories) {
                ParticleUtil.ParticleData.createSoulDud(this.field_11863, pedestal.method_11016().method_46558()).send();
            }
        } else {
            CamShakeUtil.cause(this.field_11863, this.method_11016().method_46558(), 20.0f, 0.5f);
            ParticleUtil.ParticleData.createSmithingProgress(this.field_11863, this.method_11016().method_46558()).send();
            for (PedestalBlockEntity pedestal : takenFrom) {
                ParticleUtil.ParticleData.createSoulFlare(this.field_11863, pedestal.method_11016().method_46558()).send();
            }
            if (left > 0.0f) {
                Toolbox.playSound(ModSoundEvents.USE_HAMMER_FAIL, this.field_11863, this.method_11016(), class_3419.field_15254, 1.3f, Toolbox.randomPitch());
            } else {
                Toolbox.playSound(ModSoundEvents.USE_HAMMER, this.field_11863, this.method_11016(), class_3419.field_15254, 0.7f, Toolbox.randomPitch());
            }
        }
    }

    @Override
    public boolean isHammerable() {
        return this.isActive() || this.previewingRecipe != null;
    }

    public void updateAvailableSoul() {
        float prev = this.availableSoul;
        this.availableSoul = 0.0f;
        for (PedestalBlockEntity pedestal : this.surroundingSoulInventories) {
            class_1799 stack = pedestal.getItem();
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof ISoulStoringItem)) continue;
            ISoulStoringItem storer = (ISoulStoringItem)class_17922;
            this.availableSoul += storer.getMana(this.field_11863, stack);
        }
        if (prev != this.availableSoul) {
            this.method_5431();
            this.sendUpdatesToNearbyClients();
        }
    }

    public class_1263 getDroppedItems() {
        ImplementedInventory res = ImplementedInventory.ofSize(1);
        for (int i = 0; i < 1; ++i) {
            res.method_5447(i, this.method_5438(i));
        }
        return res;
    }

    public void sendUpdatesToNearbyClients() {
        class_1937 class_19372;
        if (this.field_11863 == null || !((class_19372 = this.field_11863) instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)class_19372;
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(this.method_11016());
        buf.writeBoolean(this.isActive());
        if (this.isActive()) {
            buf.method_10812(this.activeRecipe.getIdentifier());
        }
        buf.writeBoolean(this.previewingRecipe != null);
        if (this.previewingRecipe != null) {
            buf.method_10812(this.previewingRecipe.getIdentifier());
        }
        buf.writeFloat(this.progress);
        buf.writeFloat(this.instability);
        buf.writeFloat(this.availableSoul);
        ModMessages.sendToAllClients(sw.method_8503(), ModMessages.UPDATE_SOULFORGE, buf, spe -> EntityUtil.isInRange((class_1309)spe, sw, this.method_11016().method_46558(), 100.0f));
    }

    @Environment(value=EnvType.CLIENT)
    public void setStatus(class_2960 recipe, class_2960 previewRecipe, float progress, float instability, float soul) {
        if (this.field_11863 == null) {
            return;
        }
        this.activeRecipe = recipe == null ? null : (ISoulForgeRecipe)this.field_11863.method_8433().method_8130(recipe).orElse(null);
        this.previewingRecipe = previewRecipe == null ? null : (ISoulForgeRecipe)this.field_11863.method_8433().method_8130(previewRecipe).orElse(null);
        this.progress = progress;
        this.instability = instability;
        this.availableSoul = soul;
    }
}

