/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.oxytocina.geomancy.sound.ModSoundEvents;

public class ModSoundProvider
implements class_2405 {
    protected final FabricDataOutput dataOutput;

    public ModSoundProvider(FabricDataOutput dataOutput) {
        this.dataOutput = dataOutput;
    }

    public void generateSounds(SoundBuilder soundBuilder) {
        for (class_2960 key : ModSoundEvents.EVENTS.keySet()) {
            ModSoundEvents.ExtraData event = ModSoundEvents.EVENTS.get(key);
            soundBuilder.add(key, event);
        }
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        TreeMap eventEntries = new TreeMap();
        this.generateSounds((key, value) -> {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            if (eventEntries.containsKey(key)) {
                throw new RuntimeException("Existing event key found - " + key + " - Duplicate will be ignored.");
            }
            eventEntries.put(key, value);
        });
        JsonObject soundsJson = new JsonObject();
        for (Map.Entry entry : eventEntries.entrySet()) {
            soundsJson.add((String)entry.getKey(), (JsonElement)((SoundData)entry.getValue()).toJson());
        }
        return class_2405.method_10320((class_7403)writer, (JsonElement)soundsJson, (Path)this.getSoundFilePath());
    }

    private Path getSoundFilePath() {
        Path pathPre = this.dataOutput.method_45973(class_7784.class_7490.field_39368, "..").method_44107(new class_2960(this.dataOutput.getModId(), "sounds"));
        return Path.of(pathPre.toString().replace("\\..\\", "\\"), new String[0]);
    }

    public String method_10321() {
        return "Sound";
    }

    @FunctionalInterface
    public static interface SoundBuilder {
        public void add(String var1, SoundData var2);

        default public void add(class_2960 id, ModSoundEvents.ExtraData data) {
            SoundData res = new SoundData();
            for (int i = 0; i < data.plurality; ++i) {
                SoundData.Single sound = new SoundData.Single();
                String string = sound.name = data.pathPrefix != null ? data.pathPrefix : id.method_12832();
                if (data.plurality > 1) {
                    sound.name = sound.name + "_" + (i + 1);
                }
                res.sounds.add(sound);
            }
            this.add(id.method_12832(), res);
        }
    }

    public static class SoundData {
        public boolean replace = false;
        public String subtitle = null;
        public ArrayList<Single> sounds = new ArrayList();

        public SoundData withSound(Single sound) {
            this.sounds.add(sound);
            return this;
        }

        public JsonObject toJson() {
            JsonObject eventJson = new JsonObject();
            if (this.replace) {
                eventJson.addProperty("replace", Boolean.valueOf(this.replace));
            }
            if (this.subtitle != null) {
                eventJson.addProperty("subtitle", this.subtitle);
            }
            JsonArray soundsArray = new JsonArray();
            for (Single s : this.sounds) {
                soundsArray.add((JsonElement)s.toJson());
            }
            eventJson.add("sounds", (JsonElement)soundsArray);
            return eventJson;
        }

        public static class Single {
            public String name;
            public float volume = 1.0f;
            public float pitch = 1.0f;
            public int weight = 1;
            public int attenuation_distance = 16;
            public boolean stream = false;
            public boolean preload = false;
            public String type = "file";

            public JsonObject toJson() {
                JsonObject soundJson = new JsonObject();
                soundJson.addProperty("name", this.name);
                soundJson.addProperty("volume", (Number)Float.valueOf(this.volume));
                soundJson.addProperty("pitch", (Number)Float.valueOf(this.pitch));
                soundJson.addProperty("weight", (Number)this.weight);
                soundJson.addProperty("attenuation_distance", (Number)this.attenuation_distance);
                soundJson.addProperty("stream", Boolean.valueOf(this.stream));
                soundJson.addProperty("preload", Boolean.valueOf(this.preload));
                soundJson.addProperty("type", this.type);
                return soundJson;
            }
        }
    }
}

