/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.datagen.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_184;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.recipe.smithery.SmithingIngredient;
import org.oxytocina.geomancy.registries.ModRecipeTypes;

public class JewelryRecipeJsonBuilder {
    private final class_7800 category;
    private final SmithingIngredient base;
    private final int progressRequiredBase;
    private final int difficulty;
    private final float gemProgressCostMultiplier;
    private final float gemDifficultyMultiplier;
    private final class_161.class_162 advancement = class_161.class_162.method_51698();
    private final class_1865<?> serializer;

    public JewelryRecipeJsonBuilder(class_1865<?> serializer, class_7800 category, SmithingIngredient base, int progressRequiredBase, float gemProgressCostMultiplier, int difficulty, float gemDifficultyMultiplier) {
        this.category = category;
        this.serializer = serializer;
        this.base = base;
        this.progressRequiredBase = progressRequiredBase;
        this.difficulty = difficulty;
        this.gemProgressCostMultiplier = gemProgressCostMultiplier;
        this.gemDifficultyMultiplier = gemDifficultyMultiplier;
    }

    public static JewelryRecipeJsonBuilder create(SmithingIngredient base, int progressRequiredBase, float gemProgressCostMultiplier, int difficulty, float gemDifficultyMultiplier, class_7800 category) {
        return new JewelryRecipeJsonBuilder(ModRecipeTypes.JEWELRY_SERIALIZER, category, base, progressRequiredBase, gemProgressCostMultiplier, difficulty, gemDifficultyMultiplier);
    }

    public JewelryRecipeJsonBuilder criterion(String name, class_184 conditions) {
        this.advancement.method_709(name, conditions);
        return this;
    }

    public void offerTo(Consumer<class_2444> exporter, class_2960 recipeId) {
        this.validate(recipeId);
        this.advancement.method_708(class_5797.field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_193.field_1257);
        exporter.accept(new Provider(recipeId, this.serializer, this.base, this.progressRequiredBase, this.gemProgressCostMultiplier, this.difficulty, this.gemDifficultyMultiplier, this.advancement, recipeId.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private void validate(class_2960 recipeId) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
    }

    public record Provider(class_2960 id, class_1865<?> type, SmithingIngredient base, int progressRequiredBase, float gemProgressCostMultiplier, int difficulty, float gemDifficultyMultiplier, class_161.class_162 advancement, class_2960 advancementId) implements class_2444
    {
        public void method_10416(JsonObject json) {
            JsonObject ingredientElement = this.base.toJson().getAsJsonObject();
            json.add("base", (JsonElement)ingredientElement);
            json.addProperty("progressRequiredBase", (Number)this.progressRequiredBase);
            json.addProperty("gemProgressCostMultiplier", (Number)Float.valueOf(this.gemProgressCostMultiplier));
            json.addProperty("difficulty", (Number)this.difficulty);
            json.addProperty("gemDifficultyMultiplier", (Number)Float.valueOf(this.gemDifficultyMultiplier));
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return this.type;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

