/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.client.GeomancyClient;
import org.oxytocina.geomancy.client.rendering.ModColorizationHandler;
import org.oxytocina.geomancy.util.SoulUtil;
import org.oxytocina.geomancy.util.Toolbox;

public class ModHudRenderer {
    public static float lastManaFraction = 0.0f;
    public static float manaUseShake = 0.0f;
    static float manaShakeX = 0.0f;
    static float manaShakeY = 0.0f;
    static float ambientManaArrowProgress = 0.0f;
    private static final class_2960 FILLED_THIRST = new class_2960("geomancy", "textures/item/artifact_of_gold.png");
    private static final class_2960 EMPTY_THIRST = new class_2960("geomancy", "textures/item/empty_artifact.png");
    static final class_2960 MANA_BAR_TEXTURE = Geomancy.locate("textures/gui/icons.png");
    static final float MANA_BAR_TEXTURE_SIZE = 256.0f;

    public static void onHudRender(class_332 drawContext, class_1657 playerEntity) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1690.field_1842 || playerEntity == null) {
            return;
        }
        int x = 0;
        int y = 0;
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        x = width / 2;
        y = height;
        ModHudRenderer.renderManaBar(drawContext, playerEntity, x - 91);
    }

    public static void renderManaBar(class_332 context, class_1657 player, int x) {
        class_310 client = class_310.method_1551();
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        if (SoulUtil.getMaxSoul(player) > 0.0f) {
            float manaFraction = Toolbox.clampF(SoulUtil.getSoul(player) / SoulUtil.getMaxSoul(player), 0.0f, 1.0f);
            float fractionDiff = manaFraction - lastManaFraction;
            if (fractionDiff < 0.0f) {
                manaUseShake -= fractionDiff;
            }
            int barWidth = (int)(manaFraction * 183.0f);
            int barHeight = 5;
            int y = height - 32 + 3;
            int col = ModColorizationHandler.octanguliteItemBarNoise(manaFraction);
            Vector3f colVec = Toolbox.colorIntToVec(col);
            float barX = (float)x + manaShakeX;
            float barY = (float)y + manaShakeY;
            if (barWidth > 0) {
                float alpha = 0.3f + 0.4f * (1.0f + (float)Math.sin((double)((float)GeomancyClient.tick / 20.0f / 3.0f * 2.0f) * Math.PI)) / 2.0f;
                ModHudRenderer.drawTexturedQuad(MANA_BAR_TEXTURE, context.method_51448(), barX, barX + (float)barWidth, barY, barY + 5.0f, 0.0f, 0.0f, (float)barWidth / 256.0f, 0.05859375f, 0.078125f, colVec.x, colVec.y, colVec.z, alpha);
            }
            String string = Toolbox.formatNumber(Math.round(SoulUtil.getSoul(player))) + " / " + Toolbox.formatNumber(Math.round(SoulUtil.getMaxSoul(player)));
            if (ModHudRenderer.showAmbientMana()) {
                int t = Toolbox.floor(ambientManaArrowProgress * 2.999f);
                string = Math.round(SoulUtil.getAmbientSoulsPerBlock(player.method_37908(), player.method_24515())) + " " + (t % 3 == 0 ? ">" : "-") + (t % 3 == 1 ? ">" : "-") + (t % 3 == 2 ? ">" : "-") + " " + string;
            }
            float xPos = (float)(width - client.field_1772.method_1727(string)) / 2.0f + manaShakeX;
            float yPos = (float)(height - 31 - 4) + manaShakeY;
            if (player.field_7520 > 0) {
                yPos -= 11.0f;
            }
            ModHudRenderer.drawText(client.field_1772, context, string, xPos + 1.0f, yPos, 0, false);
            ModHudRenderer.drawText(client.field_1772, context, string, xPos - 1.0f, yPos, 0, false);
            ModHudRenderer.drawText(client.field_1772, context, string, xPos, yPos + 1.0f, 0, false);
            ModHudRenderer.drawText(client.field_1772, context, string, xPos, yPos - 1.0f, 0, false);
            ModHudRenderer.drawText(client.field_1772, context, string, xPos, yPos, col, false);
            lastManaFraction = manaFraction;
        }
    }

    public static void tick() {
        manaUseShake = class_3532.method_16439((float)0.1f, (float)manaUseShake, (float)0.0f);
        manaShakeX = (int)Math.round(Math.sin(Math.PI * 4 * (double)GeomancyClient.tick / 20.0) * (double)manaUseShake * 20.0);
        manaShakeY = (int)Math.round(Math.sin(22.965042117978015 * (double)GeomancyClient.tick / 20.0) * (double)manaUseShake * 10.0);
        if (ModHudRenderer.showAmbientMana() && class_310.method_1551() != null && class_310.method_1551().field_1719 != null) {
            ambientManaArrowProgress += 1.25E-4f * SoulUtil.getAmbientSoulsPerBlock((class_1937)class_310.method_1551().field_1687, class_310.method_1551().field_1719.method_24515());
            ambientManaArrowProgress %= 1.0f;
        }
    }

    public static boolean showAmbientMana() {
        return true;
    }

    static void drawTexturedQuad(class_2960 texture, class_4587 matrices, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        bufferBuilder.method_22918(matrix4f, x1, y1, z).method_22915(red, green, blue, alpha).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix4f, x1, y2, z).method_22915(red, green, blue, alpha).method_22913(u1, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, x2, y2, z).method_22915(red, green, blue, alpha).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, x2, y1, z).method_22915(red, green, blue, alpha).method_22913(u2, v1).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public static int drawText(class_327 textRenderer, class_332 context, @Nullable String text, float x, float y, int color, boolean shadow) {
        if (text == null) {
            return 0;
        }
        int i = textRenderer.method_27522(text, x, y, color, shadow, context.method_51448().method_23760().method_23761(), (class_4597)context.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0, textRenderer.method_1726());
        context.method_51452();
        return i;
    }
}

