/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.rendering.capes;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.oxytocina.geomancy.client.rendering.capes.CapeType;
import org.oxytocina.geomancy.client.rendering.capes.Players;

public class WorthinessChecker {
    private static final HashMap<UUID, Entry> PLAYER_MAP = new HashMap();

    public static CapeType getCapeType(UUID uuid) {
        return Optional.ofNullable(PLAYER_MAP.get(uuid)).map(entry -> entry.capeType).orElse(CapeType.NONE);
    }

    private static void putPlayer(UUID id, CapeType cape) {
        PLAYER_MAP.put(id, new Entry(id, cape));
    }

    public static void init() {
    }

    static {
        WorthinessChecker.putPlayer(Players.OXY, CapeType.DEV);
        WorthinessChecker.putPlayer(Players.MAXI, CapeType.DEV);
    }

    public record Entry(UUID playerId, CapeType capeType) {
    }
}

