/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_437;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.blocks.blockEntities.SpellmakerBlockEntity;
import org.oxytocina.geomancy.client.GeomancyClient;
import org.oxytocina.geomancy.client.screen.ModScreenHandlers;
import org.oxytocina.geomancy.client.screen.SpellmakerScreen;
import org.oxytocina.geomancy.client.screen.slots.SpellComponentSelectionSlot;
import org.oxytocina.geomancy.client.screen.slots.SpellmakerAppearanceSlot;
import org.oxytocina.geomancy.client.screen.slots.SpellmakerHotbarSlot;
import org.oxytocina.geomancy.client.screen.slots.TagFilterSlot;
import org.oxytocina.geomancy.inventories.ImplementedInventory;
import org.oxytocina.geomancy.items.SpellComponentStoringItem;
import org.oxytocina.geomancy.items.SpellStoringItem;
import org.oxytocina.geomancy.networking.ModMessages;
import org.oxytocina.geomancy.registries.ModItemTags;
import org.oxytocina.geomancy.sound.ModSoundEvents;
import org.oxytocina.geomancy.spells.SpellBlock;
import org.oxytocina.geomancy.spells.SpellComponent;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.util.DrawHelper;
import org.oxytocina.geomancy.util.Toolbox;

public class SpellmakerScreenHandler
extends class_1703 {
    public static SpellmakerScreenHandler current;
    private final class_1263 inventory;
    private class_1263 availableComponents;
    public boolean desireAvailableComponentsRebuild = false;
    private final class_3913 propertyDelegate;
    public final SpellmakerBlockEntity blockEntity;
    public final class_1657 player;
    public SpellmakerAppearanceSlot appearanceSlot;
    private class_1263 appearanceInventory;
    public List<SpellComponentSelectionSlot> availableComponentSlots;
    public SpellmakerScreen screen;
    private boolean dragging = false;
    private boolean dragEnabled = false;
    private double draggedX = 0.0;
    private double draggedY = 0.0;
    public double fieldDrawOffsetX = 0.0;
    public double fieldDrawOffsetY = 0.0;
    public float fieldDrawScale = 1.0f;
    public double lastZoomMousePosX = 0.0;
    public double lastZoomMousePosY = 0.0;
    public float desiredFieldDrawScale = 1.0f;
    public class_1799 currentOutput;
    public SpellGrid currentGrid;
    public int hoveredOverHexagon = -1;
    public Vector2i hoveredOverHexagonPos = null;
    public int selectedNewComponentIndex = -1;
    public SpellComponent selectedNewComponent;
    public Vector2i selectedComponentPosition = null;
    public SpellComponent selectedComponent;
    public static final int NEW_COMPONENTS_SLOT_COUNT = 14;
    public static final int NEW_COMPONENTS_X = 8;
    public static final int NEW_COMPONENTS_WIDTH = 7;
    public static final int NEW_COMPONENTS_Y = 124;
    public static final int NEW_COMPONENTS_SLOT_OFFSET = 10;
    private class_1799 prevOutput = class_1799.field_8037;
    public static final int fieldPosX = 8;
    public static final int fieldPosY = 8;
    public static final int fieldWidth = 160;
    public static final int fieldHeight = 112;
    public static final class_2960 spellmakerGuiTexture;
    public static final class_2960 hexBGTexture;
    public static final int hexBGTextureSize = 32;
    public static final int hexWidth = 32;
    public static final int hexHeight = 28;
    public static final float previewScale = 2.0f;
    public static final int previewWidth;
    public static final int previewHeight;
    public static final int sideConfigsOffset = 85;
    public static final int spacePerSideConfigButtons = 15;
    public static final int componentInfoYOffset = 30;
    public static final int parametersYOffset = 10;
    public static final int parameterEditsYOffset = 15;
    public static final int gridPropXOffset = -100;
    public static final int appearanceSlotYOffset = 70;
    public int componentSelectScroll = 0;
    public int maxComponentSelectScroll = 0;

    public SpellmakerScreenHandler(int syncID, class_1661 inventory, class_2540 buf) {
        this(syncID, inventory, inventory.field_7546.method_37908().method_8321(buf.method_10811()), (class_3913)new class_3919(3));
    }

    public SpellmakerScreenHandler(int syncID, class_1661 playerInventory, class_2586 blockEntity, class_3913 arrayPropertyDelegate) {
        super(ModScreenHandlers.SPELLMAKER_SCREEN_HANDLER, syncID);
        current = this;
        SpellmakerScreenHandler.method_17359((class_1263)((class_1263)blockEntity), (int)1);
        this.player = playerInventory.field_7546;
        this.inventory = (class_1263)blockEntity;
        playerInventory.method_5435(this.player);
        this.propertyDelegate = arrayPropertyDelegate;
        this.blockEntity = (SpellmakerBlockEntity)blockEntity;
        this.availableComponents = ImplementedInventory.ofSize(14);
        this.updateAvailableComponents();
        this.method_7621(new TagFilterSlot(this.inventory, 0, 152, 142, ModItemTags.SPELL_STORING, 1));
        this.addPlayerHotbar(playerInventory);
        this.availableComponentSlots = this.addInventory(this.availableComponents, 0, 14, 7, 8, 124);
        this.appearanceInventory = ImplementedInventory.of((class_2371<class_1799>)class_2371.method_10213((int)1, (Object)class_1799.field_8037));
        this.appearanceSlot = (SpellmakerAppearanceSlot)this.method_7621(new SpellmakerAppearanceSlot(this.appearanceInventory, 0, 187, 71, this));
        this.method_17360(arrayPropertyDelegate);
        this.method_7596(new class_1712(){

            public void method_7635(class_1703 handler, int slotId, class_1799 stack) {
                ((SpellmakerScreenHandler)handler).desireAvailableComponentsRebuild = true;
            }

            public void method_7633(class_1703 handler, int property, int value) {
            }
        });
    }

    public void outputItemChanged() {
        this.rebuild();
    }

    @Environment(value=EnvType.CLIENT)
    public void refresh() {
        this.updateAvailableComponents();
    }

    public void rebuild() {
        class_1799 newOutput = this.getOutput();
        if (this.prevOutput.method_7960() && !newOutput.method_7960()) {
            this.playUISound(ModSoundEvents.SPELLMAKER_INSERT_CRADLE);
        } else if (!this.prevOutput.method_7960() && newOutput.method_7960()) {
            this.playUISound(ModSoundEvents.SPELLMAKER_REMOVE_CRADLE);
        }
        this.prevOutput = newOutput.method_7972();
        this.currentGrid = SpellStoringItem.getOrCreateGrid(newOutput);
        this.selectedComponentChanged();
        this.updateAvailableComponents();
        if (!this.hasGrid() && this.selectedComponent != null) {
            this.selectedComponentPosition = null;
            this.selectedComponentChanged();
        }
        this.updateAppearanceSlot();
    }

    public void updateAvailableComponents() {
        this.availableComponents.method_5448();
        class_1263 from = this.blockEntity.getComponentItemsFromPlayer(this.player);
        for (int i = 0; i < 14; ++i) {
            int index = i + 7 * this.componentSelectScroll;
            this.availableComponents.method_5447(i, from.method_5439() > index ? from.method_5438(index) : class_1799.field_8037);
        }
        this.maxComponentSelectScroll = Math.round((float)Math.ceil((float)(from.method_5439() - 14) / 7.0f));
        if (this.availableComponentSlots != null) {
            for (SpellComponentSelectionSlot s : this.availableComponentSlots) {
                s.setEnabled(this.hasGrid());
            }
        }
        if (!this.hasGrid() && this.selectedNewComponent != null) {
            this.selectedNewComponentIndex = -1;
            this.selectedNewComponentChanged();
        }
    }

    public class_1799 getOutput() {
        return this.blockEntity != null ? this.blockEntity.getOutput() : null;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        int newCompSlotIndex = slotIndex - 10;
        if (newCompSlotIndex < this.availableComponents.method_5439() && newCompSlotIndex >= 0) {
            if (this.hasGrid()) {
                if (this.selectedNewComponentIndex == newCompSlotIndex) {
                    this.selectedNewComponentIndex = -1;
                    this.selectedNewComponentChanged();
                } else {
                    this.selectedNewComponentIndex = newCompSlotIndex;
                    this.selectedNewComponentChanged();
                }
            } else {
                this.selectedNewComponentIndex = -1;
                this.selectedNewComponentChanged();
            }
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 res = class_1799.field_8037;
        class_1735 fromSlot = (class_1735)this.field_7761.get(invSlot);
        if (fromSlot != null && fromSlot.method_7681()) {
            class_1799 fromStack = fromSlot.method_7677();
            res = fromStack.method_7972();
            if (invSlot < 1 ? !this.method_7616(fromStack, 1, 10, true) : !this.method_7616(fromStack, 0, 1, false)) {
                return class_1799.field_8037;
            }
            if (fromStack.method_7960()) {
                fromSlot.method_48931(class_1799.field_8037);
            } else {
                fromSlot.method_7668();
            }
        }
        return res;
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.method_7621(new class_1735((class_1263)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new SpellmakerHotbarSlot((class_1263)playerInventory, i, 8 + i * 18, 165, this));
        }
    }

    private List<SpellComponentSelectionSlot> addInventory(class_1263 inventory, int slotIndexOffset, int count, int width, int x, int y) {
        ArrayList<SpellComponentSelectionSlot> res = new ArrayList<SpellComponentSelectionSlot>();
        for (int i = 0; i < count; ++i) {
            if (i >= inventory.method_5439()) {
                return res;
            }
            res.add((SpellComponentSelectionSlot)this.method_7621(new SpellComponentSelectionSlot(inventory, slotIndexOffset + i, x + i % width * 18, y + i / width * 18, this)));
        }
        return res;
    }

    public void tick() {
        float newZoom = class_3532.method_16439((float)0.3f, (float)this.fieldDrawScale, (float)this.desiredFieldDrawScale);
        if (newZoom != this.fieldDrawScale) {
            float factor = newZoom / this.fieldDrawScale;
            this.zoomTick(factor);
        }
        if (this.desireAvailableComponentsRebuild) {
            this.desireAvailableComponentsRebuild = false;
            this.updateAvailableComponents();
        }
    }

    public void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.dragEnabled) {
            return;
        }
        this.draggedX += deltaX;
        this.draggedY += deltaY;
        if (Math.abs(this.draggedX) + Math.abs(this.draggedY) > 2.0) {
            this.dragging = true;
        }
        this.fieldDrawOffsetX += deltaX;
        this.fieldDrawOffsetY += deltaY;
        this.checkOffsetBounds();
    }

    public void mouseScrolled(double mouseX, double mouseY, double amount) {
        if (amount == 0.0) {
            return;
        }
        if (this.mouseInField(mouseX, mouseY)) {
            this.zoom(1.0f + 0.2f * (float)amount, mouseX, mouseY);
        } else if (this.mouseInNewComponents(mouseX, mouseY) && this.changeComponentViewScroll(-Toolbox.sign((float)amount))) {
            if (this.screen != null) {
                this.screen.refreshScrollButtons();
            }
            Toolbox.playUISound(ModSoundEvents.SPELLMAKER_ROTATE);
        }
    }

    private void zoomTick(float factor) {
        float oldScale = this.fieldDrawScale;
        float newScale = Toolbox.clampF(oldScale * factor, 0.5f, 2.0f);
        int bgPosX = this.getBgPosX();
        int bgPosY = this.getBgPosY();
        double mouse_x = this.lastZoomMousePosX - (double)bgPosX - 8.0 - this.fieldDrawOffsetX * (double)oldScale;
        double mouse_y = this.lastZoomMousePosY - (double)bgPosY - 8.0 - this.fieldDrawOffsetY * (double)oldScale;
        float view_width = 160.0f;
        float view_height = 112.0f;
        double side_ratio_x = (mouse_x - (double)(view_width / 2.0f)) / (double)view_width + 0.5;
        double side_ratio_h = (mouse_y - (double)(view_height / 2.0f)) / (double)view_height + 0.5;
        this.fieldDrawOffsetX += (double)(160.0f * oldScale - 160.0f * oldScale * factor) * side_ratio_x;
        this.fieldDrawOffsetY += (double)(112.0f * oldScale - 112.0f * oldScale * factor) * side_ratio_h;
        this.checkOffsetBounds();
        this.fieldDrawScale = newScale;
    }

    public void zoom(float factor, double mouseX, double mouseY) {
        float newScale;
        float oldScale = this.desiredFieldDrawScale;
        this.desiredFieldDrawScale = newScale = Toolbox.clampF(oldScale * factor, 0.5f, 2.0f);
        this.lastZoomMousePosX = mouseX;
        this.lastZoomMousePosY = mouseY;
    }

    private void checkOffsetBounds() {
        float minX = 0.0f - 160.0f / this.fieldDrawScale;
        float minY = 0.0f - 112.0f / this.fieldDrawScale;
        float maxX = 160.0f;
        float maxY = 112.0f;
        this.fieldDrawOffsetX = Math.min(Math.max((double)minX, this.fieldDrawOffsetX), (double)maxX);
        this.fieldDrawOffsetY = Math.min(Math.max((double)minY, this.fieldDrawOffsetY), (double)maxY);
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        this.dragEnabled = this.mouseInField(mouseX, mouseY);
    }

    public void mouseReleased(double mouseX, double mouseY, int button) {
        if (this.hasGrid() && this.mouseInField(mouseX, mouseY) && !this.dragging) {
            this.hexClicked();
        }
        this.dragging = false;
        this.dragEnabled = false;
        this.draggedX = 0.0;
        this.draggedY = 0.0;
    }

    public int getBgPosX() {
        return (this.screen.field_22789 - this.screen.getBackgroundWidth()) / 2;
    }

    public int getBgPosY() {
        return (this.screen.field_22790 - this.screen.getBackgroundHeight()) / 2;
    }

    public boolean mouseInField(double x, double y) {
        int bgPosX = this.getBgPosX();
        int bgPosY = this.getBgPosY();
        return x > (double)(bgPosX + 8) && y > (double)(bgPosY + 8) && x < (double)(bgPosX + 8 + 160) && y < (double)(bgPosY + 8 + 112);
    }

    public boolean mouseInNewComponents(double x, double y) {
        int bgPosX = this.getBgPosX();
        int bgPosY = this.getBgPosY();
        return x > (double)(bgPosX + 8 - 1) && y > (double)(bgPosY + 124 - 1) && x < (double)(bgPosX + 8 - 1 + 126) && y < (double)(bgPosY + 124 - 1 + Math.round((float)Math.ceil(2.0)) * 18);
    }

    @Environment(value=EnvType.CLIENT)
    private void hexClicked() {
        Vector2i componentPosition = this.hoveredOverHexagonPos;
        if (this.selectedNewComponent != null) {
            if (!this.currentGrid.components.containsKey(componentPosition)) {
                boolean canAfford = true;
                if (canAfford) {
                    SpellComponent componentToBePlaced = this.selectedNewComponent.clone();
                    componentToBePlaced.position = componentPosition;
                    this.playUISound(ModSoundEvents.SPELLMAKER_INSERT_COMPONENT);
                    class_2540 data = PacketByteBufs.create();
                    class_2487 nbt = new class_2487();
                    componentToBePlaced.writeNbt(nbt);
                    data.method_10794(nbt);
                    data.method_10807(this.blockEntity.method_11016());
                    ClientPlayNetworking.send((class_2960)ModMessages.SPELLMAKER_TRY_ADD_COMPONENT, (class_2540)data);
                    if (!class_437.method_25442()) {
                        this.selectedNewComponentIndex = -1;
                        this.selectedNewComponentChanged();
                        this.selectedComponentPosition = componentPosition;
                        this.selectedComponentChanged();
                    }
                } else {
                    this.selectedNewComponentIndex = -1;
                    this.selectedNewComponentChanged();
                }
            } else {
                this.selectedNewComponentIndex = -1;
                this.selectedNewComponentChanged();
                this.selectedComponentPosition = this.currentGrid.components.containsKey(componentPosition) ? this.hoveredOverHexagonPos : null;
                this.selectedComponentChanged();
            }
        } else if (this.selectedComponentPosition != null && this.selectedComponentPosition.equals((Object)this.hoveredOverHexagonPos)) {
            this.selectedComponentPosition = null;
            this.selectedComponentChanged();
        } else {
            this.selectedComponentPosition = this.currentGrid.components.containsKey(componentPosition) ? this.hoveredOverHexagonPos : null;
            this.selectedComponentChanged();
        }
    }

    public void selectedNewComponentChanged() {
        SpellComponent spellComponent = this.selectedNewComponent = this.selectedNewComponentIndex < 0 || this.selectedNewComponentIndex >= 14 ? null : SpellComponentStoringItem.readComponent(this.availableComponents.method_5438(this.selectedNewComponentIndex));
        if (this.selectedNewComponent == null) {
            this.selectedNewComponentIndex = -1;
        }
        if (this.screen != null) {
            this.screen.setNewComponentSelected(this.selectedNewComponent != null);
        }
    }

    public void selectedComponentChanged() {
        this.selectedComponent = this.getComponentFromPosition(this.selectedComponentPosition);
        this.screen.setComponentInspected(this.selectedComponent != null);
    }

    private SpellComponent getComponentFromPosition(Vector2i index) {
        if (!this.hasGrid()) {
            return null;
        }
        if (index == null) {
            return null;
        }
        return this.currentGrid.getComponent(index);
    }

    public boolean hasGrid() {
        return this.currentGrid != null;
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        int bgPosX = this.getBgPosX();
        int bgPosY = this.getBgPosY();
        class_1799 newOutput = this.getOutput();
        if (this.currentOutput != newOutput) {
            this.outputItemChanged();
        }
        this.currentOutput = newOutput;
        if (this.currentGrid == null) {
            this.fieldDrawScale = 1.0f;
            this.fieldDrawOffsetX = 0.0;
            this.fieldDrawOffsetY = 0.0;
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedNewComponentIndex > -1) {
            context.method_25302(spellmakerGuiTexture, bgPosX + 8 - 4 + this.selectedNewComponentIndex % 7 * 18, bgPosY + 124 - 4 + this.selectedNewComponentIndex / 7 * 18, 176, 0, 24, 24);
        }
        float scaledHexWidth = 32.0f * this.fieldDrawScale;
        float scaledHexHeight = 32.0f * this.fieldDrawScale;
        context.method_44379(bgPosX + 8, bgPosY + 8, bgPosX + 8 + 160, bgPosY + 8 + 112);
        ArrayList<Vector2f> drawPositions = new ArrayList<Vector2f>();
        ArrayList<Vector2i> drawPositionIndices = new ArrayList<Vector2i>();
        Vector2f selectedDrawPosition = null;
        for (int y = 0; y < this.currentGrid.height; ++y) {
            int yskew = y % 2;
            for (int x = 0; x < this.currentGrid.width; ++x) {
                if (!SpellGrid.positionIsInGrid(x, y, this.currentGrid.width, this.currentGrid.height) || !this.currentGrid.inBounds(new Vector2i(x, y))) continue;
                drawPositionIndices.add(new Vector2i(x, y));
                Vector2f drawPos = new Vector2f((float)(bgPosX + 8) + (float)this.fieldDrawOffsetX + this.fieldDrawScale * (float)Math.round(((float)x - 0.5f + (float)yskew / 2.0f) * 32.0f), (float)(bgPosY + 8) + (float)this.fieldDrawOffsetY + this.fieldDrawScale * (((float)y - 0.5f) * 28.0f));
                drawPositions.add(drawPos);
                if (this.selectedComponentPosition == null || !this.selectedComponentPosition.equals((Object)new Vector2i(x, y))) continue;
                selectedDrawPosition = drawPos;
            }
        }
        int selectedHexagon = -1;
        this.hoveredOverHexagonPos = null;
        if (this.mouseInField(mouseX, mouseY)) {
            float minDist = 1.0E7f;
            for (int i = 0; i < drawPositions.size(); ++i) {
                float dist = Vector2f.distance((float)mouseX, (float)mouseY, (float)(((Vector2f)drawPositions.get((int)i)).x + scaledHexWidth / 2.0f), (float)(((Vector2f)drawPositions.get((int)i)).y + scaledHexHeight / 2.0f));
                if (dist >= minDist) continue;
                minDist = dist;
                selectedHexagon = i;
                this.hoveredOverHexagonPos = (Vector2i)drawPositionIndices.get(i);
            }
        }
        this.hoveredOverHexagon = selectedHexagon;
        for (int i = 0; i < drawPositions.size(); ++i) {
            SpellComponent component = this.currentGrid.getComponent((Vector2i)drawPositionIndices.get(i));
            if (component != null) {
                SpellmakerScreenHandler.renderComponent(context, component, ((Vector2f)drawPositions.get((int)i)).x, ((Vector2f)drawPositions.get((int)i)).y, this.fieldDrawScale);
                continue;
            }
            if (this.selectedNewComponent != null && i == selectedHexagon) {
                component = this.selectedNewComponent;
                SpellmakerScreenHandler.renderComponent(context, component, ((Vector2f)drawPositions.get((int)i)).x, ((Vector2f)drawPositions.get((int)i)).y, this.fieldDrawScale);
                continue;
            }
            if (i == selectedHexagon || drawPositionIndices.get(i) == this.selectedComponentPosition) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            }
            DrawHelper.drawTexture(context.method_51448(), hexBGTexture, ((Vector2f)drawPositions.get((int)i)).x, ((Vector2f)drawPositions.get((int)i)).y, scaledHexWidth, scaledHexHeight, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        context.method_44380();
        if (this.selectedNewComponent != null && this.hasGrid()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            infoPosX = bgPosX + 176 + 10;
            int infoPosY = bgPosY + 10;
            SpellComponent component = this.selectedNewComponent;
            SpellmakerScreenHandler.renderComponent(context, component, infoPosX, infoPosY, 2.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"geomancy.spellmaker.abouttoplace1"), infoPosX + previewWidth, infoPosY, -1, true);
            context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"geomancy.spellmaker.abouttoplace2"), infoPosX + previewWidth, infoPosY + 10, -1, true);
            List<class_2561> ioInfo = SpellComponentStoringItem.componentTooltip(component, true);
            for (int i = 0; i < ioInfo.size(); ++i) {
                class_2561 t = ioInfo.get(i);
                context.method_51439(class_310.method_1551().field_1772, t, infoPosX, infoPosY + previewHeight + 30 + i * 10, -1, true);
            }
            List paramNames = component.function.parameters.keySet().stream().toList();
            if (!paramNames.isEmpty()) {
                int posX = infoPosX + 85;
                int headlinePosY = infoPosY + 90 + 10;
                context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)("geomancy.spellmaker.parameter" + (paramNames.size() > 1 ? "s" : ""))).method_27692(class_124.field_1073), posX, headlinePosY, -1, true);
                int height = 0;
                for (int i = 0; i < paramNames.size(); ++i) {
                    String paramName = (String)paramNames.get(i);
                    SpellBlock.Parameter param = component.function.parameters.get(paramName);
                    int posY = infoPosY + 90 + height + 10 + 15;
                    context.method_51439(class_310.method_1551().field_1772, (class_2561)param.getDefaultSignal().getTypeText().method_10852((class_2561)class_2561.method_43470((String)(" " + paramName)).method_27692(class_124.field_1080)), posX, posY, -1, true);
                    height += 10;
                }
            }
        } else if (this.selectedComponent != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            infoPosX = bgPosX + 176 + 10;
            int infoPosY = bgPosY + 10;
            SpellComponent component = this.selectedComponent;
            float thicknessMod = (float)Math.sin(Math.PI * 2 * (double)GeomancyClient.tick / 20.0 / 3.0);
            if (selectedDrawPosition != null) {
                Vector2f dp = new Vector2f(selectedDrawPosition.x + 32.0f * this.fieldDrawScale / 2.0f, selectedDrawPosition.y + 28.0f * this.fieldDrawScale / 2.0f);
                if (this.mouseInField(dp.x, dp.y)) {
                    int centerPreviewPosX = infoPosX + previewWidth / 2;
                    int centerPreviewPosY = infoPosY + previewHeight / 2;
                    DrawHelper.drawLine(context, dp.x, dp.y, centerPreviewPosX, centerPreviewPosY, 0.7f + 0.2f * thicknessMod, Toolbox.colorFromRGBA(0.8f, 1.0f, 1.0f, 0.5f + 0.3f * thicknessMod));
                }
            }
            SpellmakerScreenHandler.renderComponent(context, component, infoPosX, infoPosY, 2.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < component.sideConfigs.length; ++i) {
                SpellComponent.SideConfig conf = component.sideConfigs[i];
                Vector2f offset = Toolbox.rotateVector(new Vector2f((float)previewWidth / 2.0f, 0.0f), Math.PI * 2 * (double)(i - 1) / 6.0);
                float startX = (float)infoPosX + (float)previewWidth / 2.0f + offset.x;
                float startY = (float)infoPosY + (float)previewHeight / 2.0f + offset.y;
                int endX = infoPosX + 85;
                float endY = (float)infoPosY + ((float)i + 0.5f) * 15.0f;
                if (!this.screen.hoveredOverSideConfig(i)) continue;
                DrawHelper.drawLine(context, startX, startY, endX, endY, 0.5f + 0.2f * thicknessMod, Toolbox.colorFromRGBA(0.8f, 1.0f, 1.0f, 0.5f + 0.3f * thicknessMod));
            }
            List<class_2561> ioInfo = SpellComponentStoringItem.componentTooltip(component, true);
            for (int i = 0; i < ioInfo.size(); ++i) {
                class_2561 t = ioInfo.get(i);
                context.method_51439(class_310.method_1551().field_1772, t, infoPosX, infoPosY + previewHeight + 30 + i * 10, -1, true);
            }
            List paramNames = component.function.parameters.keySet().stream().toList();
            if (!paramNames.isEmpty()) {
                int posX = infoPosX + 85;
                int headlinePosY = infoPosY + 90 + 10;
                context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)("geomancy.spellmaker.parameter" + (paramNames.size() > 1 ? "s" : ""))).method_27692(class_124.field_1073), posX, headlinePosY, -1, true);
                int height = 0;
                block11: for (int i = 0; i < paramNames.size(); ++i) {
                    String paramName = (String)paramNames.get(i);
                    SpellBlock.Parameter param = component.function.parameters.get(paramName);
                    SpellComponent.ConfiguredParameter configuredParam = component.getParam(paramName);
                    int posY = infoPosY + 90 + height + 10 + 15;
                    switch (param.type) {
                        case ConstantBoolean: {
                            height += 20;
                            continue block11;
                        }
                        default: {
                            context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)paramName), posX, posY, -1, true);
                            height += 25;
                        }
                    }
                }
            }
        } else if (this.hasGrid()) {
            infoPosX = bgPosX + 176 + 10;
            int infoPosY = bgPosY + 10;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"geomancy.spellmaker.grid.name"), infoPosX, infoPosY, -1, true);
            context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"geomancy.spellmaker.grid.appearance"), infoPosX + 25, infoPosY - 10 + 70 + 4, -1, true);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void playUISound(class_3414 event) {
        if (this.screen != null) {
            this.screen.playUISound(event);
        }
    }

    public boolean changeComponentViewScroll(int scroll) {
        int prevScroll;
        int initialScroll = this.componentSelectScroll;
        do {
            prevScroll = this.componentSelectScroll;
            this.componentSelectScroll = Toolbox.clampI(prevScroll + scroll, 0, this.maxComponentSelectScroll);
            if (this.selectedNewComponent != null) {
                this.selectedNewComponentIndex -= scroll * 7;
                if (this.selectedNewComponentIndex < 0 || this.selectedNewComponentIndex >= 14) {
                    this.selectedNewComponentIndex = -1;
                }
                this.selectedNewComponentChanged();
            }
            scroll = 0;
            this.updateAvailableComponents();
        } while (prevScroll != this.componentSelectScroll);
        return initialScroll != this.componentSelectScroll;
    }

    public boolean componentScrollVisible() {
        return this.maxComponentSelectScroll > 0;
    }

    public boolean componentScrollActive(int i) {
        if (i == 0) {
            return this.componentSelectScroll > 0;
        }
        return this.componentSelectScroll < this.maxComponentSelectScroll;
    }

    public void method_7619(int slot, int revision, class_1799 stack) {
        if (slot >= 10 && slot < 24) {
            this.field_34024 = revision;
            return;
        }
        super.method_7619(slot, revision, stack);
    }

    public void trySelectComponentOf(SpellBlock function) {
        if (this.selectedNewComponent != null && this.selectedNewComponent.function == function) {
            this.selectedNewComponentIndex = -1;
            this.selectedNewComponentChanged();
            return;
        }
        if (!this.hasGrid()) {
            return;
        }
        class_1263 from = this.blockEntity.getComponentItemsFromPlayer(this.player);
        for (int i = 0; i < from.method_5439(); ++i) {
            int maxScroll;
            class_1799 stack = from.method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof SpellComponentStoringItem)) continue;
            SpellComponentStoringItem scsi = (SpellComponentStoringItem)class_17922;
            SpellComponent comp = SpellComponentStoringItem.readComponent(stack);
            if (comp == null || comp.function != function) continue;
            int minScroll = Math.round((float)Math.ceil((float)(i - 14 + 1) / 7.0f));
            int newScroll = Toolbox.clampI(this.componentSelectScroll, minScroll, maxScroll = minScroll + 1);
            if (newScroll != this.componentSelectScroll && this.changeComponentViewScroll(newScroll - this.componentSelectScroll) && this.screen != null) {
                this.screen.refreshScrollButtons();
            }
            int newSelectedIndex = i - this.componentSelectScroll * 7;
            this.method_7593(newSelectedIndex + 10, 1, class_1713.field_7790, this.player);
            return;
        }
    }

    public class_1799 getHeldNewComponentStack() {
        if (this.selectedNewComponent == null) {
            return class_1799.field_8037;
        }
        return this.selectedNewComponent.getItemStack();
    }

    public void onAppearanceSlotClicked(SpellmakerAppearanceSlot spellmakerAppearanceSlot, class_1799 heldStack) {
        if (!(this.player instanceof class_3222)) {
            return;
        }
        this.currentGrid = SpellStoringItem.getOrCreateGrid(this.getOutput());
        if (!this.hasGrid()) {
            return;
        }
        this.currentGrid.displayStack = heldStack.method_7972();
        this.currentGrid.displayStack.method_7980(null);
        SpellStoringItem.writeGrid(this.getOutput(), this.currentGrid);
    }

    public static void renderComponent(class_332 ctx, SpellComponent component, float x, float y, float scale) {
        class_2960 fgTexture = component.getHexFrontTexture();
        class_2960 bgTexture = component.getHexBackTexture();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scaledHexWidth = 32.0f * scale;
        float scaledHexHeight = 32.0f * scale;
        DrawHelper.drawTexture(ctx.method_51448(), bgTexture, x, y, scaledHexWidth, scaledHexHeight, 0.0f, 0.0f, 32, 32, 32, 32);
        DrawHelper.drawTexture(ctx.method_51448(), fgTexture, x, y, scaledHexWidth, scaledHexHeight, 0.0f, 0.0f, 32, 32, 32, 32);
        for (SpellComponent.SideConfig conf : component.sideConfigs) {
            class_2960 tex = conf.getTexture();
            if (tex == null) continue;
            DrawHelper.drawTexture(ctx.method_51448(), tex, x, y, scaledHexWidth, scaledHexHeight, 0.0f, 0.0f, 32, 32, 32, 32);
        }
    }

    public void updateAppearanceSlot() {
        this.appearanceSlot.setEnabled(this.hasGrid());
        if (!this.hasGrid()) {
            this.appearanceInventory.method_5447(0, class_1799.field_8037);
            return;
        }
        class_1799 appearanceStack = this.currentGrid.displayStack;
        if (appearanceStack == null) {
            appearanceStack = class_1799.field_8037;
        }
        this.appearanceInventory.method_5447(0, appearanceStack);
    }

    static {
        spellmakerGuiTexture = Geomancy.locate("textures/gui/spellmaker_block_gui.png");
        hexBGTexture = Geomancy.locate("textures/gui/spellmaker_hex_bg.png");
        previewWidth = Math.round(64.0f);
        previewHeight = Math.round(64.0f);
    }
}

