/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.client.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.networking.packet.S2C.CamShakeS2CPacket;
import org.oxytocina.geomancy.util.SimplexNoise;

public class CamShakeUtil {
    @Environment(value=EnvType.CLIENT)
    public static float t = 0.0f;
    @Environment(value=EnvType.CLIENT)
    public static float shakeIntensity = 0.0f;
    @Environment(value=EnvType.CLIENT)
    public static float shakeDuration = 0.0f;
    @Environment(value=EnvType.CLIENT)
    public static float shakeSpeed = 1.0f;
    @Environment(value=EnvType.CLIENT)
    public static double time = 0.0;

    @Environment(value=EnvType.CLIENT)
    public static void tick(float tickDelta, class_4587 matrixStack) {
        float deltaTime = class_310.method_1551().method_1534() / 20.0f;
        t += deltaTime;
        time += (double)deltaTime;
        float currentShakeIntensity = Math.min(1.0f, CamShakeUtil.getCurrentShake() / 4.0f) * ((Float)Geomancy.CONFIG.shakeIntensity.value()).floatValue();
        if (currentShakeIntensity <= 0.0f) {
            return;
        }
        float speed = 5.0f * shakeSpeed;
        float lerpT = 1.0f;
        float x = 1.0f * currentShakeIntensity * CamShakeUtil.getShakeOffset(time, time, speed);
        float y = 1.0f * currentShakeIntensity * CamShakeUtil.getShakeOffset(-time, time, speed);
        float xA = 5.0f * currentShakeIntensity * CamShakeUtil.getShakeOffset(time, -time, speed);
        float zA = 5.0f * currentShakeIntensity * CamShakeUtil.getShakeOffset(-time, -time, speed);
        matrixStack.method_46416(x, y, 0.0f);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(zA));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(xA));
    }

    @Environment(value=EnvType.CLIENT)
    public static void shake(float intensity) {
        CamShakeUtil.shake(intensity, intensity);
    }

    @Environment(value=EnvType.CLIENT)
    public static void shake(float intensity, float duration) {
        CamShakeUtil.shake(intensity, duration, 1.0f);
    }

    @Environment(value=EnvType.CLIENT)
    public static void shake(float intensity, float duration, float speed) {
        if (intensity < CamShakeUtil.getCurrentShake()) {
            return;
        }
        shakeIntensity = intensity;
        shakeDuration = duration;
        shakeSpeed = speed;
        t = 0.0f;
    }

    @Environment(value=EnvType.CLIENT)
    private static float getCurrentShake() {
        return class_3532.method_16439((float)Math.max(0.0f, 1.0f - t / shakeDuration), (float)0.0f, (float)shakeIntensity);
    }

    @Environment(value=EnvType.CLIENT)
    private static float getShakeOffset(double x, double y, double scale) {
        return 1.0f - 2.0f * SimplexNoise.noiseNormalized(x, y, 0.0, scale);
    }

    public static void cause(class_1937 world, class_243 pos, float range, float intensity) {
        CamShakeUtil.cause(world, pos, range, intensity, intensity);
    }

    public static void cause(class_1937 world, class_243 pos, float range, float intensity, float duration) {
        CamShakeUtil.cause(world, pos, range, intensity, duration, 1.0f);
    }

    public static void cause(class_1937 world, class_243 pos, float range, float intensity, float duration, float speed) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)world;
        CamShakeS2CPacket.send(sw, pos, range, intensity, duration, speed);
    }
}

