/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items;

import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.client.rendering.ModColorizationHandler;
import org.oxytocina.geomancy.enchantments.ModEnchantments;
import org.oxytocina.geomancy.entity.SoulStoringItemData;
import org.oxytocina.geomancy.spells.SpellContext;

public interface ISoulStoringItem {
    public static void init(class_1937 world, class_1799 stack) {
        if (stack.method_7941("soul") != null) {
            return;
        }
        class_2487 soul = new class_2487();
        soul.method_25927("uuid", SoulStoringItemData.getNextUUID());
        stack.method_7959("soul", (class_2520)soul);
    }

    public static SoulStoringItemData getData(class_1937 world, class_1799 stack) {
        ISoulStoringItem.init(world, stack);
        return SoulStoringItemData.from(world, stack, ISoulStoringItem.getUUID(stack));
    }

    default public float getInitialMana(class_1799 base) {
        return 0.0f;
    }

    default public void onDepleted(class_1799 stack) {
    }

    default public int depletionPriority(class_1799 stack) {
        return 0;
    }

    default public float getCapacityMultiplier(class_1799 stack) {
        return 1.0f + (float)ModEnchantments.getLevel(stack, ModEnchantments.MESMERIZING) * 0.5f;
    }

    default public float getCapacity(class_1937 world, class_1799 stack) {
        ISoulStoringItem.init(world, stack);
        return ISoulStoringItem.getData((class_1937)world, (class_1799)stack).maxMana * this.getCapacityMultiplier(stack);
    }

    default public float getRechargeSpeedMultiplier(class_1937 world, class_1799 stack, class_1309 entity) {
        ISoulStoringItem.init(world, stack);
        return ISoulStoringItem.getData((class_1937)world, (class_1799)stack).speedMultiplier;
    }

    default public void setRechargeSpeedMultiplier(class_1937 world, class_1799 stack, float speed) {
        ISoulStoringItem.init(world, stack);
        ISoulStoringItem.getData((class_1937)world, (class_1799)stack).speedMultiplier = speed;
    }

    default public float getMana(class_1937 world, class_1799 stack) {
        ISoulStoringItem.init(world, stack);
        float mana = ISoulStoringItem.getData((class_1937)world, (class_1799)stack).mana;
        if (Float.isNaN(mana)) {
            Geomancy.logError("item mana was NaN!");
            this.setMana(world, stack, 0.0f);
        }
        return ISoulStoringItem.getData((class_1937)world, (class_1799)stack).mana;
    }

    default public void setCapacity(class_1937 world, class_1799 stack, float capacity) {
        ISoulStoringItem.init(world, stack);
        ISoulStoringItem.getData((class_1937)world, (class_1799)stack).maxMana = capacity;
    }

    default public void setMana(class_1937 world, class_1799 stack, float mana) {
        ISoulStoringItem.init(world, stack);
        ISoulStoringItem.getData((class_1937)world, (class_1799)stack).mana = mana;
    }

    public static void setUUID(class_1799 stack, UUID uuid) {
        class_2487 soul = new class_2487();
        soul.method_25927("uuid", uuid);
        stack.method_7959("soul", (class_2520)soul);
    }

    public static UUID getUUID(class_1799 stack) {
        UUID uuid;
        class_2487 soul = stack.method_7911("soul");
        UUID uUID = uuid = soul.method_25928("uuid") ? soul.method_25926("uuid") : null;
        if (uuid == null) {
            uuid = UUID.randomUUID();
            ISoulStoringItem.setUUID(stack, uuid);
        }
        return uuid;
    }

    @Environment(value=EnvType.CLIENT)
    default public int getBarColor(class_1799 stack) {
        if (class_310.method_1551() == null) {
            return -1;
        }
        class_638 world = class_310.method_1551().field_1687;
        float cap = this.getCapacity((class_1937)world, stack);
        float progress = this.getMana((class_1937)world, stack) / Math.max(cap, 1.0f);
        return ModColorizationHandler.octanguliteItemBarNoise(progress);
    }

    public float getBaseSoulCapacity(class_1799 var1);

    @Environment(value=EnvType.CLIENT)
    default public void addManaTooltip(class_1937 world, class_1799 stack, List<class_2561> tooltip) {
        if (world == null) {
            world = class_310.method_1551().field_1687;
        }
        if (world == null) {
            return;
        }
        float mana = this.getMana(world, stack);
        float cap = this.getCapacity(world, stack);
        if (cap <= 0.0f) {
            return;
        }
        float fraction = mana / cap;
        tooltip.add((class_2561)class_2561.method_43469((String)"geomancy.soul_storage.tooltip", (Object[])new Object[]{Math.round(mana), Math.round(cap), Math.round(fraction * 100.0f)}).method_27692(class_124.field_1063));
    }

    default public void takeSoul(class_1937 world, class_1799 left, float taken, @Nullable SpellContext ctx) {
        this.setMana(world, left, this.getMana(world, left) - taken);
    }
}

