/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.items.ICustomRarityItem;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.spells.SpellBlock;
import org.oxytocina.geomancy.spells.SpellBlocks;
import org.oxytocina.geomancy.spells.SpellComponent;
import org.oxytocina.geomancy.spells.SpellSignal;
import org.oxytocina.geomancy.util.StellgeUtil;

public class SpellComponentStoringItem
extends class_1792 {
    public static final ArrayList<SpellComponentStoringItem> List = new ArrayList();

    public SpellComponentStoringItem(class_1792.class_1793 settings) {
        super(settings);
        List.add(this);
    }

    public static class_1799 createDefaultComponentData(class_1799 stack, SpellBlock block) {
        SpellComponent component = new SpellComponent(null, null, block);
        SpellComponentStoringItem.writeComponent(stack, component);
        return stack;
    }

    public static SpellComponent readComponent(class_1799 stack) {
        if (stack == null || !stack.method_7985()) {
            return null;
        }
        class_2487 Nbt = stack.method_7969();
        if (!Nbt.method_10573("component", 10)) {
            return null;
        }
        class_2487 subNbt = Nbt.method_10562("component");
        return new SpellComponent(null, subNbt);
    }

    public static void writeComponent(class_1799 stack, SpellComponent component) {
        if (stack == null) {
            return;
        }
        class_2487 componentCompound = new class_2487();
        component.writeNbt(componentCompound);
        stack.method_7959("component", (class_2520)componentCompound);
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 method_7864(class_1799 stack) {
        SpellComponent comp = SpellComponentStoringItem.readComponent(stack);
        class_5250 compText = class_2561.method_43471((String)("geomancy.spellcomponent." + (comp != null ? comp.function.identifier.method_12832() : "empty")));
        if (comp != null && comp.isObfuscated()) {
            return StellgeUtil.stellgify(compText);
        }
        return class_2561.method_43471((String)this.method_7866(stack)).method_10852((class_2561)class_2561.method_43470((String)" [").method_10852((class_2561)compText).method_27693("]")).method_27692(class_124.field_1080);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        SpellComponent comp = SpellComponentStoringItem.readComponent(stack);
        if (comp == null) {
            return;
        }
        tooltip.addAll(SpellComponentStoringItem.componentTooltip(comp, false));
    }

    @Environment(value=EnvType.CLIENT)
    public static List<class_2561> componentTooltip(SpellComponent comp, boolean forSpellmaker) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (comp == null) {
            return tooltip;
        }
        if (forSpellmaker) {
            class_5250 compText = class_2561.method_43471((String)("geomancy.spellcomponent." + comp.function.identifier.method_12832()));
            if (comp.isObfuscated()) {
                compText = StellgeUtil.stellgify(compText);
            }
            tooltip.add((class_2561)compText.method_27692(class_124.field_1068));
        }
        class_5250 catText = class_2561.method_43471((String)("geomancy.spellcomponent.category." + comp.function.category.toString().toLowerCase())).method_27692(class_124.field_1078);
        if (comp.function.isAncient()) {
            catText = ICustomRarityItem.colorizeName(ICustomRarityItem.Rarity.Ancient, null, (class_2561)catText);
        }
        tooltip.add((class_2561)catText);
        if (!forSpellmaker) {
            tooltip.add((class_2561)class_2561.method_43471((String)("geomancy.tooltip.spellcomponent." + comp.function.identifier.method_12832())).method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43473());
        for (SpellSignal input : comp.function.inputs.values()) {
            tooltip.add(input.toText());
        }
        tooltip.add((class_2561)class_2561.method_43470((String)"->").method_27692(class_124.field_1080));
        for (SpellSignal output : comp.function.outputs.values()) {
            tooltip.add(output.toText());
        }
        return tooltip;
    }

    public static void populateItemGroup() {
        ItemGroupEvents.modifyEntriesEvent(ModItems.SPELLS_ITEM_GROUP_KEY).register(itemGroup -> {
            for (SpellComponentStoringItem i : List) {
                for (SpellBlock block : SpellBlocks.functions.values()) {
                    class_1799 item = SpellComponentStoringItem.createDefaultComponentData(i.method_7854(), block);
                    itemGroup.method_45420(item);
                }
            }
        });
    }

    public float getSpellPredicate(class_1799 stack) {
        SpellComponent comp = SpellComponentStoringItem.readComponent(stack);
        if (comp == null) {
            return 0.0f;
        }
        return (float)SpellBlocks.functionOrder.get(comp.function.identifier).intValue() / (float)SpellBlocks.functionOrder.size();
    }

    public static class_2487 getNbtFor(SpellBlock block) {
        SpellComponent component = new SpellComponent(null, null, block);
        class_2487 componentCompound = new class_2487();
        component.writeNbt(componentCompound);
        return componentCompound;
    }

    public static boolean isAncient(class_1799 stack) {
        SpellComponent comp = SpellComponentStoringItem.readComponent(stack);
        if (comp == null) {
            return false;
        }
        return comp.isAncient();
    }
}

