/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.armor;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5250;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.client.registries.ModModelLayers;
import org.oxytocina.geomancy.client.rendering.armor.CastingArmorModel;
import org.oxytocina.geomancy.client.screen.StorageItemScreenHandler;
import org.oxytocina.geomancy.items.ICustomRarityItem;
import org.oxytocina.geomancy.items.IMaddeningItem;
import org.oxytocina.geomancy.items.ISoulStoringItem;
import org.oxytocina.geomancy.items.IStorageItem;
import org.oxytocina.geomancy.items.SpellStoringItem;
import org.oxytocina.geomancy.items.armor.IListenerArmor;
import org.oxytocina.geomancy.items.tools.StorageItem;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.spells.SpellSignal;

public class CastingArmorItem
extends class_1738
implements IMaddeningItem,
IStorageItem,
ExtendedScreenHandlerFactory,
ISoulStoringItem,
ICustomRarityItem,
IListenerArmor {
    @Environment(value=EnvType.CLIENT)
    private class_572<class_1309> model;
    private final float maddeningSpeed;
    public int storageSize = 0;
    public final class_6862<class_1792> storableTag;
    public final boolean showContentsInTooltip;

    public CastingArmorItem(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 settings, float maddeningSpeed, int storageSize, class_6862<class_1792> storableTag, boolean showContentsInTooltip) {
        super(material, type, settings);
        this.maddeningSpeed = maddeningSpeed;
        this.storageSize = storageSize;
        this.storableTag = storableTag;
        this.showContentsInTooltip = showContentsInTooltip;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_5715()) {
            if (user instanceof class_3222) {
                class_3222 sp = (class_3222)user;
                class_1799 stack = user.method_5998(hand);
                sp.method_17355((class_3908)((CastingArmorItem)stack.method_7909()));
            }
            return class_1271.method_22428((Object)user.method_5998(hand));
        }
        return super.method_7836(world, user, hand);
    }

    public void cast(class_1799 key, class_1309 user, SpellBlockArgs args) {
        int index = this.getSelectedSpellIndex(key);
        ArrayList<class_1799> spells = this.getCastableSpellItems(key);
        if (spells.isEmpty()) {
            return;
        }
        class_1799 spellContainer = spells.get(index);
        class_1792 class_17922 = spellContainer.method_7909();
        if (!(class_17922 instanceof SpellStoringItem)) {
            return;
        }
        SpellStoringItem storer = (SpellStoringItem)class_17922;
        storer.cast(key, spellContainer, user, args, SpellContext.SoundBehavior.Reduced, false);
    }

    public int getSelectedSpellIndex(class_1799 stack) {
        return 0;
    }

    public int getInstalledSpellsCount(class_1799 stack) {
        return this.getCastableSpellItems(stack).size();
    }

    public ArrayList<class_1799> getCastableSpellItems(class_1799 stack) {
        if (!(stack.method_7909() instanceof CastingArmorItem)) {
            return null;
        }
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        for (int i = 0; i < this.getStorageSize(stack); ++i) {
            class_1799 spell = this.getStack(stack, i);
            class_1792 class_17922 = spell.method_7909();
            if (!(class_17922 instanceof SpellStoringItem)) continue;
            SpellStoringItem storer = (SpellStoringItem)class_17922;
            SpellGrid grid = SpellStoringItem.readGrid(spell);
            if (grid == null || grid.library) continue;
            res.add(spell);
        }
        return res;
    }

    @Override
    public float getInInventoryMaddeningSpeed() {
        return this.maddeningSpeed;
    }

    @Override
    public float getWornMaddeningSpeed() {
        return this.maddeningSpeed * 2.0f;
    }

    public class_2561 method_7864(class_1799 stack) {
        return this.colorizeName(stack, super.method_7864(stack));
    }

    @Override
    public ICustomRarityItem.Rarity getRarity() {
        return ICustomRarityItem.Rarity.Octangulite;
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        class_1799 stack = serverPlayerEntity.method_5998(serverPlayerEntity.method_6058());
        packetByteBuf.writeInt(serverPlayerEntity.method_31548().method_7395(stack));
        packetByteBuf.method_10812(this.getStorableTag().comp_327());
    }

    public class_2561 method_5476() {
        return this.method_7848();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        class_1799 stack = player.method_5998(player.method_6058());
        if (stack.method_7909() != this) {
            return null;
        }
        return new StorageItemScreenHandler(syncId, playerInventory, stack, this.getStorableTag(), new class_3913(){

            public int method_17390(int index) {
                switch (index) {
                    default: 
                }
                return 0;
            }

            public void method_17391(int index, int value) {
            }

            public int method_17389() {
                return 3;
            }
        });
    }

    @Override
    public float getBaseSoulCapacity(class_1799 stack) {
        return 0.0f;
    }

    @Override
    public class_2371<class_1799> readInventoryFromNbt(class_1799 stack) {
        class_2371 stacks = class_2371.method_10213((int)this.storageSize, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)stack.method_7948(), (class_2371)stacks);
        return stacks;
    }

    @Override
    public void saveInventoryToNbt(class_1799 stack) {
        stack.method_7948().method_10551("Items");
        class_1262.method_5426((class_2487)stack.method_7948(), this.getItems(stack));
        this.clearCache(stack);
    }

    @Override
    public int getStorageSize(class_1799 stack) {
        return this.getSize(stack);
    }

    public class_1799 getStack(class_1799 key, int slot) {
        return (class_1799)this.getItems(key).get(slot);
    }

    public void clearCache(class_1799 stack) {
        inventories.remove(stack);
        actualInventories.remove(stack);
    }

    @Override
    public void setInventory(class_1799 stack, class_2487 nbt) {
        this.clearCache(stack);
        stack.method_7959("Items", (class_2520)nbt.method_10554("Items", 10));
        this.clearCache(stack);
    }

    public int getSize(class_1799 stack) {
        return this.getItems(stack).size();
    }

    @Override
    public class_2371<class_1799> getItems(class_1799 stack) {
        if (inventories.containsKey(stack)) {
            return (class_2371)inventories.get(stack);
        }
        class_2371<class_1799> inv = this.readInventoryFromNbt(stack);
        inventories.put(stack, inv);
        return inv;
    }

    @Override
    public class_1263 getInventory(class_1799 stack) {
        return StorageItem.getInventoryStatic(stack);
    }

    @Override
    public void setStack(class_1799 key, int slot, class_1799 stack) {
        this.getItems(key).set(slot, (Object)stack);
        if (stack.method_7947() > this.getMaxCountPerStack(key)) {
            stack.method_7939(this.getMaxCountPerStack(key));
        }
        this.markDirty(key);
    }

    protected int getMaxCountPerStack(class_1799 key) {
        return 64;
    }

    @Override
    public class_6862<class_1792> getStorableTag() {
        return this.storableTag;
    }

    @Override
    public boolean autocollects() {
        return false;
    }

    @Override
    public void onGotHit(class_1799 stack, class_1309 wearer, class_1282 source, float amount) {
        class_1297 attacker;
        if (this.field_41933 == class_1738.class_8051.field_41935 && (attacker = source.method_5529()) instanceof class_1309) {
            class_1309 le = (class_1309)attacker;
            SpellBlockArgs args = new SpellBlockArgs();
            args.vars.put("attacker", SpellSignal.createUUID(le.method_5667()));
            this.cast(stack, wearer, args);
        }
    }

    @Override
    public void onJump(class_1799 stack, class_1309 wearer) {
        if (this.field_41933 == class_1738.class_8051.field_41936) {
            this.cast(stack, wearer, SpellBlockArgs.empty());
        }
    }

    @Override
    public void onHit(class_1799 stack, class_1309 wearer, class_1309 target) {
        if (this.field_41933 == class_1738.class_8051.field_41934) {
            SpellBlockArgs args = new SpellBlockArgs();
            args.vars.put("target", SpellSignal.createUUID(target.method_5667()));
            this.cast(stack, wearer, args);
        }
    }

    @Override
    public void onMessageSent(class_1799 armorItemStack, class_3222 spe, String message) {
        if (this.field_41933 == class_1738.class_8051.field_41937) {
            SpellBlockArgs args = new SpellBlockArgs();
            args.vars.put("message", SpellSignal.createText(message));
            this.cast(armorItemStack, (class_1309)spe, args);
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        ArrayList<class_1799> spells = this.getCastableSpellItems(stack);
        if (!spells.isEmpty()) {
            class_1799 spell = spells.get(0);
            SpellGrid grid = SpellStoringItem.readGrid(spell);
            tooltip.add((class_2561)this.getTriggerText().method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43469((String)"geomancy.caster.willcast", (Object[])new Object[]{SpellGrid.getName(grid)}).method_27692(class_124.field_1063));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.caster.emptyhint1").method_27692(class_124.field_1063));
            tooltip.add((class_2561)this.getTriggerText().method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.caster.emptyhint4").method_27692(class_124.field_1063));
        }
    }

    public class_5250 getTriggerText() {
        return class_2561.method_43471((String)("geomancy.caster.trigger." + (switch (this.field_41933) {
            case class_1738.class_8051.field_41937 -> "chat";
            case class_1738.class_8051.field_41936 -> "jump";
            case class_1738.class_8051.field_41935 -> "gethit";
            case class_1738.class_8051.field_41934 -> "hit";
            default -> "ERROR";
        })));
    }

    @Environment(value=EnvType.CLIENT)
    public class_572<class_1309> getArmorModel() {
        if (this.model == null) {
            this.model = this.provideArmorModelForSlot(this.method_7685());
        }
        return this.model;
    }

    public class_1921 getRenderLayer(class_1799 stack) {
        return class_1921.method_23572((class_2960)ModModelLayers.CASTING_ARMOR_MAIN_ID);
    }

    @NotNull
    public class_2960 getArmorTexture(class_1799 stack, class_1304 slot) {
        return Geomancy.locate("textures/armor/casting_armor_main.png");
    }

    @Environment(value=EnvType.CLIENT)
    protected class_572<class_1309> provideArmorModelForSlot(class_1304 slot) {
        class_5599 models = class_310.method_1551().method_31974();
        class_630 root = models.method_32072(ModModelLayers.MAIN_CASTING_LAYER);
        return new CastingArmorModel(root, slot);
    }

    @Override
    public class_3414 getOpenSound() {
        return class_3417.field_34375;
    }

    @Override
    public class_3414 getCloseSound() {
        return class_3417.field_34377;
    }
}

