/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.jewelry;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function6;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import dev.emi.trinkets.api.SlotReference;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.enchantments.ModEnchantments;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.items.jewelry.IJewelryItem;
import org.oxytocina.geomancy.util.Toolbox;

public class GemSlot {
    public final class_1792 gemItem;
    public float quality;
    public final String gemItemIdentifierString;
    public static HashMap<class_1792, Settings> settingsMap = new HashMap();
    public static HashMap<class_1792, Integer> gemColorMap = new HashMap();

    private static String QualityRounded(float q) {
        return Integer.toString(Math.round(q));
    }

    private static String QualityRounded(float q, int decimalPoints) {
        int mult = Math.round((float)Math.pow(10.0, decimalPoints));
        return Float.toString((float)Math.round(q * (float)mult) / (float)mult);
    }

    private static String QualityPercent(float q) {
        return Integer.toString(Math.round(q * 100.0f));
    }

    private static String QualityEmpty(float q) {
        return "";
    }

    public static void register(Settings settings) {
        settingsMap.put(settings.item, settings);
        GemSlot.registerColor(settings.item, settings.color);
    }

    public static void registerColor(class_1792 item, int color) {
        gemColorMap.put(item, color);
    }

    public GemSlot(class_1792 item) {
        this(item, 1.0f);
    }

    public GemSlot(class_1792 item, float quality) {
        this.gemItem = item;
        this.quality = quality;
        this.gemItemIdentifierString = class_7923.field_41178.method_10221((Object)item.method_8389()).toString();
    }

    public static GemSlot fromNbt(class_2487 nbt) {
        String identifierString = "minecraft:diamond";
        if (nbt.method_10573("item", 8)) {
            identifierString = nbt.method_10558("item");
        } else {
            Geomancy.logError("GemSlot fromNbt: item field was missing");
        }
        class_1792 item = class_1802.field_8477;
        if (class_2960.method_20207((String)identifierString)) {
            class_2960 identifier = class_2960.method_12829((String)identifierString);
            Optional op = class_7923.field_41178.method_17966(identifier);
            if (op.isPresent()) {
                item = (class_1792)op.get();
            } else {
                Geomancy.logError("GemSlot fromNbt: item field contained nonexisting item " + identifierString);
            }
        }
        float quality = 1.0f;
        if (nbt.method_10573("quality", 5)) {
            quality = nbt.method_10583("quality");
        }
        return new GemSlot(item, quality);
    }

    public static class_2487 toNbt(GemSlot slot) {
        class_2487 res = new class_2487();
        res.method_10582("item", class_7923.field_41178.method_10221((Object)slot.gemItem.method_8389()).toString());
        res.method_10548("quality", slot.quality);
        return res;
    }

    public int getColor() {
        return gemColorMap.get(this.gemItem);
    }

    public float getEffectiveQuality(class_1799 stack, class_1309 entity) {
        return this.quality * (1.0f + (float)ModEnchantments.getLevel(stack, ModEnchantments.BRILLIANCE) * 0.2f) * IJewelryItem.getGemQualityMultiplierFor(this, stack, entity);
    }

    public static Settings getSettings(class_1792 item) {
        if (!settingsMap.containsKey(item)) {
            return null;
        }
        return settingsMap.get(item);
    }

    public static boolean tick(class_1799 stack, GemSlot gem, SlotReference slot, class_1309 entity) {
        Settings s = GemSlot.getSettings(gem.gemItem);
        if (s != null && s.tickFunction != null) {
            return (Boolean)s.tickFunction.apply((Object)stack, (Object)gem, (Object)slot, (Object)entity);
        }
        return false;
    }

    public static boolean equip(class_1799 stack, GemSlot gem, SlotReference slot, class_1309 entity) {
        Settings s = GemSlot.getSettings(gem.gemItem);
        if (s != null && s.equipFunction != null) {
            return (Boolean)s.equipFunction.apply((Object)stack, (Object)gem, (Object)slot, (Object)entity);
        }
        return false;
    }

    public static boolean unequip(class_1799 stack, GemSlot gem, SlotReference slot, class_1309 entity) {
        Settings s = GemSlot.getSettings(gem.gemItem);
        if (s != null && s.unequipFunction != null) {
            return (Boolean)s.unequipFunction.apply((Object)stack, (Object)gem, (Object)slot, (Object)entity);
        }
        return false;
    }

    public static Multimap<class_1320, class_1322> modifyModifiers(class_1799 stack, GemSlot gem, SlotReference slot, class_1309 entity, UUID uuid, Multimap<class_1320, class_1322> modifiers) {
        Settings s = GemSlot.getSettings(gem.gemItem);
        if (s != null && s.modifierFunction != null) {
            return (Multimap)s.modifierFunction.apply((Object)stack, (Object)gem, (Object)slot, (Object)entity, (Object)uuid, modifiers);
        }
        return modifiers;
    }

    public static boolean appendTooltip(class_1799 stack, GemSlot gem, class_1309 wearer, class_1937 world, List<class_2561> list, class_1836 context) {
        Settings s = GemSlot.getSettings(gem.gemItem);
        if (s != null && s.tooltipFunction != null) {
            return (Boolean)s.tooltipFunction.apply((Object)stack, (Object)gem, (Object)wearer, (Object)world, list, (Object)context);
        }
        return false;
    }

    public static boolean itemIsGem(class_1799 item) {
        return item.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Geomancy.locate("jewelry_gems")));
    }

    public static float getGemDifficulty(class_1799 item) {
        Settings settings = GemSlot.getSettings(item.method_7909());
        if (settings != null) {
            return settings.difficulty;
        }
        return 1.0f;
    }

    public static float getGemProgressCost(class_1799 item) {
        Settings settings = GemSlot.getSettings(item.method_7909());
        if (settings != null) {
            return settings.progressCost;
        }
        return 0.0f;
    }

    private class_2561 getQualityString(class_1799 stack, class_1309 wearer) {
        class_124 formatting = class_124.field_1079;
        int qualityPercent = Math.round(this.quality * 100.0f);
        int effectiveQualityPercent = Math.round(this.getEffectiveQuality(stack, wearer) * 100.0f);
        if (qualityPercent > 100) {
            formatting = class_124.field_1076;
        } else if (qualityPercent > 80) {
            formatting = class_124.field_1060;
        } else if (qualityPercent > 60) {
            formatting = class_124.field_1054;
        } else if (qualityPercent > 40) {
            formatting = class_124.field_1065;
        } else if (qualityPercent > 20) {
            formatting = class_124.field_1061;
        }
        class_5250 effectiveText = class_2561.method_43473();
        if (effectiveQualityPercent != qualityPercent) {
            effectiveText = class_2561.method_43470((String)(" (" + effectiveQualityPercent + "%)")).method_27692(effectiveQualityPercent > qualityPercent ? class_124.field_1076 : class_124.field_1061);
        }
        return class_2561.method_43470((String)Integer.toString(qualityPercent)).method_27693("%").method_27692(formatting).method_10852((class_2561)effectiveText);
    }

    public float getXPMultiplier(class_1799 parent, class_1309 wearer) {
        float res = 0.0f;
        if (this.gemItem == class_1802.field_8759) {
            res += this.getEffectiveQuality(parent, wearer);
        }
        return res;
    }

    public float getFortuneBonus(class_1799 parent, class_1309 wearer) {
        float res = 0.0f;
        if (this.gemItem == class_1802.field_8687) {
            res += 0.15f * this.getEffectiveQuality(parent, wearer);
        }
        return res;
    }

    public float getManaRegenMultiplier(class_1799 parent, class_1309 wearer) {
        float res = 0.0f;
        if (this.gemItem == class_1802.field_27063) {
            res += this.getEffectiveQuality(parent, wearer);
        }
        return res;
    }

    public float getManaCapacityMultiplier(class_1799 parent, class_1309 entity) {
        float res = 0.0f;
        if (this.gemItem == class_1802.field_38746) {
            res += this.getEffectiveQuality(parent, entity);
        }
        return res;
    }

    public static Multimap<class_1320, class_1322> addAndCombineModifier(Multimap<class_1320, class_1322> modifiers, class_1322 newMod, class_1320 attribute) {
        boolean added = false;
        if (modifiers.containsKey((Object)attribute)) {
            for (class_1322 mod : modifiers.get((Object)attribute).stream().toList()) {
                if (!mod.equals((Object)newMod)) continue;
                modifiers.replaceValues((Object)attribute, modifiers.get((Object)attribute).stream().map(entityAttributeModifier -> {
                    if (mod.equals((Object)newMod)) {
                        return new class_1322(newMod.method_6189(), newMod.method_6185(), mod.method_6186() + newMod.method_6186(), newMod.method_6182());
                    }
                    return entityAttributeModifier;
                }).toList());
                added = true;
                break;
            }
        }
        if (!added) {
            modifiers.put((Object)attribute, (Object)newMod);
        }
        return modifiers;
    }

    static {
        GemSlot.register(Settings.create(class_1802.field_8477).setColor(0.0f, 1.0f, 1.0f).setDifficulty(10).setProgressCost(10).withGenericTooltip(q -> GemSlot.QualityRounded(q.floatValue() * 2.0f)).setModifier((Function6<class_1799, GemSlot, SlotReference, class_1309, UUID, Multimap<class_1320, class_1322>, Multimap<class_1320, class_1322>>)((Function6)(itemStack, gemSlot, slotReference, livingEntity, uuid, modifiers) -> {
            if (IJewelryItem.isPendant(itemStack)) {
                return modifiers;
            }
            float value = 2.0f * gemSlot.getEffectiveQuality((class_1799)itemStack, (class_1309)livingEntity);
            return GemSlot.addAndCombineModifier((Multimap<class_1320, class_1322>)modifiers, new class_1322(uuid, "geomancy:jewelry_diamond_gem_armor", (double)value, class_1322.class_1323.field_6328), class_5134.field_23724);
        })));
        GemSlot.register(Settings.create(class_1802.field_8687).setColor(0.0f, 1.0f, 0.0f).setDifficulty(15).setProgressCost(10).withGenericTooltip(q -> GemSlot.QualityRounded(q.floatValue() * 0.15f, 1)));
        GemSlot.register(Settings.create(class_1802.field_8759).setColor(0.0f, 0.0f, 1.0f).setDifficulty(10).setProgressCost(10).withGenericTooltip(GemSlot::QualityPercent));
        GemSlot.register(Settings.create(ModItems.TOURMALINE).setColor(16723265).setDifficulty(10).setProgressCost(10).withGenericTooltip(q -> GemSlot.QualityPercent(q.floatValue() * 0.1f)).setModifier((Function6<class_1799, GemSlot, SlotReference, class_1309, UUID, Multimap<class_1320, class_1322>, Multimap<class_1320, class_1322>>)((Function6)(itemStack, gemSlot, slotReference, livingEntity, uuid, modifiers) -> {
            if (IJewelryItem.isPendant(itemStack)) {
                return modifiers;
            }
            float value = 0.1f * gemSlot.getEffectiveQuality((class_1799)itemStack, (class_1309)livingEntity);
            return GemSlot.addAndCombineModifier((Multimap<class_1320, class_1322>)modifiers, new class_1322(uuid, "geomancy:jewelry_tourmaline_speed", (double)value, class_1322.class_1323.field_6331), class_5134.field_23719);
        })));
        GemSlot.register(Settings.create(ModItems.ORTHOCLASE).setColor(9467997).setDifficulty(10).setProgressCost(10).withGenericTooltip(GemSlot::QualityPercent));
        GemSlot.register(Settings.create(ModItems.PERIDOT).setColor(15069296).setDifficulty(10).setProgressCost(10).withGenericTooltip(GemSlot::QualityPercent));
        GemSlot.register(Settings.create(ModItems.AXINITE).setColor(11433553).setDifficulty(10).setProgressCost(10).withGenericTooltip(q -> GemSlot.QualityPercent(q.floatValue() * 0.1f)).setModifier((Function6<class_1799, GemSlot, SlotReference, class_1309, UUID, Multimap<class_1320, class_1322>, Multimap<class_1320, class_1322>>)((Function6)(itemStack, gemSlot, slotReference, livingEntity, uuid, modifiers) -> {
            if (IJewelryItem.isPendant(itemStack)) {
                return modifiers;
            }
            float value = 0.1f * gemSlot.getEffectiveQuality((class_1799)itemStack, (class_1309)livingEntity);
            return GemSlot.addAndCombineModifier((Multimap<class_1320, class_1322>)modifiers, new class_1322(uuid, "geomancy:jewelry_axinite_mining_speed", (double)value, class_1322.class_1323.field_6331), AdditionalEntityAttributes.DIG_SPEED);
        })));
        GemSlot.register(Settings.create(class_1802.field_27063).setColor(9267916).setDifficulty(30).setProgressCost(30).withGenericTooltip(GemSlot::QualityPercent));
        GemSlot.register(Settings.create(class_1802.field_38746).setColor(675936).setDifficulty(45).setProgressCost(30).withGenericTooltip(GemSlot::QualityPercent));
        GemSlot.register(Settings.create(class_1802.field_8207).setColor(2070193).setDifficulty(20).setProgressCost(40).withGenericTooltip(GemSlot::QualityEmpty).withGenericStatusEffectFunction(class_1294.field_5923, 0.0f, 0.0f));
        GemSlot.register(Settings.create(class_1802.field_8301).setColor(12490196).setDifficulty(20).setProgressCost(40).withGenericTooltip(GemSlot::QualityEmpty).withGenericStatusEffectFunction(class_1294.field_5924, -1.0f, 0.01f));
        GemSlot.register(Settings.create(class_1802.field_8634).setColor(2458740).setDifficulty(20).setProgressCost(40).withGenericTooltip(GemSlot::QualityEmpty));
        GemSlot.register(Settings.create(class_1802.field_8434).setColor(2458740).setDifficulty(20).setProgressCost(40).withGenericTooltip(q -> GemSlot.QualityPercent(q.floatValue() * 0.15f)).setModifier((Function6<class_1799, GemSlot, SlotReference, class_1309, UUID, Multimap<class_1320, class_1322>, Multimap<class_1320, class_1322>>)((Function6)(itemStack, gemSlot, slotReference, livingEntity, uuid, modifiers) -> {
            if (IJewelryItem.isPendant(itemStack)) {
                return modifiers;
            }
            float value = 0.15f * gemSlot.getEffectiveQuality((class_1799)itemStack, (class_1309)livingEntity);
            return GemSlot.addAndCombineModifier((Multimap<class_1320, class_1322>)modifiers, new class_1322(uuid, "geomancy:jewelry_tourmaline_speed", (double)value, class_1322.class_1323.field_6331), AdditionalEntityAttributes.WATER_SPEED);
        })));
        GemSlot.register(Settings.create(class_1802.field_8449).setColor(7449673).setDifficulty(20).setProgressCost(40).withGenericTooltip(GemSlot::QualityEmpty));
        GemSlot.register(Settings.create(class_1802.field_8137).setColor(16646056).setDifficulty(60).setProgressCost(120).withGenericTooltip(GemSlot::QualityEmpty));
    }

    public static class Settings {
        public class_1792 item;
        public int difficulty = 0;
        public int progressCost = 0;
        public int color = -1;
        public int lootWeight = 100;
        public Function4<class_1799, GemSlot, SlotReference, class_1309, Boolean> tickFunction = null;
        public Function4<class_1799, GemSlot, SlotReference, class_1309, Boolean> equipFunction = null;
        public Function4<class_1799, GemSlot, SlotReference, class_1309, Boolean> unequipFunction = null;
        public Function6<class_1799, GemSlot, SlotReference, class_1309, UUID, Multimap<class_1320, class_1322>, Multimap<class_1320, class_1322>> modifierFunction = null;
        public Function6<class_1799, GemSlot, class_1309, class_1937, List<class_2561>, class_1836, Boolean> tooltipFunction = null;

        private Settings() {
        }

        public Settings setDifficulty(int difficulty) {
            this.difficulty = difficulty;
            return this;
        }

        public Settings setProgressCost(int progressCost) {
            this.progressCost = progressCost;
            return this;
        }

        public Settings setColor(int color) {
            this.color = color;
            return this;
        }

        public Settings setColor(float r, float g, float b) {
            this.color = Toolbox.colorFromRGB(r, g, b);
            return this;
        }

        public Settings setTick(Function4<class_1799, GemSlot, SlotReference, class_1309, Boolean> f) {
            this.tickFunction = f;
            return this;
        }

        public Settings setEquip(Function4<class_1799, GemSlot, SlotReference, class_1309, Boolean> f) {
            this.equipFunction = f;
            return this;
        }

        public Settings setUnequip(Function4<class_1799, GemSlot, SlotReference, class_1309, Boolean> f) {
            this.unequipFunction = f;
            return this;
        }

        public Settings setModifier(Function6<class_1799, GemSlot, SlotReference, class_1309, UUID, Multimap<class_1320, class_1322>, Multimap<class_1320, class_1322>> f) {
            this.modifierFunction = f;
            return this;
        }

        public Settings setTooltip(Function6<class_1799, GemSlot, class_1309, class_1937, List<class_2561>, class_1836, Boolean> f) {
            this.tooltipFunction = f;
            return this;
        }

        public Settings setLootWeight(int lootWeight) {
            this.lootWeight = lootWeight;
            return this;
        }

        public Settings withGenericTooltip(Function<Float, String> qualityFunc) {
            return this.setTooltip((Function6<class_1799, GemSlot, class_1309, class_1937, List<class_2561>, class_1836, Boolean>)((Function6)(itemStack, gemSlot, wearer, world, texts, tooltipContext) -> {
                class_5250 gemText = class_2561.method_43471((String)gemSlot.gemItem.method_7876());
                gemText.method_10862(gemText.method_10866().method_36139(gemSlot.getColor()));
                texts.add(class_2561.method_43471((String)"tooltip.geomancy.jewelry.quality").method_27692(class_124.field_1075).method_27693(" ").method_10852(gemSlot.getQualityString((class_1799)itemStack, (class_1309)wearer)).method_27693(" ").method_10852((class_2561)gemText));
                if (!IJewelryItem.isPendant(itemStack)) {
                    texts.add(class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43469((String)("tooltip.geomancy.jewelry.gemeffect." + class_7923.field_41178.method_10221((Object)gemSlot.gemItem).method_12832()), (Object[])new Object[]{qualityFunc.apply(Float.valueOf(gemSlot.getEffectiveQuality((class_1799)itemStack, (class_1309)wearer)))}).method_27692(class_124.field_1063)));
                }
                return true;
            }));
        }

        public Settings withGenericStatusEffectFunction(class_1291 effect, float baseStrength, float strengthPerQuality) {
            Function4 f = (stack, gem, slot, ent) -> {
                ent.method_6092(new class_1293(effect, 10, Math.round(baseStrength + strengthPerQuality * gem.getEffectiveQuality((class_1799)stack, (class_1309)ent)), false, false, true));
                return true;
            };
            this.setTick((Function4<class_1799, GemSlot, SlotReference, class_1309, Boolean>)f);
            return this;
        }

        public Settings setItem(class_1792 item) {
            this.item = item;
            return this;
        }

        public static Settings create(class_1792 item) {
            return new Settings().setItem(item);
        }
    }
}

