/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.jewelry;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.items.jewelry.GemSlot;
import org.oxytocina.geomancy.items.jewelry.IJewelryItem;
import org.oxytocina.geomancy.items.jewelry.JewelryItemSettings;

public class JewelryArmorItem
extends class_1738
implements IJewelryItem {
    private static final EnumMap<class_1738.class_8051, UUID> MODIFIERS = (EnumMap)class_156.method_654(new EnumMap(class_1738.class_8051.class), uuidMap -> {
        uuidMap.put(class_1738.class_8051.field_41937, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A59B6B"));
        uuidMap.put(class_1738.class_8051.field_41936, UUID.fromString("D8499B04-0E66-4726-AB29-64469D744E0D"));
        uuidMap.put(class_1738.class_8051.field_41935, UUID.fromString("9F3D476D-C118-4544-8365-64846905B48E"));
        uuidMap.put(class_1738.class_8051.field_41934, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BC150"));
    });
    public final int gemSlotCount;
    private final JewelryItemSettings jewelrySettings;
    public static final HashMap<class_1799, class_1309> wearerMap = new HashMap();

    public JewelryArmorItem(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 settings, JewelryItemSettings jewelryItemSettings) {
        super(material, type, settings);
        this.gemSlotCount = jewelryItemSettings.gemSlotCount;
        List.add(this);
        this.jewelrySettings = jewelryItemSettings;
    }

    @Override
    public int getGemSlotCount() {
        return this.gemSlotCount;
    }

    @Override
    public JewelryItemSettings getSettings() {
        return this.jewelrySettings;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 le = (class_1309)entity;
        wearerMap.put(stack, le);
        if (le instanceof class_1657) {
            class_1657 pe = (class_1657)le;
            if (stack.method_7909() == this && pe.method_6118(this.method_7685()) == stack) {
                ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
                for (GemSlot gem : gems) {
                    GemSlot.tick(stack, gem, null, le);
                }
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1271 res = super.method_7836(world, user, hand);
        if (res.method_5467().method_23665()) {
            JewelryArmorItem arI;
            class_1792 class_17922 = ((class_1799)res.method_5466()).method_7909();
            if (class_17922 instanceof JewelryArmorItem) {
                arI = (JewelryArmorItem)class_17922;
                arI.onUnequip((class_1799)res.method_5466(), (class_1309)user);
            }
            if ((class_17922 = user.method_5998(hand).method_7909()) instanceof JewelryArmorItem) {
                arI = (JewelryArmorItem)class_17922;
                arI.onEquip(user.method_5998(hand), (class_1309)user);
            }
        }
        return res;
    }

    public void onEquip(class_1799 stack, class_1309 entity) {
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            GemSlot.equip(stack, gem, null, entity);
        }
    }

    public void onUnequip(class_1799 stack, class_1309 entity) {
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            GemSlot.unequip(stack, gem, null, entity);
        }
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        return slot == this.field_41933.method_48399() ? this.getAttributeModifiers(stack) : super.method_7844(slot);
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack) {
        Multimap<class_1320, class_1322> modifiers = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        for (Map.Entry e : this.field_23741.entries()) {
            modifiers.put((Object)((class_1320)e.getKey()), (Object)((class_1322)e.getValue()));
        }
        ArrayList<GemSlot> gems = IJewelryItem.getSlots(stack);
        for (GemSlot gem : gems) {
            modifiers = GemSlot.modifyModifiers(stack, gem, null, JewelryArmorItem.getWearer(stack), MODIFIERS.get(this.field_41933), modifiers);
        }
        return modifiers;
    }

    public static class_1309 getWearer(class_1799 stack) {
        return wearerMap.get(stack);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 context) {
        ArrayList<GemSlot> gems;
        if (this.isPendant()) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.geomancy.jewelry.pendant1").method_27692(class_124.field_1063));
            list.add((class_2561)class_2561.method_43471((String)"tooltip.geomancy.jewelry.pendant2").method_27692(class_124.field_1063));
        }
        boolean hasGems = !(gems = IJewelryItem.getSlots(stack)).isEmpty();
        class_746 wearer = class_310.method_1551().field_1724;
        ArrayList<ArrayList<class_2561>> tooltips = new ArrayList<ArrayList<class_2561>>();
        for (GemSlot gem : gems) {
            ArrayList<class_2561> arrayList = new ArrayList<class_2561>();
            GemSlot.appendTooltip(stack, gem, (class_1309)wearer, world, arrayList, context);
            if (arrayList.isEmpty()) continue;
            tooltips.add(arrayList);
        }
        ArrayList<class_3545> textsCounted = new ArrayList<class_3545>();
        for (List list2 : tooltips) {
            boolean sortedIn = false;
            for (int i = 0; i < textsCounted.size(); ++i) {
                if (!((List)((class_3545)textsCounted.get(i)).method_15442()).stream().findFirst().equals(list2.stream().findFirst())) continue;
                ((class_3545)textsCounted.get(i)).method_34965((Object)((Integer)((class_3545)textsCounted.get(i)).method_15441() + 1));
                sortedIn = true;
                break;
            }
            if (sortedIn) continue;
            textsCounted.add(new class_3545((Object)list2, (Object)1));
        }
        for (class_3545 class_35452 : textsCounted) {
            int amount = (Integer)class_35452.method_15441();
            List texts = (List)class_35452.method_15442();
            for (class_2561 t : texts) {
                list.add((class_2561)class_2561.method_43470((String)(amount > 1 ? "x" + amount + " " : "")).method_27692(class_124.field_1054).method_10852(t));
            }
        }
        if (!hasGems) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.geomancy.jewelry.nogems").method_27692(class_124.field_1063));
        }
        if (stack.method_7985() && stack.method_7969().method_10573("preview", 1) && stack.method_7969().method_10577("preview")) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.geomancy.jewelry.unsmith").method_27692(class_124.field_1077));
        }
        super.method_7851(stack, world, list, context);
    }
}

