/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.jewelry;

import dev.emi.trinkets.api.SlotReference;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.items.ICustomRarityItem;
import org.oxytocina.geomancy.items.IMaddeningItem;
import org.oxytocina.geomancy.items.ISoulStoringItem;
import org.oxytocina.geomancy.items.jewelry.IJewelryItem;
import org.oxytocina.geomancy.items.jewelry.JewelryItem;
import org.oxytocina.geomancy.items.jewelry.JewelryItemSettings;
import org.oxytocina.geomancy.util.MadnessUtil;
import org.oxytocina.geomancy.util.SoulUtil;

public class OctanguliteJewelryItem
extends JewelryItem
implements ISoulStoringItem,
IMaddeningItem,
ICustomRarityItem {
    public float baseSoulCapacity;
    public float maddeningSpeed;
    public float maddeningSpeedWorn;

    public OctanguliteJewelryItem(class_1792.class_1793 settings, JewelryItemSettings jewelryItemSettings, float baseSoulCapacity, float maddeningSpeed, float maddeningSpeedWorn) {
        super(settings, jewelryItemSettings);
        this.baseSoulCapacity = baseSoulCapacity;
        this.maddeningSpeed = maddeningSpeed;
        this.maddeningSpeedWorn = maddeningSpeedWorn;
    }

    @Override
    public float getCapacity(class_1937 world, class_1799 stack) {
        class_1309 wearer = null;
        class_1297 class_12972 = stack.method_27319();
        if (class_12972 instanceof class_1309) {
            class_1309 le;
            wearer = le = (class_1309)class_12972;
        }
        return this.baseSoulCapacity * this.getCapacityMultiplier(world, stack, wearer) * this.getCapacityMultiplier(stack);
    }

    @Override
    public float getRechargeSpeedMultiplier(class_1937 world, class_1799 stack, class_1309 entity) {
        return IJewelryItem.getManaRegenMultiplier(stack, entity);
    }

    public float getCapacityMultiplier(class_1937 world, class_1799 stack, class_1309 entity) {
        return IJewelryItem.getManaCapacityMultiplier(stack, entity);
    }

    @Override
    public float getBaseSoulCapacity(class_1799 stack) {
        return this.baseSoulCapacity;
    }

    @Override
    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onEquip(stack, slot, entity);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            SoulUtil.queueRecalculateSoul((class_1657)player);
            MadnessUtil.queueRecalculateMadnessSpeed((class_1657)player);
        }
    }

    @Override
    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onUnequip(stack, slot, entity);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            SoulUtil.queueRecalculateSoul((class_1657)player);
            MadnessUtil.queueRecalculateMadnessSpeed((class_1657)player);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31571(class_1799 stack) {
        return ((ISoulStoringItem)stack.method_7909()).getBarColor(stack);
    }

    @Environment(value=EnvType.CLIENT)
    public int method_31569(class_1799 stack) {
        if (class_310.method_1551() == null) {
            return 0;
        }
        class_638 world = class_310.method_1551().field_1687;
        return Math.round(this.getMana((class_1937)world, stack) * 13.0f / this.getCapacity((class_1937)world, stack));
    }

    @Override
    public float getInInventoryMaddeningSpeed() {
        return this.maddeningSpeed;
    }

    @Override
    public float getWornMaddeningSpeed() {
        return this.maddeningSpeedWorn;
    }

    public class_2561 method_7864(class_1799 stack) {
        return this.colorizeName(stack, super.method_7864(stack));
    }

    @Override
    public ICustomRarityItem.Rarity getRarity() {
        return ICustomRarityItem.Rarity.Octangulite;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 context) {
        super.method_7851(stack, world, list, context);
        ISoulStoringItem.super.addManaTooltip(world, stack, list);
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_7843(stack, world, player);
        ISoulStoringItem.init(world, stack);
    }
}

