/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.items.ICustomRarityItem;
import org.oxytocina.geomancy.items.ISoulStoringItem;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.items.tools.StorageItem;
import org.oxytocina.geomancy.registries.ModItemTags;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.util.Toolbox;

public class SoulBoreItem
extends StorageItem
implements ISoulStoringItem,
ICustomRarityItem {
    public static final HashMap<class_1792, Float> fuelItems = new HashMap();
    public static final float INGOT_FUEL_VALUE = 10000.0f;

    public static void registerFuel(class_1792 item, float fuel) {
        fuelItems.put(item, Float.valueOf(fuel));
    }

    public static float getFuel(class_1792 item) {
        if (SoulBoreItem.isFuel(item)) {
            return fuelItems.get(item).floatValue();
        }
        return 0.0f;
    }

    public static boolean isFuel(class_1792 item) {
        return fuelItems.containsKey(item);
    }

    public static void register() {
    }

    @Override
    public int depletionPriority(class_1799 stack) {
        return 5;
    }

    public SoulBoreItem(class_1792.class_1793 settings, int storageSize) {
        super(settings, storageSize, ModItemTags.FITS_IN_SOUL_BORE, false);
    }

    @Override
    public float getMana(class_1937 world, class_1799 stack) {
        float res = this.getLeftoverMana(stack);
        ArrayList<class_1799> fuels = this.getContainedSoulFuelItems(stack);
        for (class_1799 fuel : fuels) {
            res += SoulBoreItem.getFuel(fuel.method_7909()) * (float)fuel.method_7947();
        }
        return res;
    }

    public float getLeftoverMana(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("leftover")) {
            return 0.0f;
        }
        return nbt.method_10583("leftover");
    }

    public float getLeftoverManaCap(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("leftoverCap")) {
            return 0.0f;
        }
        return nbt.method_10583("leftoverCap");
    }

    public void setLeftoverMana(class_1799 stack, float amount) {
        stack.method_7948().method_10548("leftover", amount);
    }

    public void setLeftoverManaCap(class_1799 stack, float amount) {
        stack.method_7948().method_10548("leftoverCap", amount);
    }

    public void setFuelStackInUse(class_1799 stack, class_1799 fuel) {
        stack.method_7948().method_10582("fuel", class_7923.field_41178.method_10221((Object)fuel.method_7909()).toString());
    }

    public class_1799 getFuelStackInUse(class_1799 stack) {
        class_2960 id = class_2960.method_12829((String)stack.method_7948().method_10558("fuel"));
        if (id == null) {
            return null;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
        return new class_1799((class_1935)item);
    }

    @Override
    public void takeSoul(class_1937 world, class_1799 stack, float amount, @Nullable SpellContext ctx) {
        float taken;
        float leftOvers = this.getLeftoverMana(stack);
        if ((amount -= (taken = Math.min(leftOvers, amount))) <= 0.0f) {
            this.setLeftoverMana(stack, leftOvers - taken);
            return;
        }
        ArrayList<class_1799> fuels = this.getContainedSoulFuelItems(stack);
        for (int i = 0; i < fuels.size() && !(amount <= 0.0f); amount -= taken, ++i) {
            class_1799 fuelStack = fuels.get(i);
            do {
                float newFuel = SoulBoreItem.getFuel(fuelStack.method_7909());
                this.setFuelStackInUse(stack, fuelStack);
                this.setLeftoverManaCap(stack, newFuel);
                leftOvers = newFuel;
                taken = Math.min(leftOvers, amount);
                leftOvers -= taken;
                fuelStack.method_7934(1);
            } while (!(amount <= 0.0f) && !fuelStack.method_7960());
        }
        this.onTakenFuel(world, ctx);
        this.setLeftoverMana(stack, leftOvers);
        this.markDirty(stack);
    }

    public void onTakenFuel(class_1937 world, @Nullable SpellContext ctx) {
        if (ctx == null) {
            return;
        }
        Toolbox.playSound(class_3417.field_14562, world, ctx.getOriginBlockPos(), ctx.getSoundCategory(), 0.5f, Toolbox.randomPitch());
    }

    @Override
    public float getCapacity(class_1937 world, class_1799 stack) {
        return this.getMana(world, stack);
    }

    public ArrayList<class_1799> getContainedSoulFuelItems(class_1799 stack) {
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        for (int i = 0; i < this.getSize(stack); ++i) {
            class_1799 cont = this.getStack(stack, i);
            if (cont.method_7960() || !SoulBoreItem.isFuel(cont.method_7909())) continue;
            res.add(cont);
        }
        return res;
    }

    @Override
    public boolean autocollects() {
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.soul_bore.tooltip").method_27692(class_124.field_1080));
        float manaTotal = this.getMana(world, stack);
        tooltip.add((class_2561)class_2561.method_43469((String)"geomancy.soul_bore.tooltip.2", (Object[])new Object[]{class_2561.method_43470((String)Toolbox.formatNumber(manaTotal))}).method_27692(class_124.field_1080));
        class_1799 fuelStack = this.getFuelStackInUse(stack);
        if (!fuelStack.method_7960()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"geomancy.soul_bore.tooltip.1", (Object[])new Object[]{fuelStack.method_7964()}).method_27692(class_124.field_1080));
        }
    }

    @Override
    public float getBaseSoulCapacity(class_1799 stack) {
        return 0.0f;
    }

    public class_2561 method_7864(class_1799 stack) {
        return (class_5250)this.colorizeName(stack, (class_2561)class_2561.method_43471((String)this.method_7866(stack)));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_7876());
    }

    @Override
    public ICustomRarityItem.Rarity getRarity() {
        return ICustomRarityItem.Rarity.Octangulite;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31571(class_1799 stack) {
        return ((ISoulStoringItem)stack.method_7909()).getBarColor(stack);
    }

    @Environment(value=EnvType.CLIENT)
    public int method_31569(class_1799 stack) {
        if (class_310.method_1551() == null) {
            return 0;
        }
        float cap = this.getLeftoverManaCap(stack);
        if (cap <= 0.0f) {
            return 0;
        }
        float mana = this.getLeftoverMana(stack);
        return (int)(mana / cap * 13.0f);
    }

    @Override
    public class_3414 getOpenSound() {
        return class_3417.field_15134;
    }

    @Override
    public class_3414 getCloseSound() {
        return class_3417.field_15228;
    }

    static {
        SoulBoreItem.registerFuel(ModItems.OCTANGULITE_INGOT, 10000.0f);
        SoulBoreItem.registerFuel(ModItems.RAW_OCTANGULITE, 9000.0f);
        SoulBoreItem.registerFuel(ModItems.OCTANGULITE_NUGGET, 1111.1111f);
        SoulBoreItem.registerFuel(ModBlocks.OCTANGULITE_BLOCK.method_8389(), 90000.0f);
        SoulBoreItem.registerFuel(ModBlocks.RAW_OCTANGULITE_BLOCK.method_8389(), 90000.0f);
    }
}

