/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.tools;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.items.ICustomRarityItem;
import org.oxytocina.geomancy.items.IScrollListenerItem;
import org.oxytocina.geomancy.items.ISoulStoringItem;
import org.oxytocina.geomancy.items.ISpellSelectorItem;
import org.oxytocina.geomancy.items.SpellStoringItem;
import org.oxytocina.geomancy.items.tools.StorageItem;
import org.oxytocina.geomancy.networking.ModMessages;
import org.oxytocina.geomancy.registries.ModItemTags;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.spells.SpellGrid;
import org.oxytocina.geomancy.util.Toolbox;

public class SoulCastingItem
extends StorageItem
implements ISoulStoringItem,
IScrollListenerItem,
ICustomRarityItem,
ISpellSelectorItem {
    public final float internalSoulStorage;
    public final float rechargeSpeedMultiplier;
    public boolean tempOpenStorageScreenOverride = false;

    public SoulCastingItem(class_1792.class_1793 settings, int storageSize, float internalSoulStorage, float rechargeSpeedMultiplier) {
        super(settings, storageSize, ModItemTags.FITS_IN_CASTERS, false);
        this.internalSoulStorage = internalSoulStorage;
        this.rechargeSpeedMultiplier = rechargeSpeedMultiplier;
    }

    @Override
    public boolean autocollects() {
        return false;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236) {
            if (user.method_5715()) {
                if (user instanceof class_3222) {
                    class_3222 sp = (class_3222)user;
                    class_1799 stack = user.method_5998(hand);
                    sp.method_17355((class_3908)((SoulCastingItem)stack.method_7909()));
                }
            } else {
                this.cast(user.method_5998(hand), (class_1309)user);
            }
        }
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    public void cast(class_1799 key, class_1309 user) {
        int index = this.getSelectedSpellIndex(key);
        ArrayList spells = this.getCastableSpellItems(key);
        if (spells.isEmpty()) {
            return;
        }
        class_1799 spellContainer = (class_1799)spells.get(index);
        class_1792 class_17922 = spellContainer.method_7909();
        if (!(class_17922 instanceof SpellStoringItem)) {
            return;
        }
        SpellStoringItem storer = (SpellStoringItem)class_17922;
        storer.cast(key, spellContainer, user, SpellBlockArgs.empty(), SpellContext.SoundBehavior.Full, false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int selectedSpellIndex = this.getSelectedSpellIndex(stack);
        ArrayList spells = this.getCastableSpellItems(stack);
        if (!spells.isEmpty()) {
            selectedSpellIndex %= spells.size();
            for (int i = 0; i < spells.size(); ++i) {
                class_1799 spell = (class_1799)spells.get(i);
                SpellGrid grid = SpellStoringItem.readGrid(spell);
                String selectedString = "  ";
                if (selectedSpellIndex == i) {
                    selectedString = "> ";
                }
                tooltip.add((class_2561)class_2561.method_43470((String)selectedString).method_27692(class_124.field_1062).method_10852((class_2561)(grid == null ? class_2561.method_43471((String)"geomancy.spellstorage.empty").method_27692(class_124.field_1063) : (grid.name == "" ? class_2561.method_43471((String)"geomancy.spellstorage.unnamed").method_27692(class_124.field_1080) : class_2561.method_43470((String)grid.name).method_27692(class_124.field_1080)))));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.caster.emptyhint1").method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.caster.emptyhint2").method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.caster.emptyhint3").method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.caster.emptyhint4").method_27692(class_124.field_1063));
        }
        ISoulStoringItem.super.addManaTooltip(world, stack, tooltip);
    }

    @Override
    public float getBaseSoulCapacity(class_1799 stack) {
        return this.internalSoulStorage;
    }

    @Override
    public float getRechargeSpeedMultiplier(class_1937 world, class_1799 stack, class_1309 entity) {
        return this.rechargeSpeedMultiplier * ISoulStoringItem.super.getRechargeSpeedMultiplier(world, stack, entity);
    }

    public class_2561 method_7864(class_1799 stack) {
        ArrayList spells = this.getCastableSpellItems(stack);
        class_5250 spellText = null;
        if (spells.isEmpty()) {
            spellText = class_2561.method_43471((String)"geomancy.caster.nospells").method_27692(class_124.field_1061);
        } else {
            int nextIndex = this.getSelectedSpellIndex(stack);
            class_1799 spellItem = (class_1799)spells.get(nextIndex);
            SpellGrid grid = SpellStoringItem.readGrid(spellItem);
            class_5250 indexText = class_2561.method_43470((String)(nextIndex + 1 + "/" + spells.size() + "/" + this.getStorageSize(stack) + ": ")).method_27692(class_124.field_1080);
            spellText = grid == null ? indexText.method_10852((class_2561)class_2561.method_43471((String)"geomancy.spellstorage.empty").method_27692(class_124.field_1080)) : indexText.method_10852((class_2561)grid.getName().method_27692(class_124.field_1062));
        }
        return ((class_5250)this.colorizeName(stack, (class_2561)class_2561.method_43471((String)this.method_7866(stack)))).method_10852((class_2561)class_2561.method_43470((String)" [").method_10852((class_2561)spellText).method_27693("]").method_27692(class_124.field_1080));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean onScrolled(class_1799 stack, float delta, class_1657 player) {
        if (!player.method_5715()) {
            return false;
        }
        int dir = -Toolbox.sign(delta);
        int nextIndex = this.getSelectedSpellIndex(stack) + dir;
        this.setSelectedSpellIndex(stack, nextIndex);
        nextIndex = this.getSelectedSpellIndex(stack);
        this.displaySelectedSpell(stack, player, nextIndex);
        class_2540 data = PacketByteBufs.create();
        int slot = -1;
        int i = 0;
        for (class_1799 item : player.method_5877()) {
            if (item == stack) {
                slot = i == 0 ? player.method_31548().field_7545 : 40;
                break;
            }
            ++i;
        }
        data.method_10793(stack);
        data.writeInt(slot);
        data.writeInt(nextIndex);
        ClientPlayNetworking.send((class_2960)ModMessages.CASTER_CHANGE_SELECTED_SPELL, (class_2540)data);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void displaySelectedSpell(class_1799 stack, class_1657 player, int index) {
        ArrayList spells = this.getCastableSpellItems(stack);
        if (spells.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"geomancy.caster.nospells").method_27692(class_124.field_1061), true);
        } else {
            class_1799 spellItem = (class_1799)spells.get(index);
            SpellGrid grid = SpellStoringItem.readGrid(spellItem);
            class_5250 indexText = class_2561.method_43470((String)(index + 1 + "/" + spells.size() + "/" + this.getStorageSize(stack) + ": ")).method_27692(class_124.field_1080);
            if (grid == null) {
                player.method_7353((class_2561)indexText.method_10852((class_2561)class_2561.method_43471((String)"geomancy.spellstorage.empty").method_27692(class_124.field_1080)), true);
            } else {
                player.method_7353((class_2561)indexText.method_10852((class_2561)grid.getName().method_27692(class_124.field_1062)), true);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_746 player;
        super.method_7888(stack, world, entity, slot, selected);
        if (selected && entity instanceof class_746 && (player = (class_746)entity).method_5715()) {
            this.displaySelectedSpell(stack, (class_1657)player, this.getSelectedSpellIndex(stack));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldBlockScrolling(class_1799 stack, class_1657 player) {
        return player.method_5715();
    }

    @Override
    public class_2561 method_5476() {
        return this.method_7848();
    }

    @Override
    public ICustomRarityItem.Rarity getRarity() {
        return ICustomRarityItem.Rarity.None;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        ISpellSelectorItem sps;
        ArrayList<class_1799> castables;
        class_1799 stack = player.method_5998(player.method_6058());
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof StorageItem)) {
            return null;
        }
        StorageItem sci = (StorageItem)class_17922;
        if (this.tempOpenStorageScreenOverride) {
            return super.createMenu(syncId, playerInventory, player);
        }
        class_1792 class_17923 = stack.method_7909();
        if (class_17923 instanceof ISpellSelectorItem && (castables = (sps = (ISpellSelectorItem)class_17923).getCastableSpellItems(stack)).isEmpty()) {
            return super.createMenu(syncId, playerInventory, player);
        }
        if (player instanceof class_3222) {
            class_3222 spe = (class_3222)player;
            class_2540 buf = PacketByteBufs.create();
            buf.method_10793(stack);
            buf.writeInt(playerInventory.method_7395(stack));
            ServerPlayNetworking.send((class_3222)spe, (class_2960)ModMessages.OPEN_SPELL_SELECT_SCREEN, (class_2540)buf);
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onSpellChanged(class_1799 stack, class_746 player, int spellIndex) {
        this.displaySelectedSpell(stack, (class_1657)player, spellIndex);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_31567(class_1799 stack) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public int method_31571(class_1799 stack) {
        return ((ISoulStoringItem)stack.method_7909()).getBarColor(stack);
    }

    @Environment(value=EnvType.CLIENT)
    public int method_31569(class_1799 stack) {
        if (class_310.method_1551() == null) {
            return 0;
        }
        class_638 world = class_310.method_1551().field_1687;
        return Math.round(this.getMana((class_1937)world, stack) * 13.0f / this.getCapacity((class_1937)world, stack));
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int method_7837() {
        return 14;
    }

    @Override
    public class_3414 getOpenSound() {
        return class_3417.field_15082;
    }

    @Override
    public class_3414 getCloseSound() {
        return class_3417.field_15131;
    }
}

