/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.client.screen.StorageItemScreenHandler;
import org.oxytocina.geomancy.inventories.ImplementedInventory;
import org.oxytocina.geomancy.items.IStorageItem;

public class StorageItem
extends class_1792
implements IStorageItem,
ExtendedScreenHandlerFactory {
    public int storageSize = 0;
    public final class_6862<class_1792> storableTag;
    public final boolean showContentsInTooltip;
    public final Function<class_1799, Boolean> collectablePredicate;

    public StorageItem(class_1792.class_1793 settings, int storageSize, class_6862<class_1792> storableTag, boolean showContentsInTooltip) {
        this(settings, storageSize, storableTag, showContentsInTooltip, a -> true);
    }

    public StorageItem(class_1792.class_1793 settings, int storageSize, class_6862<class_1792> storableTag, boolean showContentsInTooltip, Function<class_1799, Boolean> collectablePredicate) {
        super(settings);
        this.storageSize = storageSize;
        this.storableTag = storableTag;
        this.showContentsInTooltip = showContentsInTooltip;
        this.collectablePredicate = collectablePredicate;
    }

    @Override
    public class_6862<class_1792> getStorableTag() {
        return this.storableTag;
    }

    @Override
    public boolean autocollectsStack(class_1799 stack) {
        return this.collectablePredicate.apply(stack);
    }

    @Override
    public boolean autocollects() {
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236 && user instanceof class_3222) {
            class_3222 sp = (class_3222)user;
            class_1799 stack = user.method_5998(hand);
            sp.method_17355((class_3908)((StorageItem)stack.method_7909()));
        }
        return class_1271.method_29237((Object)user.method_5998(hand), (boolean)true);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.storage.tooltip").method_27692(class_124.field_1080));
        if (this.showContentsInTooltip) {
            this.appendContentsTooltip(stack, world, tooltip, context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void appendContentsTooltip(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        ArrayList<class_1799> containedStacks = this.getAllItems(stack);
        for (int i = 0; i < containedStacks.size(); ++i) {
            if (i >= 10) {
                tooltip.add((class_2561)class_2561.method_43469((String)"geomancy.storage_item.more", (Object[])new Object[]{containedStacks.size() - 10}).method_27692(class_124.field_1080));
                break;
            }
            class_1799 containedStack = containedStacks.get(i);
            tooltip.add((class_2561)class_2561.method_43470((String)"").method_10852(containedStack.method_7964()).method_27693((String)(containedStack.method_7947() >= 0 ? " x " + containedStack.method_7947() : "")).method_27692(class_124.field_1080));
        }
    }

    public ArrayList<class_1799> getAllItems(class_1799 stack) {
        if (!(stack.method_7909() instanceof StorageItem)) {
            return null;
        }
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        for (int i = 0; i < this.getSize(stack); ++i) {
            class_1799 item = this.getStack(stack, i);
            if (item == null || item.method_7960()) continue;
            res.add(item);
        }
        return res;
    }

    public class_2561 method_5476() {
        return this.method_7848();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        class_1799 stack = player.method_5998(player.method_6058());
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof StorageItem)) {
            return null;
        }
        StorageItem sci = (StorageItem)class_17922;
        return new StorageItemScreenHandler(syncId, playerInventory, stack, this.getStorableTag(), new class_3913(){

            public int method_17390(int index) {
                switch (index) {
                    default: 
                }
                return 0;
            }

            public void method_17391(int index, int value) {
            }

            public int method_17389() {
                return 3;
            }
        });
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        class_1799 stack = serverPlayerEntity.method_5998(serverPlayerEntity.method_6058());
        packetByteBuf.writeInt(serverPlayerEntity.method_31548().method_7395(stack));
        packetByteBuf.method_10812(this.getStorableTag().comp_327());
    }

    @Override
    public class_2371<class_1799> readInventoryFromNbt(class_1799 stack) {
        class_2371 stacks = class_2371.method_10213((int)this.storageSize, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)stack.method_7948(), (class_2371)stacks);
        return stacks;
    }

    @Override
    public void saveInventoryToNbt(class_1799 stack) {
        stack.method_7948().method_10551("Items");
        class_1262.method_5426((class_2487)stack.method_7948(), this.getItems(stack));
        this.clearCache(stack);
    }

    @Override
    public int getStorageSize(class_1799 stack) {
        return this.getSize(stack);
    }

    public void clearCache(class_1799 stack) {
        inventories.remove(stack);
        actualInventories.remove(stack);
    }

    @Override
    public void setInventory(class_1799 stack, class_2487 nbt) {
        this.clearCache(stack);
        stack.method_7959("Items", (class_2520)nbt.method_10554("Items", 10));
        this.clearCache(stack);
    }

    public int getSize(class_1799 stack) {
        return this.getItems(stack).size();
    }

    @Override
    public class_2371<class_1799> getItems(class_1799 stack) {
        if (inventories.containsKey(stack)) {
            return (class_2371)inventories.get(stack);
        }
        class_2371<class_1799> inv = this.readInventoryFromNbt(stack);
        inventories.put(stack, inv);
        return inv;
    }

    @Override
    public class_1263 getInventory(class_1799 stack) {
        return StorageItem.getInventoryStatic(stack);
    }

    public static class_1263 getInventoryStatic(class_1799 stack) {
        if (actualInventories.containsKey(stack)) {
            return (class_1263)actualInventories.get(stack);
        }
        ImplementedInventory inv = ImplementedInventory.of(((IStorageItem)stack.method_7909()).getItems(stack));
        actualInventories.put(stack, inv);
        return inv;
    }

    public int size(class_1799 key) {
        return this.getItems(key).size();
    }

    public boolean isEmpty(class_1799 key) {
        for (int i = 0; i < this.size(key); ++i) {
            class_1799 stack = this.getStack(key, i);
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 getStack(class_1799 key, int slot) {
        return (class_1799)this.getItems(key).get(slot);
    }

    public class_1799 removeStack(class_1799 key, int slot, int count) {
        class_1799 result = class_1262.method_5430(this.getItems(key), (int)slot, (int)count);
        if (!result.method_7960()) {
            this.markDirty(key);
        }
        return result;
    }

    public class_1799 removeStack(class_1799 key, int slot) {
        return class_1262.method_5428(this.getItems(key), (int)slot);
    }

    @Override
    public void setStack(class_1799 key, int slot, class_1799 stack) {
        this.getItems(key).set(slot, (Object)stack);
        if (stack.method_7947() > this.getMaxCountPerStack(key)) {
            stack.method_7939(this.getMaxCountPerStack(key));
        }
        this.markDirty(key);
    }

    protected int getMaxCountPerStack(class_1799 key) {
        return 64;
    }

    public void clear(class_1799 key) {
        this.getItems(key).clear();
    }

    @Override
    public void markDirty(class_1799 key) {
        this.saveInventoryToNbt(key);
    }

    @Override
    public class_3414 getOpenSound() {
        return class_3417.field_34375;
    }

    @Override
    public class_3414 getCloseSound() {
        return class_3417.field_34377;
    }

    @Override
    public class_3414 getCollectSound() {
        return class_3417.field_34376;
    }
}

