/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.items.trinkets;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.client.screen.StorageItemScreenHandler;
import org.oxytocina.geomancy.items.ICustomRarityItem;
import org.oxytocina.geomancy.items.ISoulStoringItem;
import org.oxytocina.geomancy.items.ISpellSelectorItem;
import org.oxytocina.geomancy.items.IStorageItem;
import org.oxytocina.geomancy.items.SpellStoringItem;
import org.oxytocina.geomancy.items.tools.StorageItem;
import org.oxytocina.geomancy.items.trinkets.ICastingTrinket;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.spells.SpellGrid;

public class CastingTrinketItem
extends TrinketItem
implements IStorageItem,
ExtendedScreenHandlerFactory,
ISoulStoringItem,
ICustomRarityItem,
ICastingTrinket,
ISpellSelectorItem {
    public int storageSize = 0;
    public final class_6862<class_1792> storableTag;
    public final boolean showContentsInTooltip;
    public static List<String> castableNames = List.of("auto", "1", "2", "3", "4", "5", "6", "7", "8", "9");

    public CastingTrinketItem(class_1792.class_1793 settings, int storageSize, class_6862<class_1792> storableTag, boolean showContentsInTooltip) {
        super(settings);
        this.storageSize = storageSize;
        this.storableTag = storableTag;
        this.showContentsInTooltip = showContentsInTooltip;
    }

    public static void tryCast(class_3222 player, int selected) {
        List allTrinkets = ((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).getAllEquipped();
        for (class_3545 e : allTrinkets) {
            class_1799 stack = (class_1799)e.method_15441();
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof ICastingTrinket)) continue;
            ICastingTrinket ct = (ICastingTrinket)class_17922;
            ct.tryCastOfHotkey(stack, player, selected);
        }
    }

    @Override
    public void tryCastOfHotkey(class_1799 stack, class_3222 player, int selected) {
        class_1799 storageStack = this.getSpellStorageStack(stack, Integer.toString(selected + 1));
        if (storageStack == null) {
            return;
        }
        class_1792 class_17922 = storageStack.method_7909();
        if (!(class_17922 instanceof SpellStoringItem)) {
            return;
        }
        SpellStoringItem storer = (SpellStoringItem)class_17922;
        storer.cast(stack, storageStack, (class_1309)player, SpellBlockArgs.empty(), SpellContext.SoundBehavior.Full, true);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_5715()) {
            if (user instanceof class_3222) {
                class_3222 sp = (class_3222)user;
                class_1799 stack = user.method_5998(hand);
                sp.method_17355((class_3908)((CastingTrinketItem)stack.method_7909()));
            }
            return class_1271.method_22428((Object)user.method_5998(hand));
        }
        return super.method_7836(world, user, hand);
    }

    public void cast(class_1799 key, class_1309 user, SpellBlockArgs args) {
        int index = this.getSpellIndexOfSpell(key, "auto");
        if (index < 0) {
            return;
        }
        ArrayList spells = this.getCastableSpellItems(key);
        if (spells.isEmpty()) {
            return;
        }
        class_1799 spellContainer = (class_1799)spells.get(index);
        class_1792 class_17922 = spellContainer.method_7909();
        if (!(class_17922 instanceof SpellStoringItem)) {
            return;
        }
        SpellStoringItem storer = (SpellStoringItem)class_17922;
        storer.cast(key, spellContainer, user, args, SpellContext.SoundBehavior.Reduced, false);
    }

    public class_2561 method_7864(class_1799 stack) {
        return this.colorizeName(stack, super.method_7864(stack));
    }

    @Override
    public ICustomRarityItem.Rarity getRarity() {
        return ICustomRarityItem.Rarity.Octangulite;
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        class_1799 stack = serverPlayerEntity.method_5998(serverPlayerEntity.method_6058());
        packetByteBuf.writeInt(serverPlayerEntity.method_31548().method_7395(stack));
        packetByteBuf.method_10812(this.getStorableTag().comp_327());
    }

    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        class_1799 stack = player.method_5998(player.method_6058());
        if (stack.method_7909() != this) {
            return null;
        }
        return new StorageItemScreenHandler(syncId, playerInventory, stack, this.getStorableTag(), new class_3913(){

            public int method_17390(int index) {
                switch (index) {
                    default: 
                }
                return 0;
            }

            public void method_17391(int index, int value) {
            }

            public int method_17389() {
                return 3;
            }
        });
    }

    @Override
    public float getBaseSoulCapacity(class_1799 stack) {
        return 0.0f;
    }

    @Override
    public class_2371<class_1799> readInventoryFromNbt(class_1799 stack) {
        class_2371 stacks = class_2371.method_10213((int)this.storageSize, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)stack.method_7948(), (class_2371)stacks);
        return stacks;
    }

    @Override
    public void saveInventoryToNbt(class_1799 stack) {
        stack.method_7948().method_10551("Items");
        class_1262.method_5426((class_2487)stack.method_7948(), this.getItems(stack));
        this.clearCache(stack);
    }

    @Override
    public int getStorageSize(class_1799 stack) {
        return this.getSize(stack);
    }

    @Override
    public class_1799 getStack(class_1799 key, int slot) {
        return (class_1799)this.getItems(key).get(slot);
    }

    public void clearCache(class_1799 stack) {
        inventories.remove(stack);
        actualInventories.remove(stack);
    }

    @Override
    public void setInventory(class_1799 stack, class_2487 nbt) {
        this.clearCache(stack);
        stack.method_7959("Items", (class_2520)nbt.method_10554("Items", 10));
        this.clearCache(stack);
    }

    public int getSize(class_1799 stack) {
        return this.getItems(stack).size();
    }

    @Override
    public class_2371<class_1799> getItems(class_1799 stack) {
        if (inventories.containsKey(stack)) {
            return (class_2371)inventories.get(stack);
        }
        class_2371<class_1799> inv = this.readInventoryFromNbt(stack);
        inventories.put(stack, inv);
        return inv;
    }

    @Override
    public class_1263 getInventory(class_1799 stack) {
        return StorageItem.getInventoryStatic(stack);
    }

    @Override
    public void setStack(class_1799 key, int slot, class_1799 stack) {
        this.getItems(key).set(slot, (Object)stack);
        if (stack.method_7947() > this.getMaxCountPerStack(key)) {
            stack.method_7939(this.getMaxCountPerStack(key));
        }
        this.markDirty(key);
    }

    protected int getMaxCountPerStack(class_1799 key) {
        return 64;
    }

    @Override
    public class_6862<class_1792> getStorableTag() {
        return this.storableTag;
    }

    @Override
    public boolean autocollects() {
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        ArrayList spells = this.getSpellItems(stack, this::isCastable);
        if (!spells.isEmpty()) {
            tooltip.add((class_2561)this.getTriggerText().method_27692(class_124.field_1063));
            tooltip.add((class_2561)this.getTriggerText2().method_27692(class_124.field_1063));
            for (class_1799 spell : spells) {
                SpellGrid grid = SpellStoringItem.readGrid(spell);
                String selectedString = "  ";
                tooltip.add((class_2561)class_2561.method_43470((String)selectedString).method_27692(class_124.field_1062).method_10852((class_2561)(grid == null ? class_2561.method_43471((String)"geomancy.spellstorage.empty").method_27692(class_124.field_1063) : (grid.name == "" ? class_2561.method_43471((String)"geomancy.spellstorage.unnamed").method_27692(class_124.field_1080) : class_2561.method_43470((String)grid.name).method_27692(class_124.field_1080)))));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.caster.emptyhint1").method_27692(class_124.field_1063));
            tooltip.add((class_2561)this.getTriggerText().method_27692(class_124.field_1063));
            tooltip.add((class_2561)this.getTriggerText2().method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43471((String)"geomancy.caster.emptyhint4").method_27692(class_124.field_1063));
        }
    }

    public boolean isCastable(SpellGrid g) {
        return castableNames.contains(g.name);
    }

    public class_5250 getTriggerText() {
        return class_2561.method_43471((String)"geomancy.caster.trigger.tick");
    }

    public class_5250 getTriggerText2() {
        return class_2561.method_43471((String)"geomancy.caster.trigger.hotkey");
    }

    @Override
    public void trigger(class_1799 stack, class_1309 wearer, SpellBlockArgs args) {
        this.cast(stack, wearer, args);
    }

    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onEquip(stack, slot, entity);
    }

    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onUnequip(stack, slot, entity);
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (!(entity.method_37908() instanceof class_638)) {
            this.trigger(stack, entity, SpellBlockArgs.empty());
        }
    }

    @Override
    public void markDirty(class_1799 stack) {
        IStorageItem.super.markDirty(stack);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onSpellChanged(class_1799 stack, class_746 player, int spellIndex) {
    }

    @Override
    public class_3414 getOpenSound() {
        return class_3417.field_15082;
    }

    @Override
    public class_3414 getCloseSound() {
        return class_3417.field_15131;
    }
}

