/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class CountIngredient {
    public class_1856 ingredient;
    public int count;
    public int slot;

    public CountIngredient(class_1856 ingredient, int count, int slot) {
        this.ingredient = ingredient;
        this.count = count;
        this.slot = slot;
    }

    public static CountIngredient fromJson(@Nullable JsonElement json) {
        return CountIngredient.fromJson(json, true);
    }

    public static CountIngredient fromJson(@Nullable JsonElement json, boolean allowAir) {
        if (json != null && !json.isJsonNull()) {
            class_1856 ingredient1 = class_1856.method_8102((JsonElement)json, (boolean)allowAir);
            int count = json.getAsJsonObject().get("count").getAsInt();
            int slot = -1;
            if (json.getAsJsonObject().has("slot")) {
                slot = json.getAsJsonObject().get("slot").getAsInt();
            }
            return new CountIngredient(ingredient1, count, slot);
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static CountIngredient fromPacket(class_2540 buf) {
        class_1856 ingredient1 = class_1856.method_8086((class_2540)buf);
        int count = buf.readInt();
        int slot = buf.readInt();
        return new CountIngredient(ingredient1, count, slot);
    }

    public void write(class_2540 buf) {
        this.ingredient.method_8088(buf);
        buf.writeInt(this.count);
        buf.writeInt(this.slot);
    }

    public boolean test(class_1799 stack) {
        return this.ingredient.method_8093(stack);
    }

    public JsonElement toJson() {
        JsonElement ingredientElement = this.ingredient.method_8089();
        JsonObject res = ingredientElement.getAsJsonObject();
        res.addProperty("count", (Number)this.count);
        if (this.hasSlot()) {
            res.addProperty("slot", (Number)this.slot);
        }
        return res;
    }

    public boolean hasSlot() {
        return this.slot != -1;
    }

    public static CountIngredient ofItems(class_1935 ... items) {
        return CountIngredient.ofItems(1, items);
    }

    public static CountIngredient ofItems(int count, class_1935 ... items) {
        return CountIngredient.ofItems(count, -1, items);
    }

    public static CountIngredient ofItems(int count, int slot, class_1935 ... items) {
        class_1856 ingredient1 = class_1856.method_8091((class_1935[])items);
        return new CountIngredient(ingredient1, count, slot);
    }

    public List<class_1799> getStacks() {
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        for (class_1799 stack : this.ingredient.method_8105()) {
            res.add(stack.method_46651(this.count));
        }
        return res;
    }
}

