/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe.smithery;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_52;
import net.minecraft.class_5455;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.enchantments.ModEnchantments;
import org.oxytocina.geomancy.items.GeodeItem;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.recipe.GatedModRecipe;
import org.oxytocina.geomancy.recipe.smithery.SmitheryRecipeI;
import org.oxytocina.geomancy.recipe.smithery.SmithingIngredient;
import org.oxytocina.geomancy.registries.ModRecipeTypes;

public class GeodeRecipe
extends GatedModRecipe<class_1263>
implements SmitheryRecipeI {
    public static final class_2960 UNLOCK_IDENTIFIER = null;
    public final SmithingIngredient base;
    protected final int progressRequiredBase;
    protected final int difficulty;
    protected final float difficultyPerMighty;

    public GeodeRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, @NotNull SmithingIngredient base, int progressRequiredBase, int difficulty, float difficultyPerMighty) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.base = base;
        this.progressRequiredBase = progressRequiredBase;
        this.difficulty = difficulty;
        this.difficultyPerMighty = difficultyPerMighty;
    }

    public boolean method_8115(@NotNull class_1263 inv, class_1937 world) {
        return !this.getOutput(inv, false, false, class_1799.field_8037, null, world).isEmpty();
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        List<class_1799> res = this.newCraft(inventory, null);
        return res.isEmpty() ? class_1799.field_8037 : res.get(0);
    }

    public List<class_1799> newCraft(class_1263 inv, class_1937 world) {
        return this.getOutput(inv, true, false, class_1799.field_8037, null, world);
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return ModItems.GEODE_PREVIEW.method_7854();
    }

    public List<class_1799> getOutput(class_1263 inv, boolean removeIngredients, boolean preview, class_1799 hammer, class_1309 hammerer, class_1937 world) {
        ArrayList<class_1799> res = new ArrayList<class_1799>();
        class_1799 baseStack = this.getRecipeBase(inv);
        if (baseStack.method_7960()) {
            return res;
        }
        if (!preview) {
            class_1792 class_17922 = baseStack.method_7909();
            if (class_17922 instanceof GeodeItem) {
                GeodeItem geodeItem = (GeodeItem)class_17922;
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    class_52 lootTable = geodeItem.getLootTable(world);
                    ObjectArrayList loot = lootTable.method_51878(new class_8567.class_8568(serverWorld).method_51875(class_176.method_35554().method_782()));
                    res.addAll((Collection<class_1799>)loot);
                } else {
                    res.add(ModItems.GEODE_PREVIEW.method_7854());
                }
            }
        } else {
            res.add(ModItems.GEODE_PREVIEW.method_7854());
        }
        if (removeIngredients) {
            baseStack.method_7934(1);
        }
        return res;
    }

    public class_1799 getRecipeBase(class_1263 inv) {
        for (int baseSlot = 0; baseSlot < inv.method_5439(); ++baseSlot) {
            if (!this.base.test(inv.method_5438(baseSlot))) continue;
            return inv.method_5438(baseSlot);
        }
        return class_1799.field_8037;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 res = class_2371.method_10211();
        res.add((Object)this.base.ingredient);
        return res;
    }

    @Override
    public int getDifficulty(class_1263 inv, class_1799 hammer, class_1309 hammerer) {
        int res = this.difficulty;
        return res += (int)(this.difficultyPerMighty * (float)ModEnchantments.getLevel(hammer, ModEnchantments.MIGHTY));
    }

    @Override
    public int getProgressRequired(class_1263 inv) {
        return this.progressRequiredBase;
    }

    @Override
    public class_1799 getPreviewOutput(class_1263 inv) {
        List<class_1799> outputs = this.getOutput(inv, false, true, class_1799.field_8037, null, null);
        return outputs.isEmpty() ? class_1799.field_8037 : outputs.get(0);
    }

    @Override
    public boolean hasBaseStack() {
        return false;
    }

    @Override
    public List<SmithingIngredient> getSmithingIngredients(class_1263 inv) {
        ArrayList<SmithingIngredient> res = new ArrayList<SmithingIngredient>();
        class_1799 stack = this.getRecipeBase(inv);
        res.add(SmithingIngredient.ofItems(stack.method_7947(), this.base.mishapWeight, new class_1935[]{stack.method_7909()}));
        return res;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.SMITHERY.method_8389());
    }

    public class_1865<?> method_8119() {
        return ModRecipeTypes.GEODE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.GEODE;
    }

    @Override
    public boolean isShapeless() {
        return true;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "geode";
    }

    @Override
    public List<class_1799> getSmithingResult(class_1263 inv, boolean removeItems, boolean preview, class_1799 hammer, class_1309 hammerer, class_1937 world) {
        return this.getOutput(inv, removeItems, preview, hammer, hammerer, world);
    }
}

