/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe.smithery;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.recipe.CountIngredient;
import org.oxytocina.geomancy.recipe.GatedModRecipe;
import org.oxytocina.geomancy.recipe.smithery.SmitheryRecipeI;
import org.oxytocina.geomancy.recipe.smithery.SmithingIngredient;
import org.oxytocina.geomancy.registries.ModRecipeTypes;

public class SmitheryRecipe
extends GatedModRecipe<class_1263>
implements SmitheryRecipeI {
    public static final class_2960 UNLOCK_IDENTIFIER = null;
    protected final class_2371<SmithingIngredient> inputs;
    protected final class_1799 output;
    protected final int progressRequired;
    protected final int difficulty;
    protected final boolean shapeless;

    public SmitheryRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, @NotNull class_2371<SmithingIngredient> inputs, class_1799 output, int progressRequired, int difficulty, boolean shapeless) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.inputs = inputs;
        this.output = output;
        this.progressRequired = progressRequired;
        this.difficulty = difficulty;
        this.shapeless = shapeless;
    }

    public boolean method_8115(@NotNull class_1263 inv, class_1937 world) {
        if (this.shapeless) {
            for (CountIngredient ing : this.inputs) {
                int countLeft = ing.count;
                boolean ingredientAvailable = false;
                for (int i = 0; i < inv.method_5439(); ++i) {
                    int removed;
                    class_1799 slot = inv.method_5438(i);
                    if (slot.method_7960() || !ing.test(slot) || (countLeft -= (removed = Math.min(countLeft, slot.method_7947()))) > 0) continue;
                    ingredientAvailable = true;
                    break;
                }
                if (ingredientAvailable) continue;
                return false;
            }
        } else {
            ArrayList<Integer> shapelessExcludedSlots = new ArrayList<Integer>();
            ArrayList<Integer> usedSlots = new ArrayList<Integer>();
            for (CountIngredient ing : this.inputs) {
                if (!ing.hasSlot()) continue;
                shapelessExcludedSlots.add(ing.slot);
                boolean ingredientAvailable = false;
                class_1799 slot = inv.method_5438(ing.slot);
                if (!slot.method_7960() && ing.test(slot) && slot.method_7947() >= ing.count) {
                    ingredientAvailable = true;
                    usedSlots.add(ing.slot);
                }
                if (ingredientAvailable) continue;
                return false;
            }
            for (CountIngredient ing : this.inputs) {
                if (ing.hasSlot()) continue;
                int countLeft = ing.count;
                boolean ingredientAvailable = false;
                for (int i = 0; i < inv.method_5439(); ++i) {
                    int removed;
                    class_1799 slot;
                    if (shapelessExcludedSlots.contains(i) || (slot = inv.method_5438(i)).method_7960() || !ing.test(slot) || (countLeft -= (removed = Math.min(countLeft, slot.method_7947()))) > 0) continue;
                    ingredientAvailable = true;
                    usedSlots.add(i);
                    break;
                }
                if (ingredientAvailable) continue;
                return false;
            }
            for (int i = 0; i < inv.method_5439(); ++i) {
                if (usedSlots.contains(i) || inv.method_5438(i).method_7960()) continue;
                return false;
            }
        }
        return true;
    }

    public class_1799 method_8116(class_1263 inv, class_5455 drm) {
        for (CountIngredient ing : this.inputs) {
            int countLeft = ing.count;
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 slot = inv.method_5438(i);
                if (slot.method_7960() || !ing.test(slot)) continue;
                int removed = Math.min(slot.method_7947(), countLeft);
                slot.method_7934(removed);
                if ((countLeft -= removed) <= 0) break;
            }
            if (countLeft == 0) continue;
            Geomancy.logError("recipe " + this.method_8114().toString() + " got crafted but couldnt remove the necessary ingredients");
        }
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return this.output;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 res = class_2371.method_10211();
        res.addAll(this.inputs.stream().map(a -> a.ingredient).toList());
        return res;
    }

    public class_2371<SmithingIngredient> getSmithingIngredients() {
        return this.inputs;
    }

    @Override
    public int getProgressRequired(class_1263 inv) {
        return this.progressRequired;
    }

    @Override
    public class_1799 getPreviewOutput(class_1263 inv) {
        return this.method_8110(null);
    }

    @Override
    public boolean hasBaseStack() {
        return !this.isShapeless();
    }

    @Override
    public List<SmithingIngredient> getSmithingIngredients(class_1263 inv) {
        return this.inputs;
    }

    @Override
    public int getDifficulty(class_1263 inv, class_1799 hammer, class_1309 hammerer) {
        return this.difficulty;
    }

    @Override
    public boolean isShapeless() {
        return this.shapeless;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.SMITHERY.method_8389());
    }

    public class_1865<?> method_8119() {
        return ModRecipeTypes.SMITHING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.SMITHING;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "smithing";
    }

    @Override
    public List<class_1799> getSmithingResult(class_1263 inv, boolean removeItems, boolean preview, class_1799 hammer, class_1309 hammerer, class_1937 world) {
        return removeItems ? List.of(this.method_8116(inv, null)) : List.of(this.method_8110(null));
    }
}

