/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe.smithery;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.oxytocina.geomancy.recipe.GatedRecipeSerializer;
import org.oxytocina.geomancy.recipe.RecipeUtils;
import org.oxytocina.geomancy.recipe.smithery.SmitheryRecipe;
import org.oxytocina.geomancy.recipe.smithery.SmithingIngredient;

public class SmitheryRecipeSerializer<R extends SmitheryRecipe>
implements GatedRecipeSerializer<R> {
    public final RecipeFactory<R> recipeFactory;

    public SmitheryRecipeSerializer(RecipeFactory<R> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public R read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        JsonArray jsonElement = class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients");
        class_2371 ingredients = class_2371.method_10211();
        for (JsonElement ingredientElement : jsonElement) {
            SmithingIngredient ingredient = SmithingIngredient.fromJson(ingredientElement);
            ingredients.add((Object)ingredient);
        }
        class_1799 outputItemStack = RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"), (String)"item"));
        int progressRequired = jsonObject.get("cost").getAsInt();
        int difficulty = jsonObject.get("difficulty").getAsInt();
        boolean shapeless = jsonObject.get("shapeless").getAsBoolean();
        return (R)((SmitheryRecipe)this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, (class_2371<SmithingIngredient>)ingredients, outputItemStack, progressRequired, difficulty, shapeless));
    }

    public void write(class_2540 packetByteBuf, R recipe) {
        packetByteBuf.method_10814(((SmitheryRecipe)recipe).group);
        packetByteBuf.writeBoolean(((SmitheryRecipe)recipe).secret);
        this.writeNullableIdentifier(packetByteBuf, ((SmitheryRecipe)recipe).requiredAdvancementIdentifier);
        packetByteBuf.writeInt(((SmitheryRecipe)recipe).inputs.size());
        for (SmithingIngredient input : ((SmitheryRecipe)recipe).inputs) {
            input.write(packetByteBuf);
        }
        packetByteBuf.method_10793(((SmitheryRecipe)recipe).output);
        packetByteBuf.writeInt(((SmitheryRecipe)recipe).progressRequired);
        packetByteBuf.writeInt(((SmitheryRecipe)recipe).difficulty);
        packetByteBuf.writeBoolean(((SmitheryRecipe)recipe).shapeless);
    }

    public R read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        int ingredientCount = packetByteBuf.readInt();
        class_2371 ingredients = class_2371.method_10211();
        for (int i = 0; i < ingredientCount; ++i) {
            SmithingIngredient ingredient = SmithingIngredient.fromPacket(packetByteBuf);
            ingredients.add((Object)ingredient);
        }
        class_1799 outputItemStack = packetByteBuf.method_10819();
        int progressRequired = packetByteBuf.readInt();
        int difficulty = packetByteBuf.readInt();
        boolean shapeless = packetByteBuf.readBoolean();
        return (R)((SmitheryRecipe)this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, (class_2371<SmithingIngredient>)ingredients, outputItemStack, progressRequired, difficulty, shapeless));
    }

    public static interface RecipeFactory<R> {
        public R create(class_2960 var1, String var2, boolean var3, class_2960 var4, class_2371<SmithingIngredient> var5, class_1799 var6, int var7, int var8, boolean var9);
    }
}

