/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe.smithery;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;
import org.oxytocina.geomancy.recipe.CountIngredient;

public class SmithingIngredient
extends CountIngredient {
    public int mishapWeight = 1;

    public SmithingIngredient(class_1856 ingredient, int count, int slot) {
        this(ingredient, count, slot, 1);
    }

    public SmithingIngredient(class_1856 ingredient, int count, int slot, int mishapWeight) {
        super(ingredient, count, slot);
        this.mishapWeight = mishapWeight;
    }

    public SmithingIngredient(CountIngredient base, int mishapWeight) {
        this(base.ingredient, base.count, base.slot, mishapWeight);
    }

    public static SmithingIngredient fromJson(@Nullable JsonElement json) {
        return SmithingIngredient.fromJson(json, true);
    }

    public static SmithingIngredient fromJson(@Nullable JsonElement json, boolean allowAir) {
        if (json != null && !json.isJsonNull()) {
            CountIngredient base = CountIngredient.fromJson(json, allowAir);
            int mishapWeight = json.getAsJsonObject().get("mishapWeight").getAsInt();
            return new SmithingIngredient(base, mishapWeight);
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static SmithingIngredient fromPacket(class_2540 buf) {
        CountIngredient ing = CountIngredient.fromPacket(buf);
        int mishapWeight = buf.readInt();
        return new SmithingIngredient(ing, mishapWeight);
    }

    @Override
    public void write(class_2540 buf) {
        super.write(buf);
        buf.writeInt(this.mishapWeight);
    }

    @Override
    public JsonElement toJson() {
        JsonObject res = super.toJson().getAsJsonObject();
        res.addProperty("mishapWeight", (Number)this.mishapWeight);
        return res;
    }

    public static SmithingIngredient ofItems(class_1935 ... items) {
        return SmithingIngredient.ofItems(1, items);
    }

    public static SmithingIngredient ofItems(int count, class_1935 ... items) {
        return SmithingIngredient.ofItems(count, 1, items);
    }

    public static SmithingIngredient ofItems(int count, int mishapWeight, class_1935 ... items) {
        return SmithingIngredient.ofItems(count, 1, -1, items);
    }

    public static SmithingIngredient ofItems(int count, int mishapWeight, int slot, class_1935 ... items) {
        CountIngredient ingredient1 = CountIngredient.ofItems(count, slot, items);
        return new SmithingIngredient(ingredient1, mishapWeight);
    }
}

