/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.recipe.soulforge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.oxytocina.geomancy.recipe.GatedRecipeSerializer;
import org.oxytocina.geomancy.recipe.NbtIngredient;
import org.oxytocina.geomancy.recipe.RecipeUtils;
import org.oxytocina.geomancy.recipe.soulforge.SoulForgeRecipe;

public class SoulForgeRecipeSerializer<R extends SoulForgeRecipe>
implements GatedRecipeSerializer<R> {
    public final RecipeFactory<R> recipeFactory;

    public SoulForgeRecipeSerializer(RecipeFactory<R> recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public R read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        JsonArray ingredientArr = jsonObject.getAsJsonArray("ingredients");
        ArrayList<NbtIngredient> ingredients = new ArrayList<NbtIngredient>();
        for (int i = 0; i < ingredientArr.size(); ++i) {
            JsonElement ingredientJson = ingredientArr.get(i);
            NbtIngredient ingredient = NbtIngredient.fromJson(ingredientJson);
            ingredients.add(ingredient);
        }
        class_1799 outputItemStack = RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"), (String)"item"));
        float cost = jsonObject.get("cost").getAsFloat();
        float instability = jsonObject.get("instability").getAsFloat();
        float speed = jsonObject.get("speed").getAsFloat();
        return (R)((SoulForgeRecipe)this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, ingredients, outputItemStack, cost, instability, speed));
    }

    public void write(class_2540 buf, R recipe) {
        buf.method_10814(((SoulForgeRecipe)recipe).group);
        buf.writeBoolean(((SoulForgeRecipe)recipe).secret);
        this.writeNullableIdentifier(buf, ((SoulForgeRecipe)recipe).requiredAdvancementIdentifier);
        buf.writeInt(((SoulForgeRecipe)recipe).inputs.size());
        for (int i = 0; i < ((SoulForgeRecipe)recipe).inputs.size(); ++i) {
            ((SoulForgeRecipe)recipe).inputs.get(i).write(buf);
        }
        buf.method_10793(((SoulForgeRecipe)recipe).output);
        buf.writeFloat(((SoulForgeRecipe)recipe).cost);
        buf.writeFloat(((SoulForgeRecipe)recipe).instability);
        buf.writeFloat(((SoulForgeRecipe)recipe).speed);
    }

    public R read(class_2960 identifier, class_2540 buf) {
        String group = buf.method_19772();
        boolean secret = buf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(buf);
        int inputSize = buf.readInt();
        ArrayList<NbtIngredient> inputs = new ArrayList<NbtIngredient>();
        for (int i = 0; i < inputSize; ++i) {
            inputs.add(NbtIngredient.fromPacket(buf));
        }
        class_1799 outputItemStack = buf.method_10819();
        float cost = buf.readFloat();
        float instability = buf.readFloat();
        float speed = buf.readFloat();
        return (R)((SoulForgeRecipe)this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, inputs, outputItemStack, cost, instability, speed));
    }

    public static interface RecipeFactory<R> {
        public R create(class_2960 var1, String var2, boolean var3, class_2960 var4, List<NbtIngredient> var5, class_1799 var6, float var7, float var8, float var9);
    }
}

