/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.spells;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.items.ModItems;
import org.oxytocina.geomancy.items.SpellComponentStoringItem;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellBlockResult;
import org.oxytocina.geomancy.spells.SpellComponent;
import org.oxytocina.geomancy.spells.SpellSignal;
import org.oxytocina.geomancy.util.AdvancementHelper;

public class SpellBlock {
    public HashMap<String, SpellSignal> variables;
    public HashMap<String, SpellSignal> inputs;
    public HashMap<String, Parameter> parameters;
    public HashMap<String, SpellSignal> outputs;
    public boolean singleOutput;
    public SpellSignal output;
    public class_2960 identifier;
    public class_2960 hexFrontTexture;
    public class_2960 hexBackTexture;
    public Function<SpellComponent, SpellComponent.SideConfig[]> sideConfigGetter;
    public Category category;
    public class_1799 stack;
    public int defaultLootWeight;
    public int recipeRequiredProgress;
    public int recipeDifficulty;
    public OverarchingCategory overarchingCategory;
    public BiFunction<SpellComponent, SpellBlockArgs, SpellBlockResult> function;
    public Consumer<SpellComponent> initFunction;
    public Consumer<SpellComponent> postFunction;

    public SpellBlockResult run(SpellComponent component, SpellBlockArgs arguments) {
        if (this.function == null) {
            return SpellBlockResult.empty();
        }
        return this.function.apply(component, arguments);
    }

    public void initRun(SpellComponent component) {
        if (this.initFunction != null) {
            this.initFunction.accept(component);
        }
    }

    public void postRun(SpellComponent component) {
        if (this.postFunction != null) {
            this.postFunction.accept(component);
        }
    }

    protected SpellBlock(class_2960 identifier, List<SpellSignal> inputs, List<SpellSignal> outputs, List<Parameter> parameters, BiFunction<SpellComponent, SpellBlockArgs, SpellBlockResult> function, Function<SpellComponent, SpellComponent.SideConfig[]> sideConfigGetter, Consumer<SpellComponent> initFunction, Consumer<SpellComponent> postFunction, Category category, int defaultLootWeight, int recipeRequiredProgress, int recipeDifficulty, class_1799 stack, OverarchingCategory overarchingCategory) {
        this.identifier = identifier;
        this.inputs = new HashMap();
        this.outputs = new HashMap();
        this.variables = new HashMap();
        this.parameters = new HashMap();
        this.category = category;
        this.stack = stack;
        this.hexFrontTexture = Geomancy.locate("textures/gui/spells/" + identifier.method_12832() + ".png");
        this.hexBackTexture = Geomancy.locate("textures/gui/spellmaker_hex_bg_" + category.toString().toLowerCase() + ".png");
        this.defaultLootWeight = defaultLootWeight;
        this.recipeRequiredProgress = recipeRequiredProgress;
        this.recipeDifficulty = recipeDifficulty;
        this.overarchingCategory = overarchingCategory;
        this.function = function;
        this.sideConfigGetter = sideConfigGetter;
        this.initFunction = initFunction;
        this.postFunction = postFunction;
        for (SpellSignal spellSignal : inputs) {
            this.inputs.put(spellSignal.name, spellSignal);
            this.variables.put(spellSignal.name, spellSignal);
        }
        for (SpellSignal spellSignal : outputs) {
            this.outputs.put(spellSignal.name, spellSignal);
            this.variables.put(spellSignal.name, spellSignal);
        }
        for (Parameter parameter : parameters) {
            this.parameters.put(parameter.name, parameter);
        }
        boolean bl = this.singleOutput = outputs.size() == 1;
        if (this.singleOutput) {
            this.output = outputs.get(0);
        }
        if (this.stack == null) {
            this.stack = SpellComponentStoringItem.createDefaultComponentData(new class_1799((class_1935)ModItems.SPELLCOMPONENT), this);
        }
    }

    public SpellBlock hexTex(String texture) {
        this.hexFrontTexture = Geomancy.locate(texture);
        return this;
    }

    public SpellComponent.SideConfig[] getDefaultSideConfigs(SpellComponent component) {
        return this.sideConfigGetter.apply(component);
    }

    public Parameter getParameter(String param) {
        if (this.parameters.containsKey(param)) {
            return this.parameters.get(param);
        }
        return null;
    }

    public class_2960 getHexFrontTexture() {
        return this.hexFrontTexture;
    }

    public class_2960 getHexBackTexture() {
        return this.hexBackTexture;
    }

    public class_1799 getItemStack() {
        return this.stack;
    }

    public class_1799 copyItemStack() {
        return this.stack.method_7972();
    }

    public boolean isAncient() {
        return this.overarchingCategory == OverarchingCategory.Ancient;
    }

    public boolean recipeUnlocked(class_3222 spe) {
        return AdvancementHelper.hasAdvancementServer((class_1657)spe, Geomancy.locate("spellcomponents/get_" + this.identifier.method_12832()));
    }

    public static enum Category {
        FlowControl,
        Provider,
        Arithmetic,
        Effector,
        Reference,
        Lists,
        Ancient;

    }

    public static enum OverarchingCategory {
        Normal,
        Ancient;

    }

    public static class Parameter {
        public Type type;
        public String name;
        public float defaultValue;
        public float minimum;
        public float maximum;
        public String defaultText;

        private Parameter(Type type, String name, float defaultValue, float min, float max, String text) {
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
            this.minimum = min;
            this.maximum = max;
            this.defaultText = text;
        }

        public static Parameter createNumber(String name, float defaultValue, float min, float max) {
            return new Parameter(Type.ConstantNumber, name, defaultValue, min, max, "");
        }

        public static Parameter createText(String name, String defaultText) {
            return new Parameter(Type.ConstantText, name, 0.0f, 0.0f, 0.0f, defaultText);
        }

        public static Parameter createBoolean(String name, boolean defaultValue) {
            return new Parameter(Type.ConstantBoolean, name, defaultValue ? 1.0f : 0.0f, 0.0f, 1.0f, "");
        }

        public SpellSignal getDefaultSignal() {
            switch (this.type.ordinal()) {
                case 2: {
                    return SpellSignal.createBoolean(this.defaultValue).named(this.name);
                }
                case 0: {
                    return SpellSignal.createNumber(this.defaultValue).named(this.name);
                }
                case 1: {
                    return SpellSignal.createText(this.defaultText).named(this.name);
                }
            }
            return SpellSignal.createNone().named(this.name);
        }

        public static enum Type {
            ConstantNumber,
            ConstantText,
            ConstantBoolean;

        }
    }

    public static class SideUtil {
        public static SpellComponent.SideConfig[] sidesUniform(SpellComponent parent, SpellComponent.SideConfig.Mode[] modes, String varName) {
            SpellComponent.SideConfig[] res = new SpellComponent.SideConfig[6];
            for (int i = 0; i < 6; ++i) {
                res[i] = SpellComponent.SideConfig.create(parent, modes, SpellComponent.directions[i]);
                res[i].varName = varName;
            }
            return res;
        }

        public static SpellComponent.SideConfig[] sidesFreeform(SpellComponent parent) {
            return SideUtil.sidesUniform(parent, new SpellComponent.SideConfig.Mode[]{SpellComponent.SideConfig.Mode.Blocked, SpellComponent.SideConfig.Mode.Input, SpellComponent.SideConfig.Mode.Output}, "");
        }

        public static SpellComponent.SideConfig[] sidesBlocked(SpellComponent parent) {
            return SideUtil.sidesUniform(parent, new SpellComponent.SideConfig.Mode[]{SpellComponent.SideConfig.Mode.Blocked}, "");
        }

        public static SpellComponent.SideConfig[] sidesInput(SpellComponent parent) {
            return SideUtil.sidesInput(parent, "");
        }

        public static SpellComponent.SideConfig[] sidesInput(SpellComponent parent, String varName) {
            return SideUtil.sidesUniform(parent, new SpellComponent.SideConfig.Mode[]{SpellComponent.SideConfig.Mode.Blocked, SpellComponent.SideConfig.Mode.Input}, varName);
        }

        public static SpellComponent.SideConfig[] sidesOutput(SpellComponent parent) {
            return SideUtil.sidesOutput(parent, "");
        }

        public static SpellComponent.SideConfig[] sidesOutput(SpellComponent parent, String varName) {
            return SideUtil.sidesUniform(parent, new SpellComponent.SideConfig.Mode[]{SpellComponent.SideConfig.Mode.Blocked, SpellComponent.SideConfig.Mode.Output}, varName);
        }
    }

    public static class Builder {
        final class_2960 identifier;
        Category category;
        class_1799 stack;
        SpellSignal[] inputs;
        SpellSignal[] outputs;
        Parameter[] parameters;
        int defaultLootWeight = 100;
        public int recipeRequiredProgress = 100;
        public int recipeDifficulty = 20;
        OverarchingCategory overarchingCategory = null;
        public Function<SpellComponent, SpellComponent.SideConfig[]> sideConfigGetter;
        public BiFunction<SpellComponent, SpellBlockArgs, SpellBlockResult> function;
        public Consumer<SpellComponent> initFunction;
        public Consumer<SpellComponent> postFunction;

        private Builder(class_2960 identifier) {
            this.identifier = identifier;
        }

        public static Builder create(class_2960 identifier) {
            return new Builder(identifier);
        }

        public static Builder create(String identifier) {
            return Builder.create(Geomancy.locate(identifier));
        }

        public SpellBlock build() {
            if (this.inputs == null) {
                this.inputs = new SpellSignal[0];
            }
            if (this.outputs == null) {
                this.outputs = new SpellSignal[0];
            }
            if (this.parameters == null) {
                this.parameters = new Parameter[0];
            }
            if (this.sideConfigGetter == null) {
                this.autoSideConfig();
            }
            if (this.overarchingCategory == null) {
                this.overarchingCategory = this.category == Category.Ancient ? OverarchingCategory.Ancient : OverarchingCategory.Normal;
            }
            return new SpellBlock(this.identifier, Arrays.stream(this.inputs).toList(), Arrays.stream(this.outputs).toList(), Arrays.stream(this.parameters).toList(), this.function, this.sideConfigGetter, this.initFunction, this.postFunction, this.category, this.defaultLootWeight, this.recipeRequiredProgress, this.recipeDifficulty, this.stack, this.overarchingCategory);
        }

        public Builder category(Category category) {
            this.category = category;
            return this;
        }

        public Builder stack(class_1799 stack) {
            this.stack = stack;
            return this;
        }

        public Builder defaultLootWeight(int defaultLootWeight) {
            this.defaultLootWeight = defaultLootWeight;
            return this;
        }

        public Builder recipeRequiredProgress(int recipeRequiredProgress) {
            this.recipeRequiredProgress = recipeRequiredProgress;
            return this;
        }

        public Builder recipeDifficulty(int recipeDifficulty) {
            this.recipeDifficulty = recipeDifficulty;
            return this;
        }

        public Builder parameters(Parameter ... parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder inputs(SpellSignal ... inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder outputs(SpellSignal ... outputs) {
            this.outputs = outputs;
            return this;
        }

        public Builder init(Consumer<SpellComponent> initFunction) {
            this.initFunction = initFunction;
            return this;
        }

        public Builder func(BiFunction<SpellComponent, SpellBlockArgs, SpellBlockResult> func) {
            this.function = func;
            return this;
        }

        public Builder post(Consumer<SpellComponent> postFunction) {
            this.postFunction = postFunction;
            return this;
        }

        public Builder sideConfigGetter(Function<SpellComponent, SpellComponent.SideConfig[]> func) {
            this.sideConfigGetter = func;
            return this;
        }

        public Builder ancient() {
            this.overarchingCategory = OverarchingCategory.Ancient;
            return this;
        }

        public Builder autoSideConfig() {
            if (this.inputs.length > 0 && this.outputs.length > 0) {
                this.sideConfigGetter(SideUtil::sidesFreeform);
            } else if (this.inputs.length > 0) {
                this.sideConfigGetter(SideUtil::sidesInput);
            } else if (this.outputs.length > 0) {
                this.sideConfigGetter(SideUtil::sidesOutput);
            } else {
                this.sideConfigGetter(SideUtil::sidesBlocked);
            }
            return this;
        }
    }
}

