/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.spells;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellSignal;

public class SpellBlockResult {
    public HashMap<String, SpellSignal> vars;
    public int iterations = 1;
    public String iterationVarName = "i";
    public List<SpellBlockResult> subResults = null;
    public int depth = 0;

    public SpellBlockResult() {
        this.vars = new HashMap();
    }

    public SpellBlockResult(HashMap<String, SpellSignal> vars) {
        this.vars = vars;
    }

    public SpellBlockResult(SpellBlockArgs args) {
        this.vars = new HashMap();
        this.vars.putAll(args.vars);
    }

    public SpellBlockResult add(SpellSignal signal) {
        this.vars.put(signal.name, signal);
        return this;
    }

    public SpellBlockResult add(String name, float value) {
        this.add(SpellSignal.createNumber(value).named(name));
        return this;
    }

    public SpellBlockResult add(String name, double value) {
        this.add(name, (float)value);
        return this;
    }

    public SpellBlockResult add(String name, boolean value) {
        this.add(SpellSignal.createBoolean(value).named(name));
        return this;
    }

    public SpellBlockResult add(String name, String value) {
        this.add(SpellSignal.createText(value).named(name));
        return this;
    }

    public SpellBlockResult add(String name, UUID value) {
        this.add(SpellSignal.createUUID(value).named(name));
        return this;
    }

    public SpellBlockResult add(String name, class_243 value) {
        this.add(SpellSignal.createVector(value).named(name));
        return this;
    }

    public SpellBlockResult add(String name, class_2382 value) {
        this.add(SpellSignal.createVector(value).named(name));
        return this;
    }

    public SpellBlockResult add(String name, class_2338 value) {
        this.add(SpellSignal.createVector(value.method_46558()).named(name));
        return this;
    }

    public SpellBlockResult add(String name, List<SpellSignal> value) {
        this.add(SpellSignal.createList(value).named(name));
        return this;
    }

    public SpellBlockResult addSubResult(SpellBlockResult res) {
        if (this.subResults == null) {
            this.subResults = new ArrayList<SpellBlockResult>();
        }
        res.depth = this.depth;
        this.subResults.add(res);
        return this;
    }

    public static SpellBlockResult empty() {
        return new SpellBlockResult();
    }

    public SpellBlockResult clone() {
        SpellBlockResult res = new SpellBlockResult();
        res.vars.putAll(this.vars);
        res.iterationVarName = this.iterationVarName;
        res.depth = this.depth;
        if (this.subResults != null) {
            res.subResults = new ArrayList<SpellBlockResult>();
            for (SpellBlockResult r : this.subResults) {
                res.subResults.add(r.clone());
            }
        }
        return res;
    }

    public void refreshSignalDepths() {
        for (SpellSignal sig : this.vars.values()) {
            sig.setDepth(this.depth);
        }
    }

    public void writeNbt(class_2487 temp) {
        temp.method_10569("iterations", this.iterations);
        temp.method_10569("depth", this.depth);
        temp.method_10582("iterationVarName", this.iterationVarName);
        class_2499 subResultsNbt = new class_2499();
        for (SpellBlockResult s : this.subResults) {
            class_2487 temp2 = new class_2487();
            s.writeNbt(temp2);
            subResultsNbt.add((Object)temp2);
        }
        temp.method_10566("subResults", (class_2520)subResultsNbt);
        class_2487 varsNbt = new class_2487();
        for (String s : this.vars.keySet()) {
            varsNbt.method_10566(s, (class_2520)this.vars.get(s).toNBT(false));
        }
        temp.method_10566("vars", (class_2520)varsNbt);
    }
}

