/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.spells;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.joml.Vector2i;
import org.oxytocina.geomancy.Geomancy;
import org.oxytocina.geomancy.blocks.blockEntities.AutocasterBlockEntity;
import org.oxytocina.geomancy.client.util.CamShakeUtil;
import org.oxytocina.geomancy.effects.ModStatusEffects;
import org.oxytocina.geomancy.enchantments.ModEnchantments;
import org.oxytocina.geomancy.entity.CasterDelegateEntity;
import org.oxytocina.geomancy.items.SpellStoringItem;
import org.oxytocina.geomancy.spells.SpellBlock;
import org.oxytocina.geomancy.spells.SpellBlockArgs;
import org.oxytocina.geomancy.spells.SpellBlockResult;
import org.oxytocina.geomancy.spells.SpellBlocks;
import org.oxytocina.geomancy.spells.SpellComponent;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.util.ByteUtil;
import org.oxytocina.geomancy.util.EntityUtil;
import org.oxytocina.geomancy.util.SoulUtil;
import org.oxytocina.geomancy.util.Toolbox;

public class SpellGrid {
    public static final int CURRENT_DATA_FORMAT_VERSION = 1;
    public int width;
    public int height;
    public String name;
    public boolean library;
    public HashMap<Vector2i, SpellComponent> components;
    public float soulCostMultiplier = 1.0f;
    public class_1799 displayStack = null;

    public SpellGrid(class_1799 stack, class_2487 nbt) {
        this.components = new LinkedHashMap<Vector2i, SpellComponent>();
        this.readNbt(nbt);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof SpellStoringItem) {
            SpellStoringItem storer = (SpellStoringItem)class_17922;
            this.soulCostMultiplier = storer.getSoulCostMultiplier(stack);
        }
    }

    public SpellGrid(int width, int height) {
        this.width = width;
        this.height = height;
        this.name = "";
        this.library = false;
        this.components = new LinkedHashMap<Vector2i, SpellComponent>();
    }

    private SpellGrid(class_2540 buf) {
        this.deserializeInstance(buf);
    }

    public CasterDelegateEntity spawnDelegate(SpellContext parent, class_243 pos, class_241 rot, int delay) {
        CasterDelegateEntity res = new CasterDelegateEntity(parent, this, pos, rot, delay);
        parent.getWorld().method_8649((class_1297)res);
        return res;
    }

    public SpellBlockResult runReferenced(SpellContext parent, SpellComponent casterComp, SpellBlockArgs args) {
        SpellContext context = parent.createReferenced(casterComp);
        context.internalVars = args;
        context.grid = this;
        context.refreshAvailableSoul();
        for (SpellComponent comp : this.components.values()) {
            comp.preRunSetup(context);
        }
        context.stage = SpellContext.Stage.Run;
        for (SpellComponent comp : this.components.values()) {
            comp.run();
        }
        context.refreshAvailableSoul();
        for (SpellComponent comp : this.components.values()) {
            comp.postRun();
        }
        return context.referenceResult;
    }

    public void run(class_1799 casterItem, class_1799 spellStorage, class_1309 casterEntity, AutocasterBlockEntity blockEntity, CasterDelegateEntity delegate, SpellBlockArgs args, SpellContext.SoundBehavior soundBehavior, boolean activatedByHotkey) {
        int amp;
        long startTime = System.nanoTime();
        class_1937 world = casterEntity != null ? casterEntity.method_37908() : (blockEntity != null ? blockEntity.method_10997() : (delegate != null ? delegate.method_37908() : null));
        SpellContext.Restrictions restrictions = SpellContext.Restrictions.NONE;
        float casterItemCostMultiplier = 1.0f - 0.1f * (float)class_1890.method_8225((class_1887)ModEnchantments.SOUL_SAVER, (class_1799)casterItem);
        float costMultiplier = this.soulCostMultiplier * casterItemCostMultiplier;
        if (casterEntity != null && casterEntity.method_6059(ModStatusEffects.REGRETFUL)) {
            amp = casterEntity.method_6112(ModStatusEffects.REGRETFUL).method_5578();
            costMultiplier *= 1.0f + (float)(amp + 1) * 0.5f;
        }
        if (casterEntity != null && casterEntity.method_6059(ModStatusEffects.BLISSFUL)) {
            amp = casterEntity.method_6112(ModStatusEffects.BLISSFUL).method_5578();
            costMultiplier *= 1.0f - (float)(amp + 1) * 0.2f;
        }
        SpellContext context = new SpellContext(this, casterEntity, blockEntity, delegate, casterItem, spellStorage, 0.0f, costMultiplier, 0.0f, soundBehavior);
        context.activatedByHotkey = activatedByHotkey;
        context.refreshAvailableSoul();
        context.internalVars = args;
        context.setRestrictions(restrictions);
        try {
            for (SpellComponent comp : this.components.values()) {
                comp.preRunSetup(context);
            }
            context.stage = SpellContext.Stage.Run;
            for (SpellComponent comp : this.components.values()) {
                comp.run();
            }
            for (SpellComponent comp : this.components.values()) {
                comp.postRun();
            }
        }
        catch (Exception ignored) {
            Geomancy.logError("AAAAA!!!! Spells threw an exception! DEBUG ME!");
            Geomancy.logError(ignored.getMessage());
            Geomancy.logError(Arrays.toString(ignored.getStackTrace()));
        }
        if (context.depthLimitReached && context.debugging) {
            SpellBlocks.tryLogDebugDepthLimitReached(context);
        }
        if (context.timedOut()) {
            SpellBlocks.tryLogDebugTimedOut(context);
            SpellBlocks.tryUnlockSpellAdvancement(context.caster, "ambition");
            if (((Boolean)Geomancy.CONFIG.penalizeSpellTimeout.value()).booleanValue()) {
                class_1538 lightning = new class_1538(class_1299.field_6112, context.getWorld());
                class_243 pos = context.getOriginPos();
                if (context.caster != null) {
                    pos = context.caster.method_19538();
                }
                lightning.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
                switch (context.sourceType) {
                    case Caster: {
                        EntityUtil.slipItem(context.caster, context.casterItem);
                        break;
                    }
                    case Block: {
                        class_1937 class_19372;
                        if (!(Toolbox.random.nextFloat() < 0.2f) || !((class_19372 = context.getWorld()) instanceof class_3218)) break;
                        class_3218 sw = (class_3218)class_19372;
                        sw.method_22352(context.getOriginBlockPos(), true);
                        break;
                    }
                }
                context.getWorld().method_8649((class_1297)lightning);
                CamShakeUtil.cause(context.getWorld(), pos, 20.0f, 2.0f);
            }
        }
        if (context.getSoulConsumed() > 0.0f) {
            switch (context.sourceType) {
                case Caster: {
                    if (!(casterEntity instanceof class_1657)) break;
                    class_1657 pe = (class_1657)casterEntity;
                    SoulUtil.syncSoul(pe);
                    break;
                }
            }
            if (context.getSoulConsumed() >= 10000.0f) {
                SpellBlocks.tryUnlockSpellAdvancement(context.caster, "deconsciousness");
            }
        }
        SpellBlocks.playCastSound(context);
        SpellBlocks.spawnMuzzleParticles(context);
        long msTaken = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        if (msTaken > 10L) {
            Geomancy.logWarning(this.name + " Spell execution time: " + msTaken);
        }
    }

    public boolean tryRemoveComponent(Vector2i position) {
        if (!this.components.containsKey(position)) {
            return false;
        }
        this.components.remove(position);
        return true;
    }

    public boolean tryAddComponent(SpellComponent component) {
        if (this.components.containsKey(component.position)) {
            return false;
        }
        if (!this.inBounds(component.position)) {
            return false;
        }
        component.parent = this;
        this.components.put(component.position, component);
        this.recalculateNeighbors(component.position);
        return true;
    }

    public SpellComponent getComponent(Vector2i pos) {
        if (!this.components.containsKey(pos)) {
            return null;
        }
        return this.components.get(pos);
    }

    public void recalculateNeighbors(Vector2i position) {
        SpellComponent componentAtThisPosition = this.getComponent(position);
        ArrayList<Vector2i> neighborPosistions = this.getNeighboringPositions(position);
        for (int i = 0; i < 6; ++i) {
            SpellComponent comp = this.getComponent(neighborPosistions.get(i));
            byte dir = ByteUtil.intToByte(i);
            if (componentAtThisPosition != null) {
                componentAtThisPosition.setNeighbor(dir, comp);
            }
            if (comp == null) continue;
            comp.setNeighbor(SpellComponent.mirrorDirection(dir), componentAtThisPosition);
        }
    }

    public ArrayList<Vector2i> getNeighboringPositions(Vector2i pos) {
        ArrayList<Vector2i> res = new ArrayList<Vector2i>();
        int ySkew = pos.y % 2;
        res.add(new Vector2i(pos.x + ySkew, pos.y - 1));
        res.add(new Vector2i(pos.x + 1, pos.y));
        res.add(new Vector2i(pos.x + ySkew, pos.y + 1));
        res.add(new Vector2i(pos.x - 1 + ySkew, pos.y + 1));
        res.add(new Vector2i(pos.x - 1, pos.y));
        res.add(new Vector2i(pos.x - 1 + ySkew, pos.y - 1));
        return res;
    }

    public boolean inBounds(Vector2i position) {
        return position.x >= 0 && position.y >= 0 && position.x < this.width && position.y < this.height && SpellGrid.positionIsInGrid(position.x, position.y, this.width, this.height);
    }

    public class_5250 getName() {
        if (Objects.equals(this.name, "")) {
            return class_2561.method_43471((String)"geomancy.spellstorage.unnamed");
        }
        return class_2561.method_43470((String)this.name);
    }

    public class_5250 getRuntimeName(SpellContext context) {
        class_5250 res = this.getName();
        if (context.isChild()) {
            res = context.parentCall.grid.getRuntimeName(context.parentCall).method_27693(" -> ").method_10852((class_2561)res);
        }
        return res;
    }

    public class_2540 serialize() {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(1);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
        buf.method_10814(this.name);
        buf.writeBoolean(this.library);
        buf.writeInt(this.components.size());
        for (SpellComponent c : this.components.values()) {
            buf.method_10814(ByteUtil.bufToString(c.serialize()));
        }
        buf.writeBoolean(this.displayStack != null && !this.displayStack.method_7960());
        if (this.displayStack != null && !this.displayStack.method_7960()) {
            buf.method_10793(this.displayStack);
        }
        return buf;
    }

    public static SpellGrid deserialize(class_2540 buf) {
        return new SpellGrid(buf);
    }

    public void deserializeInstance(class_2540 buf) {
        int formatVersion = buf.readInt();
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.name = buf.method_19772();
        this.library = buf.readBoolean();
        int compsSize = buf.readInt();
        for (int i = 0; i < compsSize; ++i) {
            try {
                class_2540 tmpBuf = ByteUtil.stringToBuf(buf.method_19772());
                this.tryAddComponent(SpellComponent.deserialize(this, tmpBuf));
                continue;
            }
            catch (Throwable ignored) {
                return;
            }
        }
        if (buf.readBoolean()) {
            this.displayStack = buf.method_10819();
        }
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("v", 1);
        String wKey = "w";
        String hKey = "h";
        String nKey = "n";
        String lKey = "l";
        String cKey = "c";
        String dKey = "d";
        nbt.method_10569(wKey, this.width);
        nbt.method_10569(hKey, this.height);
        if (this.name != null && !this.name.isEmpty()) {
            nbt.method_10582(nKey, this.name);
        }
        if (this.library) {
            nbt.method_10556(lKey, this.library);
        }
        class_2499 compsNbt = new class_2499();
        for (SpellComponent c : this.components.values()) {
            class_2487 cComp = new class_2487();
            c.writeNbt(cComp);
            compsNbt.add((Object)cComp);
        }
        if (!compsNbt.isEmpty()) {
            nbt.method_10566(cKey, (class_2520)compsNbt);
        }
        if (this.displayStack != null && !this.displayStack.method_7960()) {
            class_2487 displayNbt = new class_2487();
            this.displayStack.method_7953(displayNbt);
            nbt.method_10566(dKey, (class_2520)displayNbt);
        }
    }

    public void readNbt(class_2487 nbt) {
        int version = nbt.method_10550("v");
        if (nbt.method_10545("data") && version >= 100) {
            this.deserializeInstance(ByteUtil.stringToBuf(nbt.method_10558("data")));
            return;
        }
        String wKey = version >= 1 ? "w" : "width";
        String hKey = version >= 1 ? "h" : "height";
        String nKey = version >= 1 ? "n" : "name";
        String lKey = version >= 1 ? "l" : "lib";
        String cKey = version >= 1 ? "c" : "components";
        String dKey = version >= 1 ? "d" : "displayStack";
        this.width = nbt.method_10550(wKey);
        this.height = nbt.method_10550(hKey);
        this.name = nbt.method_10545(nKey) ? nbt.method_10558(nKey) : "";
        this.library = nbt.method_10545(lKey) && nbt.method_10577(lKey);
        class_2499 compsNbt = nbt.method_10545(cKey) ? nbt.method_10554(cKey, 10) : new class_2499();
        for (class_2520 c : compsNbt) {
            if (!(c instanceof class_2487)) continue;
            class_2487 nbtComp = (class_2487)c;
            SpellComponent comp = new SpellComponent(this, nbtComp);
            this.tryAddComponent(comp);
        }
        if (nbt.method_10545(dKey)) {
            this.displayStack = class_1799.method_7915((class_2487)nbt.method_10562(dKey));
        }
    }

    public static boolean positionIsInGrid(int x, int y, int width, int height) {
        int ySkew = y % 2;
        float midYIndex = (float)height / 2.0f - 0.5f;
        float diffToMidYIndex = Math.abs((float)y - midYIndex);
        if ((float)x > (float)width / 2.0f) {
            int xDiffToEdges = width - x;
            return (float)xDiffToEdges >= (diffToMidYIndex + 1.0f + (float)ySkew) / 2.0f;
        }
        int xDiffToEdges = x;
        return (float)xDiffToEdges >= (diffToMidYIndex - (float)ySkew) / 2.0f;
    }

    public static class_5250 getName(SpellGrid grid) {
        if (grid == null) {
            return class_2561.method_43471((String)"geomancy.spellstorage.empty").method_27692(class_124.field_1063);
        }
        return grid.getName().method_27692(class_124.field_1080);
    }

    public class_1799 getDisplayStack(class_1799 storage) {
        class_1799 base = this.displayStack;
        if (base == null || base.method_7960()) {
            base = storage;
        }
        base = base.method_7972();
        base.method_7980(null);
        base.method_7977((class_2561)this.getName());
        return base;
    }

    public class_1799 getAsStack(SpellStoringItem storage) {
        class_1799 res = storage.method_7854();
        SpellStoringItem.writeGrid(res, this);
        return res;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public int getSlotCount() {
        int res = this.height;
        for (int i = 0; i < this.height / 2; ++i) {
            res += 2 * (this.height - i - 1);
        }
        return res;
    }

    public float getFilledFraction() {
        return (float)this.components.size() / (float)this.getSlotCount();
    }

    public boolean containsComponent(SpellBlock comp) {
        for (SpellComponent c : this.components.values()) {
            if (c.function != comp) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        public String name = "";
        public int width = 3;
        public int height = 3;
        public HashMap<Vector2i, SpellComponent.Builder> components;

        public Builder(String name) {
            this.name = name;
            this.components = new LinkedHashMap<Vector2i, SpellComponent.Builder>();
        }

        public SpellGrid build() {
            SpellGrid res = new SpellGrid(this.width, this.height);
            res.name = this.name;
            for (SpellComponent.Builder b : this.components.values()) {
                res.tryAddComponent(b.build(res));
            }
            return res;
        }

        public Builder dim(SpellStoringItem storer) {
            this.width = storer.getWidth();
            this.height = storer.getHeight();
            return this;
        }

        public Builder add(SpellComponent.Builder builder) {
            this.components.put(builder.pos, builder);
            return this;
        }
    }
}

