/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2673;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5552;
import net.minecraft.class_5702;
import net.minecraft.class_5712;
import net.minecraft.class_6335;

public class BlockHelper {
    public static boolean breakBlock(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, Predicate<class_2680> filter, boolean drop) {
        if (world.field_9236) {
            return false;
        }
        class_1923 chunkPos = world.method_22350(pos).method_12004();
        if (!world.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
            return false;
        }
        class_2680 blockstate = world.method_8320(pos);
        if (blockstate.method_26215()) {
            return false;
        }
        if (player == null) {
            return BlockHelper.tryBreakBlock((class_3218)world, pos, stack, drop);
        }
        if (!drop) {
            return BlockHelper.tryBreakBlockAsPlayer((class_3222)player, pos, stack, drop);
        }
        if (blockstate.method_26165(player, (class_1922)world, pos) > 0.0f && filter.test(blockstate)) {
            class_1799 save = player.method_6047();
            player.method_6122(class_1268.field_5808, stack);
            ((class_3222)player).field_13987.method_14364((class_2596)new class_2673(2001, pos, class_2248.method_9507((class_2680)blockstate), false));
            ((class_3222)player).field_13974.method_14266(pos);
            player.method_6122(class_1268.field_5808, save);
            return true;
        }
        return false;
    }

    public static boolean replaceBlockWithDrops(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, class_2680 newState, Predicate<class_2680> filter) {
        if (player == null) {
            BlockHelper.tryBreakBlock((class_3218)world, pos, stack, true);
            world.method_8501(pos, newState);
            return false;
        }
        class_1923 chunkPos = world.method_22350(pos).method_12004();
        if (world.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
            class_2680 blockstate = world.method_8320(pos);
            if (!world.field_9236 && !blockstate.method_26215() && blockstate.method_26165(player, (class_1922)world, pos) > 0.0f && filter.test(blockstate)) {
                class_1799 save = player.method_6047();
                player.method_6122(class_1268.field_5808, stack);
                ((class_3222)player).field_13987.method_14364((class_2596)new class_2673(2001, pos, class_2248.method_9507((class_2680)blockstate), false));
                ((class_3222)player).field_13974.method_14266(pos);
                world.method_8501(pos, newState);
                player.method_6122(class_1268.field_5808, save);
                return true;
            }
        }
        return false;
    }

    public static boolean replaceBlock(class_1937 world, class_2338 pos, class_2680 newState) {
        class_1923 chunkPos = world.method_22350(pos).method_12004();
        if (world.method_8393(chunkPos.field_9181, chunkPos.field_9180) && !world.field_9236) {
            world.method_8501(pos, newState);
            return true;
        }
        return false;
    }

    public static boolean tryBreakBlockAsPlayer(class_3222 player, class_2338 pos, class_1799 tool, boolean drop) {
        class_1937 world = player.method_37908();
        class_2680 blockState = world.method_8320(pos);
        if (!tool.method_7909().method_7885(blockState, world, pos, (class_1657)player)) {
            return false;
        }
        class_2586 blockEntity = world.method_8321(pos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_5552 && !player.method_7338()) {
            world.method_8413(pos, blockState, blockState, 3);
            return false;
        }
        if (player.method_21701(world, pos, player.field_13974.method_14257())) {
            return false;
        }
        boolean broke = BlockHelper.tryBreakBlock((class_3218)world, pos, tool, drop);
        if (broke) {
            // empty if block
        }
        return broke;
    }

    public static boolean tryBreakBlock(class_3218 world, class_2338 pos, class_1799 tool, boolean drop) {
        class_2680 blockState = world.method_8320(pos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_5552) {
            world.method_8413(pos, blockState, blockState, 3);
            return false;
        }
        block.method_33614((class_1937)world, null, pos, blockState);
        world.method_43276(class_5712.field_28165, pos, class_5712.class_7397.method_43286(null, (class_2680)blockState));
        boolean removed = world.method_8650(pos, false);
        if (removed) {
            class_2586 blockEntity;
            block.method_9585((class_1936)world, pos, blockState);
            class_2586 class_25862 = blockEntity = blockState.method_31709() ? world.method_8321(pos) : null;
            if (drop) {
                class_2248.method_9511((class_2680)blockState, (class_1937)world, (class_2338)pos, (class_2586)blockEntity, null, (class_1799)tool);
            }
        }
        return true;
    }

    public static boolean canHarvest(class_2680 state, class_1799 tool) {
        return !state.method_29291() || tool.method_7951(state);
    }

    public static class_3965 raycastBlock(class_1937 world, class_243 from, class_243 to) {
        return world.method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)new class_6335(class_1299.field_33456, world)));
    }

    public static List<class_3965> raycastBlocksInPath(class_1937 world, class_243 from, class_243 to) {
        class_5702 context = new class_5702(from, to, b -> false);
        ArrayList<class_3965> res = new ArrayList<class_3965>();
        class_1922.method_17744((class_243)context.method_32884(), (class_243)context.method_32883(), (Object)context, (innerContext, pos) -> {
            class_2680 blockState = world.method_8320(pos);
            class_243 vec3d = innerContext.method_32884().method_1020(innerContext.method_32883());
            res.add(new class_3965(pos.method_46558(), class_2350.method_10142((double)vec3d.field_1352, (double)vec3d.field_1351, (double)vec3d.field_1350), (class_2338)pos.method_25503(), false));
            return innerContext.method_32885().test(blockState) ? new class_3965(pos.method_46558(), class_2350.method_10142((double)vec3d.field_1352, (double)vec3d.field_1351, (double)vec3d.field_1350), pos, false) : null;
        }, innerContext -> {
            class_243 vec3d = innerContext.method_32884().method_1020(innerContext.method_32883());
            return class_3965.method_17778((class_243)innerContext.method_32883(), (class_2350)class_2350.method_10142((double)vec3d.field_1352, (double)vec3d.field_1351, (double)vec3d.field_1350), (class_2338)class_2338.method_49638((class_2374)innerContext.method_32883()));
        });
        return res;
    }

    public static boolean withinCube(class_2382 distance, int pedestalRange) {
        return Math.max(Math.max(Math.abs(distance.method_10263()), Math.abs(distance.method_10264())), Math.abs(distance.method_10260())) <= pedestalRange;
    }
}

