/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6575;
import net.minecraft.class_7923;
import org.oxytocina.geomancy.client.GeomancyClient;
import org.oxytocina.geomancy.networking.packet.S2C.ParticlesS2CPacket;
import org.oxytocina.geomancy.spells.SpellComponent;
import org.oxytocina.geomancy.spells.SpellContext;
import org.oxytocina.geomancy.util.Toolbox;

public class ParticleUtil {

    public static class ParticleData {
        public Type type = Type.CAST_SOUL;
        public int amount = 10;
        public float dispersion = 0.5f;
        public class_243 pos;
        public class_243 dir;
        public class_243 velMin;
        public class_243 velMax;
        public class_2960 world;
        public String data = "";
        public class_1937 worldObj;

        private ParticleData(Type type, int amount, class_243 pos, class_243 dir, class_2960 world, class_1937 worldObj, float dispersion) {
            this.type = type;
            this.amount = amount;
            this.pos = pos;
            this.dir = dir;
            this.world = world;
            this.dispersion = dispersion;
            this.worldObj = worldObj;
            this.velMin = new class_243(0.0, 0.0, 0.0);
            this.velMax = new class_243(0.0, 0.0, 0.0);
        }

        public static ParticleData createGenericCastSuccess(SpellComponent comp, class_243 pos) {
            return ParticleData.create(comp.world(), pos).type(Type.CAST_SOUL).amount(10);
        }

        public static ParticleData createGenericCastBroke(SpellComponent comp, class_243 pos) {
            return ParticleData.create(comp.world(), pos).type(Type.CAST_SOUL_FIRE).amount(10);
        }

        public static ParticleData createGenericCastMuzzle(SpellContext ctx, class_243 pos, class_243 dir) {
            return ParticleData.create(ctx.getWorld(), pos).type(Type.CAST_MUZZLE).amount(5).dir(dir).dispersion(0.2f);
        }

        public static ParticleData createGenericCastFail(SpellComponent comp, class_243 pos) {
            return ParticleData.create(comp.world(), pos).type(Type.CAST_SOUL_FIRE).amount(10);
        }

        public static ParticleData createSmithingProgress(class_1937 world, class_243 pos) {
            return ParticleData.create(world, pos.method_1031(0.0, (double)0.6f, 0.0)).type(Type.SMITHING_PROGRESS).amount(5).vel(new class_243(0.0, 0.0, 0.0), new class_243(0.0, 0.0, 0.0)).dispersion(0.3f);
        }

        public static ParticleData createSmithingComplete(class_1937 world, class_243 pos) {
            return ParticleData.create(world, pos.method_1031(0.0, (double)0.6f, 0.0)).type(Type.SMITHING_COMPLETE).amount(10).vel(new class_243((double)-0.2f, 0.0, (double)-0.2f), new class_243((double)0.2f, (double)0.4f, (double)0.2f)).dispersion(0.3f);
        }

        public static ParticleData createSmithingFailure(class_1937 world, class_243 pos) {
            return ParticleData.create(world, pos.method_1031(0.0, (double)0.6f, 0.0)).type(Type.SMITHING_FAILURE).amount(10).vel(new class_243((double)-0.2f, 0.0, (double)-0.2f), new class_243((double)0.1f, (double)0.2f, (double)0.1f)).dispersion(0.3f);
        }

        public static ParticleData createSoulFlare(class_1937 world, class_243 pos) {
            return ParticleData.create(world, pos.method_1031(0.0, (double)0.6f, 0.0)).type(Type.SOUL_FLARE).amount(10).vel(new class_243((double)-0.1f, (double)0.05f, (double)-0.1f), new class_243((double)0.1f, 0.5, (double)0.1f)).dispersion(0.3f);
        }

        public static ParticleData createSoulDud(class_1937 world, class_243 pos) {
            return ParticleData.create(world, pos.method_1031(0.0, (double)0.6f, 0.0)).type(Type.SOUL_DUD).amount(10).vel(new class_243((double)-0.1f, (double)0.05f, (double)-0.1f), new class_243((double)0.1f, (double)0.05f, (double)0.1f)).dispersion(0.3f);
        }

        public static ParticleData createInstability(class_1937 world, class_243 pos) {
            return ParticleData.create(world, pos.method_1031(0.0, (double)0.6f, 0.0)).type(Type.INSTABILITY).amount(10).vel(new class_243((double)-0.1f, (double)0.05f, (double)-0.1f), new class_243((double)0.1f, (double)0.05f, (double)0.1f)).dispersion(0.3f);
        }

        public static ParticleData createForgeConsume(class_1937 world, class_243 from, class_243 to) {
            return ParticleData.create(world, from).type(Type.FORGE_CONSUME).amount(1).vel(to, to);
        }

        public static ParticleData createGeneric(class_1937 world, class_2396<?> type, class_243 pos, class_243 vel, int count, float disp) {
            return ParticleData.create(world, pos).type(Type.GENERIC).amount(count).dispersion(disp).vel(vel, vel).data(class_7923.field_41180.method_10221(type).toString());
        }

        public static ParticleData createRestrictedAction(class_1937 world, class_243 where) {
            return ParticleData.create(world, where).type(Type.RESTRICTED_ACTION).amount(20).dispersion(0.75f).vel(new class_243(-0.2, -0.2, -0.2), new class_243(0.2, 0.2, 0.2));
        }

        public static ParticleData create(class_1937 world, class_243 pos) {
            return new ParticleData(Type.CAST_SOUL, 10, pos, new class_243(0.0, 0.0, 0.0), world.method_27983().method_29177(), world, 0.5f);
        }

        public ParticleData amount(int amount) {
            this.amount = amount;
            return this;
        }

        public ParticleData dir(class_243 dir) {
            this.dir = dir;
            return this;
        }

        public ParticleData vel(class_243 min, class_243 max) {
            this.velMin = min;
            this.velMax = max;
            return this;
        }

        public ParticleData dispersion(float dispersion) {
            this.dispersion = dispersion;
            return this;
        }

        public ParticleData type(Type type) {
            this.type = type;
            return this;
        }

        public ParticleData data(String data) {
            this.data = data;
            return this;
        }

        public void send() {
            ParticlesS2CPacket.send(this.worldObj, this);
        }

        public void write(class_2540 buf) {
            buf.method_10814(this.type.toString());
            buf.writeInt(this.amount);
            buf.writeFloat(this.dispersion);
            buf.method_49068(this.pos.method_46409());
            buf.method_49068(this.dir.method_46409());
            buf.method_49068(this.velMin.method_46409());
            buf.method_49068(this.velMax.method_46409());
            buf.method_10812(this.world);
            buf.method_10814(this.data);
        }

        public static ParticleData from(class_2540 buf) {
            Type type = Type.valueOf(buf.method_19772());
            int amount = buf.readInt();
            float dispersion = buf.readFloat();
            class_243 pos = new class_243(buf.method_49069());
            class_243 dir = new class_243(buf.method_49069());
            class_243 velMin = new class_243(buf.method_49069());
            class_243 velMax = new class_243(buf.method_49069());
            class_2960 world = buf.method_10810();
            String data = buf.method_19772();
            ParticleData res = new ParticleData(type, amount, pos, dir, world, null, dispersion);
            res.velMin = velMin;
            res.velMax = velMax;
            res.data = data;
            return res;
        }

        @Environment(value=EnvType.CLIENT)
        public void run() {
            class_638 worldObj = class_310.method_1551().field_1687;
            if (!worldObj.method_27983().method_29177().equals((Object)this.world)) {
                return;
            }
            class_6575 rand = new class_6575(GeomancyClient.tick);
            block14: for (int i = 0; i < this.amount; ++i) {
                class_243 pPos = new class_243(this.pos.field_1352 + (double)((rand.method_43057() * 2.0f - 1.0f) * this.dispersion), this.pos.field_1351 + (double)((rand.method_43057() * 2.0f - 1.0f) * this.dispersion), this.pos.field_1350 + (double)((rand.method_43057() * 2.0f - 1.0f) * this.dispersion));
                class_243 vel = new class_243(class_3532.method_16436((double)rand.method_43057(), (double)this.velMin.field_1352, (double)this.velMax.field_1352), class_3532.method_16436((double)rand.method_43057(), (double)this.velMin.field_1351, (double)this.velMax.field_1351), class_3532.method_16436((double)rand.method_43057(), (double)this.velMin.field_1350, (double)this.velMax.field_1350));
                switch (this.type.ordinal()) {
                    case 0: {
                        worldObj.method_8406((class_2394)class_2398.field_38002, pPos.field_1352, pPos.field_1351, pPos.field_1350, 0.0, 0.0, 0.0);
                        continue block14;
                    }
                    case 1: {
                        class_243 randVel = new class_243(0.0, 0.0, 0.0).method_49272((class_5819)rand, 0.08f);
                        worldObj.method_8406((class_2394)class_2398.field_22246, pPos.field_1352, pPos.field_1351, pPos.field_1350, randVel.field_1352, randVel.field_1351, randVel.field_1350);
                        continue block14;
                    }
                    case 2: {
                        class_243 randVel = this.dir.method_1021((double)0.2f).method_49272((class_5819)rand, 0.08f);
                        worldObj.method_8406((class_2394)class_2398.field_22246, pPos.field_1352, pPos.field_1351, pPos.field_1350, randVel.field_1352, randVel.field_1351, randVel.field_1350);
                        continue block14;
                    }
                    case 3: {
                        worldObj.method_8406((class_2394)class_2398.field_11239, pPos.field_1352, pPos.field_1351, pPos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
                        continue block14;
                    }
                    case 4: {
                        worldObj.method_8406((class_2394)class_2398.field_11239, pPos.field_1352, pPos.field_1351, pPos.field_1350, 0.0, 0.0, 0.0);
                        worldObj.method_8406((class_2394)class_2398.field_11240, pPos.field_1352, pPos.field_1351, pPos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
                        continue block14;
                    }
                    case 5: {
                        worldObj.method_8406((class_2394)class_2398.field_17430, pPos.field_1352, pPos.field_1351, pPos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
                        continue block14;
                    }
                    case 6: {
                        worldObj.method_8406((class_2394)class_2398.field_22246, pPos.field_1352, pPos.field_1351, pPos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
                        worldObj.method_8406((class_2394)class_2398.field_38002, pPos.field_1352, pPos.field_1351, pPos.field_1350, 0.0, 0.0, 0.0);
                        continue block14;
                    }
                    case 7: {
                        worldObj.method_8406((class_2394)class_2398.field_22246, pPos.field_1352, pPos.field_1351, pPos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
                        continue block14;
                    }
                    case 8: {
                        worldObj.method_8406((class_2394)class_2398.field_11248, pPos.field_1352, pPos.field_1351, pPos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
                        worldObj.method_8406((class_2394)class_2398.field_17430, pPos.field_1352, pPos.field_1351, pPos.field_1350, 0.0, 0.0, 0.0);
                        continue block14;
                    }
                    case 9: {
                        class_243 dir = vel.method_1020(pPos);
                        float distance = (float)dir.method_1033();
                        int j = 0;
                        while ((float)j < distance * 5.0f) {
                            class_243 newPos = pPos.method_1019(dir.method_1021((double)((float)j / 5.0f / distance)));
                            worldObj.method_8406((class_2394)class_2398.field_38002, newPos.field_1352, newPos.field_1351, newPos.field_1350, 0.0, 0.0, 0.0);
                            worldObj.method_8406((class_2394)class_2398.field_22246, newPos.field_1352, newPos.field_1351, newPos.field_1350, (double)Toolbox.randomBetween(-0.1f, 0.1f), (double)Toolbox.randomBetween(0.0f, 0.1f), (double)Toolbox.randomBetween(-0.1f, 0.1f));
                            ++j;
                        }
                        continue block14;
                    }
                    case 10: {
                        class_2396 type = (class_2396)class_7923.field_41180.method_10223(class_2960.method_12829((String)this.data));
                        if (!(type instanceof class_2394)) continue block14;
                        class_2394 effect = (class_2394)type;
                        worldObj.method_8406(effect, pPos.field_1352, pPos.field_1351, pPos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
                        continue block14;
                    }
                    case 11: {
                        worldObj.method_8406((class_2394)class_2398.field_11233, pPos.field_1352, pPos.field_1351, pPos.field_1350, 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        public static enum Type {
            CAST_SOUL,
            CAST_SOUL_FIRE,
            CAST_MUZZLE,
            SMITHING_PROGRESS,
            SMITHING_COMPLETE,
            SMITHING_FAILURE,
            SOUL_FLARE,
            SOUL_DUD,
            INSTABILITY,
            FORGE_CONSUME,
            GENERIC,
            RESTRICTED_ACTION;

        }
    }
}

