/*
 * Decompiled with CFR 0.152.
 */
package org.oxytocina.geomancy.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5539;
import net.minecraft.class_6748;
import net.minecraft.class_7138;
import org.oxytocina.geomancy.blocks.ModBlocks;
import org.oxytocina.geomancy.blocks.NullSpikeBlock;
import org.oxytocina.geomancy.registries.ModBlockTags;
import org.oxytocina.geomancy.util.GenUtil;
import org.oxytocina.geomancy.util.SimplexNoise;
import org.oxytocina.geomancy.util.Toolbox;

public class NullChunkGenerator
extends class_2794 {
    public static final Codec<NullChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(class_2794::method_12098), (App)Codec.INT.fieldOf("world_height").forGetter(NullChunkGenerator::method_12104)).apply((Applicative)instance, NullChunkGenerator::new));
    static final class_2680 rubbleState = ModBlocks.NULL_RUBBLE.method_9564();
    static final class_2680 crystalState = ModBlocks.NULL_CRYSTAL.method_9564();
    static final class_2680 spikeUpState = (class_2680)ModBlocks.NULL_SPIKE.method_9564().method_11657((class_2769)NullSpikeBlock.VERTICAL_DIRECTION, (Comparable)class_2350.field_11036);
    static final class_2680 spikeDownState = (class_2680)ModBlocks.NULL_SPIKE.method_9564().method_11657((class_2769)NullSpikeBlock.VERTICAL_DIRECTION, (Comparable)class_2350.field_11033);
    static final class_2680 floorVinesState = (class_2680)ModBlocks.IRIDESCENT_VINES.method_9564().method_11657((class_2769)class_2429.field_11330, (Comparable)Boolean.valueOf(true));
    static final float blobThreshold = 0.9f;
    static final float crystalBlobThreshold = 0.95f;
    static final float hangingCrystalBlobThresholdLow = 0.5f;
    static final float hangingCrystalBlobThresholdHigh = 0.95f;
    static final float crystalBlobFloorVineThreshold = 0.4f;
    static final float groundSpikeThreshold = 0.7f;
    static final float ceilingSpikeThreshold = 0.6f;
    static final float surfaceThreshold = 0.8f;
    static final float surfaceNoisePerDepth = 0.02f;
    final int worldHeight;
    static final float mainNoiseScale = 0.03f;
    static final float mainNoiseScaleOctave1 = 0.1431f;
    static final float mainNoiseScaleOctave2 = 0.028314f;
    static final float crystalNoiseScale = 0.041f;
    static final float crystalNoiseScaleOctave1 = 0.1331f;
    static final float hangingCrystalBiomeNoiseScale = 0.0315f;
    static final float crystalFloorVineNoiseScale = 0.4812f;
    static final float crystalFloorVineNoiseScaleOctave1 = 0.7541f;
    static final float spikeNoiseScale = 0.3524f;

    public NullChunkGenerator(class_1966 biomeSource, int worldHeight) {
        super(biomeSource);
        this.worldHeight = worldHeight;
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        int startX = chunkPos.method_8326();
        int startZ = chunkPos.method_8328();
        int height = chunk.method_31605();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2680 state = null;
        for (int ix = 0; ix < 16; ++ix) {
            int genX = startX + ix;
            for (int iy = 0; iy < height; ++iy) {
                int genY = iy;
                for (int iz = 0; iz < 16; ++iz) {
                    class_2680 lowerState;
                    class_2680 upperState;
                    int depth;
                    float noise;
                    int genZ = startZ + iz;
                    state = chunk.method_8320((class_2338)mutable.method_10103(ix, iy, iz));
                    if (state.method_26164(ModBlockTags.NULL_RUBBLE_REPLACEABLE)) {
                        noise = this.rubbleNoise(genX, genY, genZ);
                        if (noise > 0.9f) {
                            chunk.method_12010((class_2338)mutable, rubbleState, false);
                        }
                        if (noise > 0.8f) {
                            depth = Math.round((float)Math.ceil((noise - 0.8f) / 0.02f));
                            class_2680 topstate = chunk.method_8320(mutable.method_10086(depth));
                            mutable.method_10087(depth);
                            if (topstate.method_26215()) {
                                chunk.method_12010((class_2338)mutable, rubbleState, false);
                            }
                        }
                    }
                    if (state.method_26164(ModBlockTags.NULL_CRYSTAL_REPLACEABLE)) {
                        noise = this.crystalNoise(genX, genY, genZ);
                        if (noise > 0.95f) {
                            chunk.method_12010((class_2338)mutable, crystalState, false);
                        }
                        if (noise > this.getHangingCrystalThreshold(genX, genY, genZ)) {
                            depth = Math.round((float)Math.ceil((noise - 0.8f) / 0.02f));
                            class_2680 bottomstate = chunk.method_8320(mutable.method_10087(depth));
                            class_2680 immediateBottomState = chunk.method_8320(mutable.method_10074());
                            if (bottomstate.method_26215()) {
                                chunk.method_12010((class_2338)mutable, crystalState, false);
                            }
                            if (immediateBottomState.method_26215()) {
                                int offset = 0;
                                while (immediateBottomState.method_26215() && mutable.method_10264() - ++offset > chunk.method_31607()) {
                                    immediateBottomState = chunk.method_8320(mutable.method_10087(offset));
                                }
                                if (immediateBottomState.method_26164(ModBlockTags.NULL_CRYSTAL_REPLACEABLE)) {
                                    class_2338.class_2339 tempPos;
                                    class_2680 tempState;
                                    chunk.method_12010(mutable.method_10087(offset), rubbleState, false);
                                    noise = this.crystalFloorVineNoise(genX, genY, genZ);
                                    if (noise > 0.4f && ((tempState = chunk.method_8320((class_2338)(tempPos = mutable.method_10087(offset - 1).method_25503()))).method_26215() || tempState.method_27852((class_2248)ModBlocks.NULL_SPIKE))) {
                                        chunk.method_12010((class_2338)tempPos, floorVinesState, false);
                                    }
                                }
                            }
                        }
                    }
                    if (genY < 64 && state.method_26164(ModBlockTags.NULL_HOLDS_SPIKES) && (upperState = chunk.method_8320(mutable.method_10084())).method_26215()) {
                        float noise2 = this.groundSpikeNoise(genX, genY, genZ);
                        if ((noise2 = Toolbox.clampF(noise2 - (float)(iy - 30) * 0.02f, 0.0f, noise2)) > 0.7f) {
                            chunk.method_12010(mutable.method_10084(), spikeUpState, false);
                        }
                    }
                    if (!state.method_26164(ModBlockTags.NULL_HOLDS_SPIKES) || !(lowerState = chunk.method_8320(mutable.method_10074())).method_26215()) continue;
                    float noise3 = this.groundSpikeNoise(genX, genY, genZ);
                    if (!((noise3 = Toolbox.clampF(noise3 + (float)(iy - height + 100) * 0.02f, 0.0f, noise3)) > 0.6f)) continue;
                    chunk.method_12010(mutable.method_10074(), spikeDownState, false);
                }
            }
        }
    }

    public CompletableFuture<class_2791> method_38275(Executor executor, class_7138 noiseConfig, class_6748 blender, class_5138 structureAccessor, class_2791 chunk) {
        return super.method_38275(executor, noiseConfig, blender, structureAccessor, chunk);
    }

    public void method_12107(class_3233 region) {
    }

    public int method_12104() {
        return this.worldHeight;
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return CompletableFuture.supplyAsync(class_156.method_37910((String)"wgen_fill_noise", () -> this.generate(chunk)), class_156.method_18349()).whenCompleteAsync((chunkx, throwable) -> {}, executor);
    }

    private class_2791 generate(class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        int startX = chunkPos.method_8326();
        int startZ = chunkPos.method_8328();
        int height = this.method_12104();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2902 oceanFloorHeightmap = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 surfaceHeightmap = chunk.method_12032(class_2902.class_2903.field_13194);
        float thresholdNoiseScale = 0.004f;
        float padding = 0.05f;
        class_2680 core = ModBlocks.NULL_ROCK.method_9564();
        for (int ix = 0; ix < 16; ++ix) {
            int genX = (startX + ix) / 2 * 2;
            for (int iy = 0; iy < height; ++iy) {
                int genY = iy / 2 * 2;
                for (int iz = 0; iz < 16; ++iz) {
                    int genZ = (startZ + iz) / 2 * 2;
                    float distanceToEnds = (float)Math.min(iy, height - iy) / (float)height;
                    float threshold = Toolbox.clampF((distanceToEnds - 0.05f) * 6.0f, 0.0f, 1.0f) * (0.2f + SimplexNoise.noiseNormalized(genX, genY, genZ, 0.004f) * 0.6f);
                    float noise = this.tunnellyNoise(genX, iy, genZ);
                    if (!(noise > threshold)) continue;
                    chunk.method_12010((class_2338)mutable.method_10103(ix, iy, iz), core, false);
                }
            }
        }
        float typeNoiseScale = 0.00742f;
        float typeMazeThreshold = 0.1f;
        float typeNoise = SimplexNoise.noiseNormalized((float)startX * 0.00742f, 0.0, (float)startZ * 0.00742f);
        if (typeNoise < 0.1f) {
            class_2826[] sections = chunk.method_12006();
            for (int i = 0; i < sections.length; ++i) {
                class_2826 section = sections[i];
                section.method_16676();
                this.generateMazeSection(chunk, section, i);
                section.method_16677();
            }
        }
        int bottomY = chunk.method_31607();
        int topY = chunk.method_31600() - 1;
        class_2680 bread = class_2246.field_9987.method_9564();
        for (int ix = 0; ix < 16; ++ix) {
            for (int iz = 0; iz < 16; ++iz) {
                chunk.method_12010((class_2338)mutable.method_10103(ix, bottomY, iz), bread, false);
                chunk.method_12010((class_2338)mutable.method_10103(ix, topY, iz), bread, false);
                oceanFloorHeightmap.method_12597(ix, bottomY, iz, bread);
                surfaceHeightmap.method_12597(ix, topY, iz, bread);
            }
        }
        return chunk;
    }

    private float tunnellyNoise(int x, int y, int z) {
        return (0.8f * ((1.0f - (float)Math.pow(SimplexNoise.noiseNormalized((float)x * 0.03f, (float)y * 0.03f * 2.0f, (float)z * 0.03f), 3.0)) * 3.0f) % 1.0f + 0.2f * SimplexNoise.noiseNormalized(x, y, z, 0.1431f)) * Toolbox.clampF(20.0f * (SimplexNoise.noiseNormalized(x, y, z, 0.028314f) - 0.5f), 0.2f, 1.0f);
    }

    private float rubbleNoise(int x, int y, int z) {
        return 0.8f * (1.0f - (float)Math.pow(SimplexNoise.noiseNormalized((double)((float)x * 0.03f) + 0.51231, (double)((float)y * 0.03f) + 0.3142, (double)((float)z * 0.03f) + 0.1573), 2.0)) % 1.0f + 0.2f * SimplexNoise.noiseNormalized(x + 4819, y + 1931, z - 5738, 0.1431f);
    }

    private float crystalNoise(int x, int y, int z) {
        return 0.8f * (1.0f - (float)Math.pow(SimplexNoise.noiseNormalized((double)((float)x * 0.041f) + 0.51231, (double)((float)y * 0.041f) + 0.3142, (double)((float)z * 0.041f) + 0.1573), 2.0)) % 1.0f + 0.2f * SimplexNoise.noiseNormalized(x + 623, y + 4375, z - 165, 0.1331f);
    }

    private float getHangingCrystalThreshold(int x, int y, int z) {
        return class_3532.method_16439((float)(1.0f * (1.0f - (float)Math.pow(SimplexNoise.noiseNormalized((double)((float)x * 0.0315f) + 0.51231, (double)((float)y * 0.0315f) + 0.3142, (double)((float)z * 0.0315f) + 0.1573), 2.0)) % 1.0f), (float)0.5f, (float)0.95f);
    }

    private float crystalFloorVineNoise(int x, int y, int z) {
        return 0.5f * SimplexNoise.noiseNormalized((double)((float)x * 0.4812f) + 0.61231, (double)((float)y * 0.4812f) + 0.2142, (double)((float)z * 0.4812f) + 0.3573) + 0.5f * SimplexNoise.noiseNormalized(x + 6235, y + 435, z - 2365, 0.7541f);
    }

    private float groundSpikeNoise(int x, int y, int z) {
        return 1.0f * (1.0f - (float)Math.pow(SimplexNoise.noiseNormalized((double)((float)x * 0.3524f) + 0.51231, (double)((float)y * 0.3524f) + 0.3142, (double)((float)z * 0.3524f) + 0.1573), 2.0)) % 1.0f;
    }

    private class_2826 generateMazeSection(class_2791 chunk, class_2826 section, int y) {
        class_2680 wall = class_2246.field_28900.method_9564();
        class_2680 wireframe = class_2246.field_10340.method_9564();
        Random random = new Random(chunk.method_12004().hashCode() + y * 1000);
        float wallChance = 0.7f;
        boolean[] directions = new boolean[]{random.nextFloat() < 0.7f, random.nextFloat() < 0.7f, random.nextFloat() < 0.7f, random.nextFloat() < 0.7f, random.nextFloat() < 0.7f, random.nextFloat() < 0.7f};
        int width = 16;
        int height = 16;
        int depth = 16;
        int yOff = y * 16;
        if (directions[0]) {
            GenUtil.fillBox(chunk, wall, 1, yOff + 0, 1, 15, yOff + 0, 15);
        }
        if (directions[1]) {
            GenUtil.fillBox(chunk, wall, 1, yOff + 16 - 1, 1, 15, yOff + 16 - 1, 15);
        }
        if (directions[2]) {
            GenUtil.fillBox(chunk, wall, 0, yOff + 1, 1, 0, yOff + 16 - 1, 15);
        }
        if (directions[3]) {
            GenUtil.fillBox(chunk, wall, 15, yOff + 1, 1, 15, yOff + 16 - 1, 15);
        }
        if (directions[4]) {
            GenUtil.fillBox(chunk, wall, 1, yOff + 1, 0, 15, yOff + 16 - 1, 0);
        }
        if (directions[5]) {
            GenUtil.fillBox(chunk, wall, 1, yOff + 1, 15, 15, yOff + 16 - 1, 15);
        }
        GenUtil.fillKeepWireframe(chunk, wireframe, 0, yOff, 0, 15, yOff + 16 - 1, 15);
        return section;
    }

    public int method_16398() {
        return 0;
    }

    public int method_33730() {
        return 0;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        return 0;
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        return new class_4966(0, new class_2680[0]);
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }
}

