/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.reflections.Reflections;
import me.xginko.aef.libs.reflections.scanners.Scanner;
import me.xginko.aef.libs.reflections.scanners.Scanners;
import me.xginko.aef.utils.models.ConditionalEnableable;
import me.xginko.aef.utils.models.Disableable;
import me.xginko.aef.utils.models.Enableable;
import me.xginko.aef.utils.reflection.CommandReflection;
import org.bukkit.command.Command;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class AEFCommand
extends Command
implements PluginIdentifiableCommand,
ConditionalEnableable,
Disableable {
    protected static final Set<Class<AEFCommand>> AVAILABLE_COMMANDS = (Set)new Reflections(AEFCommand.class.getPackage().getName(), new Scanner[0]).get(Scanners.SubTypes.of(new AnnotatedElement[]{AEFCommand.class}).asClass(new ClassLoader[0])).stream().filter(clazz -> !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).map(clazz -> clazz).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf));
    protected static final Set<AEFCommand> ENABLED_COMMANDS = new HashSet<AEFCommand>(AVAILABLE_COMMANDS.size());
    private final AnarchyExploitFixes plugin = AnarchyExploitFixes.getInstance();

    protected AEFCommand(@NotNull String name, @NotNull String description, @NotNull String usageMessage, @NotNull List<String> aliases) {
        super(name, description, usageMessage, aliases);
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean shouldEnable() {
        return true;
    }

    @Override
    public void enable() {
        this.plugin.getServer().getCommandMap().register(this.plugin.getDescription().getName().toLowerCase(), (Command)this);
    }

    @Override
    public void disable() {
        ConcurrentHashMap<String, Command> knownCommands = new ConcurrentHashMap<String, Command>(this.plugin.getServer().getCommandMap().getKnownCommands());
        for (Map.Entry entry : knownCommands.entrySet()) {
            if (entry.getValue() != this) continue;
            ((Command)entry.getValue()).unregister(this.plugin.getServer().getCommandMap());
            CommandReflection.get().removeCommand((String)entry.getKey());
            knownCommands.remove(entry.getKey());
        }
        CommandReflection.get().setKnownCommands(knownCommands);
        CommandReflection.get().syncCommands();
    }

    public static void disableAll() {
        ENABLED_COMMANDS.forEach(Disableable::disable);
        ENABLED_COMMANDS.clear();
    }

    public static void reloadCommands() {
        AEFCommand.disableAll();
        for (Class<AEFCommand> cmdClass : AVAILABLE_COMMANDS) {
            try {
                AEFCommand aefCommand = cmdClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!aefCommand.shouldEnable()) continue;
                ENABLED_COMMANDS.add(aefCommand);
            }
            catch (Throwable t2) {
                if (t2.getCause() instanceof NoClassDefFoundError) {
                    AnarchyExploitFixes.logger().info("Dependencies for command class {} missing, not enabling.", (Object)cmdClass.getSimpleName());
                    continue;
                }
                AnarchyExploitFixes.logger().warn("Failed initialising command class '{}'.", (Object)cmdClass.getSimpleName(), (Object)t2);
            }
        }
        ENABLED_COMMANDS.forEach(Enableable::enable);
    }
}

