/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.commands;

import java.util.Collections;
import java.util.List;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.commands.AEFCommand;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class ToggleFirstJoinMsgsCmd
extends AEFCommand {
    public ToggleFirstJoinMsgsCmd() {
        super("togglefirstjoinmsgs", "Toggle first join messages on/off", "/togglefirstjoinmsgs | /togglefirstjoins", Collections.singletonList("togglefirstjoins"));
    }

    @Override
    public boolean shouldEnable() {
        return AnarchyExploitFixes.config().cmd_toggleConMsgs_enabled;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws CommandException, IllegalArgumentException {
        return Collections.emptyList();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)sender, AEFPermission.CMD_TOGGLE_FIRST_JOIN_MSGS.node()).toBoolean()) {
            sender.sendMessage(AnarchyExploitFixes.translation((CommandSender)sender).no_permission);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can execute this command.");
            return true;
        }
        Player player = (Player)sender;
        AnarchyExploitFixes.datastore().getFirstJoinEnabled(player.getUniqueId()).thenAccept(enabled -> {
            if (enabled.booleanValue()) {
                AnarchyExploitFixes.datastore().setFirstJoinEnabled(player.getUniqueId(), false).thenRun(() -> sender.sendMessage(AnarchyExploitFixes.translation((String)player.getLocale()).misc_disabledFirstJoinMsgs));
            } else {
                AnarchyExploitFixes.datastore().setFirstJoinEnabled(player.getUniqueId(), true).thenRun(() -> sender.sendMessage(AnarchyExploitFixes.translation((String)player.getLocale()).misc_enabledFirstJoinMsgs));
            }
        });
        return true;
    }
}

